/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.Collection;
import java.util.HashMap;
import org.cqframework.cql.elm.tracking.ListType;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.DefineClause;

public class QueryContext {
    private final HashMap<String, AliasedQuerySource> sources = new HashMap();
    private final HashMap<String, DefineClause> defines = new HashMap();
    private boolean isSingularValue = true;
    private boolean inSourceClauseValue;
    private boolean referencesPatientContextValue;

    public void addQuerySources(Collection<AliasedQuerySource> sources) {
        for (AliasedQuerySource source : sources) {
            this.addQuerySource(source);
        }
    }

    public void addQuerySource(AliasedQuerySource source) {
        this.sources.put(source.getAlias(), source);
        if (source.getResultType() instanceof ListType) {
            this.isSingularValue = false;
        }
    }

    public void removeQuerySource(AliasedQuerySource source) {
        this.sources.remove(source.getAlias());
    }

    public void addDefineClauses(Collection<DefineClause> defines) {
        for (DefineClause define : defines) {
            this.addDefineClause(define);
        }
    }

    public void addDefineClause(DefineClause define) {
        this.defines.put(define.getIdentifier(), define);
    }

    public AliasedQuerySource resolveAlias(String identifier) {
        return this.sources.get(identifier);
    }

    public DefineClause resolveDefine(String identifier) {
        return this.defines.get(identifier);
    }

    public boolean isSingular() {
        return this.isSingularValue;
    }

    public void enterSourceClause() {
        this.inSourceClauseValue = true;
    }

    public void exitSourceClause() {
        this.inSourceClauseValue = false;
    }

    public boolean inSourceClause() {
        return this.inSourceClauseValue;
    }

    public boolean referencesPatientContext() {
        return this.referencesPatientContextValue;
    }

    public void referencePatientContext() {
        this.referencesPatientContextValue = true;
    }
}

