/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.cqframework.cql.cql2elm.model.Signature;
import org.cqframework.cql.elm.tracking.DataType;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.VersionedIdentifier;

public class TranslatedLibrary {
    private VersionedIdentifier identifier;
    private final HashMap<String, Element> namespace = new HashMap();
    private final OperatorMap operators = new OperatorMap();
    private final List<Conversion> conversions = new ArrayList<Conversion>();

    public VersionedIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(VersionedIdentifier identifier) {
        this.identifier = identifier;
    }

    private void checkNamespace(String identifier) {
        Element existingElement = this.resolve(identifier);
        if (existingElement != null) {
            throw new IllegalArgumentException(String.format("Identifier %s is already in use in this library.", identifier));
        }
    }

    public void add(UsingDef using) {
        this.checkNamespace(using.getLocalIdentifier());
        this.namespace.put(using.getLocalIdentifier(), (Element)using);
    }

    public void add(IncludeDef include) {
        this.checkNamespace(include.getLocalIdentifier());
        this.namespace.put(include.getLocalIdentifier(), (Element)include);
    }

    public void add(CodeSystemDef codesystem) {
        this.checkNamespace(codesystem.getName());
        this.namespace.put(codesystem.getName(), (Element)codesystem);
    }

    public void add(ValueSetDef valueset) {
        this.checkNamespace(valueset.getName());
        this.namespace.put(valueset.getName(), (Element)valueset);
    }

    public void add(ParameterDef parameter) {
        this.checkNamespace(parameter.getName());
        this.namespace.put(parameter.getName(), (Element)parameter);
    }

    public void add(ExpressionDef expression) {
        if (expression instanceof FunctionDef) {
            this.add(this.expressionDefToOperator((FunctionDef)expression));
        } else {
            this.checkNamespace(expression.getName());
            this.namespace.put(expression.getName(), (Element)expression);
        }
    }

    private Operator expressionDefToOperator(FunctionDef functionDef) {
        ArrayList<DataType> operandTypes = new ArrayList<DataType>();
        for (OperandDef operand : functionDef.getOperand()) {
            operandTypes.add(operand.getResultType());
        }
        return new Operator(functionDef.getName(), new Signature(operandTypes.toArray(new DataType[operandTypes.size()])), functionDef.getResultType()).withAccessLevel(functionDef.getAccessLevel());
    }

    private void ensureLibrary(Operator operator) {
        if (this.identifier != null) {
            if (operator.getLibraryName() == null) {
                operator.setLibraryName(this.identifier.getId());
            } else if (!operator.getLibraryName().equals(this.identifier.getId())) {
                throw new IllegalArgumentException(String.format("Operator %s cannot be registered in library %s because it is defined in library %s.", operator.getName(), this.identifier.getId(), operator.getLibraryName()));
            }
        }
    }

    public void add(Operator operator) {
        this.ensureLibrary(operator);
        this.operators.addOperator(operator);
    }

    public void add(Conversion conversion) {
        if (conversion.isCast()) {
            throw new IllegalArgumentException("Casting conversions cannot be registered as part of a library.");
        }
        this.conversions.add(conversion);
    }

    public Element resolve(String identifier) {
        return this.namespace.get(identifier);
    }

    public UsingDef resolveUsingRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof UsingDef) {
            return (UsingDef)element;
        }
        return null;
    }

    public IncludeDef resolveIncludeRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof IncludeDef) {
            return (IncludeDef)element;
        }
        return null;
    }

    public CodeSystemDef resolveCodeSystemRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof CodeSystemDef) {
            return (CodeSystemDef)element;
        }
        return null;
    }

    public ValueSetDef resolveValueSetRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof ValueSetDef) {
            return (ValueSetDef)element;
        }
        return null;
    }

    public ParameterDef resolveParameterRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof ParameterDef) {
            return (ParameterDef)element;
        }
        return null;
    }

    public ExpressionDef resolveExpressionRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof ExpressionDef) {
            return (ExpressionDef)element;
        }
        return null;
    }

    public OperatorResolution resolveCall(CallContext callContext, ConversionMap conversionMap) {
        return this.operators.resolveOperator(callContext, conversionMap);
    }

    public Iterable<Conversion> getConversions() {
        return this.conversions;
    }
}

