/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorEntry;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.hl7.cql.model.DataType;

public class OperatorMap {
    private Map<String, OperatorEntry> operators = new HashMap<String, OperatorEntry>();

    public boolean containsOperator(Operator operator) {
        OperatorEntry entry = this.getEntry(operator.getName());
        return entry.containsOperator(operator);
    }

    public void addOperator(Operator operator) {
        OperatorEntry entry = this.getEntry(operator.getName());
        entry.addOperator(operator);
    }

    private OperatorEntry getEntry(String operatorName) {
        if (operatorName == null || operatorName.equals("")) {
            throw new IllegalArgumentException("operatorName is null or empty.");
        }
        OperatorEntry entry = this.operators.get(operatorName);
        if (entry == null) {
            entry = new OperatorEntry(operatorName);
            this.operators.put(operatorName, entry);
        }
        return entry;
    }

    public OperatorResolution resolveOperator(CallContext callContext, ConversionMap conversionMap) {
        OperatorEntry entry = this.getEntry(callContext.getOperatorName());
        List<OperatorResolution> results = entry.resolve(callContext, this, conversionMap);
        OperatorResolution result = null;
        if (results != null) {
            int lowestScore = Integer.MAX_VALUE;
            ArrayList<OperatorResolution> lowestScoringResults = new ArrayList<OperatorResolution>();
            for (OperatorResolution resolution : results) {
                Iterator<DataType> operands = resolution.getOperator().getSignature().getOperandTypes().iterator();
                Iterator<DataType> callOperands = callContext.getSignature().getOperandTypes().iterator();
                Iterator<Conversion> conversions = resolution.hasConversions() ? resolution.getConversions().iterator() : null;
                int score = 0;
                while (operands.hasNext()) {
                    Conversion conversion;
                    DataType operand = operands.next();
                    DataType callOperand = callOperands.next();
                    Conversion conversion2 = conversion = conversions != null ? conversions.next() : null;
                    if (operand.equals(callOperand)) {
                        score += 0;
                        continue;
                    }
                    if (operand.isSuperTypeOf(callOperand)) {
                        ++score;
                        continue;
                    }
                    if (callOperand.isCompatibleWith(operand)) {
                        score += 2;
                        continue;
                    }
                    if (conversion == null) continue;
                    if (conversion.isCast()) {
                        score += 3;
                        continue;
                    }
                    if (conversion.isListDemotion()) {
                        score += 5;
                        continue;
                    }
                    if (conversion.isListPromotion()) {
                        score += 6;
                        continue;
                    }
                    score += 4;
                }
                if (score < lowestScore) {
                    lowestScore = score;
                    lowestScoringResults.clear();
                    lowestScoringResults.add(resolution);
                    continue;
                }
                if (score != lowestScore) continue;
                lowestScoringResults.add(resolution);
            }
            if (lowestScoringResults.size() > 1) {
                StringBuilder message = new StringBuilder("Call to operator ").append(callContext.getOperatorName()).append(callContext.getSignature()).append(" is ambiguous with: ");
                for (OperatorResolution resolution : lowestScoringResults) {
                    message.append("\n  - ").append(resolution.getOperator().getName()).append(resolution.getOperator().getSignature());
                }
                throw new IllegalArgumentException(message.toString());
            }
            result = (OperatorResolution)lowestScoringResults.get(0);
        }
        return result;
    }
}

