/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.Collection;
import java.util.HashMap;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.ListType;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.LetClause;

public class QueryContext {
    private final HashMap<String, AliasedQuerySource> sources = new HashMap();
    private final HashMap<String, LetClause> lets = new HashMap();
    private boolean isSingularValue = true;
    private boolean inSourceClauseValue;
    private boolean inSortClauseValue;
    private boolean isImplicitValue;
    private DataType resultElementType;
    private boolean referencesPatientContextValue;

    public void addQuerySources(Collection<AliasedQuerySource> sources) {
        for (AliasedQuerySource source : sources) {
            this.addQuerySource(source);
        }
    }

    public Collection<AliasedQuerySource> getQuerySources() {
        return this.sources.values();
    }

    public void addQuerySource(AliasedQuerySource source) {
        this.sources.put(source.getAlias(), source);
        if (source.getResultType() instanceof ListType) {
            this.isSingularValue = false;
        }
    }

    public void removeQuerySource(AliasedQuerySource source) {
        this.sources.remove(source.getAlias());
    }

    public void removeQuerySources(Collection<AliasedQuerySource> sources) {
        for (AliasedQuerySource source : sources) {
            this.removeQuerySource(source);
        }
    }

    public void addLetClauses(Collection<LetClause> lets) {
        for (LetClause let : lets) {
            this.addLetClause(let);
        }
    }

    public void addLetClause(LetClause let) {
        this.lets.put(let.getIdentifier(), let);
    }

    public void removeLetClause(LetClause let) {
        this.lets.remove(let.getIdentifier());
    }

    public void removeLetClauses(Collection<LetClause> lets) {
        for (LetClause let : lets) {
            this.removeLetClause(let);
        }
    }

    public AliasedQuerySource resolveAlias(String identifier) {
        return this.sources.get(identifier);
    }

    public LetClause resolveLet(String identifier) {
        return this.lets.get(identifier);
    }

    public boolean isSingular() {
        return this.isSingularValue;
    }

    public void enterSourceClause() {
        this.inSourceClauseValue = true;
    }

    public void exitSourceClause() {
        this.inSourceClauseValue = false;
    }

    public boolean inSourceClause() {
        return this.inSourceClauseValue;
    }

    public void enterSortClause() {
        this.inSortClauseValue = true;
    }

    public void exitSortClause() {
        this.inSortClauseValue = false;
    }

    public boolean inSortClause() {
        return this.inSortClauseValue;
    }

    public boolean isImplicit() {
        return this.isImplicitValue;
    }

    public void setIsImplicit(boolean isImplicitValue) {
        this.isImplicitValue = isImplicitValue;
    }

    public DataType getResultElementType() {
        return this.resultElementType;
    }

    public void setResultElementType(DataType resultElementType) {
        this.resultElementType = resultElementType;
    }

    public boolean referencesPatientContext() {
        return this.referencesPatientContextValue;
    }

    public void referencePatientContext() {
        this.referencesPatientContextValue = true;
    }
}

