/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.misc.NotNull;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ModelImporter;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.NamedType;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class Model {
    private ModelInfo info;
    private Map<String, DataType> index;
    private Map<String, ClassType> classIndex;
    private Map<String, DataType> nameIndex;
    private List<Conversion> conversions;

    public Model(@NotNull ModelInfo modelInfo, Model systemModel) throws ClassNotFoundException {
        this.info = modelInfo;
        this.index = new HashMap<String, DataType>();
        this.nameIndex = new HashMap<String, DataType>();
        this.classIndex = new HashMap<String, ClassType>();
        this.conversions = new ArrayList<Conversion>();
        ModelImporter importer = new ModelImporter(this.info, systemModel != null ? systemModel.nameIndex.values() : null);
        this.index = importer.getTypes();
        for (Conversion c : importer.getConversions()) {
            this.conversions.add(c);
        }
        for (DataType t : this.index.values()) {
            if (t instanceof ClassType && ((ClassType)t).getLabel() != null) {
                this.classIndex.put(this.casify(((ClassType)t).getLabel()), (ClassType)t);
            }
            if (!(t instanceof NamedType)) continue;
            this.nameIndex.put(this.casify(((NamedType)t).getSimpleName()), t);
        }
    }

    public ModelInfo getModelInfo() {
        return this.info;
    }

    public Iterable<Conversion> getConversions() {
        return this.conversions;
    }

    public DataType resolveTypeName(@NotNull String typeName) {
        DataType result = this.index.get(typeName = this.casify(typeName));
        if (result == null) {
            result = this.nameIndex.get(typeName);
        }
        return result;
    }

    public ClassType resolveLabel(@NotNull String label) {
        return this.classIndex.get(this.casify(label));
    }

    private String casify(String typeName) {
        return this.info.isCaseSensitive() != null && this.info.isCaseSensitive() != false ? typeName.toLowerCase() : typeName;
    }

    private DataType internalResolveTypeName(@NotNull String typeName, Model systemModel) {
        DataType result = this.resolveTypeName(typeName);
        if (result == null && (result = systemModel.resolveTypeName(typeName)) == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type name %s in model %s.", typeName, this.info.getName()));
        }
        return result;
    }
}

