/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.cqframework.cql.cql2elm.CqlSemanticException;
import org.cqframework.cql.cql2elm.CqlSyntaxException;
import org.cqframework.cql.cql2elm.CqlTranslatorException;
import org.cqframework.cql.cql2elm.CqlTranslatorIncludeException;
import org.cqframework.cql.cql2elm.DataTypes;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.SystemFunctionResolver;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.Invocation;
import org.cqframework.cql.cql2elm.model.LibraryRef;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.cqframework.cql.cql2elm.model.QueryContext;
import org.cqframework.cql.cql2elm.model.SystemLibraryHelper;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.cqframework.cql.cql2elm.model.invocation.AggregateExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.BinaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.FunctionRefInvocation;
import org.cqframework.cql.cql2elm.model.invocation.InCodeSystemInvocation;
import org.cqframework.cql.cql2elm.model.invocation.InValueSetInvocation;
import org.cqframework.cql.cql2elm.model.invocation.NaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.TernaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.UnaryExpressionInvocation;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.cql_annotations.r1.CqlToElmError;
import org.hl7.cql_annotations.r1.ErrorSeverity;
import org.hl7.cql_annotations.r1.ErrorType;
import org.hl7.elm.r1.AccessModifier;
import org.hl7.elm.r1.AggregateExpression;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.Flatten;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.In;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.IsNull;
import org.hl7.elm.r1.Less;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Not;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.OperandRef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryLetRef;
import org.hl7.elm.r1.ReturnClause;
import org.hl7.elm.r1.SingletonFrom;
import org.hl7.elm.r1.TernaryExpression;
import org.hl7.elm.r1.ToList;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class LibraryBuilder {
    private final List<CqlTranslatorException> errors = new ArrayList<CqlTranslatorException>();
    private final List<CqlTranslatorException> warnings = new ArrayList<CqlTranslatorException>();
    private final List<CqlTranslatorException> messages = new ArrayList<CqlTranslatorException>();
    private final List<CqlTranslatorException> exceptions = new ArrayList<CqlTranslatorException>();
    private final Map<String, Model> models = new HashMap<String, Model>();
    private final Map<String, TranslatedLibrary> libraries = new HashMap<String, TranslatedLibrary>();
    private final SystemFunctionResolver systemFunctionResolver = new SystemFunctionResolver(this);
    private final Stack<String> expressionContext = new Stack();
    private final ExpressionDefinitionContextStack expressionDefinitions = new ExpressionDefinitionContextStack();
    private final Stack<FunctionDef> functionDefs = new Stack();
    private ModelManager modelManager = null;
    private Model defaultModel = null;
    private LibraryManager libraryManager = null;
    private Library library = null;
    private TranslatedLibrary translatedLibrary = null;
    private final ConversionMap conversionMap = new ConversionMap();
    private final ObjectFactory of = new ObjectFactory();
    private final org.hl7.cql_annotations.r1.ObjectFactory af = new org.hl7.cql_annotations.r1.ObjectFactory();
    private boolean listTraversal = true;
    private CqlTranslatorException.ErrorSeverity errorLevel = CqlTranslatorException.ErrorSeverity.Info;

    public LibraryBuilder(ModelManager modelManager, LibraryManager libraryManager) {
        if (modelManager == null) {
            throw new IllegalArgumentException("modelManager is null");
        }
        if (libraryManager == null) {
            throw new IllegalArgumentException("libraryManager is null");
        }
        this.modelManager = modelManager;
        this.libraryManager = libraryManager;
        this.library = this.of.createLibrary().withSchemaIdentifier(this.of.createVersionedIdentifier().withId("urn:hl7-org:elm").withVersion("r1"));
        this.translatedLibrary = new TranslatedLibrary();
        this.translatedLibrary.setLibrary(this.library);
    }

    public List<CqlTranslatorException> getErrors() {
        return this.errors;
    }

    public List<CqlTranslatorException> getWarnings() {
        return this.warnings;
    }

    public List<CqlTranslatorException> getMessages() {
        return this.messages;
    }

    public List<CqlTranslatorException> getExceptions() {
        return this.exceptions;
    }

    public Library getLibrary() {
        return this.library;
    }

    public TranslatedLibrary getTranslatedLibrary() {
        return this.translatedLibrary;
    }

    public ConversionMap getConversionMap() {
        return this.conversionMap;
    }

    public void enableListTraversal() {
        this.listTraversal = true;
    }

    public void disableListTraversal() {
        this.listTraversal = false;
    }

    public CqlTranslatorException.ErrorSeverity getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(CqlTranslatorException.ErrorSeverity severity) {
        this.errorLevel = severity;
    }

    private Model loadModel(VersionedIdentifier modelIdentifier) {
        Model model = this.modelManager.resolveModel(modelIdentifier);
        this.loadConversionMap(model);
        return model;
    }

    public Model getDefaultModel() {
        return this.defaultModel;
    }

    private void setDefaultModel(Model model) {
        if (this.defaultModel == null && !model.getModelInfo().getName().equals("System")) {
            this.defaultModel = model;
        }
    }

    public Model getModel(VersionedIdentifier modelIdentifier) {
        Model model = this.models.get(modelIdentifier.getId());
        if (model == null) {
            model = this.loadModel(modelIdentifier);
            this.setDefaultModel(model);
            this.models.put(modelIdentifier.getId(), model);
            this.buildUsingDef(modelIdentifier, model);
        }
        if (modelIdentifier.getVersion() != null && !modelIdentifier.getVersion().equals(model.getModelInfo().getVersion())) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s because version %s is already loaded.", modelIdentifier.getId(), modelIdentifier.getVersion(), model.getModelInfo().getVersion()));
        }
        return model;
    }

    private void loadConversionMap(Model model) {
        for (Conversion conversion : model.getConversions()) {
            this.conversionMap.add(conversion);
        }
    }

    private UsingDef buildUsingDef(VersionedIdentifier modelIdentifier, Model model) {
        UsingDef usingDef = this.of.createUsingDef().withLocalIdentifier(modelIdentifier.getId()).withVersion(modelIdentifier.getVersion()).withUri(model.getModelInfo().getUrl());
        this.addUsing(usingDef);
        return usingDef;
    }

    public boolean hasUsings() {
        for (Model model : this.models.values()) {
            if (model.getModelInfo().getName().equals("System")) continue;
            return true;
        }
        return false;
    }

    private void addUsing(UsingDef usingDef) {
        if (this.library.getUsings() == null) {
            this.library.setUsings(this.of.createLibraryUsings());
        }
        this.library.getUsings().getDef().add(usingDef);
        this.translatedLibrary.add(usingDef);
    }

    public ClassType resolveLabel(String modelName, String label) {
        ClassType result = null;
        if (modelName == null || modelName.equals("")) {
            for (Model model : this.models.values()) {
                ClassType modelResult = model.resolveLabel(label);
                if (modelResult == null) continue;
                if (result != null) {
                    throw new IllegalArgumentException(String.format("Label %s is ambiguous between %s and %s.", label, result.getLabel(), modelResult.getLabel()));
                }
                result = modelResult;
            }
        } else {
            result = this.getModel(modelName).resolveLabel(label);
        }
        return result;
    }

    public DataType resolveTypeName(String typeName) {
        return this.resolveTypeName(null, typeName);
    }

    public DataType resolveTypeName(String modelName, String typeName) {
        ClassType result = this.resolveLabel(modelName, typeName);
        if (result == null) {
            if (modelName == null || modelName.equals("")) {
                DataType modelResult;
                if (this.defaultModel != null && (modelResult = this.defaultModel.resolveTypeName(typeName)) != null) {
                    return modelResult;
                }
                for (Model model : this.models.values()) {
                    DataType modelResult2 = model.resolveTypeName(typeName);
                    if (modelResult2 == null) continue;
                    if (result != null) {
                        throw new IllegalArgumentException(String.format("Type name %s is ambiguous between %s and %s.", typeName, ((NamedType)result).getName(), ((NamedType)modelResult2).getName()));
                    }
                    result = modelResult2;
                }
            } else {
                result = this.getModel(modelName).resolveTypeName(typeName);
            }
        }
        return result;
    }

    public DataType resolveTypeSpecifier(String typeSpecifier) {
        if (typeSpecifier == null) {
            throw new IllegalArgumentException("typeSpecifier is null");
        }
        if (typeSpecifier.toLowerCase().startsWith("interval<")) {
            DataType pointType = this.resolveTypeSpecifier(typeSpecifier.substring(typeSpecifier.indexOf(60) + 1, typeSpecifier.lastIndexOf(62)));
            return new IntervalType(pointType);
        }
        if (typeSpecifier.toLowerCase().startsWith("list<")) {
            DataType elementType = this.resolveTypeName(typeSpecifier.substring(typeSpecifier.indexOf(60) + 1, typeSpecifier.lastIndexOf(62)));
            return new ListType(elementType);
        }
        if (typeSpecifier.indexOf(".") >= 0) {
            String modelName = typeSpecifier.substring(0, typeSpecifier.indexOf("."));
            String typeName = typeSpecifier.substring(typeSpecifier.indexOf(".") + 1);
            return this.resolveTypeName(modelName, typeName);
        }
        return this.resolveTypeName(typeSpecifier);
    }

    public UsingDef resolveUsingRef(String modelName) {
        return this.translatedLibrary.resolveUsingRef(modelName);
    }

    public SystemModel getSystemModel() {
        return (SystemModel)this.getModel(new VersionedIdentifier().withId("System"));
    }

    public Model getModel(String modelName) {
        UsingDef usingDef = this.resolveUsingRef(modelName);
        if (usingDef == null) {
            throw new IllegalArgumentException(String.format("Could not resolve model name %s", modelName));
        }
        return this.getModel(new VersionedIdentifier().withId(usingDef.getLocalIdentifier()).withVersion(usingDef.getVersion()));
    }

    private void loadSystemLibrary() {
        TranslatedLibrary systemLibrary = SystemLibraryHelper.load(this.getSystemModel());
        this.libraries.put(systemLibrary.getIdentifier().getId(), systemLibrary);
        this.loadConversionMap(systemLibrary);
    }

    private void loadConversionMap(TranslatedLibrary library) {
        for (Conversion conversion : library.getConversions()) {
            this.conversionMap.add(conversion);
        }
    }

    public TranslatedLibrary getSystemLibrary() {
        return this.resolveLibrary("System");
    }

    public TranslatedLibrary resolveLibrary(String identifier) {
        TranslatedLibrary result = this.libraries.get(identifier);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not resolve library name %s.", identifier));
        }
        return result;
    }

    private ErrorSeverity toErrorSeverity(CqlTranslatorException.ErrorSeverity severity) {
        if (severity == CqlTranslatorException.ErrorSeverity.Info) {
            return ErrorSeverity.INFO;
        }
        if (severity == CqlTranslatorException.ErrorSeverity.Warning) {
            return ErrorSeverity.WARNING;
        }
        if (severity == CqlTranslatorException.ErrorSeverity.Error) {
            return ErrorSeverity.ERROR;
        }
        throw new IllegalArgumentException(String.format("Unknown error severity %s", severity.toString()));
    }

    private void addException(CqlTranslatorException e) {
        this.exceptions.add(e);
        if (e.getSeverity() == CqlTranslatorException.ErrorSeverity.Error) {
            this.errors.add(e);
        } else if (e.getSeverity() == CqlTranslatorException.ErrorSeverity.Warning) {
            this.warnings.add(e);
        } else if (e.getSeverity() == CqlTranslatorException.ErrorSeverity.Info) {
            this.messages.add(e);
        }
    }

    private boolean shouldReport(CqlTranslatorException.ErrorSeverity errorSeverity) {
        switch (this.errorLevel) {
            case Info: {
                return errorSeverity == CqlTranslatorException.ErrorSeverity.Info || errorSeverity == CqlTranslatorException.ErrorSeverity.Warning || errorSeverity == CqlTranslatorException.ErrorSeverity.Error;
            }
            case Warning: {
                return errorSeverity == CqlTranslatorException.ErrorSeverity.Warning || errorSeverity == CqlTranslatorException.ErrorSeverity.Error;
            }
            case Error: {
                return errorSeverity == CqlTranslatorException.ErrorSeverity.Error;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown error severity %s", errorSeverity.toString()));
    }

    public void recordParsingException(CqlTranslatorException e) {
        this.addException(e);
        if (this.shouldReport(e.getSeverity())) {
            CqlToElmError err = this.af.createCqlToElmError();
            err.setMessage(e.getMessage());
            err.setErrorType(e instanceof CqlSyntaxException ? ErrorType.SYNTAX : (e instanceof CqlSemanticException ? ErrorType.SEMANTIC : ErrorType.INTERNAL));
            err.setErrorSeverity(this.toErrorSeverity(e.getSeverity()));
            if (e.getLocator() != null) {
                err.setStartLine(Integer.valueOf(e.getLocator().getStartLine()));
                err.setEndLine(Integer.valueOf(e.getLocator().getEndLine()));
                err.setStartChar(Integer.valueOf(e.getLocator().getStartChar()));
                err.setEndChar(Integer.valueOf(e.getLocator().getEndChar()));
            }
            if (e.getCause() != null && e.getCause() instanceof CqlTranslatorIncludeException) {
                CqlTranslatorIncludeException incEx = (CqlTranslatorIncludeException)e.getCause();
                err.setTargetIncludeLibraryId(incEx.getLibraryId());
                err.setTargetIncludeLibraryVersionId(incEx.getVersionId());
                err.setErrorType(ErrorType.INCLUDE);
            }
            this.library.getAnnotation().add(err);
        }
    }

    private String getLibraryName() {
        String libraryName = this.library.getIdentifier().getId();
        if (libraryName == null) {
            libraryName = "Anonymous";
        }
        return libraryName;
    }

    public void beginTranslation() {
        this.loadSystemLibrary();
        this.libraryManager.beginTranslation(this.getLibraryName());
    }

    public VersionedIdentifier getLibraryIdentifier() {
        return this.library.getIdentifier();
    }

    public void setLibraryIdentifier(VersionedIdentifier vid) {
        this.library.setIdentifier(vid);
        this.translatedLibrary.setIdentifier(vid);
    }

    public void endTranslation() {
        this.libraryManager.endTranslation(this.getLibraryName());
    }

    public void addInclude(IncludeDef includeDef) {
        if (this.library.getIdentifier() == null || this.library.getIdentifier().getId() == null) {
            throw new IllegalArgumentException("Unnamed libraries cannot reference other libraries.");
        }
        if (this.library.getIncludes() == null) {
            this.library.setIncludes(this.of.createLibraryIncludes());
        }
        this.library.getIncludes().getDef().add(includeDef);
        this.translatedLibrary.add(includeDef);
        VersionedIdentifier libraryIdentifier = new VersionedIdentifier().withId(includeDef.getPath()).withVersion(includeDef.getVersion());
        TranslatedLibrary referencedLibrary = this.libraryManager.resolveLibrary(libraryIdentifier, this.errors);
        this.libraries.put(includeDef.getLocalIdentifier(), referencedLibrary);
        this.loadConversionMap(referencedLibrary);
    }

    public void addParameter(ParameterDef paramDef) {
        if (this.library.getParameters() == null) {
            this.library.setParameters(this.of.createLibraryParameters());
        }
        this.library.getParameters().getDef().add(paramDef);
        this.translatedLibrary.add(paramDef);
    }

    public void addCodeSystem(CodeSystemDef cs) {
        if (this.library.getCodeSystems() == null) {
            this.library.setCodeSystems(this.of.createLibraryCodeSystems());
        }
        this.library.getCodeSystems().getDef().add(cs);
        this.translatedLibrary.add(cs);
    }

    public void addValueSet(ValueSetDef vs) {
        if (this.library.getValueSets() == null) {
            this.library.setValueSets(this.of.createLibraryValueSets());
        }
        this.library.getValueSets().getDef().add(vs);
        this.translatedLibrary.add(vs);
    }

    public void addCode(CodeDef cd) {
        if (this.library.getCodes() == null) {
            this.library.setCodes(this.of.createLibraryCodes());
        }
        this.library.getCodes().getDef().add(cd);
        this.translatedLibrary.add(cd);
    }

    public void addConcept(ConceptDef cd) {
        if (this.library.getConcepts() == null) {
            this.library.setConcepts(this.of.createLibraryConcepts());
        }
        this.library.getConcepts().getDef().add(cd);
        this.translatedLibrary.add(cd);
    }

    public void addExpression(ExpressionDef expDef) {
        if (this.library.getStatements() == null) {
            this.library.setStatements(this.of.createLibraryStatements());
        }
        this.library.getStatements().getDef().add(expDef);
        this.translatedLibrary.add(expDef);
    }

    public Element resolve(String identifier) {
        return this.translatedLibrary.resolve(identifier);
    }

    public IncludeDef resolveIncludeRef(String identifier) {
        return this.translatedLibrary.resolveIncludeRef(identifier);
    }

    public CodeSystemDef resolveCodeSystemRef(String identifier) {
        return this.translatedLibrary.resolveCodeSystemRef(identifier);
    }

    public ValueSetDef resolveValueSetRef(String identifier) {
        return this.translatedLibrary.resolveValueSetRef(identifier);
    }

    public CodeDef resolveCodeRef(String identifier) {
        return this.translatedLibrary.resolveCodeRef(identifier);
    }

    public ConceptDef resolveConceptRef(String identifier) {
        return this.translatedLibrary.resolveConceptRef(identifier);
    }

    public ParameterDef resolveParameterRef(String identifier) {
        return this.translatedLibrary.resolveParameterRef(identifier);
    }

    public ExpressionDef resolveExpressionRef(String identifier) {
        return this.translatedLibrary.resolveExpressionRef(identifier);
    }

    public Conversion findConversion(DataType fromType, DataType toType, boolean implicit) {
        return this.conversionMap.findConversion(fromType, toType, implicit, this.translatedLibrary.getOperatorMap());
    }

    public Expression resolveUnaryCall(String libraryName, String operatorName, UnaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new UnaryExpressionInvocation(expression));
    }

    public Expression resolveBinaryCall(String libraryName, String operatorName, BinaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new BinaryExpressionInvocation(expression));
    }

    public Expression resolveTernaryCall(String libraryName, String operatorName, TernaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new TernaryExpressionInvocation(expression));
    }

    public Expression resolveNaryCall(String libraryName, String operatorName, NaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new NaryExpressionInvocation(expression));
    }

    public Expression resolveAggregateCall(String libraryName, String operatorName, AggregateExpression expression) {
        return this.resolveCall(libraryName, operatorName, new AggregateExpressionInvocation(expression));
    }

    public Expression resolveIn(Expression left, Expression right) {
        if (right instanceof ValueSetRef) {
            InValueSet in = this.of.createInValueSet().withCode(left).withValueset((ValueSetRef)right);
            this.resolveCall("System", "InValueSet", new InValueSetInvocation(in));
            return in;
        }
        if (right instanceof CodeSystemRef) {
            InCodeSystem in = this.of.createInCodeSystem().withCode(left).withCodesystem((CodeSystemRef)right);
            this.resolveCall("System", "InCodeSystem", new InCodeSystemInvocation(in));
            return in;
        }
        In in = this.of.createIn().withOperand(new Expression[]{left, right});
        this.resolveBinaryCall("System", "In", (BinaryExpression)in);
        return in;
    }

    public Expression resolveCall(String libraryName, String operatorName, Invocation invocation) {
        return this.resolveCall(libraryName, operatorName, invocation, true);
    }

    public Expression resolveCall(String libraryName, String operatorName, Invocation invocation, boolean mustResolve) {
        Iterable<Expression> operands = invocation.getOperands();
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (Expression operand : operands) {
            if (operand.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not determine signature for invocation of operator %s%s.", libraryName == null ? "" : libraryName + ".", operatorName));
            }
            dataTypes.add(operand.getResultType());
        }
        CallContext callContext = new CallContext(libraryName, operatorName, dataTypes.toArray(new DataType[dataTypes.size()]));
        OperatorResolution resolution = this.resolveCall(callContext);
        if (resolution != null || mustResolve) {
            this.checkOperator(callContext, resolution);
            if (resolution.hasConversions()) {
                ArrayList<Expression> convertedOperands = new ArrayList<Expression>();
                Iterator<Expression> operandIterator = operands.iterator();
                Iterator<Conversion> conversionIterator = resolution.getConversions().iterator();
                while (operandIterator.hasNext()) {
                    Expression operand = operandIterator.next();
                    Conversion conversion = conversionIterator.next();
                    if (conversion != null) {
                        convertedOperands.add(this.convertExpression(operand, conversion));
                        continue;
                    }
                    convertedOperands.add(operand);
                }
                invocation.setOperands(convertedOperands);
            }
            invocation.setResultType(resolution.getOperator().getResultType());
            return invocation.getExpression();
        }
        return null;
    }

    public OperatorResolution resolveCall(CallContext callContext) {
        OperatorResolution result = null;
        if (callContext.getLibraryName() == null || callContext.getLibraryName().equals("")) {
            result = this.translatedLibrary.resolveCall(callContext, this.conversionMap);
            if (result == null && (result = this.getSystemLibrary().resolveCall(callContext, this.conversionMap)) != null) {
                this.checkAccessLevel(result.getOperator().getLibraryName(), result.getOperator().getName(), result.getOperator().getAccessLevel());
            }
        } else {
            result = this.resolveLibrary(callContext.getLibraryName()).resolveCall(callContext, this.conversionMap);
        }
        return result;
    }

    public void checkOperator(CallContext callContext, OperatorResolution resolution) {
        if (resolution == null) {
            throw new IllegalArgumentException(String.format("Could not resolve call to operator %s with signature %s.", callContext.getOperatorName(), callContext.getSignature()));
        }
    }

    public void checkAccessLevel(String libraryName, String objectName, AccessModifier accessModifier) {
        if (accessModifier == AccessModifier.PRIVATE) {
            throw new IllegalArgumentException(String.format("Object %s in library %s is marked private and cannot be referenced from another library.", objectName, libraryName));
        }
    }

    public Expression resolveFunction(String libraryName, String functionName, Iterable<Expression> paramList) {
        return this.resolveFunction(libraryName, functionName, paramList, true);
    }

    public Expression resolveFunction(String libraryName, String functionName, Iterable<Expression> paramList, boolean mustResolve) {
        FunctionRef fun = this.of.createFunctionRef().withLibraryName(libraryName).withName(functionName);
        for (Expression param : paramList) {
            fun.getOperand().add(param);
        }
        Expression systemFunction = this.systemFunctionResolver.resolveSystemFunction(fun);
        if (systemFunction != null) {
            return systemFunction;
        }
        fun = (FunctionRef)this.resolveCall(fun.getLibraryName(), fun.getName(), new FunctionRefInvocation(fun), mustResolve);
        return fun;
    }

    public void verifyComparable(DataType dataType) {
        Expression left = (Expression)this.of.createLiteral().withResultType(dataType);
        Expression right = (Expression)this.of.createLiteral().withResultType(dataType);
        Less comparison = this.of.createLess().withOperand(new Expression[]{left, right});
        this.resolveBinaryCall("System", "Less", (BinaryExpression)comparison);
    }

    public Expression convertExpression(Expression expression, DataType targetType) {
        Conversion conversion = this.findConversion(expression.getResultType(), targetType, true);
        if (conversion != null) {
            return this.convertExpression(expression, conversion);
        }
        DataTypes.verifyType(expression.getResultType(), targetType);
        return expression;
    }

    private Expression convertListExpression(Expression expression, Conversion conversion) {
        ListType fromType = (ListType)conversion.getFromType();
        ListType toType = (ListType)conversion.getToType();
        Query query = (Query)this.of.createQuery().withSource(new AliasedQuerySource[]{(AliasedQuerySource)this.of.createAliasedQuerySource().withAlias("X").withExpression(expression).withResultType((DataType)fromType)}).withReturn((ReturnClause)this.of.createReturnClause().withDistinct(Boolean.valueOf(false)).withExpression(this.convertExpression((Expression)((AliasRef)this.of.createAliasRef().withName("X").withResultType(fromType.getElementType())), conversion.getConversion())).withResultType((DataType)toType)).withResultType((DataType)toType);
        return query;
    }

    private void reportWarning(String message, Expression expression) {
        TrackBack trackback = expression.getTrackbacks() != null && expression.getTrackbacks().size() > 0 ? (TrackBack)expression.getTrackbacks().get(0) : null;
        CqlSemanticException warning = new CqlSemanticException(message, CqlTranslatorException.ErrorSeverity.Warning, trackback);
        this.recordParsingException(warning);
    }

    private Expression demoteListExpression(Expression expression, Conversion conversion) {
        ListType fromType = (ListType)conversion.getFromType();
        DataType toType = conversion.getToType();
        SingletonFrom singletonFrom = this.of.createSingletonFrom().withOperand(expression);
        singletonFrom.setResultType(fromType.getElementType());
        this.resolveUnaryCall("System", "SingletonFrom", (UnaryExpression)singletonFrom);
        this.reportWarning("List-valued expression was demoted to a singleton.", expression);
        if (conversion.getConversion() != null) {
            return this.convertExpression((Expression)singletonFrom, conversion.getConversion());
        }
        return singletonFrom;
    }

    private Expression promoteListExpression(Expression expression, Conversion conversion) {
        if (conversion.getConversion() != null) {
            expression = this.convertExpression(expression, conversion.getConversion());
        }
        if (expression.getResultType().equals(this.resolveTypeName("System", "Boolean"))) {
            this.reportWarning("Boolean-valued expression was promoted to a list.", expression);
        }
        return this.resolveToList(expression);
    }

    public Expression resolveToList(Expression expression) {
        ToList toList = this.of.createToList().withOperand(expression);
        toList.setResultType((DataType)new ListType(expression.getResultType()));
        return toList;
    }

    private Expression convertIntervalExpression(Expression expression, Conversion conversion) {
        IntervalType fromType = (IntervalType)conversion.getFromType();
        IntervalType toType = (IntervalType)conversion.getToType();
        Interval interval = (Interval)this.of.createInterval().withLow(this.convertExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("low").withResultType(fromType.getPointType())), conversion.getConversion())).withLowClosedExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("lowClosed").withResultType(this.resolveTypeName("System", "Boolean")))).withHigh(this.convertExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("high").withResultType(fromType.getPointType())), conversion.getConversion())).withHighClosedExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("highClosed").withResultType(this.resolveTypeName("System", "Boolean")))).withResultType((DataType)toType);
        return interval;
    }

    public Expression convertExpression(Expression expression, Conversion conversion) {
        if (conversion.isCast() && (conversion.getFromType().isSuperTypeOf(conversion.getToType()) || conversion.getFromType().isCompatibleWith(conversion.getToType()))) {
            As castedOperand = (As)this.of.createAs().withOperand(expression).withResultType(conversion.getToType());
            castedOperand.setAsTypeSpecifier(this.dataTypeToTypeSpecifier(castedOperand.getResultType()));
            if (castedOperand.getResultType() instanceof NamedType) {
                castedOperand.setAsType(this.dataTypeToQName(castedOperand.getResultType()));
            }
            return castedOperand;
        }
        if (conversion.isCast() && conversion.getConversion() != null && (conversion.getFromType().isSuperTypeOf(conversion.getConversion().getFromType()) || conversion.getFromType().isCompatibleWith(conversion.getConversion().getFromType()))) {
            As castedOperand = (As)this.of.createAs().withOperand(expression).withResultType(conversion.getConversion().getFromType());
            castedOperand.setAsTypeSpecifier(this.dataTypeToTypeSpecifier(castedOperand.getResultType()));
            if (castedOperand.getResultType() instanceof NamedType) {
                castedOperand.setAsType(this.dataTypeToQName(castedOperand.getResultType()));
            }
            return this.convertExpression((Expression)castedOperand, conversion.getConversion());
        }
        if (conversion.isListConversion()) {
            return this.convertListExpression(expression, conversion);
        }
        if (conversion.isListDemotion()) {
            return this.demoteListExpression(expression, conversion);
        }
        if (conversion.isListPromotion()) {
            return this.promoteListExpression(expression, conversion);
        }
        if (conversion.isIntervalConversion()) {
            return this.convertIntervalExpression(expression, conversion);
        }
        if (conversion.getOperator() != null) {
            FunctionRef functionRef = this.of.createFunctionRef().withLibraryName(conversion.getOperator().getLibraryName()).withName(conversion.getOperator().getName()).withOperand(new Expression[]{expression});
            Expression systemFunction = this.systemFunctionResolver.resolveSystemFunction(functionRef);
            if (systemFunction != null) {
                return systemFunction;
            }
            this.resolveCall(functionRef.getLibraryName(), functionRef.getName(), new FunctionRefInvocation(functionRef));
            return functionRef;
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Boolean"))) {
            return (Expression)this.of.createToBoolean().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Integer"))) {
            return (Expression)this.of.createToInteger().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Decimal"))) {
            return (Expression)this.of.createToDecimal().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "String"))) {
            return (Expression)this.of.createToString().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "DateTime"))) {
            return (Expression)this.of.createToDateTime().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Time"))) {
            return (Expression)this.of.createToTime().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Quantity"))) {
            return (Expression)this.of.createToQuantity().withOperand(expression).withResultType(conversion.getToType());
        }
        Convert convertedOperand = (Convert)this.of.createConvert().withOperand(expression).withResultType(conversion.getToType());
        if (convertedOperand.getResultType() instanceof NamedType) {
            convertedOperand.setToType(this.dataTypeToQName(convertedOperand.getResultType()));
        } else {
            convertedOperand.setToTypeSpecifier(this.dataTypeToTypeSpecifier(convertedOperand.getResultType()));
        }
        return convertedOperand;
    }

    public void verifyType(DataType actualType, DataType expectedType) {
        if (expectedType.isSuperTypeOf(actualType) || actualType.isCompatibleWith(expectedType)) {
            return;
        }
        Conversion conversion = this.findConversion(actualType, expectedType, true);
        if (conversion != null) {
            return;
        }
        DataTypes.verifyType(actualType, expectedType);
    }

    public DataType findCompatibleType(DataType first, DataType second) {
        if (first == null || second == null) {
            return null;
        }
        if (first.equals(DataType.ANY)) {
            return second;
        }
        if (second.equals(DataType.ANY)) {
            return first;
        }
        if (first.isSuperTypeOf(second) || second.isCompatibleWith(first)) {
            return first;
        }
        if (second.isSuperTypeOf(first) || first.isCompatibleWith(second)) {
            return second;
        }
        Conversion conversion = this.findConversion(second, first, true);
        if (conversion != null) {
            return first;
        }
        conversion = this.findConversion(first, second, true);
        if (conversion != null) {
            return second;
        }
        return null;
    }

    public DataType ensureCompatibleTypes(DataType first, DataType second) {
        DataType compatibleType = this.findCompatibleType(first, second);
        if (compatibleType != null) {
            return compatibleType;
        }
        DataTypes.verifyType(second, first);
        return first;
    }

    public Expression ensureCompatible(Expression expression, DataType targetType) {
        if (targetType == null) {
            return this.of.createNull();
        }
        if (!targetType.isSuperTypeOf(expression.getResultType())) {
            return this.convertExpression(expression, targetType);
        }
        return expression;
    }

    public Literal createLiteral(String val, String type) {
        DataType resultType = this.resolveTypeName("System", type);
        Literal result = this.of.createLiteral().withValue(val).withValueType(this.dataTypeToQName(resultType));
        result.setResultType(resultType);
        return result;
    }

    public Literal createLiteral(String string) {
        return this.createLiteral(String.valueOf(string), "String");
    }

    public Literal createLiteral(Boolean bool) {
        return this.createLiteral(String.valueOf(bool), "Boolean");
    }

    public Literal createLiteral(Integer integer) {
        return this.createLiteral(String.valueOf(integer), "Integer");
    }

    public Literal createLiteral(Double value) {
        return this.createLiteral(String.valueOf(value), "Decimal");
    }

    public Literal createNumberLiteral(String value) {
        DataType resultType = this.resolveTypeName("System", value.contains(".") ? "Decimal" : "Integer");
        Literal result = this.of.createLiteral().withValue(value).withValueType(this.dataTypeToQName(resultType));
        result.setResultType(resultType);
        return result;
    }

    public Interval createInterval(Expression low, boolean lowClosed, Expression high, boolean highClosed) {
        Interval result = this.of.createInterval().withLow(low).withLowClosed(Boolean.valueOf(lowClosed)).withHigh(high).withHighClosed(Boolean.valueOf(highClosed));
        DataType pointType = this.ensureCompatibleTypes(result.getLow().getResultType(), result.getHigh().getResultType());
        result.setResultType((DataType)new IntervalType(pointType));
        result.setLow(this.ensureCompatible(result.getLow(), pointType));
        result.setHigh(this.ensureCompatible(result.getHigh(), pointType));
        return result;
    }

    public QName dataTypeToQName(DataType type) {
        if (type instanceof NamedType) {
            NamedType namedType = (NamedType)type;
            ModelInfo modelInfo = this.getModel(namedType.getNamespace()).getModelInfo();
            return new QName(modelInfo.getUrl(), namedType.getSimpleName());
        }
        throw new IllegalArgumentException("A named type is required in this context.");
    }

    public TypeSpecifier dataTypeToTypeSpecifier(DataType type) {
        if (type instanceof NamedType) {
            return (TypeSpecifier)this.of.createNamedTypeSpecifier().withName(this.dataTypeToQName(type)).withResultType(type);
        }
        if (type instanceof ListType) {
            return this.listTypeToTypeSpecifier((ListType)type);
        }
        if (type instanceof IntervalType) {
            return this.intervalTypeToTypeSpecifier((IntervalType)type);
        }
        if (type instanceof TupleType) {
            return this.tupleTypeToTypeSpecifier((TupleType)type);
        }
        if (type instanceof ChoiceType) {
            return this.choiceTypeToTypeSpecifier((ChoiceType)type);
        }
        throw new IllegalArgumentException(String.format("Could not convert type %s to a type specifier.", type));
    }

    private TypeSpecifier listTypeToTypeSpecifier(ListType type) {
        return (TypeSpecifier)this.of.createListTypeSpecifier().withElementType(this.dataTypeToTypeSpecifier(type.getElementType())).withResultType((DataType)type);
    }

    private TypeSpecifier intervalTypeToTypeSpecifier(IntervalType type) {
        return (TypeSpecifier)this.of.createIntervalTypeSpecifier().withPointType(this.dataTypeToTypeSpecifier(type.getPointType())).withResultType((DataType)type);
    }

    private TypeSpecifier tupleTypeToTypeSpecifier(TupleType type) {
        return (TypeSpecifier)this.of.createTupleTypeSpecifier().withElement(this.tupleTypeElementsToTupleElementDefinitions(type.getElements())).withResultType((DataType)type);
    }

    private TupleElementDefinition[] tupleTypeElementsToTupleElementDefinitions(Iterable<TupleTypeElement> elements) {
        ArrayList<TupleElementDefinition> definitions = new ArrayList<TupleElementDefinition>();
        for (TupleTypeElement element : elements) {
            definitions.add(this.of.createTupleElementDefinition().withName(element.getName()).withType(this.dataTypeToTypeSpecifier(element.getType())));
        }
        return definitions.toArray(new TupleElementDefinition[definitions.size()]);
    }

    private TypeSpecifier choiceTypeToTypeSpecifier(ChoiceType type) {
        return (TypeSpecifier)this.of.createChoiceTypeSpecifier().withType(this.choiceTypeTypesToTypeSpecifiers(type)).withResultType((DataType)type);
    }

    private TypeSpecifier[] choiceTypeTypesToTypeSpecifiers(ChoiceType choiceType) {
        ArrayList<TypeSpecifier> specifiers = new ArrayList<TypeSpecifier>();
        for (DataType type : choiceType.getTypes()) {
            specifiers.add(this.dataTypeToTypeSpecifier(type));
        }
        return specifiers.toArray(new TypeSpecifier[specifiers.size()]);
    }

    public DataType resolvePath(DataType sourceType, String path) {
        String[] identifiers = path.split("\\.");
        for (int i = 0; i < identifiers.length; ++i) {
            sourceType = this.resolveProperty(sourceType, identifiers[i]);
        }
        return sourceType;
    }

    public DataType resolveProperty(DataType sourceType, String identifier) {
        return this.resolveProperty(sourceType, identifier, true);
    }

    public DataType resolveProperty(DataType sourceType, String identifier, boolean mustResolve) {
        for (DataType currentType = sourceType; currentType != null; currentType = currentType.getBaseType()) {
            if (currentType instanceof ClassType) {
                ClassType classType = (ClassType)currentType;
                for (ClassTypeElement e : classType.getElements()) {
                    if (!e.getName().equals(identifier)) continue;
                    if (e.isProhibited()) {
                        throw new IllegalArgumentException(String.format("Element %s cannot be referenced because it is marked prohibited in type %s.", e.getName(), ((ClassType)currentType).getName()));
                    }
                    return e.getType();
                }
            } else if (currentType instanceof TupleType) {
                TupleType tupleType = (TupleType)currentType;
                for (ClassTypeElement e : tupleType.getElements()) {
                    if (!e.getName().equals(identifier)) continue;
                    return e.getType();
                }
            } else {
                if (currentType instanceof IntervalType) {
                    IntervalType intervalType = (IntervalType)currentType;
                    switch (identifier) {
                        case "low": 
                        case "high": {
                            return intervalType.getPointType();
                        }
                        case "lowClosed": 
                        case "highClosed": {
                            return this.resolveTypeName("System", "Boolean");
                        }
                    }
                    throw new IllegalArgumentException(String.format("Invalid interval property name %s.", identifier));
                }
                if (currentType instanceof ChoiceType) {
                    ChoiceType choiceType = (ChoiceType)currentType;
                    HashSet<DataType> resultTypes = new HashSet<DataType>();
                    Iterator<Object> iterator = choiceType.getTypes().iterator();
                    while (iterator.hasNext()) {
                        DataType choice = (DataType)iterator.next();
                        DataType resultType = this.resolveProperty(choice, identifier, false);
                        if (resultType == null) continue;
                        resultTypes.add(resultType);
                    }
                    if (resultTypes.size() > 1) {
                        return new ChoiceType(resultTypes);
                    }
                    if (resultTypes.size() == 1 && (iterator = resultTypes.iterator()).hasNext()) {
                        DataType resultType = (DataType)iterator.next();
                        return resultType;
                    }
                } else if (currentType instanceof ListType && this.listTraversal) {
                    ListType listType = (ListType)currentType;
                    DataType resultType = this.resolveProperty(listType.getElementType(), identifier);
                    return new ListType(resultType);
                }
            }
            if (currentType.getBaseType() == null) break;
        }
        if (mustResolve) {
            throw new IllegalArgumentException(String.format("Member %s not found for type %s.", identifier, sourceType != null ? sourceType.toLabel() : null));
        }
        return null;
    }

    public Expression resolveIdentifier(String identifier, boolean mustResolve) {
        IdentifierRef resultElement = this.resolveQueryResultElement(identifier);
        if (resultElement != null) {
            return resultElement;
        }
        Expression thisElement = this.resolveQueryThisElement(identifier);
        if (thisElement != null) {
            return thisElement;
        }
        AliasedQuerySource alias = this.resolveAlias(identifier);
        if (alias != null) {
            AliasRef result = this.of.createAliasRef().withName(identifier);
            if (alias.getResultType() instanceof ListType) {
                result.setResultType(((ListType)alias.getResultType()).getElementType());
            } else {
                result.setResultType(alias.getResultType());
            }
            return result;
        }
        LetClause let = this.resolveQueryLet(identifier);
        if (let != null) {
            QueryLetRef result = this.of.createQueryLetRef().withName(identifier);
            result.setResultType(let.getResultType());
            return result;
        }
        OperandRef operandRef = this.resolveOperandRef(identifier);
        if (operandRef != null) {
            return operandRef;
        }
        Element element = this.resolve(identifier);
        if (element instanceof ExpressionDef) {
            ExpressionRef expressionRef = this.of.createExpressionRef().withName(((ExpressionDef)element).getName());
            expressionRef.setResultType(this.getExpressionDefResultType((ExpressionDef)element));
            if (expressionRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to expression %s because its definition contains errors.", expressionRef.getName()));
            }
            return expressionRef;
        }
        if (element instanceof ParameterDef) {
            ParameterRef parameterRef = this.of.createParameterRef().withName(((ParameterDef)element).getName());
            parameterRef.setResultType(element.getResultType());
            if (parameterRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to parameter %s because its definition contains errors.", parameterRef.getName()));
            }
            return parameterRef;
        }
        if (element instanceof ValueSetDef) {
            ValueSetRef valuesetRef = this.of.createValueSetRef().withName(((ValueSetDef)element).getName());
            valuesetRef.setResultType(element.getResultType());
            if (valuesetRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to valueset %s because its definition contains errors.", valuesetRef.getName()));
            }
            return valuesetRef;
        }
        if (element instanceof CodeSystemDef) {
            CodeSystemRef codesystemRef = this.of.createCodeSystemRef().withName(((CodeSystemDef)element).getName());
            codesystemRef.setResultType(element.getResultType());
            if (codesystemRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to codesystem %s because its definition contains errors.", codesystemRef.getName()));
            }
            return codesystemRef;
        }
        if (element instanceof CodeDef) {
            CodeRef codeRef = this.of.createCodeRef().withName(((CodeDef)element).getName());
            codeRef.setResultType(element.getResultType());
            if (codeRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to code %s because its definition contains errors.", codeRef.getName()));
            }
            return codeRef;
        }
        if (element instanceof ConceptDef) {
            ConceptRef conceptRef = this.of.createConceptRef().withName(((ConceptDef)element).getName());
            conceptRef.setResultType(element.getResultType());
            if (conceptRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to concept %s because its definition contains error.", conceptRef.getName()));
            }
            return conceptRef;
        }
        if (element instanceof IncludeDef) {
            LibraryRef libraryRef = new LibraryRef();
            libraryRef.setLibraryName(((IncludeDef)element).getLocalIdentifier());
            return libraryRef;
        }
        if (mustResolve) {
            throw new IllegalArgumentException(String.format("Could not resolve identifier %s in the current library.", identifier));
        }
        return null;
    }

    public Expression resolveAccessor(Expression left, String memberIdentifier) {
        if (left instanceof LibraryRef) {
            String libraryName = ((LibraryRef)left).getLibraryName();
            TranslatedLibrary referencedLibrary = this.resolveLibrary(libraryName);
            Element element = referencedLibrary.resolve(memberIdentifier);
            if (element instanceof ExpressionDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ExpressionDef)element).getAccessLevel());
                ExpressionRef result = this.of.createExpressionRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(this.getExpressionDefResultType((ExpressionDef)element));
                return result;
            }
            if (element instanceof ParameterDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ParameterDef)element).getAccessLevel());
                ParameterRef result = this.of.createParameterRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof ValueSetDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ValueSetDef)element).getAccessLevel());
                ValueSetRef result = this.of.createValueSetRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof CodeSystemDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((CodeSystemDef)element).getAccessLevel());
                CodeSystemRef result = this.of.createCodeSystemRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof CodeDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((CodeDef)element).getAccessLevel());
                CodeRef result = this.of.createCodeRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof ConceptDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ConceptDef)element).getAccessLevel());
                ConceptRef result = this.of.createConceptRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            throw new IllegalArgumentException(String.format("Could not resolve identifier %s in library %s.", memberIdentifier, referencedLibrary.getIdentifier().getId()));
        }
        if (left instanceof AliasRef) {
            Property result = this.of.createProperty().withScope(((AliasRef)left).getName()).withPath(memberIdentifier);
            result.setResultType(this.resolveProperty(left.getResultType(), memberIdentifier));
            return result;
        }
        if (left.getResultType() instanceof ListType && this.listTraversal) {
            ListType listType = (ListType)left.getResultType();
            DataType propertyType = this.resolveProperty(listType.getElementType(), memberIdentifier);
            Property accessor = this.of.createProperty().withSource((Expression)this.of.createAliasRef().withName("$this")).withPath(memberIdentifier);
            accessor.setResultType(propertyType);
            IsNull isNull = this.of.createIsNull().withOperand((Expression)accessor);
            isNull.setResultType(this.resolveTypeName("System", "Boolean"));
            Not not = this.of.createNot().withOperand((Expression)isNull);
            not.setResultType(this.resolveTypeName("System", "Boolean"));
            accessor = this.of.createProperty().withSource((Expression)this.of.createAliasRef().withName("$this")).withPath(memberIdentifier);
            accessor.setResultType(propertyType);
            AliasedQuerySource source = this.of.createAliasedQuerySource().withExpression(left).withAlias("$this");
            source.setResultType(left.getResultType());
            Query query = this.of.createQuery().withSource(new AliasedQuerySource[]{source}).withWhere((Expression)not).withReturn(this.of.createReturnClause().withExpression((Expression)accessor));
            query.setResultType((DataType)new ListType(accessor.getResultType()));
            if (accessor.getResultType() instanceof ListType) {
                Flatten result = this.of.createFlatten().withOperand((Expression)query);
                result.setResultType(accessor.getResultType());
                return result;
            }
            return query;
        }
        Property result = this.of.createProperty().withSource(left).withPath(memberIdentifier);
        result.setResultType(this.resolveProperty(left.getResultType(), memberIdentifier));
        return result;
    }

    private IdentifierRef resolveQueryResultElement(String identifier) {
        QueryContext query;
        if (this.inQueryContext() && (query = this.peekQueryContext()).inSortClause() && !query.isSingular()) {
            if (identifier.equals("$this")) {
                IdentifierRef result = new IdentifierRef().withName(identifier);
                result.setResultType(query.getResultElementType());
                return result;
            }
            DataType sortColumnType = this.resolveProperty(query.getResultElementType(), identifier, false);
            if (sortColumnType != null) {
                IdentifierRef result = new IdentifierRef().withName(identifier);
                result.setResultType(sortColumnType);
                return result;
            }
        }
        return null;
    }

    private AliasedQuerySource resolveAlias(String identifier) {
        if (this.inQueryContext()) {
            for (int i = this.getScope().getQueries().size() - 1; i >= 0; --i) {
                AliasedQuerySource source = ((QueryContext)this.getScope().getQueries().get(i)).resolveAlias(identifier);
                if (source == null) continue;
                return source;
            }
        }
        return null;
    }

    private Expression resolveQueryThisElement(String identifier) {
        AliasedQuerySource source;
        QueryContext query;
        if (this.inQueryContext() && (query = this.peekQueryContext()).isImplicit() && (source = this.resolveAlias("$this")) != null) {
            AliasRef aliasRef = this.of.createAliasRef().withName("$this");
            if (source.getResultType() instanceof ListType) {
                aliasRef.setResultType(((ListType)source.getResultType()).getElementType());
            } else {
                aliasRef.setResultType(source.getResultType());
            }
            DataType resultType = this.resolveProperty(aliasRef.getResultType(), identifier, false);
            if (resultType != null) {
                return this.resolveAccessor((Expression)aliasRef, identifier);
            }
        }
        return null;
    }

    private LetClause resolveQueryLet(String identifier) {
        if (this.inQueryContext()) {
            for (int i = this.getScope().getQueries().size() - 1; i >= 0; --i) {
                LetClause let = ((QueryContext)this.getScope().getQueries().get(i)).resolveLet(identifier);
                if (let == null) continue;
                return let;
            }
        }
        return null;
    }

    private OperandRef resolveOperandRef(String identifier) {
        if (!this.functionDefs.empty()) {
            for (OperandDef operand : this.functionDefs.peek().getOperand()) {
                if (!operand.getName().equals(identifier)) continue;
                return (OperandRef)this.of.createOperandRef().withName(identifier).withResultType(operand.getResultType());
            }
        }
        return null;
    }

    private DataType getExpressionDefResultType(ExpressionDef expressionDef) {
        if (this.currentExpressionContext().equals(expressionDef.getContext())) {
            return expressionDef.getResultType();
        }
        if (this.inPatientContext()) {
            return expressionDef.getResultType();
        }
        if (this.inPopulationContext()) {
            DataType resultType;
            if (this.inQueryContext() && this.getScope().getQueries().peek().inSourceClause()) {
                this.getScope().getQueries().peek().referencePatientContext();
            }
            if (!((resultType = expressionDef.getResultType()) instanceof ListType)) {
                return new ListType(resultType);
            }
            return resultType;
        }
        throw new IllegalArgumentException(String.format("Invalid context reference from %s context to %s context.", this.currentExpressionContext(), expressionDef.getContext()));
    }

    public Exception determineRootCause() {
        ExpressionDefinitionContext currentContext;
        if (!this.expressionDefinitions.isEmpty() && (currentContext = (ExpressionDefinitionContext)this.expressionDefinitions.peek()) != null) {
            return currentContext.getRootCause();
        }
        return null;
    }

    public void setRootCause(Exception rootCause) {
        ExpressionDefinitionContext currentContext;
        if (!this.expressionDefinitions.isEmpty() && (currentContext = (ExpressionDefinitionContext)this.expressionDefinitions.peek()) != null) {
            currentContext.setRootCause(rootCause);
        }
    }

    public void pushExpressionDefinition(String identifier) {
        if (this.expressionDefinitions.contains(identifier)) {
            throw new IllegalArgumentException(String.format("Cannot resolve reference to expression or function %s because it results in a circular reference.", identifier));
        }
        this.expressionDefinitions.push(new ExpressionDefinitionContext(identifier));
    }

    public void popExpressionDefinition() {
        this.expressionDefinitions.pop();
    }

    private boolean hasScope() {
        return !this.expressionDefinitions.empty();
    }

    private Scope getScope() {
        return ((ExpressionDefinitionContext)this.expressionDefinitions.peek()).getScope();
    }

    public void pushExpressionContext(String context) {
        this.expressionContext.push(context);
    }

    public void popExpressionContext() {
        if (this.expressionContext.empty()) {
            throw new IllegalStateException("Expression context stack is empty.");
        }
        this.expressionContext.pop();
    }

    public String currentExpressionContext() {
        if (this.expressionContext.empty()) {
            throw new IllegalStateException("Expression context stack is empty.");
        }
        return this.expressionContext.peek();
    }

    public boolean inPatientContext() {
        return this.currentExpressionContext().equals("Patient");
    }

    public boolean inPopulationContext() {
        return this.currentExpressionContext().equals("Population");
    }

    public boolean inQueryContext() {
        return this.hasScope() && this.getScope().getQueries().size() > 0;
    }

    public void pushQueryContext(QueryContext context) {
        this.getScope().getQueries().push(context);
    }

    public QueryContext popQueryContext() {
        return this.getScope().getQueries().pop();
    }

    public QueryContext peekQueryContext() {
        return this.getScope().getQueries().peek();
    }

    public void pushExpressionTarget(Expression target) {
        this.getScope().getTargets().push(target);
    }

    public Expression popExpressionTarget() {
        return this.getScope().getTargets().pop();
    }

    public boolean hasExpressionTarget() {
        return this.hasScope() && !this.getScope().getTargets().isEmpty();
    }

    public void beginFunctionDef(FunctionDef functionDef) {
        this.functionDefs.push(functionDef);
    }

    public void endFunctionDef() {
        this.functionDefs.pop();
    }

    private class ExpressionDefinitionContextStack
    extends Stack<ExpressionDefinitionContext> {
        private ExpressionDefinitionContextStack() {
        }

        public boolean contains(String identifier) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!((ExpressionDefinitionContext)this.elementAt(i)).getIdentifier().equals(identifier)) continue;
                return true;
            }
            return false;
        }
    }

    private class ExpressionDefinitionContext {
        private String identifier;
        private Scope scope;
        private Exception rootCause;

        public ExpressionDefinitionContext(String identifier) {
            this.scope = new Scope();
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Scope getScope() {
            return this.scope;
        }

        public Exception getRootCause() {
            return this.rootCause;
        }

        public void setRootCause(Exception rootCause) {
            this.rootCause = rootCause;
        }
    }

    private class Scope {
        private final Stack<Expression> targets = new Stack();
        private final Stack<QueryContext> queries = new Stack();

        private Scope() {
        }

        public Stack<Expression> getTargets() {
            return this.targets;
        }

        public Stack<QueryContext> getQueries() {
            return this.queries;
        }
    }
}

