/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.preprocessor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.preprocessor.CodeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.CodesystemDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ConceptDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ExpressionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.FunctionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.IncludeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ParameterDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.UsingDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ValuesetDefinitionInfo;

public class LibraryInfo {
    private String libraryName;
    private String version;
    private UsingDefinitionInfo preferredUsingDefinition;
    private final Map<String, UsingDefinitionInfo> usingDefinitions = new LinkedHashMap<String, UsingDefinitionInfo>();
    private final Map<String, IncludeDefinitionInfo> includeDefinitions = new LinkedHashMap<String, IncludeDefinitionInfo>();
    private final Map<String, CodesystemDefinitionInfo> codesystemDefinitions = new LinkedHashMap<String, CodesystemDefinitionInfo>();
    private final Map<String, ValuesetDefinitionInfo> valuesetDefinitions = new LinkedHashMap<String, ValuesetDefinitionInfo>();
    private final Map<String, CodeDefinitionInfo> codeDefinitions = new LinkedHashMap<String, CodeDefinitionInfo>();
    private final Map<String, ConceptDefinitionInfo> conceptDefinitions = new LinkedHashMap<String, ConceptDefinitionInfo>();
    private final Map<String, ParameterDefinitionInfo> parameterDefinitions = new LinkedHashMap<String, ParameterDefinitionInfo>();
    private final Map<String, ExpressionDefinitionInfo> expressionDefinitions = new LinkedHashMap<String, ExpressionDefinitionInfo>();
    private final Map<String, List<FunctionDefinitionInfo>> functionDefinitions = new LinkedHashMap<String, List<FunctionDefinitionInfo>>();

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public LibraryInfo withLibraryName(String value) {
        this.setLibraryName(value);
        return this;
    }

    public LibraryInfo withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public void addUsingDefinition(UsingDefinitionInfo usingDefinition) {
        if (this.preferredUsingDefinition == null) {
            this.preferredUsingDefinition = usingDefinition;
        }
        this.usingDefinitions.put(usingDefinition.getName(), usingDefinition);
    }

    public UsingDefinitionInfo resolveModelReference(String identifier) {
        return this.usingDefinitions.get(identifier);
    }

    public UsingDefinitionInfo getDefaultUsingDefinition() {
        return this.preferredUsingDefinition;
    }

    public String getDefaultModelName() {
        UsingDefinitionInfo usingDefinitionInfo = this.getDefaultUsingDefinition();
        if (usingDefinitionInfo == null) {
            throw new IllegalArgumentException("Could not determine a default model because no usings have been defined.");
        }
        return usingDefinitionInfo.getName();
    }

    public void addIncludeDefinition(IncludeDefinitionInfo includeDefinition) {
        this.includeDefinitions.put(includeDefinition.getLocalName(), includeDefinition);
    }

    public IncludeDefinitionInfo resolveLibraryReference(String identifier) {
        return this.includeDefinitions.get(identifier);
    }

    public String resolveLibraryName(String identifier) {
        IncludeDefinitionInfo includeDefinition = this.resolveLibraryReference(identifier);
        if (includeDefinition != null) {
            return includeDefinition.getLocalName();
        }
        return null;
    }

    public void addParameterDefinition(ParameterDefinitionInfo parameterDefinition) {
        this.parameterDefinitions.put(parameterDefinition.getName(), parameterDefinition);
    }

    public ParameterDefinitionInfo resolveParameterReference(String identifier) {
        return this.parameterDefinitions.get(identifier);
    }

    public String resolveParameterName(String identifier) {
        ParameterDefinitionInfo parameterDefinition = this.resolveParameterReference(identifier);
        if (parameterDefinition != null) {
            return parameterDefinition.getName();
        }
        return null;
    }

    public void addCodesystemDefinition(CodesystemDefinitionInfo codesystemDefinition) {
        this.codesystemDefinitions.put(codesystemDefinition.getName(), codesystemDefinition);
    }

    public CodesystemDefinitionInfo resolveCodesystemReference(String identifier) {
        return this.codesystemDefinitions.get(identifier);
    }

    public void addValuesetDefinition(ValuesetDefinitionInfo valuesetDefinition) {
        this.valuesetDefinitions.put(valuesetDefinition.getName(), valuesetDefinition);
    }

    public ValuesetDefinitionInfo resolveValuesetReference(String identifier) {
        return this.valuesetDefinitions.get(identifier);
    }

    public String resolveValuesetName(String identifier) {
        ValuesetDefinitionInfo valuesetDefinition = this.resolveValuesetReference(identifier);
        if (valuesetDefinition != null) {
            return valuesetDefinition.getName();
        }
        return null;
    }

    public void addCodeDefinition(CodeDefinitionInfo codeDefinition) {
        this.codeDefinitions.put(codeDefinition.getName(), codeDefinition);
    }

    public CodeDefinitionInfo resolveCodeReference(String identifier) {
        return this.codeDefinitions.get(identifier);
    }

    public void addConceptDefinition(ConceptDefinitionInfo conceptDefinition) {
        this.conceptDefinitions.put(conceptDefinition.getName(), conceptDefinition);
    }

    public ConceptDefinitionInfo resolveConceptReference(String identifier) {
        return this.conceptDefinitions.get(identifier);
    }

    public void addExpressionDefinition(ExpressionDefinitionInfo letStatement) {
        this.expressionDefinitions.put(letStatement.getName(), letStatement);
    }

    public ExpressionDefinitionInfo resolveExpressionReference(String identifier) {
        return this.expressionDefinitions.get(identifier);
    }

    public String resolveExpressionName(String identifier) {
        ExpressionDefinitionInfo letStatement = this.resolveExpressionReference(identifier);
        if (letStatement != null) {
            return letStatement.getName();
        }
        return null;
    }

    public void addFunctionDefinition(FunctionDefinitionInfo functionDefinition) {
        List<FunctionDefinitionInfo> infos = this.functionDefinitions.get(functionDefinition.getName());
        if (infos == null) {
            infos = new ArrayList<FunctionDefinitionInfo>();
            this.functionDefinitions.put(functionDefinition.getName(), infos);
        }
        infos.add(functionDefinition);
    }

    public Iterable<FunctionDefinitionInfo> resolveFunctionReference(String identifier) {
        return this.functionDefinitions.get(identifier);
    }

    public String resolveFunctionName(String identifier) {
        Iterable<FunctionDefinitionInfo> functionDefinitions = this.resolveFunctionReference(identifier);
        Iterator<FunctionDefinitionInfo> iterator = functionDefinitions.iterator();
        if (iterator.hasNext()) {
            FunctionDefinitionInfo functionInfo = iterator.next();
            return functionInfo.getName();
        }
        return null;
    }
}

