/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.InstantiationResult;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.SimpleType;
import org.hl7.cql.model.TypeParameter;

public class InstantiationContextImpl
implements InstantiationContext {
    private Map<TypeParameter, DataType> typeMap;
    private OperatorMap operatorMap;
    private ConversionMap conversionMap;
    private int conversionScore;

    public InstantiationContextImpl(Map<TypeParameter, DataType> typeMap, OperatorMap operatorMap, ConversionMap conversionMap) {
        if (typeMap == null) {
            throw new IllegalArgumentException("typeMap is null");
        }
        if (operatorMap == null) {
            throw new IllegalArgumentException("operatorMap is null");
        }
        if (conversionMap == null) {
            throw new IllegalArgumentException("conversionMap is null");
        }
        this.typeMap = typeMap;
        this.operatorMap = operatorMap;
        this.conversionMap = conversionMap;
    }

    public int getConversionScore() {
        return this.conversionScore;
    }

    public boolean isInstantiable(TypeParameter parameter, DataType callType) {
        DataType boundType = this.typeMap.get(parameter);
        if (boundType == null) {
            this.typeMap.put(parameter, callType);
            return true;
        }
        if (boundType.isSuperTypeOf(callType) || callType.isCompatibleWith(boundType)) {
            return true;
        }
        if (callType.isSuperTypeOf(boundType) || boundType.isCompatibleWith(callType)) {
            this.typeMap.put(parameter, callType);
            return true;
        }
        Conversion conversion = this.conversionMap.findConversion(callType, boundType, true, this.operatorMap);
        if (conversion != null) {
            ListType boundListType;
            if (boundType instanceof ListType && ((boundListType = (ListType)boundType).getElementType().isSuperTypeOf(callType) || callType.isCompatibleWith(boundListType.getElementType()))) {
                this.typeMap.put(parameter, callType);
                this.conversionScore -= 4;
            }
            return true;
        }
        conversion = this.conversionMap.findConversion(boundType, callType, true, this.operatorMap);
        if (conversion != null) {
            this.typeMap.put(parameter, callType);
            this.conversionScore -= 2;
            return true;
        }
        return false;
    }

    public DataType instantiate(TypeParameter parameter) {
        DataType result = this.typeMap.get(parameter);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type parameter %s.", parameter.getIdentifier()));
        }
        return result;
    }

    public Iterable<IntervalType> getIntervalConversionTargets(DataType callType) {
        ArrayList<IntervalType> results = new ArrayList<IntervalType>();
        for (Conversion c : this.conversionMap.getConversions(callType)) {
            if (!(c.getToType() instanceof IntervalType)) continue;
            results.add((IntervalType)c.getToType());
            this.conversionScore += 2;
        }
        return results;
    }

    public Iterable<ListType> getListConversionTargets(DataType callType) {
        ArrayList<ListType> results = new ArrayList<ListType>();
        for (Conversion c : this.conversionMap.getConversions(callType)) {
            if (!(c.getToType() instanceof ListType)) continue;
            results.add((ListType)c.getToType());
            this.conversionScore += 2;
        }
        if (results.isEmpty()) {
            for (Conversion c : this.conversionMap.getGenericConversions()) {
                InstantiationResult instantiationResult;
                Operator operator;
                if (c.getOperator() == null || !(c.getToType() instanceof ListType) || (operator = (instantiationResult = ((GenericOperator)c.getOperator()).instantiate(new Signature(callType), this.operatorMap, this.conversionMap)).getOperator()) == null) continue;
                this.operatorMap.addOperator(operator);
                Conversion conversion = new Conversion(operator, true);
                this.conversionMap.add(conversion);
                results.add((ListType)conversion.getToType());
            }
        }
        if (results.isEmpty() && !(callType instanceof ListType)) {
            results.add(new ListType(callType));
            this.conversionScore += 4;
        }
        return results;
    }

    public Iterable<SimpleType> getSimpleConversionTargets(DataType callType) {
        ListType callListType;
        ArrayList<SimpleType> results = new ArrayList<SimpleType>();
        for (Conversion c : this.conversionMap.getConversions(callType)) {
            if (!(c.getToType() instanceof SimpleType)) continue;
            results.add((SimpleType)c.getToType());
            this.conversionScore += 2;
        }
        if (results.isEmpty()) {
            for (Conversion c : this.conversionMap.getGenericConversions()) {
                InstantiationResult instantiationResult;
                Operator operator;
                if (c.getOperator() == null || !(c.getToType() instanceof SimpleType) || (operator = (instantiationResult = ((GenericOperator)c.getOperator()).instantiate(new Signature(callType), this.operatorMap, this.conversionMap)).getOperator()) == null) continue;
                this.operatorMap.addOperator(operator);
                Conversion conversion = new Conversion(operator, true);
                this.conversionMap.add(conversion);
                results.add((SimpleType)conversion.getToType());
            }
        }
        if (results.isEmpty() && callType instanceof ListType && (callListType = (ListType)callType).getElementType() instanceof SimpleType) {
            results.add((SimpleType)callListType.getElementType());
            this.conversionScore += 3;
        }
        return results;
    }
}

