/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.ProfileType;
import org.hl7.cql.model.SimpleType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.elm_modelinfo.r1.ChoiceTypeInfo;
import org.hl7.elm_modelinfo.r1.ChoiceTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ClassInfo;
import org.hl7.elm_modelinfo.r1.ClassInfoElement;
import org.hl7.elm_modelinfo.r1.ConversionInfo;
import org.hl7.elm_modelinfo.r1.IntervalTypeInfo;
import org.hl7.elm_modelinfo.r1.IntervalTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ListTypeInfo;
import org.hl7.elm_modelinfo.r1.ListTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.NamedTypeSpecifier;
import org.hl7.elm_modelinfo.r1.ProfileInfo;
import org.hl7.elm_modelinfo.r1.SimpleTypeInfo;
import org.hl7.elm_modelinfo.r1.TupleTypeInfo;
import org.hl7.elm_modelinfo.r1.TupleTypeInfoElement;
import org.hl7.elm_modelinfo.r1.TypeInfo;
import org.hl7.elm_modelinfo.r1.TypeSpecifier;

public class ModelImporter {
    private ModelInfo modelInfo;
    private Map<String, TypeInfo> typeInfoIndex;
    private Map<String, DataType> resolvedTypes;
    private List<DataType> dataTypes;
    private List<Conversion> conversions;

    public ModelImporter(ModelInfo modelInfo, Iterable<DataType> systemTypes) {
        NamedType namedSystemType;
        if (modelInfo == null) {
            throw new IllegalArgumentException("modelInfo is null");
        }
        this.modelInfo = modelInfo;
        this.typeInfoIndex = new HashMap<String, TypeInfo>();
        this.resolvedTypes = new HashMap<String, DataType>();
        this.dataTypes = new ArrayList<DataType>();
        this.conversions = new ArrayList<Conversion>();
        if (systemTypes != null) {
            for (DataType systemType : systemTypes) {
                if (!(systemType instanceof NamedType)) continue;
                namedSystemType = (NamedType)systemType;
                this.resolvedTypes.put(namedSystemType.getName(), systemType);
            }
        }
        for (TypeInfo t : this.modelInfo.getTypeInfo()) {
            ClassInfo classInfo;
            if (t instanceof SimpleTypeInfo) {
                this.typeInfoIndex.put(this.ensureUnqualified(((SimpleTypeInfo)t).getName()), t);
                continue;
            }
            if (!(t instanceof ClassInfo) || (classInfo = (ClassInfo)t).getName() == null) continue;
            this.typeInfoIndex.put(this.ensureUnqualified(classInfo.getName()), (TypeInfo)classInfo);
        }
        for (ConversionInfo c : this.modelInfo.getConversionInfo()) {
            DataType fromType = this.resolveTypeNameOrSpecifier(c.getFromType(), c.getFromTypeSpecifier());
            DataType toType = this.resolveTypeNameOrSpecifier(c.getToType(), c.getToTypeSpecifier());
            int qualifierIndex = c.getFunctionName().indexOf(46);
            String libraryName = qualifierIndex >= 0 ? c.getFunctionName().substring(0, qualifierIndex) : null;
            String functionName = qualifierIndex >= 0 ? c.getFunctionName().substring(qualifierIndex + 1) : null;
            Operator operator = new Operator(functionName, new Signature(fromType), toType);
            if (libraryName != null) {
                operator.setLibraryName(libraryName);
            }
            Conversion conversion = new Conversion(operator, true);
            this.conversions.add(conversion);
        }
        for (TypeInfo t : this.modelInfo.getTypeInfo()) {
            this.dataTypes.add(this.resolveTypeInfo(t));
        }
        if (systemTypes != null) {
            for (DataType systemType : systemTypes) {
                if (!(systemType instanceof NamedType)) continue;
                namedSystemType = (NamedType)systemType;
                this.resolvedTypes.remove(namedSystemType.getName());
            }
        }
    }

    public Map<String, DataType> getTypes() {
        return this.resolvedTypes;
    }

    public Iterable<Conversion> getConversions() {
        return this.conversions;
    }

    private String casify(String typeName) {
        return this.casify(typeName, this.modelInfo.isCaseSensitive() != null ? this.modelInfo.isCaseSensitive() : false);
    }

    private String casify(String typeName, boolean caseSensitive) {
        return caseSensitive ? typeName.toLowerCase() : typeName;
    }

    private DataType resolveTypeInfo(TypeInfo t) {
        if (t instanceof SimpleTypeInfo) {
            return this.resolveSimpleType((SimpleTypeInfo)t);
        }
        if (t instanceof ClassInfo) {
            return this.resolveClassType((ClassInfo)t);
        }
        if (t instanceof TupleTypeInfo) {
            return this.resolveTupleType((TupleTypeInfo)t);
        }
        if (t instanceof IntervalTypeInfo) {
            return this.resolveIntervalType((IntervalTypeInfo)t);
        }
        if (t instanceof ListTypeInfo) {
            return this.resolveListType((ListTypeInfo)t);
        }
        if (t instanceof ChoiceTypeInfo) {
            return this.resolveChoiceType((ChoiceTypeInfo)t);
        }
        return null;
    }

    private DataType resolveTypeSpecifier(TypeSpecifier typeSpecifier) {
        if (typeSpecifier == null) {
            return null;
        }
        if (typeSpecifier instanceof NamedTypeSpecifier) {
            NamedTypeSpecifier namedTypeSpecifier = (NamedTypeSpecifier)typeSpecifier;
            String qualifier = namedTypeSpecifier.getModelName();
            if (qualifier == null || qualifier.isEmpty()) {
                qualifier = this.modelInfo.getName();
            }
            String qualifiedTypeName = String.format("%s.%s", qualifier, namedTypeSpecifier.getName());
            return this.resolveTypeName(qualifiedTypeName);
        }
        if (typeSpecifier instanceof IntervalTypeSpecifier) {
            IntervalTypeSpecifier intervalTypeSpecifier = (IntervalTypeSpecifier)typeSpecifier;
            DataType pointType = this.resolveTypeNameOrSpecifier(intervalTypeSpecifier.getPointType(), intervalTypeSpecifier.getPointTypeSpecifier());
            return new IntervalType(pointType);
        }
        if (typeSpecifier instanceof ListTypeSpecifier) {
            ListTypeSpecifier listTypeSpecifier = (ListTypeSpecifier)typeSpecifier;
            DataType elementType = this.resolveTypeNameOrSpecifier(listTypeSpecifier.getElementType(), listTypeSpecifier.getElementTypeSpecifier());
            return new ListType(elementType);
        }
        if (typeSpecifier instanceof ChoiceTypeSpecifier) {
            ChoiceTypeSpecifier choiceTypeSpecifier = (ChoiceTypeSpecifier)typeSpecifier;
            ArrayList<DataType> choices = new ArrayList<DataType>();
            for (TypeSpecifier choice : choiceTypeSpecifier.getChoice()) {
                DataType choiceType = this.resolveTypeSpecifier(choice);
                choices.add(choiceType);
            }
            return new ChoiceType(choices);
        }
        return null;
    }

    private DataType resolveTypeName(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        if (typeName.toLowerCase().startsWith("interval<")) {
            DataType pointType = this.resolveTypeName(typeName.substring(typeName.indexOf(60) + 1, typeName.lastIndexOf(62)));
            return new IntervalType(pointType);
        }
        if (typeName.toLowerCase().startsWith("list<")) {
            DataType elementType = this.resolveTypeName(typeName.substring(typeName.indexOf(60) + 1, typeName.lastIndexOf(62)));
            return new ListType(elementType);
        }
        DataType result = this.lookupType(typeName);
        if (result == null) {
            TypeInfo typeInfo = this.lookupTypeInfo(this.ensureUnqualified(typeName));
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Could not resolve type info for type name %s.", typeName));
            }
            result = this.resolveTypeInfo(typeInfo);
        }
        return result;
    }

    private DataType resolveTypeNameOrSpecifier(String typeName, TypeSpecifier typeSpecifier) {
        if ((typeName == null || typeName.isEmpty()) && typeSpecifier == null) {
            return null;
        }
        if (typeSpecifier != null) {
            return this.resolveTypeSpecifier(typeSpecifier);
        }
        return this.resolveTypeName(typeName);
    }

    private DataType lookupType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        return this.resolvedTypes.get(this.casify(typeName));
    }

    private TypeInfo lookupTypeInfo(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        return this.typeInfoIndex.get(typeName);
    }

    private String ensureQualified(String name) {
        String qualifier = String.format("%s.", this.modelInfo.getName());
        if (!name.startsWith(qualifier)) {
            return String.format("%s%s", qualifier, name);
        }
        return name;
    }

    private String ensureUnqualified(String name) {
        if (name.startsWith(String.format("%s.", this.modelInfo.getName()))) {
            return name.substring(name.indexOf(46) + 1);
        }
        return name;
    }

    private SimpleType resolveSimpleType(SimpleTypeInfo t) {
        String qualifiedTypeName = this.ensureQualified(t.getName());
        DataType lookupType = this.lookupType(qualifiedTypeName);
        if (lookupType instanceof ClassType) {
            throw new IllegalArgumentException("Expected instance of SimpleType but found instance of ClassType instead.");
        }
        SimpleType result = (SimpleType)this.lookupType(qualifiedTypeName);
        if (result == null) {
            result = qualifiedTypeName.equals(DataType.ANY.getName()) ? DataType.ANY : new SimpleType(qualifiedTypeName, this.resolveTypeNameOrSpecifier(t.getBaseType(), t.getBaseTypeSpecifier()));
            this.resolvedTypes.put(this.casify(result.getName()), (DataType)result);
        }
        return result;
    }

    private DataType resolveTypeNameOrSpecifier(TupleTypeInfoElement element) {
        DataType result = this.resolveTypeNameOrSpecifier(element.getElementType(), element.getElementTypeSpecifier());
        if (result == null) {
            result = this.resolveTypeNameOrSpecifier(element.getType(), element.getTypeSpecifier());
        }
        return result;
    }

    private Collection<TupleTypeElement> resolveTupleTypeElements(Collection<TupleTypeInfoElement> infoElements) {
        ArrayList<TupleTypeElement> elements = new ArrayList<TupleTypeElement>();
        for (TupleTypeInfoElement e : infoElements) {
            elements.add(new TupleTypeElement(e.getName(), this.resolveTypeNameOrSpecifier(e)));
        }
        return elements;
    }

    private TupleType resolveTupleType(TupleTypeInfo t) {
        TupleType result = new TupleType(this.resolveTupleTypeElements(t.getElement()));
        return result;
    }

    private DataType resolveTypeNameOrSpecifier(ClassInfoElement element) {
        DataType result = this.resolveTypeNameOrSpecifier(element.getElementType(), element.getElementTypeSpecifier());
        if (result == null) {
            result = this.resolveTypeNameOrSpecifier(element.getType(), element.getTypeSpecifier());
        }
        return result;
    }

    private Collection<ClassTypeElement> resolveClassTypeElements(Collection<ClassInfoElement> infoElements) {
        ArrayList<ClassTypeElement> elements = new ArrayList<ClassTypeElement>();
        for (ClassInfoElement e : infoElements) {
            elements.add(new ClassTypeElement(e.getName(), this.resolveTypeNameOrSpecifier(e), e.isProhibited(), e.isOneBased()));
        }
        return elements;
    }

    private ClassType resolveClassType(ClassInfo t) {
        if (t.getName() == null) {
            throw new IllegalArgumentException("Class definition must have a name.");
        }
        String qualifiedName = this.ensureQualified(t.getName());
        Object result = (ClassType)this.lookupType(qualifiedName);
        if (result == null) {
            result = t instanceof ProfileInfo ? new ProfileType(qualifiedName, this.resolveTypeNameOrSpecifier(t.getBaseType(), t.getBaseTypeSpecifier())) : new ClassType(qualifiedName, this.resolveTypeNameOrSpecifier(t.getBaseType(), t.getBaseTypeSpecifier()));
            this.resolvedTypes.put(this.casify(result.getName()), (DataType)result);
            result.addElements(this.resolveClassTypeElements(t.getElement()));
            result.setIdentifier(t.getIdentifier());
            result.setLabel(t.getLabel());
            result.setRetrievable(t.isRetrievable());
            result.setPrimaryCodePath(t.getPrimaryCodePath());
        }
        return result;
    }

    private IntervalType resolveIntervalType(IntervalTypeInfo t) {
        IntervalType result = new IntervalType(this.resolveTypeNameOrSpecifier(t.getPointType(), t.getPointTypeSpecifier()));
        return result;
    }

    private ListType resolveListType(ListTypeInfo t) {
        ListType result = new ListType(this.resolveTypeNameOrSpecifier(t.getElementType(), t.getElementTypeSpecifier()));
        return result;
    }

    private ChoiceType resolveChoiceType(ChoiceTypeInfo t) {
        ArrayList<DataType> types = new ArrayList<DataType>();
        if (t.getChoice() != null && t.getChoice().size() > 0) {
            for (TypeSpecifier typeSpecifier : t.getChoice()) {
                types.add(this.resolveTypeSpecifier(typeSpecifier));
            }
        } else {
            for (TypeSpecifier typeSpecifier : t.getType()) {
                types.add(this.resolveTypeSpecifier(typeSpecifier));
            }
        }
        return new ChoiceType(types);
    }
}

