/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.cql2elm.LibraryBuilder;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.cqframework.cql.cql2elm.model.invocation.CombineInvocation;
import org.cqframework.cql.cql2elm.model.invocation.ConvertInvocation;
import org.cqframework.cql.cql2elm.model.invocation.DateInvocation;
import org.cqframework.cql.cql2elm.model.invocation.DateTimeInvocation;
import org.cqframework.cql.cql2elm.model.invocation.FirstInvocation;
import org.cqframework.cql.cql2elm.model.invocation.IndexOfInvocation;
import org.cqframework.cql.cql2elm.model.invocation.LastInvocation;
import org.cqframework.cql.cql2elm.model.invocation.LastPositionOfInvocation;
import org.cqframework.cql.cql2elm.model.invocation.MessageInvocation;
import org.cqframework.cql.cql2elm.model.invocation.NaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.PositionOfInvocation;
import org.cqframework.cql.cql2elm.model.invocation.RoundInvocation;
import org.cqframework.cql.cql2elm.model.invocation.SkipInvocation;
import org.cqframework.cql.cql2elm.model.invocation.SplitInvocation;
import org.cqframework.cql.cql2elm.model.invocation.SplitOnMatchesInvocation;
import org.cqframework.cql.cql2elm.model.invocation.SubstringInvocation;
import org.cqframework.cql.cql2elm.model.invocation.TailInvocation;
import org.cqframework.cql.cql2elm.model.invocation.TakeInvocation;
import org.cqframework.cql.cql2elm.model.invocation.TimeInvocation;
import org.cqframework.cql.cql2elm.model.invocation.ZeroOperandExpressionInvocation;
import org.hl7.elm.r1.AggregateExpression;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.CalculateAge;
import org.hl7.elm.r1.CalculateAgeAt;
import org.hl7.elm.r1.Coalesce;
import org.hl7.elm.r1.Combine;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.DateTimePrecision;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.First;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IndexOf;
import org.hl7.elm.r1.Last;
import org.hl7.elm.r1.LastPositionOf;
import org.hl7.elm.r1.Message;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Now;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.OperatorExpression;
import org.hl7.elm.r1.PositionOf;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Round;
import org.hl7.elm.r1.Slice;
import org.hl7.elm.r1.Split;
import org.hl7.elm.r1.SplitOnMatches;
import org.hl7.elm.r1.Substring;
import org.hl7.elm.r1.TernaryExpression;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.TimeOfDay;
import org.hl7.elm.r1.Today;
import org.hl7.elm.r1.UnaryExpression;

public class SystemFunctionResolver {
    private final ObjectFactory of = new ObjectFactory();
    private final LibraryBuilder builder;

    public SystemFunctionResolver(LibraryBuilder builder) {
        this.builder = builder;
    }

    public Expression resolveSystemFunction(FunctionRef fun) {
        if (fun.getLibraryName() == null || "System".equals(fun.getLibraryName())) {
            switch (fun.getName()) {
                case "AllTrue": 
                case "AnyTrue": 
                case "Avg": 
                case "Count": 
                case "GeometricMean": 
                case "Max": 
                case "Median": 
                case "Min": 
                case "Mode": 
                case "PopulationStdDev": 
                case "PopulationVariance": 
                case "Product": 
                case "StdDev": 
                case "Sum": 
                case "Variance": {
                    return this.resolveAggregate(fun);
                }
                case "Abs": 
                case "Ceiling": 
                case "Floor": 
                case "Ln": 
                case "Exp": 
                case "Truncate": 
                case "Negate": 
                case "Predecessor": 
                case "Successor": {
                    return this.resolveUnary(fun);
                }
                case "Log": 
                case "Modulo": 
                case "Power": 
                case "TruncatedDivide": {
                    return this.resolveBinary(fun);
                }
                case "Round": {
                    return this.resolveRound(fun);
                }
                case "AgeInYears": 
                case "AgeInMonths": {
                    this.checkNumberOfOperands(fun, 0);
                    return this.resolveCalculateAge(this.builder.enforceCompatible((Expression)this.getPatientBirthDateProperty(), this.builder.resolveTypeName("System", "Date")), SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "AgeInWeeks": 
                case "AgeInDays": 
                case "AgeInHours": 
                case "AgeInMinutes": 
                case "AgeInSeconds": 
                case "AgeInMilliseconds": {
                    this.checkNumberOfOperands(fun, 0);
                    return this.resolveCalculateAge(this.builder.ensureCompatible((Expression)this.getPatientBirthDateProperty(), this.builder.resolveTypeName("System", "DateTime")), SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "AgeInYearsAt": 
                case "AgeInMonthsAt": 
                case "AgeInWeeksAt": 
                case "AgeInDaysAt": {
                    this.checkNumberOfOperands(fun, 1);
                    ArrayList<Expression> ops = new ArrayList<Expression>();
                    Expression op = (Expression)fun.getOperand().get(0);
                    if (!op.getResultType().isSubTypeOf(this.builder.resolveTypeName("System", "Date")) && !op.getResultType().isSubTypeOf(this.builder.resolveTypeName("System", "DateTime"))) {
                        Conversion dateConversion = this.builder.findConversion(op.getResultType(), this.builder.resolveTypeName("System", "Date"), true, false);
                        Conversion dateTimeConversion = this.builder.findConversion(op.getResultType(), this.builder.resolveTypeName("System", "DateTime"), true, false);
                        if (dateConversion != null && dateTimeConversion != null) {
                            if (dateConversion.getScore() == dateTimeConversion.getScore()) {
                                throw new IllegalArgumentException(String.format("Ambiguous implicit conversion from %s to %s or %s.", op.getResultType().toString(), dateConversion.getToType().toString(), dateTimeConversion.getToType().toString()));
                            }
                            op = dateConversion.getScore() < dateTimeConversion.getScore() ? this.builder.convertExpression(op, dateConversion) : this.builder.convertExpression(op, dateTimeConversion);
                        } else if (dateConversion != null) {
                            op = this.builder.convertExpression(op, dateConversion);
                        } else if (dateTimeConversion != null) {
                            op = this.builder.convertExpression(op, dateTimeConversion);
                        } else {
                            throw new IllegalArgumentException(String.format("Could not resolve call to operator %s with argument of type %s.", fun.getName(), op.getResultType().toString()));
                        }
                    }
                    ops.add(this.builder.enforceCompatible((Expression)this.getPatientBirthDateProperty(), op.getResultType()));
                    ops.add(op);
                    return this.resolveCalculateAgeAt(ops, SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "AgeInHoursAt": 
                case "AgeInMinutesAt": 
                case "AgeInSecondsAt": 
                case "AgeInMillisecondsAt": {
                    ArrayList<Expression> ops = new ArrayList<Expression>();
                    ops.add((Expression)this.getPatientBirthDateProperty());
                    ops.addAll(fun.getOperand());
                    return this.resolveCalculateAgeAt(ops, SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "CalculateAgeInYears": 
                case "CalculateAgeInMonths": 
                case "CalculateAgeInWeeks": 
                case "CalculateAgeInDays": 
                case "CalculateAgeInHours": 
                case "CalculateAgeInMinutes": 
                case "CalculateAgeInSeconds": 
                case "CalculateAgeInMilliseconds": {
                    this.checkNumberOfOperands(fun, 1);
                    return this.resolveCalculateAge((Expression)fun.getOperand().get(0), SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "CalculateAgeInYearsAt": 
                case "CalculateAgeInMonthsAt": 
                case "CalculateAgeInWeeksAt": 
                case "CalculateAgeInDaysAt": 
                case "CalculateAgeInHoursAt": 
                case "CalculateAgeInMinutesAt": 
                case "CalculateAgeInSecondsAt": 
                case "CalculateAgeInMillisecondsAt": {
                    return this.resolveCalculateAgeAt(fun.getOperand(), SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "DateTime": {
                    return this.resolveDateTime(fun);
                }
                case "Date": {
                    return this.resolveDate(fun);
                }
                case "Time": {
                    return this.resolveTime(fun);
                }
                case "Now": {
                    return this.resolveNow(fun);
                }
                case "Today": {
                    return this.resolveToday(fun);
                }
                case "TimeOfDay": {
                    return this.resolveTimeOfDay(fun);
                }
                case "IndexOf": {
                    return this.resolveIndexOf(fun);
                }
                case "First": {
                    return this.resolveFirst(fun);
                }
                case "Last": {
                    return this.resolveLast(fun);
                }
                case "Skip": {
                    return this.resolveSkip(fun);
                }
                case "Take": {
                    return this.resolveTake(fun);
                }
                case "Tail": {
                    return this.resolveTail(fun);
                }
                case "Contains": 
                case "Except": 
                case "Expand": 
                case "In": 
                case "Includes": 
                case "IncludedIn": 
                case "Intersect": 
                case "ProperIncludes": 
                case "ProperIncludedIn": 
                case "Union": {
                    return this.resolveBinary(fun);
                }
                case "Distinct": 
                case "Exists": 
                case "Flatten": 
                case "Collapse": 
                case "SingletonFrom": {
                    return this.resolveUnary(fun);
                }
                case "Coalesce": {
                    return this.resolveNary(fun);
                }
                case "IsNull": 
                case "IsTrue": 
                case "IsFalse": {
                    return this.resolveUnary(fun);
                }
                case "Length": {
                    return this.resolveUnary(fun);
                }
                case "Indexer": 
                case "StartsWith": 
                case "EndsWith": 
                case "Matches": {
                    return this.resolveBinary(fun);
                }
                case "ReplaceMatches": {
                    return this.resolveTernary(fun);
                }
                case "Concatenate": {
                    return this.resolveNary(fun);
                }
                case "Combine": {
                    return this.resolveCombine(fun);
                }
                case "Split": {
                    return this.resolveSplit(fun);
                }
                case "SplitOnMatches": {
                    return this.resolveSplitOnMatches(fun);
                }
                case "Upper": 
                case "Lower": {
                    return this.resolveUnary(fun);
                }
                case "PositionOf": {
                    return this.resolvePositionOf(fun);
                }
                case "LastPositionOf": {
                    return this.resolveLastPositionOf(fun);
                }
                case "Substring": {
                    return this.resolveSubstring(fun);
                }
                case "Not": {
                    return this.resolveUnary(fun);
                }
                case "And": 
                case "Or": 
                case "Xor": 
                case "Implies": {
                    return this.resolveBinary(fun);
                }
                case "ConvertsToString": 
                case "ConvertsToBoolean": 
                case "ConvertsToInteger": 
                case "ConvertsToDecimal": 
                case "ConvertsToDateTime": 
                case "ConvertsToDate": 
                case "ConvertsToTime": 
                case "ConvertsToQuantity": 
                case "ConvertsToRatio": 
                case "ToString": 
                case "ToBoolean": 
                case "ToInteger": 
                case "ToDecimal": 
                case "ToDateTime": 
                case "ToDate": 
                case "ToTime": 
                case "ToQuantity": 
                case "ToRatio": 
                case "ToConcept": {
                    return this.resolveUnary(fun);
                }
                case "Equal": 
                case "NotEqual": 
                case "Greater": 
                case "GreaterOrEqual": 
                case "Less": 
                case "LessOrEqual": 
                case "Equivalent": {
                    return this.resolveBinary(fun);
                }
                case "Message": {
                    return this.resolveMessage(fun);
                }
            }
        }
        return null;
    }

    private CalculateAge resolveCalculateAge(Expression e, DateTimePrecision p) {
        CalculateAge operator = this.of.createCalculateAge().withPrecision(p).withOperand(e);
        this.builder.resolveUnaryCall("System", "CalculateAge", (UnaryExpression)operator);
        return operator;
    }

    private CalculateAgeAt resolveCalculateAgeAt(List<Expression> e, DateTimePrecision p) {
        CalculateAgeAt operator = this.of.createCalculateAgeAt().withPrecision(p).withOperand(e);
        this.builder.resolveBinaryCall("System", "CalculateAgeAt", (BinaryExpression)operator);
        return operator;
    }

    private static DateTimePrecision resolveAgeRelatedFunctionPrecision(FunctionRef fun) {
        String name = fun.getName();
        if (name.contains("Years")) {
            return DateTimePrecision.YEAR;
        }
        if (name.contains("Months")) {
            return DateTimePrecision.MONTH;
        }
        if (name.contains("Weeks")) {
            return DateTimePrecision.WEEK;
        }
        if (name.contains("Days")) {
            return DateTimePrecision.DAY;
        }
        if (name.contains("Hours")) {
            return DateTimePrecision.HOUR;
        }
        if (name.contains("Minutes")) {
            return DateTimePrecision.MINUTE;
        }
        if (name.contains("Second")) {
            return DateTimePrecision.SECOND;
        }
        if (name.contains("Milliseconds")) {
            return DateTimePrecision.MILLISECOND;
        }
        throw new IllegalArgumentException(String.format("Unknown precision '%s'.", name));
    }

    private Property getPatientBirthDateProperty() {
        Expression source = this.builder.resolveIdentifier("Patient", true);
        Property property = this.of.createProperty().withSource(source).withPath(this.builder.getDefaultModel().getModelInfo().getPatientBirthDatePropertyName());
        property.setResultType(this.builder.resolvePath(source.getResultType(), property.getPath()));
        return property;
    }

    private Round resolveRound(FunctionRef fun) {
        if (fun.getOperand().isEmpty() || fun.getOperand().size() > 2) {
            throw new IllegalArgumentException("Could not resolve call to system operator Round.  Expected 1 or 2 arguments.");
        }
        Round round = this.of.createRound().withOperand((Expression)fun.getOperand().get(0));
        if (fun.getOperand().size() == 2) {
            round.setPrecision((Expression)fun.getOperand().get(1));
        }
        this.builder.resolveCall("System", "Round", new RoundInvocation(round));
        return round;
    }

    private DateTime resolveDateTime(FunctionRef fun) {
        DateTime dt = this.of.createDateTime();
        DateTimeInvocation.setDateTimeFieldsFromOperands(dt, fun.getOperand());
        this.builder.resolveCall("System", "DateTime", new DateTimeInvocation(dt));
        return dt;
    }

    private Date resolveDate(FunctionRef fun) {
        Date d = this.of.createDate();
        DateInvocation.setDateFieldsFromOperands(d, fun.getOperand());
        this.builder.resolveCall("System", "Date", new DateInvocation(d));
        return d;
    }

    private Time resolveTime(FunctionRef fun) {
        Time t = this.of.createTime();
        TimeInvocation.setTimeFieldsFromOperands(t, fun.getOperand());
        this.builder.resolveCall("System", "Time", new TimeInvocation(t));
        return t;
    }

    private Now resolveNow(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 0);
        Now now = this.of.createNow();
        this.builder.resolveCall("System", "Now", new ZeroOperandExpressionInvocation((OperatorExpression)now));
        return now;
    }

    private Today resolveToday(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 0);
        Today today = this.of.createToday();
        this.builder.resolveCall("System", "Today", new ZeroOperandExpressionInvocation((OperatorExpression)today));
        return today;
    }

    private TimeOfDay resolveTimeOfDay(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 0);
        TimeOfDay timeOfDay = this.of.createTimeOfDay();
        this.builder.resolveCall("System", "TimeOfDay", new ZeroOperandExpressionInvocation((OperatorExpression)timeOfDay));
        return timeOfDay;
    }

    private IndexOf resolveIndexOf(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        IndexOf indexOf = this.of.createIndexOf();
        indexOf.setSource((Expression)fun.getOperand().get(0));
        indexOf.setElement((Expression)fun.getOperand().get(1));
        this.builder.resolveCall("System", "IndexOf", new IndexOfInvocation(indexOf));
        return indexOf;
    }

    private First resolveFirst(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 1);
        First first = this.of.createFirst();
        first.setSource((Expression)fun.getOperand().get(0));
        this.builder.resolveCall("System", "First", new FirstInvocation(first));
        return first;
    }

    private Last resolveLast(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 1);
        Last last = this.of.createLast();
        last.setSource((Expression)fun.getOperand().get(0));
        this.builder.resolveCall("System", "Last", new LastInvocation(last));
        return last;
    }

    private Slice resolveSkip(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        Slice slice = this.of.createSlice();
        slice.setSource((Expression)fun.getOperand().get(0));
        slice.setStartIndex((Expression)fun.getOperand().get(1));
        this.builder.resolveCall("System", "Skip", new SkipInvocation(slice));
        return slice;
    }

    private Slice resolveTake(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        Slice slice = this.of.createSlice();
        slice.setSource((Expression)fun.getOperand().get(0));
        slice.setStartIndex((Expression)this.builder.createLiteral(0));
        Coalesce coalesce = this.of.createCoalesce().withOperand(new Expression[]{(Expression)fun.getOperand().get(1), this.builder.createLiteral(0)});
        this.builder.resolveCall("System", "Coalesce", new NaryExpressionInvocation((NaryExpression)coalesce));
        slice.setEndIndex((Expression)coalesce);
        this.builder.resolveCall("System", "Take", new TakeInvocation(slice));
        return slice;
    }

    private Slice resolveTail(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 1);
        Slice slice = this.of.createSlice();
        slice.setSource((Expression)fun.getOperand().get(0));
        slice.setStartIndex((Expression)this.builder.createLiteral(1));
        this.builder.resolveCall("System", "Tail", new TailInvocation(slice));
        return slice;
    }

    private Combine resolveCombine(FunctionRef fun) {
        if (fun.getOperand().isEmpty() || fun.getOperand().size() > 2) {
            throw new IllegalArgumentException("Could not resolve call to system operator Combine.  Expected 1 or 2 arguments.");
        }
        Combine combine = this.of.createCombine().withSource((Expression)fun.getOperand().get(0));
        if (fun.getOperand().size() == 2) {
            combine.setSeparator((Expression)fun.getOperand().get(1));
        }
        this.builder.resolveCall("System", "Combine", new CombineInvocation(combine));
        return combine;
    }

    private Split resolveSplit(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        Split split = this.of.createSplit().withStringToSplit((Expression)fun.getOperand().get(0)).withSeparator((Expression)fun.getOperand().get(1));
        this.builder.resolveCall("System", "Split", new SplitInvocation(split));
        return split;
    }

    private SplitOnMatches resolveSplitOnMatches(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        SplitOnMatches splitOnMatches = this.of.createSplitOnMatches().withStringToSplit((Expression)fun.getOperand().get(0)).withSeparatorPattern((Expression)fun.getOperand().get(1));
        this.builder.resolveCall("System", "SplitOnMatches", new SplitOnMatchesInvocation(splitOnMatches));
        return splitOnMatches;
    }

    private PositionOf resolvePositionOf(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        PositionOf pos = this.of.createPositionOf().withPattern((Expression)fun.getOperand().get(0)).withString((Expression)fun.getOperand().get(1));
        this.builder.resolveCall("System", "PositionOf", new PositionOfInvocation(pos));
        return pos;
    }

    private LastPositionOf resolveLastPositionOf(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        LastPositionOf pos = this.of.createLastPositionOf().withPattern((Expression)fun.getOperand().get(0)).withString((Expression)fun.getOperand().get(1));
        this.builder.resolveCall("System", "LastPositionOf", new LastPositionOfInvocation(pos));
        return pos;
    }

    private Substring resolveSubstring(FunctionRef fun) {
        if (fun.getOperand().size() < 2 || fun.getOperand().size() > 3) {
            throw new IllegalArgumentException("Could not resolve call to system operator Substring.  Expected 2 or 3 arguments.");
        }
        Substring substring = this.of.createSubstring().withStringToSub((Expression)fun.getOperand().get(0)).withStartIndex((Expression)fun.getOperand().get(1));
        if (fun.getOperand().size() == 3) {
            substring.setLength((Expression)fun.getOperand().get(2));
        }
        this.builder.resolveCall("System", "Substring", new SubstringInvocation(substring));
        return substring;
    }

    private Message resolveMessage(FunctionRef fun) {
        if (fun.getOperand().size() != 5) {
            throw new IllegalArgumentException("Could not resolve call to system operator Message. Expected 5 arguments.");
        }
        Message message = this.of.createMessage().withSource((Expression)fun.getOperand().get(0)).withCondition((Expression)fun.getOperand().get(1)).withCode((Expression)fun.getOperand().get(2)).withSeverity((Expression)fun.getOperand().get(3)).withMessage((Expression)fun.getOperand().get(4));
        this.builder.resolveCall("System", "Message", new MessageInvocation(message));
        return message;
    }

    private Convert resolveConvert(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 1);
        Convert convert = this.of.createConvert().withOperand((Expression)fun.getOperand().get(0));
        SystemModel sm = this.builder.getSystemModel();
        switch (fun.getName()) {
            case "ToString": {
                convert.setToType(this.builder.dataTypeToQName(sm.getString()));
                break;
            }
            case "ToBoolean": {
                convert.setToType(this.builder.dataTypeToQName(sm.getBoolean()));
                break;
            }
            case "ToInteger": {
                convert.setToType(this.builder.dataTypeToQName(sm.getInteger()));
                break;
            }
            case "ToDecimal": {
                convert.setToType(this.builder.dataTypeToQName(sm.getDecimal()));
                break;
            }
            case "ToQuantity": {
                convert.setToType(this.builder.dataTypeToQName(sm.getQuantity()));
                break;
            }
            case "ToRatio": {
                convert.setToType(this.builder.dataTypeToQName(sm.getRatio()));
                break;
            }
            case "ToDate": {
                convert.setToType(this.builder.dataTypeToQName(sm.getDate()));
                break;
            }
            case "ToDateTime": {
                convert.setToType(this.builder.dataTypeToQName(sm.getDateTime()));
                break;
            }
            case "ToTime": {
                convert.setToType(this.builder.dataTypeToQName(sm.getTime()));
                break;
            }
            case "ToConcept": {
                convert.setToType(this.builder.dataTypeToQName(sm.getConcept()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Could not resolve call to system operator %s. Unknown conversion type.", fun.getName()));
            }
        }
        this.builder.resolveCall("System", fun.getName(), new ConvertInvocation(convert));
        return convert;
    }

    private UnaryExpression resolveUnary(FunctionRef fun) {
        UnaryExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (UnaryExpression.class.isAssignableFrom(clazz)) {
                operator = (UnaryExpression)clazz.newInstance();
                this.checkNumberOfOperands(fun, 1);
                operator.setOperand((Expression)fun.getOperand().get(0));
                this.builder.resolveUnaryCall("System", fun.getName(), operator);
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private BinaryExpression resolveBinary(FunctionRef fun) {
        BinaryExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (BinaryExpression.class.isAssignableFrom(clazz)) {
                operator = (BinaryExpression)clazz.newInstance();
                this.checkNumberOfOperands(fun, 2);
                operator.getOperand().addAll(fun.getOperand());
                this.builder.resolveBinaryCall("System", fun.getName(), operator);
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TernaryExpression resolveTernary(FunctionRef fun) {
        TernaryExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (TernaryExpression.class.isAssignableFrom(clazz)) {
                operator = (TernaryExpression)clazz.newInstance();
                this.checkNumberOfOperands(fun, 3);
                operator.getOperand().addAll(fun.getOperand());
                this.builder.resolveTernaryCall("System", fun.getName(), operator);
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private NaryExpression resolveNary(FunctionRef fun) {
        NaryExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (NaryExpression.class.isAssignableFrom(clazz)) {
                operator = (NaryExpression)clazz.newInstance();
                operator.getOperand().addAll(fun.getOperand());
                this.builder.resolveCall("System", fun.getName(), new NaryExpressionInvocation(operator));
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private AggregateExpression resolveAggregate(FunctionRef fun) {
        AggregateExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (AggregateExpression.class.isAssignableFrom(clazz)) {
                operator = (AggregateExpression)clazz.newInstance();
                this.checkNumberOfOperands(fun, 1);
                operator.setSource((Expression)fun.getOperand().get(0));
                this.builder.resolveAggregateCall("System", fun.getName(), operator);
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void checkNumberOfOperands(FunctionRef fun, int expectedOperands) {
        if (fun.getOperand().size() != expectedOperands) {
            throw new IllegalArgumentException(String.format("Could not resolve call to system operator %s.  Expected %d arguments.", fun.getName(), expectedOperands));
        }
    }
}

