/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.InstantiationResult;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;

public class ConversionMap {
    private Map<DataType, List<Conversion>> map = new HashMap<DataType, List<Conversion>>();
    private List<Conversion> genericConversions = new ArrayList<Conversion>();
    private boolean listDemotion = true;
    private boolean listPromotion = true;
    private boolean intervalDemotion = false;
    private boolean intervalPromotion = false;

    public static int getConversionScore(DataType callOperand, DataType operand, Conversion conversion) {
        if (operand.equals(callOperand)) {
            return ConversionScore.ExactMatch.score();
        }
        if (operand.isSuperTypeOf(callOperand)) {
            return ConversionScore.SubType.score();
        }
        if (callOperand.isCompatibleWith(operand)) {
            return ConversionScore.Compatible.score();
        }
        if (conversion != null) {
            return conversion.getScore();
        }
        throw new IllegalArgumentException("Could not determine conversion score for conversion");
    }

    public void enableListDemotion() {
        this.listDemotion = true;
    }

    public void disableListDemotion() {
        this.listDemotion = false;
    }

    public boolean isListDemotionEnabled() {
        return this.listDemotion;
    }

    public void enableListPromotion() {
        this.listPromotion = true;
    }

    public void disableListPromotion() {
        this.listPromotion = false;
    }

    public boolean isListPromotionEnabled() {
        return this.listPromotion;
    }

    public void enableIntervalDemotion() {
        this.intervalDemotion = true;
    }

    public void disableIntervalDemotion() {
        this.intervalDemotion = false;
    }

    public boolean isIntervalDemotionEnabled() {
        return this.intervalDemotion;
    }

    public void enableIntervalPromotion() {
        this.intervalPromotion = true;
    }

    public void disableIntervalPromotion() {
        this.intervalPromotion = false;
    }

    public boolean isIntervalPromotionEnabled() {
        return this.intervalPromotion;
    }

    public void add(Conversion conversion) {
        if (conversion == null) {
            throw new IllegalArgumentException("conversion is null.");
        }
        if (conversion.isGeneric()) {
            List<Conversion> conversions = this.getGenericConversions();
            if (conversions.contains(conversion)) {
                throw new IllegalArgumentException(String.format("Conversion from %s to %s is already defined.", conversion.getFromType().toString(), conversion.getToType().toString()));
            }
            conversions.add(conversion);
        } else {
            List<Conversion> conversions = this.getConversions(conversion.getFromType());
            if (conversions.contains(conversion)) {
                throw new IllegalArgumentException(String.format("Conversion from %s to %s is already defined.", conversion.getFromType().toString(), conversion.getToType().toString()));
            }
            conversions.add(conversion);
        }
    }

    public List<Conversion> getGenericConversions() {
        return this.genericConversions;
    }

    public List<Conversion> getConversions(DataType fromType) {
        List<Conversion> conversions = this.map.get(fromType);
        if (conversions == null) {
            conversions = new ArrayList<Conversion>();
            this.map.put(fromType, conversions);
        }
        return conversions;
    }

    public Conversion findCompatibleConversion(DataType fromType, DataType toType) {
        if (fromType.isCompatibleWith(toType)) {
            return new Conversion(fromType, toType);
        }
        return null;
    }

    public Conversion findChoiceConversion(ChoiceType fromType, DataType toType, boolean allowPromotionAndDemotion, OperatorMap operatorMap) {
        Conversion result = null;
        for (DataType choice : fromType.getTypes()) {
            Conversion choiceConversion = this.findConversion(choice, toType, true, allowPromotionAndDemotion, operatorMap);
            if (choiceConversion == null) continue;
            if (result == null) {
                result = new Conversion(fromType, toType, choiceConversion);
                continue;
            }
            result.addAlternativeConversion(choiceConversion);
        }
        return result;
    }

    public Conversion findTargetChoiceConversion(DataType fromType, ChoiceType toType, boolean allowPromotionAndDemotion, OperatorMap operatorMap) {
        for (DataType choice : toType.getTypes()) {
            Conversion choiceConversion = this.findConversion(fromType, choice, true, allowPromotionAndDemotion, operatorMap);
            if (choiceConversion == null) continue;
            return new Conversion(fromType, toType, choiceConversion);
        }
        return null;
    }

    public Conversion findListConversion(ListType fromType, ListType toType, OperatorMap operatorMap) {
        Conversion elementConversion = this.findConversion(fromType.getElementType(), toType.getElementType(), true, false, operatorMap);
        if (elementConversion != null) {
            return new Conversion(fromType, toType, elementConversion);
        }
        return null;
    }

    public Conversion findIntervalConversion(IntervalType fromType, IntervalType toType, OperatorMap operatorMap) {
        Conversion pointConversion = this.findConversion(fromType.getPointType(), toType.getPointType(), true, false, operatorMap);
        if (pointConversion != null) {
            return new Conversion(fromType, toType, pointConversion);
        }
        return null;
    }

    public Conversion findListDemotion(ListType fromType, DataType toType, OperatorMap operatorMap) {
        DataType elementType = fromType.getElementType();
        if (elementType.isSubTypeOf(toType)) {
            return new Conversion(fromType, toType, null);
        }
        Conversion elementConversion = this.findConversion(elementType, toType, true, false, operatorMap);
        if (elementConversion != null) {
            return new Conversion(fromType, toType, elementConversion);
        }
        return null;
    }

    public Conversion findListPromotion(DataType fromType, ListType toType, OperatorMap operatorMap) {
        if (fromType.isSubTypeOf(toType.getElementType())) {
            return new Conversion(fromType, toType, null);
        }
        Conversion elementConversion = this.findConversion(fromType, toType.getElementType(), true, false, operatorMap);
        if (elementConversion != null) {
            return new Conversion(fromType, toType, elementConversion);
        }
        return null;
    }

    public Conversion findIntervalDemotion(IntervalType fromType, DataType toType, OperatorMap operatorMap) {
        DataType pointType = fromType.getPointType();
        if (pointType.isSubTypeOf(toType)) {
            return new Conversion(fromType, toType, null);
        }
        Conversion pointConversion = this.findConversion(pointType, toType, true, false, operatorMap);
        if (pointConversion != null) {
            return new Conversion(fromType, toType, pointConversion);
        }
        return null;
    }

    public Conversion findIntervalPromotion(DataType fromType, IntervalType toType, OperatorMap operatorMap) {
        if (fromType.isSubTypeOf(toType.getPointType())) {
            return new Conversion(fromType, toType, null);
        }
        Conversion pointConversion = this.findConversion(fromType, toType.getPointType(), true, false, operatorMap);
        if (pointConversion != null) {
            return new Conversion(fromType, toType, pointConversion);
        }
        return null;
    }

    public boolean ensureGenericConversionInstantiated(DataType fromType, DataType toType, boolean isImplicit, OperatorMap operatorMap) {
        boolean operatorsInstantiated = false;
        for (Conversion c : this.getGenericConversions()) {
            InstantiationResult instantiationResult;
            Operator operator;
            if (c.getOperator() == null || (operator = (instantiationResult = ((GenericOperator)c.getOperator()).instantiate(new Signature(fromType), operatorMap, this, false)).getOperator()) == null || operatorMap.containsOperator(operator)) continue;
            operatorMap.addOperator(operator);
            Conversion conversion = new Conversion(operator, true);
            this.add(conversion);
            operatorsInstantiated = true;
        }
        return operatorsInstantiated;
    }

    private Conversion internalFindConversion(DataType fromType, DataType toType, boolean isImplicit) {
        Conversion result = null;
        int score = Integer.MAX_VALUE;
        for (Conversion conversion : this.getConversions(fromType)) {
            int newScore;
            if (isImplicit && !conversion.isImplicit() || !conversion.getToType().isSuperTypeOf(toType) && !conversion.getToType().isGeneric()) continue;
            int n = conversion.getToType().equals(toType) ? 0 : (newScore = conversion.getToType().isGeneric() ? 1 : 2);
            if (newScore < score) {
                result = conversion;
                score = newScore;
                continue;
            }
            if (newScore != score) continue;
            throw new IllegalArgumentException(String.format("Ambiguous implicit conversion from %s to %s or %s.", fromType.toString(), result.getToType().toString(), conversion.getToType().toString()));
        }
        return result;
    }

    public Conversion findConversion(DataType fromType, DataType toType, boolean isImplicit, boolean allowPromotionAndDemotion, OperatorMap operatorMap) {
        Conversion result = this.findCompatibleConversion(fromType, toType);
        if (result == null) {
            result = this.internalFindConversion(fromType, toType, isImplicit);
        }
        if (result == null && this.ensureGenericConversionInstantiated(fromType, toType, isImplicit, operatorMap)) {
            result = this.internalFindConversion(fromType, toType, isImplicit);
        }
        if (result == null) {
            if (fromType instanceof ListType && !(toType instanceof ListType) && (allowPromotionAndDemotion || this.listDemotion)) {
                result = this.findListDemotion((ListType)fromType, toType, operatorMap);
            }
            if (!(fromType instanceof ListType) && toType instanceof ListType && (allowPromotionAndDemotion || this.listPromotion)) {
                result = this.findListPromotion(fromType, (ListType)toType, operatorMap);
            }
            if (fromType instanceof IntervalType && !(toType instanceof IntervalType) && (allowPromotionAndDemotion || this.intervalDemotion)) {
                result = this.findIntervalDemotion((IntervalType)fromType, toType, operatorMap);
            }
            if (!(fromType instanceof IntervalType) && toType instanceof IntervalType && (allowPromotionAndDemotion || this.intervalPromotion)) {
                result = this.findIntervalPromotion(fromType, (IntervalType)toType, operatorMap);
            }
            if (fromType instanceof ChoiceType) {
                result = this.findChoiceConversion((ChoiceType)fromType, toType, allowPromotionAndDemotion, operatorMap);
            }
            if (toType instanceof ChoiceType) {
                result = this.findTargetChoiceConversion(fromType, (ChoiceType)toType, allowPromotionAndDemotion, operatorMap);
            }
            if (fromType instanceof ListType && toType instanceof ListType) {
                result = this.findListConversion((ListType)fromType, (ListType)toType, operatorMap);
            }
            if (fromType instanceof IntervalType && toType instanceof IntervalType) {
                result = this.findIntervalConversion((IntervalType)fromType, (IntervalType)toType, operatorMap);
            }
        }
        return result;
    }

    public static enum ConversionScore {
        ExactMatch(0),
        SubType(1),
        Compatible(2),
        Cast(3),
        SimpleConversion(4),
        ComplexConversion(5),
        IntervalPromotion(6),
        ListDemotion(7),
        IntervalDemotion(8),
        ListPromotion(9);

        private final int score;

        public int score() {
            return this.score;
        }

        private ConversionScore(int score) {
            this.score = score;
        }
    }
}

