/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.InstantiationResult;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.cqframework.cql.cql2elm.model.Signature;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.SimpleType;
import org.hl7.cql.model.TypeParameter;

public class InstantiationContextImpl
implements InstantiationContext {
    private Map<TypeParameter, DataType> typeMap;
    private OperatorMap operatorMap;
    private ConversionMap conversionMap;
    private boolean allowPromotionAndDemotion;
    private int conversionScore;

    public InstantiationContextImpl(Map<TypeParameter, DataType> typeMap, OperatorMap operatorMap, ConversionMap conversionMap, boolean allowPromotionAndDemotion) {
        if (typeMap == null) {
            throw new IllegalArgumentException("typeMap is null");
        }
        if (operatorMap == null) {
            throw new IllegalArgumentException("operatorMap is null");
        }
        if (conversionMap == null) {
            throw new IllegalArgumentException("conversionMap is null");
        }
        this.typeMap = typeMap;
        this.operatorMap = operatorMap;
        this.conversionMap = conversionMap;
        this.allowPromotionAndDemotion = allowPromotionAndDemotion;
    }

    public int getConversionScore() {
        return this.conversionScore;
    }

    public boolean isInstantiable(TypeParameter parameter, DataType callType) {
        DataType boundType = this.typeMap.get(parameter);
        if (boundType == null) {
            if (parameter.canBind(callType)) {
                this.typeMap.put(parameter, callType);
                return true;
            }
            return false;
        }
        if (boundType.isSuperTypeOf(callType) || callType.isCompatibleWith(boundType)) {
            return true;
        }
        if (callType.isSuperTypeOf(boundType) || boundType.isCompatibleWith(callType)) {
            if (parameter.canBind(callType)) {
                this.typeMap.put(parameter, callType);
                return true;
            }
            return false;
        }
        Conversion conversion = this.conversionMap.findConversion(callType, boundType, true, this.allowPromotionAndDemotion, this.operatorMap);
        if (conversion != null) {
            ListType boundListType;
            if (boundType instanceof ListType && ((boundListType = (ListType)boundType).getElementType().isSuperTypeOf(callType) || callType.isCompatibleWith(boundListType.getElementType()))) {
                if (parameter.canBind(callType)) {
                    this.typeMap.put(parameter, callType);
                    this.conversionScore -= ConversionMap.ConversionScore.ListPromotion.score();
                    return true;
                }
                return false;
            }
            return true;
        }
        conversion = this.conversionMap.findConversion(boundType, callType, true, this.allowPromotionAndDemotion, this.operatorMap);
        if (conversion != null) {
            if (parameter.canBind(callType)) {
                this.typeMap.put(parameter, callType);
                this.conversionScore -= conversion.getToType() instanceof SimpleType ? ConversionMap.ConversionScore.SimpleConversion.score() : ConversionMap.ConversionScore.ComplexConversion.score();
                return true;
            }
            return false;
        }
        DataType boundCommonSuperType = boundType.getCommonSuperTypeOf(callType);
        DataType callCommonSuperType = callType.getCommonSuperTypeOf(boundType);
        if (boundCommonSuperType != null && callCommonSuperType != null) {
            if (boundCommonSuperType.isSuperTypeOf(callCommonSuperType)) {
                if (parameter.canBind(boundCommonSuperType)) {
                    this.typeMap.put(parameter, boundCommonSuperType);
                    return true;
                }
                return false;
            }
            if (parameter.canBind(callCommonSuperType)) {
                this.typeMap.put(parameter, callCommonSuperType);
                return true;
            }
            return false;
        }
        return false;
    }

    public DataType instantiate(TypeParameter parameter) {
        DataType result = this.typeMap.get(parameter);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type parameter %s.", parameter.getIdentifier()));
        }
        return result;
    }

    public Iterable<IntervalType> getIntervalConversionTargets(DataType callType) {
        ArrayList<IntervalType> results = new ArrayList<IntervalType>();
        for (Conversion c : this.conversionMap.getConversions(callType)) {
            if (!(c.getToType() instanceof IntervalType)) continue;
            results.add((IntervalType)c.getToType());
            this.conversionScore += ConversionMap.ConversionScore.ComplexConversion.score();
        }
        if (results.isEmpty()) {
            for (Conversion c : this.conversionMap.getGenericConversions()) {
                InstantiationResult instantiationResult;
                Operator operator;
                if (c.getOperator() == null || !(c.getToType() instanceof IntervalType) || (operator = (instantiationResult = ((GenericOperator)c.getOperator()).instantiate(new Signature(callType), this.operatorMap, this.conversionMap, false)).getOperator()) == null) continue;
                this.operatorMap.addOperator(operator);
                Conversion conversion = new Conversion(operator, true);
                this.conversionMap.add(conversion);
                results.add((IntervalType)conversion.getToType());
            }
        }
        if (results.isEmpty() && !(callType instanceof IntervalType) && this.operatorMap.isPointType(callType) && (this.allowPromotionAndDemotion || this.conversionMap.isIntervalPromotionEnabled())) {
            results.add(new IntervalType(callType));
            this.conversionScore += ConversionMap.ConversionScore.IntervalPromotion.score();
        }
        return results;
    }

    public Iterable<ListType> getListConversionTargets(DataType callType) {
        ArrayList<ListType> results = new ArrayList<ListType>();
        for (Conversion c : this.conversionMap.getConversions(callType)) {
            if (!(c.getToType() instanceof ListType)) continue;
            results.add((ListType)c.getToType());
            this.conversionScore += ConversionMap.ConversionScore.ComplexConversion.score();
        }
        if (results.isEmpty()) {
            for (Conversion c : this.conversionMap.getGenericConversions()) {
                InstantiationResult instantiationResult;
                Operator operator;
                if (c.getOperator() == null || !(c.getToType() instanceof ListType) || (operator = (instantiationResult = ((GenericOperator)c.getOperator()).instantiate(new Signature(callType), this.operatorMap, this.conversionMap, false)).getOperator()) == null) continue;
                this.operatorMap.addOperator(operator);
                Conversion conversion = new Conversion(operator, true);
                this.conversionMap.add(conversion);
                results.add((ListType)conversion.getToType());
            }
        }
        if (results.isEmpty() && !(callType instanceof ListType) && (this.allowPromotionAndDemotion || this.conversionMap.isListPromotionEnabled())) {
            results.add(new ListType(callType));
            this.conversionScore += ConversionMap.ConversionScore.ListPromotion.score();
        }
        return results;
    }

    public Iterable<SimpleType> getSimpleConversionTargets(DataType callType) {
        ListType callListType;
        IntervalType callIntervalType;
        ArrayList<SimpleType> results = new ArrayList<SimpleType>();
        for (Conversion c : this.conversionMap.getConversions(callType)) {
            if (!(c.getToType() instanceof SimpleType)) continue;
            results.add((SimpleType)c.getToType());
            this.conversionScore += ConversionMap.ConversionScore.SimpleConversion.score();
        }
        if (results.isEmpty()) {
            for (Conversion c : this.conversionMap.getGenericConversions()) {
                InstantiationResult instantiationResult;
                Operator operator;
                if (c.getOperator() == null || !(c.getToType() instanceof SimpleType) || (operator = (instantiationResult = ((GenericOperator)c.getOperator()).instantiate(new Signature(callType), this.operatorMap, this.conversionMap, false)).getOperator()) == null) continue;
                this.operatorMap.addOperator(operator);
                Conversion conversion = new Conversion(operator, true);
                this.conversionMap.add(conversion);
                results.add((SimpleType)conversion.getToType());
            }
        }
        if (results.isEmpty() && callType instanceof IntervalType && (callIntervalType = (IntervalType)callType).getPointType() instanceof SimpleType && (this.allowPromotionAndDemotion || this.conversionMap.isIntervalDemotionEnabled())) {
            results.add((SimpleType)callIntervalType.getPointType());
            this.conversionScore += ConversionMap.ConversionScore.IntervalDemotion.score();
        }
        if (results.isEmpty() && callType instanceof ListType && (callListType = (ListType)callType).getElementType() instanceof SimpleType && (this.allowPromotionAndDemotion || this.conversionMap.isListDemotionEnabled())) {
            results.add((SimpleType)callListType.getElementType());
            this.conversionScore += ConversionMap.ConversionScore.ListDemotion.score();
        }
        return results;
    }
}

