/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.cqframework.cql.cql2elm.CqlSemanticException;
import org.cqframework.cql.cql2elm.CqlSyntaxException;
import org.cqframework.cql.cql2elm.CqlTranslatorException;
import org.cqframework.cql.cql2elm.CqlTranslatorIncludeException;
import org.cqframework.cql.cql2elm.DataTypes;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.SystemFunctionResolver;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.Invocation;
import org.cqframework.cql.cql2elm.model.LibraryRef;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.cqframework.cql.cql2elm.model.PropertyResolution;
import org.cqframework.cql.cql2elm.model.QueryContext;
import org.cqframework.cql.cql2elm.model.SystemLibraryHelper;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.cqframework.cql.cql2elm.model.invocation.AggregateExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.AnyInCodeSystemInvocation;
import org.cqframework.cql.cql2elm.model.invocation.AnyInValueSetInvocation;
import org.cqframework.cql.cql2elm.model.invocation.BinaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.FunctionRefInvocation;
import org.cqframework.cql.cql2elm.model.invocation.InCodeSystemInvocation;
import org.cqframework.cql.cql2elm.model.invocation.InValueSetInvocation;
import org.cqframework.cql.cql2elm.model.invocation.NaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.TernaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.UnaryExpressionInvocation;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.fhir.ucum.UcumService;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.ModelContext;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.cql_annotations.r1.CqlToElmError;
import org.hl7.cql_annotations.r1.ErrorSeverity;
import org.hl7.cql_annotations.r1.ErrorType;
import org.hl7.elm.r1.AccessModifier;
import org.hl7.elm.r1.AggregateExpression;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.AnyInCodeSystem;
import org.hl7.elm.r1.AnyInValueSet;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.Case;
import org.hl7.elm.r1.CaseItem;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.Contains;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.DateTimePrecision;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Except;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.Flatten;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.In;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.IncludedIn;
import org.hl7.elm.r1.Includes;
import org.hl7.elm.r1.Intersect;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.Is;
import org.hl7.elm.r1.IsNull;
import org.hl7.elm.r1.Iteration;
import org.hl7.elm.r1.Less;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.MaxValue;
import org.hl7.elm.r1.MinValue;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Not;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.OperandRef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.PointFrom;
import org.hl7.elm.r1.Predecessor;
import org.hl7.elm.r1.ProperContains;
import org.hl7.elm.r1.ProperIn;
import org.hl7.elm.r1.ProperIncludedIn;
import org.hl7.elm.r1.ProperIncludes;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Quantity;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryLetRef;
import org.hl7.elm.r1.Ratio;
import org.hl7.elm.r1.ReturnClause;
import org.hl7.elm.r1.SingletonFrom;
import org.hl7.elm.r1.Successor;
import org.hl7.elm.r1.TernaryExpression;
import org.hl7.elm.r1.ToList;
import org.hl7.elm.r1.Total;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.Union;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class LibraryBuilder {
    private final List<CqlTranslatorException> errors = new ArrayList<CqlTranslatorException>();
    private final List<CqlTranslatorException> warnings = new ArrayList<CqlTranslatorException>();
    private final List<CqlTranslatorException> messages = new ArrayList<CqlTranslatorException>();
    private final List<CqlTranslatorException> exceptions = new ArrayList<CqlTranslatorException>();
    private final Map<String, Model> models = new HashMap<String, Model>();
    private final Map<String, TranslatedLibrary> libraries = new HashMap<String, TranslatedLibrary>();
    private final SystemFunctionResolver systemFunctionResolver = new SystemFunctionResolver(this);
    private final Stack<String> expressionContext = new Stack();
    private final ExpressionDefinitionContextStack expressionDefinitions = new ExpressionDefinitionContextStack();
    private final Stack<FunctionDef> functionDefs = new Stack();
    private int literalContext = 0;
    private ModelManager modelManager = null;
    private Model defaultModel = null;
    private LibraryManager libraryManager = null;
    private Library library = null;
    private TranslatedLibrary translatedLibrary = null;
    private final ConversionMap conversionMap = new ConversionMap();
    private final ObjectFactory of = new ObjectFactory();
    private final org.hl7.cql_annotations.r1.ObjectFactory af = new org.hl7.cql_annotations.r1.ObjectFactory();
    private boolean listTraversal = true;
    private UcumService ucumService = null;
    private SignatureLevel signatureLevel = SignatureLevel.Differing;
    private CqlTranslatorException.ErrorSeverity errorLevel = CqlTranslatorException.ErrorSeverity.Info;

    public LibraryBuilder(ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService) {
        if (modelManager == null) {
            throw new IllegalArgumentException("modelManager is null");
        }
        if (libraryManager == null) {
            throw new IllegalArgumentException("libraryManager is null");
        }
        this.modelManager = modelManager;
        this.libraryManager = libraryManager;
        this.library = this.of.createLibrary().withSchemaIdentifier(this.of.createVersionedIdentifier().withId("urn:hl7-org:elm").withVersion("r1"));
        this.translatedLibrary = new TranslatedLibrary();
        this.translatedLibrary.setLibrary(this.library);
        this.ucumService = ucumService;
    }

    public List<CqlTranslatorException> getErrors() {
        return this.errors;
    }

    public List<CqlTranslatorException> getWarnings() {
        return this.warnings;
    }

    public List<CqlTranslatorException> getMessages() {
        return this.messages;
    }

    public List<CqlTranslatorException> getExceptions() {
        return this.exceptions;
    }

    public Library getLibrary() {
        return this.library;
    }

    public TranslatedLibrary getTranslatedLibrary() {
        return this.translatedLibrary;
    }

    public ConversionMap getConversionMap() {
        return this.conversionMap;
    }

    public void enableListTraversal() {
        this.listTraversal = true;
    }

    public void disableListTraversal() {
        this.listTraversal = false;
    }

    public SignatureLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        this.signatureLevel = signatureLevel;
    }

    public CqlTranslatorException.ErrorSeverity getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(CqlTranslatorException.ErrorSeverity severity) {
        this.errorLevel = severity;
    }

    private Model loadModel(VersionedIdentifier modelIdentifier) {
        Model model = this.modelManager.resolveModel(modelIdentifier);
        this.loadConversionMap(model);
        return model;
    }

    public Model getDefaultModel() {
        return this.defaultModel;
    }

    private void setDefaultModel(Model model) {
        if (this.defaultModel == null && !model.getModelInfo().getName().equals("System")) {
            this.defaultModel = model;
        }
    }

    public Model getModel(VersionedIdentifier modelIdentifier) {
        Model model = this.models.get(modelIdentifier.getId());
        if (model == null) {
            model = this.loadModel(modelIdentifier);
            this.setDefaultModel(model);
            this.models.put(modelIdentifier.getId(), model);
            this.buildUsingDef(modelIdentifier, model);
        }
        if (modelIdentifier.getVersion() != null && !modelIdentifier.getVersion().equals(model.getModelInfo().getVersion())) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s because version %s is already loaded.", modelIdentifier.getId(), modelIdentifier.getVersion(), model.getModelInfo().getVersion()));
        }
        return model;
    }

    private void loadConversionMap(Model model) {
        for (Conversion conversion : model.getConversions()) {
            this.conversionMap.add(conversion);
        }
    }

    private UsingDef buildUsingDef(VersionedIdentifier modelIdentifier, Model model) {
        UsingDef usingDef = this.of.createUsingDef().withLocalIdentifier(modelIdentifier.getId()).withVersion(modelIdentifier.getVersion()).withUri(model.getModelInfo().getUrl());
        this.addUsing(usingDef);
        return usingDef;
    }

    public boolean hasUsings() {
        for (Model model : this.models.values()) {
            if (model.getModelInfo().getName().equals("System")) continue;
            return true;
        }
        return false;
    }

    private void addUsing(UsingDef usingDef) {
        if (this.library.getUsings() == null) {
            this.library.setUsings(this.of.createLibraryUsings());
        }
        this.library.getUsings().getDef().add(usingDef);
        this.translatedLibrary.add(usingDef);
    }

    public ClassType resolveLabel(String modelName, String label) {
        ClassType result = null;
        if (modelName == null || modelName.equals("")) {
            for (Model model : this.models.values()) {
                ClassType modelResult = model.resolveLabel(label);
                if (modelResult == null) continue;
                if (result != null) {
                    throw new IllegalArgumentException(String.format("Label %s is ambiguous between %s and %s.", label, result.getLabel(), modelResult.getLabel()));
                }
                result = modelResult;
            }
        } else {
            result = this.getModel(modelName).resolveLabel(label);
        }
        return result;
    }

    public ModelContext resolveContextName(String modelName, String contextName) {
        ModelContext result = null;
        if (modelName == null || modelName.equals("")) {
            ModelContext modelResult;
            if (this.defaultModel != null && (modelResult = this.defaultModel.resolveContextName(contextName)) != null) {
                return modelResult;
            }
            for (Model model : this.models.values()) {
                ModelContext modelResult2 = model.resolveContextName(contextName);
                if (modelResult2 == null) continue;
                if (result != null) {
                    throw new IllegalArgumentException(String.format("Context name %s is ambiguous between %s and %s.", contextName, result.getName(), modelResult2.getName()));
                }
                result = modelResult2;
            }
        } else {
            result = this.getModel(modelName).resolveContextName(contextName);
        }
        return result;
    }

    public DataType resolveTypeName(String typeName) {
        return this.resolveTypeName(null, typeName);
    }

    public DataType resolveTypeName(String modelName, String typeName) {
        ClassType result = this.resolveLabel(modelName, typeName);
        if (result == null) {
            if (modelName == null || modelName.equals("")) {
                DataType modelResult;
                if (this.defaultModel != null && (modelResult = this.defaultModel.resolveTypeName(typeName)) != null) {
                    return modelResult;
                }
                for (Model model : this.models.values()) {
                    DataType modelResult2 = model.resolveTypeName(typeName);
                    if (modelResult2 == null) continue;
                    if (result != null) {
                        throw new IllegalArgumentException(String.format("Type name %s is ambiguous between %s and %s.", typeName, ((NamedType)result).getName(), ((NamedType)modelResult2).getName()));
                    }
                    result = modelResult2;
                }
            } else {
                result = this.getModel(modelName).resolveTypeName(typeName);
            }
        }
        return result;
    }

    public DataType resolveTypeSpecifier(String typeSpecifier) {
        if (typeSpecifier == null) {
            throw new IllegalArgumentException("typeSpecifier is null");
        }
        if (typeSpecifier.toLowerCase().startsWith("interval<")) {
            DataType pointType = this.resolveTypeSpecifier(typeSpecifier.substring(typeSpecifier.indexOf(60) + 1, typeSpecifier.lastIndexOf(62)));
            return new IntervalType(pointType);
        }
        if (typeSpecifier.toLowerCase().startsWith("list<")) {
            DataType elementType = this.resolveTypeName(typeSpecifier.substring(typeSpecifier.indexOf(60) + 1, typeSpecifier.lastIndexOf(62)));
            return new ListType(elementType);
        }
        if (typeSpecifier.indexOf(".") >= 0) {
            String modelName = typeSpecifier.substring(0, typeSpecifier.indexOf("."));
            String typeName = typeSpecifier.substring(typeSpecifier.indexOf(".") + 1);
            return this.resolveTypeName(modelName, typeName);
        }
        return this.resolveTypeName(typeSpecifier);
    }

    public UsingDef resolveUsingRef(String modelName) {
        return this.translatedLibrary.resolveUsingRef(modelName);
    }

    public SystemModel getSystemModel() {
        return (SystemModel)this.getModel(new VersionedIdentifier().withId("System"));
    }

    public Model getModel(String modelName) {
        UsingDef usingDef = this.resolveUsingRef(modelName);
        if (usingDef == null) {
            throw new IllegalArgumentException(String.format("Could not resolve model name %s", modelName));
        }
        return this.getModel(new VersionedIdentifier().withId(usingDef.getLocalIdentifier()).withVersion(usingDef.getVersion()));
    }

    private void loadSystemLibrary() {
        TranslatedLibrary systemLibrary = SystemLibraryHelper.load(this.getSystemModel());
        this.libraries.put(systemLibrary.getIdentifier().getId(), systemLibrary);
        this.loadConversionMap(systemLibrary);
    }

    private void loadConversionMap(TranslatedLibrary library) {
        for (Conversion conversion : library.getConversions()) {
            this.conversionMap.add(conversion);
        }
    }

    public TranslatedLibrary getSystemLibrary() {
        return this.resolveLibrary("System");
    }

    public TranslatedLibrary resolveLibrary(String identifier) {
        TranslatedLibrary result;
        if (!identifier.equals("System")) {
            this.checkLiteralContext();
        }
        if ((result = this.libraries.get(identifier)) == null) {
            throw new IllegalArgumentException(String.format("Could not resolve library name %s.", identifier));
        }
        return result;
    }

    private ErrorSeverity toErrorSeverity(CqlTranslatorException.ErrorSeverity severity) {
        if (severity == CqlTranslatorException.ErrorSeverity.Info) {
            return ErrorSeverity.INFO;
        }
        if (severity == CqlTranslatorException.ErrorSeverity.Warning) {
            return ErrorSeverity.WARNING;
        }
        if (severity == CqlTranslatorException.ErrorSeverity.Error) {
            return ErrorSeverity.ERROR;
        }
        throw new IllegalArgumentException(String.format("Unknown error severity %s", severity.toString()));
    }

    private void addException(CqlTranslatorException e) {
        this.exceptions.add(e);
        if (e.getSeverity() == CqlTranslatorException.ErrorSeverity.Error) {
            this.errors.add(e);
        } else if (e.getSeverity() == CqlTranslatorException.ErrorSeverity.Warning) {
            this.warnings.add(e);
        } else if (e.getSeverity() == CqlTranslatorException.ErrorSeverity.Info) {
            this.messages.add(e);
        }
    }

    private boolean shouldReport(CqlTranslatorException.ErrorSeverity errorSeverity) {
        switch (this.errorLevel) {
            case Info: {
                return errorSeverity == CqlTranslatorException.ErrorSeverity.Info || errorSeverity == CqlTranslatorException.ErrorSeverity.Warning || errorSeverity == CqlTranslatorException.ErrorSeverity.Error;
            }
            case Warning: {
                return errorSeverity == CqlTranslatorException.ErrorSeverity.Warning || errorSeverity == CqlTranslatorException.ErrorSeverity.Error;
            }
            case Error: {
                return errorSeverity == CqlTranslatorException.ErrorSeverity.Error;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown error severity %s", errorSeverity.toString()));
    }

    public void recordParsingException(CqlTranslatorException e) {
        this.addException(e);
        if (this.shouldReport(e.getSeverity())) {
            CqlToElmError err = this.af.createCqlToElmError();
            err.setMessage(e.getMessage());
            err.setErrorType(e instanceof CqlSyntaxException ? ErrorType.SYNTAX : (e instanceof CqlSemanticException ? ErrorType.SEMANTIC : ErrorType.INTERNAL));
            err.setErrorSeverity(this.toErrorSeverity(e.getSeverity()));
            if (e.getLocator() != null) {
                err.setStartLine(Integer.valueOf(e.getLocator().getStartLine()));
                err.setEndLine(Integer.valueOf(e.getLocator().getEndLine()));
                err.setStartChar(Integer.valueOf(e.getLocator().getStartChar()));
                err.setEndChar(Integer.valueOf(e.getLocator().getEndChar()));
            }
            if (e.getCause() != null && e.getCause() instanceof CqlTranslatorIncludeException) {
                CqlTranslatorIncludeException incEx = (CqlTranslatorIncludeException)e.getCause();
                err.setTargetIncludeLibraryId(incEx.getLibraryId());
                err.setTargetIncludeLibraryVersionId(incEx.getVersionId());
                err.setErrorType(ErrorType.INCLUDE);
            }
            this.library.getAnnotation().add(err);
        }
    }

    private String getLibraryName() {
        String libraryName = this.library.getIdentifier().getId();
        if (libraryName == null) {
            libraryName = "Anonymous";
        }
        return libraryName;
    }

    public void beginTranslation() {
        this.loadSystemLibrary();
        this.libraryManager.beginTranslation(this.getLibraryName());
    }

    public VersionedIdentifier getLibraryIdentifier() {
        return this.library.getIdentifier();
    }

    public void setLibraryIdentifier(VersionedIdentifier vid) {
        this.library.setIdentifier(vid);
        this.translatedLibrary.setIdentifier(vid);
    }

    public void endTranslation() {
        this.libraryManager.endTranslation(this.getLibraryName());
    }

    public void addInclude(IncludeDef includeDef) {
        if (this.library.getIdentifier() == null || this.library.getIdentifier().getId() == null) {
            throw new IllegalArgumentException("Unnamed libraries cannot reference other libraries.");
        }
        if (this.library.getIncludes() == null) {
            this.library.setIncludes(this.of.createLibraryIncludes());
        }
        this.library.getIncludes().getDef().add(includeDef);
        this.translatedLibrary.add(includeDef);
        VersionedIdentifier libraryIdentifier = new VersionedIdentifier().withId(includeDef.getPath()).withVersion(includeDef.getVersion());
        ArrayList<CqlTranslatorException> errors = new ArrayList<CqlTranslatorException>();
        TranslatedLibrary referencedLibrary = this.libraryManager.resolveLibrary(libraryIdentifier, errors);
        for (CqlTranslatorException error : errors) {
            this.addException(error);
        }
        this.libraries.put(includeDef.getLocalIdentifier(), referencedLibrary);
        this.loadConversionMap(referencedLibrary);
    }

    public void addParameter(ParameterDef paramDef) {
        if (this.library.getParameters() == null) {
            this.library.setParameters(this.of.createLibraryParameters());
        }
        this.library.getParameters().getDef().add(paramDef);
        this.translatedLibrary.add(paramDef);
    }

    public void addCodeSystem(CodeSystemDef cs) {
        if (this.library.getCodeSystems() == null) {
            this.library.setCodeSystems(this.of.createLibraryCodeSystems());
        }
        this.library.getCodeSystems().getDef().add(cs);
        this.translatedLibrary.add(cs);
    }

    public void addValueSet(ValueSetDef vs) {
        if (this.library.getValueSets() == null) {
            this.library.setValueSets(this.of.createLibraryValueSets());
        }
        this.library.getValueSets().getDef().add(vs);
        this.translatedLibrary.add(vs);
    }

    public void addCode(CodeDef cd) {
        if (this.library.getCodes() == null) {
            this.library.setCodes(this.of.createLibraryCodes());
        }
        this.library.getCodes().getDef().add(cd);
        this.translatedLibrary.add(cd);
    }

    public void addConcept(ConceptDef cd) {
        if (this.library.getConcepts() == null) {
            this.library.setConcepts(this.of.createLibraryConcepts());
        }
        this.library.getConcepts().getDef().add(cd);
        this.translatedLibrary.add(cd);
    }

    public void addExpression(ExpressionDef expDef) {
        if (this.library.getStatements() == null) {
            this.library.setStatements(this.of.createLibraryStatements());
        }
        this.library.getStatements().getDef().add(expDef);
        this.translatedLibrary.add(expDef);
    }

    public void removeExpression(ExpressionDef expDef) {
        if (this.library.getStatements() != null) {
            this.library.getStatements().getDef().remove(expDef);
            this.translatedLibrary.remove(expDef);
        }
    }

    public Element resolve(String identifier) {
        return this.translatedLibrary.resolve(identifier);
    }

    public IncludeDef resolveIncludeRef(String identifier) {
        return this.translatedLibrary.resolveIncludeRef(identifier);
    }

    public CodeSystemDef resolveCodeSystemRef(String identifier) {
        return this.translatedLibrary.resolveCodeSystemRef(identifier);
    }

    public ValueSetDef resolveValueSetRef(String identifier) {
        return this.translatedLibrary.resolveValueSetRef(identifier);
    }

    public CodeDef resolveCodeRef(String identifier) {
        return this.translatedLibrary.resolveCodeRef(identifier);
    }

    public ConceptDef resolveConceptRef(String identifier) {
        return this.translatedLibrary.resolveConceptRef(identifier);
    }

    public ParameterDef resolveParameterRef(String identifier) {
        this.checkLiteralContext();
        return this.translatedLibrary.resolveParameterRef(identifier);
    }

    public ExpressionDef resolveExpressionRef(String identifier) {
        this.checkLiteralContext();
        return this.translatedLibrary.resolveExpressionRef(identifier);
    }

    public Conversion findConversion(DataType fromType, DataType toType, boolean implicit, boolean allowPromotionAndDemotion) {
        return this.conversionMap.findConversion(fromType, toType, implicit, allowPromotionAndDemotion, this.translatedLibrary.getOperatorMap());
    }

    public Expression resolveUnaryCall(String libraryName, String operatorName, UnaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new UnaryExpressionInvocation(expression), false);
    }

    public Invocation resolveBinaryInvocation(String libraryName, String operatorName, BinaryExpression expression) {
        return this.resolveBinaryInvocation(libraryName, operatorName, expression, true, false);
    }

    public Expression resolveBinaryCall(String libraryName, String operatorName, BinaryExpression expression) {
        Invocation invocation = this.resolveBinaryInvocation(libraryName, operatorName, expression);
        return invocation != null ? invocation.getExpression() : null;
    }

    public Invocation resolveBinaryInvocation(String libraryName, String operatorName, BinaryExpression expression, boolean mustResolve, boolean allowPromotionAndDemotion) {
        return this.resolveInvocation(libraryName, operatorName, new BinaryExpressionInvocation(expression), mustResolve, allowPromotionAndDemotion);
    }

    public Expression resolveBinaryCall(String libraryName, String operatorName, BinaryExpression expression, boolean mustResolve, boolean allowPromotionAndDemotion) {
        Invocation invocation = this.resolveBinaryInvocation(libraryName, operatorName, expression, mustResolve, allowPromotionAndDemotion);
        return invocation != null ? invocation.getExpression() : null;
    }

    public Expression resolveTernaryCall(String libraryName, String operatorName, TernaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new TernaryExpressionInvocation(expression), false);
    }

    public Expression resolveNaryCall(String libraryName, String operatorName, NaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new NaryExpressionInvocation(expression), false);
    }

    public Expression resolveAggregateCall(String libraryName, String operatorName, AggregateExpression expression) {
        return this.resolveCall(libraryName, operatorName, new AggregateExpressionInvocation(expression), false);
    }

    private BinaryWrapper normalizeListTypes(Expression left, Expression right) {
        ListType rightListType;
        ListType leftListType;
        if (left.getResultType() instanceof ListType && right.getResultType() instanceof ListType && !(leftListType = (ListType)left.getResultType()).isSuperTypeOf((DataType)(rightListType = (ListType)right.getResultType())) && !rightListType.isSuperTypeOf((DataType)leftListType) && !leftListType.isCompatibleWith((DataType)rightListType) && !rightListType.isCompatibleWith((DataType)leftListType)) {
            HashSet<DataType> elementTypes = new HashSet<DataType>();
            if (leftListType.getElementType() instanceof ChoiceType) {
                for (DataType choice : ((ChoiceType)leftListType.getElementType()).getTypes()) {
                    elementTypes.add(choice);
                }
            } else {
                elementTypes.add(leftListType.getElementType());
            }
            if (rightListType.getElementType() instanceof ChoiceType) {
                for (DataType choice : ((ChoiceType)rightListType.getElementType()).getTypes()) {
                    elementTypes.add(choice);
                }
            } else {
                elementTypes.add(rightListType.getElementType());
            }
            if (elementTypes.size() > 1) {
                ListType targetType = new ListType((DataType)new ChoiceType(elementTypes));
                left = this.of.createAs().withOperand(left).withAsTypeSpecifier(this.dataTypeToTypeSpecifier((DataType)targetType));
                left.setResultType((DataType)targetType);
                right = this.of.createAs().withOperand(right).withAsTypeSpecifier(this.dataTypeToTypeSpecifier((DataType)targetType));
                right.setResultType((DataType)targetType);
            }
        }
        return new BinaryWrapper(left, right);
    }

    public Expression resolveUnion(Expression left, Expression right) {
        if (left instanceof Union) {
            Union leftUnion = (Union)left;
            Expression leftUnionLeft = (Expression)leftUnion.getOperand().get(0);
            Expression leftUnionRight = (Expression)leftUnion.getOperand().get(1);
            if (leftUnionLeft instanceof Union && !(leftUnionRight instanceof Union)) {
                left = leftUnionLeft;
                right = this.resolveUnion(leftUnionRight, right);
            }
        }
        BinaryWrapper wrapper = this.normalizeListTypes(left, right);
        Union union = this.of.createUnion().withOperand(new Expression[]{wrapper.left, wrapper.right});
        this.resolveNaryCall("System", "Union", (NaryExpression)union);
        return union;
    }

    public Expression resolveIntersect(Expression left, Expression right) {
        if (left instanceof Intersect) {
            Intersect leftIntersect = (Intersect)left;
            Expression leftIntersectLeft = (Expression)leftIntersect.getOperand().get(0);
            Expression leftIntersectRight = (Expression)leftIntersect.getOperand().get(1);
            if (leftIntersectLeft instanceof Intersect && !(leftIntersectRight instanceof Intersect)) {
                left = leftIntersectLeft;
                right = this.resolveIntersect(leftIntersectRight, right);
            }
        }
        BinaryWrapper wrapper = this.normalizeListTypes(left, right);
        Intersect intersect = this.of.createIntersect().withOperand(new Expression[]{wrapper.left, wrapper.right});
        this.resolveNaryCall("System", "Intersect", (NaryExpression)intersect);
        return intersect;
    }

    public Expression resolveExcept(Expression left, Expression right) {
        BinaryWrapper wrapper = this.normalizeListTypes(left, right);
        Except except = this.of.createExcept().withOperand(new Expression[]{wrapper.left, wrapper.right});
        this.resolveNaryCall("System", "Except", (NaryExpression)except);
        return except;
    }

    public Expression resolveIn(Expression left, Expression right) {
        if (right instanceof ValueSetRef) {
            if (left.getResultType() instanceof ListType) {
                AnyInValueSet anyIn = this.of.createAnyInValueSet().withCodes(left).withValueset((ValueSetRef)right);
                this.resolveCall("System", "AnyInValueSet", new AnyInValueSetInvocation(anyIn));
                return anyIn;
            }
            InValueSet in = this.of.createInValueSet().withCode(left).withValueset((ValueSetRef)right);
            this.resolveCall("System", "InValueSet", new InValueSetInvocation(in));
            return in;
        }
        if (right instanceof CodeSystemRef) {
            if (left.getResultType() instanceof ListType) {
                AnyInCodeSystem anyIn = this.of.createAnyInCodeSystem().withCodes(left).withCodesystem((CodeSystemRef)right);
                this.resolveCall("System", "AnyInCodeSystem", new AnyInCodeSystemInvocation(anyIn));
                return anyIn;
            }
            InCodeSystem in = this.of.createInCodeSystem().withCode(left).withCodesystem((CodeSystemRef)right);
            this.resolveCall("System", "InCodeSystem", new InCodeSystemInvocation(in));
            return in;
        }
        In in = this.of.createIn().withOperand(new Expression[]{left, right});
        this.resolveBinaryCall("System", "In", (BinaryExpression)in);
        return in;
    }

    public Expression resolveIn(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        Invocation result = this.resolveInInvocation(left, right, dateTimePrecision);
        return result != null ? result.getExpression() : null;
    }

    public Invocation resolveInInvocation(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        In in = this.of.createIn().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        return this.resolveBinaryInvocation("System", "In", (BinaryExpression)in);
    }

    public Expression resolveProperIn(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        Invocation result = this.resolveProperInInvocation(left, right, dateTimePrecision);
        return result != null ? result.getExpression() : null;
    }

    public Invocation resolveProperInInvocation(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        ProperIn properIn = this.of.createProperIn().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        return this.resolveBinaryInvocation("System", "ProperIn", (BinaryExpression)properIn);
    }

    public Expression resolveContains(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        Invocation result = this.resolveContainsInvocation(left, right, dateTimePrecision);
        return result != null ? result.getExpression() : null;
    }

    public Invocation resolveContainsInvocation(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        Contains contains = this.of.createContains().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        return this.resolveBinaryInvocation("System", "Contains", (BinaryExpression)contains);
    }

    public Expression resolveProperContains(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        Invocation result = this.resolveProperContainsInvocation(left, right, dateTimePrecision);
        return result != null ? result.getExpression() : null;
    }

    public Invocation resolveProperContainsInvocation(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        ProperContains properContains = this.of.createProperContains().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        return this.resolveBinaryInvocation("System", "ProperContains", (BinaryExpression)properContains);
    }

    private Expression lowestScoringInvocation(Invocation primary, Invocation secondary) {
        if (primary != null) {
            if (secondary != null && secondary.getResolution().getScore() < primary.getResolution().getScore()) {
                return secondary.getExpression();
            }
            return primary.getExpression();
        }
        if (secondary != null) {
            return secondary.getExpression();
        }
        return null;
    }

    public Expression resolveIncludes(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        Includes includes = this.of.createIncludes().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        Invocation includesInvocation = this.resolveBinaryInvocation("System", "Includes", (BinaryExpression)includes, false, false);
        Contains contains = this.of.createContains().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        Invocation containsInvocation = this.resolveBinaryInvocation("System", "Contains", (BinaryExpression)contains, false, false);
        Expression result = this.lowestScoringInvocation(includesInvocation, containsInvocation);
        if (result != null) {
            return result;
        }
        return this.resolveBinaryCall("System", "Includes", (BinaryExpression)includes);
    }

    public Expression resolveProperIncludes(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        ProperIncludes properIncludes = this.of.createProperIncludes().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        Invocation properIncludesInvocation = this.resolveBinaryInvocation("System", "ProperIncludes", (BinaryExpression)properIncludes, false, false);
        ProperContains properContains = this.of.createProperContains().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        Invocation properContainsInvocation = this.resolveBinaryInvocation("System", "ProperContains", (BinaryExpression)properContains, false, false);
        Expression result = this.lowestScoringInvocation(properIncludesInvocation, properContainsInvocation);
        if (result != null) {
            return result;
        }
        return this.resolveBinaryCall("System", "ProperIncludes", (BinaryExpression)properIncludes);
    }

    public Expression resolveIncludedIn(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        IncludedIn includedIn = this.of.createIncludedIn().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        Invocation includedInInvocation = this.resolveBinaryInvocation("System", "IncludedIn", (BinaryExpression)includedIn, false, false);
        In in = this.of.createIn().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        Invocation inInvocation = this.resolveBinaryInvocation("System", "In", (BinaryExpression)in, false, false);
        Expression result = this.lowestScoringInvocation(includedInInvocation, inInvocation);
        if (result != null) {
            return result;
        }
        return this.resolveBinaryCall("System", "IncludedIn", (BinaryExpression)includedIn);
    }

    public Expression resolveProperIncludedIn(Expression left, Expression right, DateTimePrecision dateTimePrecision) {
        ProperIncludedIn properIncludedIn = this.of.createProperIncludedIn().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        Invocation properIncludedInInvocation = this.resolveBinaryInvocation("System", "ProperIncludedIn", (BinaryExpression)properIncludedIn, false, false);
        ProperIn properIn = this.of.createProperIn().withOperand(new Expression[]{left, right}).withPrecision(dateTimePrecision);
        Invocation properInInvocation = this.resolveBinaryInvocation("System", "ProperIn", (BinaryExpression)properIn, false, false);
        Expression result = this.lowestScoringInvocation(properIncludedInInvocation, properInInvocation);
        if (result != null) {
            return result;
        }
        return this.resolveBinaryCall("System", "ProperIncludedIn", (BinaryExpression)properIncludedIn);
    }

    public Expression resolveCall(String libraryName, String operatorName, Invocation invocation) {
        return this.resolveCall(libraryName, operatorName, invocation, true, false);
    }

    public Expression resolveCall(String libraryName, String operatorName, Invocation invocation, boolean allowPromotionAndDemotion) {
        return this.resolveCall(libraryName, operatorName, invocation, true, allowPromotionAndDemotion);
    }

    public Expression resolveCall(String libraryName, String operatorName, Invocation invocation, boolean mustResolve, boolean allowPromotionAndDemotion) {
        Invocation result = this.resolveInvocation(libraryName, operatorName, invocation, mustResolve, allowPromotionAndDemotion);
        return result != null ? result.getExpression() : null;
    }

    public Invocation resolveInvocation(String libraryName, String operatorName, Invocation invocation, boolean mustResolve, boolean allowPromotionAndDemotion) {
        Iterable<Expression> operands = invocation.getOperands();
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (Expression operand : operands) {
            if (operand.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not determine signature for invocation of operator %s%s.", libraryName == null ? "" : libraryName + ".", operatorName));
            }
            dataTypes.add(operand.getResultType());
        }
        CallContext callContext = new CallContext(libraryName, operatorName, allowPromotionAndDemotion, mustResolve, dataTypes.toArray(new DataType[dataTypes.size()]));
        OperatorResolution resolution = this.resolveCall(callContext);
        if (resolution != null || mustResolve) {
            this.checkOperator(callContext, resolution);
            if (resolution.hasConversions()) {
                ArrayList<Expression> convertedOperands = new ArrayList<Expression>();
                Iterator<Expression> operandIterator = operands.iterator();
                Iterator<Conversion> conversionIterator = resolution.getConversions().iterator();
                while (operandIterator.hasNext()) {
                    Expression operand = operandIterator.next();
                    Conversion conversion = conversionIterator.next();
                    if (conversion != null) {
                        convertedOperands.add(this.convertExpression(operand, conversion));
                        continue;
                    }
                    convertedOperands.add(operand);
                }
                invocation.setOperands(convertedOperands);
            }
            if (this.signatureLevel == SignatureLevel.All || this.signatureLevel == SignatureLevel.Differing && !resolution.getOperator().getSignature().equals(callContext.getSignature()) || this.signatureLevel == SignatureLevel.Overloads && resolution.getOperatorHasOverloads()) {
                invocation.setSignature(this.dataTypesToTypeSpecifiers(resolution.getOperator().getSignature().getOperandTypes()));
            }
            invocation.setResultType(resolution.getOperator().getResultType());
            invocation.setResolution(resolution);
            return invocation;
        }
        return null;
    }

    public OperatorResolution resolveCall(CallContext callContext) {
        OperatorResolution result = null;
        if (callContext.getLibraryName() == null || callContext.getLibraryName().equals("")) {
            result = this.translatedLibrary.resolveCall(callContext, this.conversionMap);
            if (result == null && (result = this.getSystemLibrary().resolveCall(callContext, this.conversionMap)) != null) {
                this.checkAccessLevel(result.getOperator().getLibraryName(), result.getOperator().getName(), result.getOperator().getAccessLevel());
            }
        } else {
            result = this.resolveLibrary(callContext.getLibraryName()).resolveCall(callContext, this.conversionMap);
        }
        return result;
    }

    public void checkOperator(CallContext callContext, OperatorResolution resolution) {
        if (resolution == null) {
            throw new IllegalArgumentException(String.format("Could not resolve call to operator %s with signature %s.", callContext.getOperatorName(), callContext.getSignature()));
        }
    }

    public void checkAccessLevel(String libraryName, String objectName, AccessModifier accessModifier) {
        if (accessModifier == AccessModifier.PRIVATE) {
            throw new IllegalArgumentException(String.format("Object %s in library %s is marked private and cannot be referenced from another library.", objectName, libraryName));
        }
    }

    public Expression resolveFunction(String libraryName, String functionName, Iterable<Expression> paramList) {
        return this.resolveFunction(libraryName, functionName, paramList, true);
    }

    private FunctionRef buildFunctionRef(String libraryName, String functionName, Iterable<Expression> paramList) {
        FunctionRef fun = this.of.createFunctionRef().withLibraryName(libraryName).withName(functionName);
        for (Expression param : paramList) {
            fun.getOperand().add(param);
        }
        return fun;
    }

    public Expression resolveFunction(String libraryName, String functionName, Iterable<Expression> paramList, boolean mustResolve) {
        FunctionRef fun = this.buildFunctionRef(libraryName, functionName, paramList);
        FunctionRefInvocation invocation = new FunctionRefInvocation(fun);
        if ((fun = (FunctionRef)this.resolveCall(fun.getLibraryName(), fun.getName(), invocation, false, false)) != null) {
            if ("System".equals(invocation.getResolution().getOperator().getLibraryName())) {
                FunctionRef systemFun = this.buildFunctionRef(libraryName, functionName, paramList);
                Expression systemFunction = this.systemFunctionResolver.resolveSystemFunction(systemFun);
                if (systemFunction != null) {
                    return systemFunction;
                }
            } else if (mustResolve) {
                this.checkLiteralContext();
            }
        }
        if (fun == null) {
            fun = this.buildFunctionRef(libraryName, functionName, paramList);
            Expression systemFunction = this.systemFunctionResolver.resolveSystemFunction(fun);
            if (systemFunction != null) {
                return systemFunction;
            }
            if (mustResolve) {
                this.checkLiteralContext();
            }
            fun = (FunctionRef)this.resolveCall(fun.getLibraryName(), fun.getName(), new FunctionRefInvocation(fun), mustResolve, false);
        }
        return fun;
    }

    public void verifyComparable(DataType dataType) {
        Expression left = (Expression)this.of.createLiteral().withResultType(dataType);
        Expression right = (Expression)this.of.createLiteral().withResultType(dataType);
        Less comparison = this.of.createLess().withOperand(new Expression[]{left, right});
        this.resolveBinaryCall("System", "Less", (BinaryExpression)comparison);
    }

    public Expression convertExpression(Expression expression, DataType targetType) {
        return this.convertExpression(expression, targetType, true);
    }

    public Expression convertExpression(Expression expression, DataType targetType, boolean implicit) {
        Conversion conversion = this.findConversion(expression.getResultType(), targetType, implicit, false);
        if (conversion != null) {
            return this.convertExpression(expression, conversion);
        }
        DataTypes.verifyType(expression.getResultType(), targetType);
        return expression;
    }

    private Expression convertListExpression(Expression expression, Conversion conversion) {
        ListType fromType = (ListType)conversion.getFromType();
        ListType toType = (ListType)conversion.getToType();
        Query query = (Query)this.of.createQuery().withSource(new AliasedQuerySource[]{(AliasedQuerySource)this.of.createAliasedQuerySource().withAlias("X").withExpression(expression).withResultType((DataType)fromType)}).withReturn((ReturnClause)this.of.createReturnClause().withDistinct(Boolean.valueOf(false)).withExpression(this.convertExpression((Expression)((AliasRef)this.of.createAliasRef().withName("X").withResultType(fromType.getElementType())), conversion.getConversion())).withResultType((DataType)toType)).withResultType((DataType)toType);
        return query;
    }

    private void reportWarning(String message, Expression expression) {
        TrackBack trackback = expression.getTrackbacks() != null && expression.getTrackbacks().size() > 0 ? (TrackBack)expression.getTrackbacks().get(0) : null;
        CqlSemanticException warning = new CqlSemanticException(message, CqlTranslatorException.ErrorSeverity.Warning, trackback);
        this.recordParsingException(warning);
    }

    private Expression demoteListExpression(Expression expression, Conversion conversion) {
        ListType fromType = (ListType)conversion.getFromType();
        DataType toType = conversion.getToType();
        SingletonFrom singletonFrom = this.of.createSingletonFrom().withOperand(expression);
        singletonFrom.setResultType(fromType.getElementType());
        this.resolveUnaryCall("System", "SingletonFrom", (UnaryExpression)singletonFrom);
        this.reportWarning("List-valued expression was demoted to a singleton.", expression);
        if (conversion.getConversion() != null) {
            return this.convertExpression((Expression)singletonFrom, conversion.getConversion());
        }
        return singletonFrom;
    }

    private Expression promoteListExpression(Expression expression, Conversion conversion) {
        if (conversion.getConversion() != null) {
            expression = this.convertExpression(expression, conversion.getConversion());
        }
        if (expression.getResultType().equals(this.resolveTypeName("System", "Boolean"))) {
            this.reportWarning("Boolean-valued expression was promoted to a list.", expression);
        }
        return this.resolveToList(expression);
    }

    public Expression resolveToList(Expression expression) {
        ToList toList = this.of.createToList().withOperand(expression);
        toList.setResultType((DataType)new ListType(expression.getResultType()));
        return toList;
    }

    private Expression demoteIntervalExpression(Expression expression, Conversion conversion) {
        IntervalType fromType = (IntervalType)conversion.getFromType();
        DataType toType = conversion.getToType();
        PointFrom pointFrom = this.of.createPointFrom().withOperand(expression);
        pointFrom.setResultType(fromType.getPointType());
        this.resolveUnaryCall("System", "PointFrom", (UnaryExpression)pointFrom);
        this.reportWarning("Interval-valued expression was demoted to a point.", expression);
        if (conversion.getConversion() != null) {
            return this.convertExpression((Expression)pointFrom, conversion.getConversion());
        }
        return pointFrom;
    }

    private Expression promoteIntervalExpression(Expression expression, Conversion conversion) {
        if (conversion.getConversion() != null) {
            expression = this.convertExpression(expression, conversion.getConversion());
        }
        return this.resolveToInterval(expression);
    }

    public Expression resolveToInterval(Expression expression) {
        Interval toInterval = this.of.createInterval().withLow(expression).withHigh(expression).withLowClosed(Boolean.valueOf(true)).withHighClosed(Boolean.valueOf(true));
        toInterval.setResultType((DataType)new IntervalType(expression.getResultType()));
        return toInterval;
    }

    private Expression convertIntervalExpression(Expression expression, Conversion conversion) {
        IntervalType fromType = (IntervalType)conversion.getFromType();
        IntervalType toType = (IntervalType)conversion.getToType();
        Interval interval = (Interval)this.of.createInterval().withLow(this.convertExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("low").withResultType(fromType.getPointType())), conversion.getConversion())).withLowClosedExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("lowClosed").withResultType(this.resolveTypeName("System", "Boolean")))).withHigh(this.convertExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("high").withResultType(fromType.getPointType())), conversion.getConversion())).withHighClosedExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("highClosed").withResultType(this.resolveTypeName("System", "Boolean")))).withResultType((DataType)toType);
        return interval;
    }

    public As buildAs(Expression expression, DataType asType) {
        As result = (As)this.of.createAs().withOperand(expression).withResultType(asType);
        if (result.getResultType() instanceof NamedType) {
            result.setAsType(this.dataTypeToQName(result.getResultType()));
        } else {
            result.setAsTypeSpecifier(this.dataTypeToTypeSpecifier(result.getResultType()));
        }
        return result;
    }

    public Is buildIs(Expression expression, DataType isType) {
        Is result = (Is)this.of.createIs().withOperand(expression).withResultType(this.resolveTypeName("System", "Boolean"));
        if (isType instanceof NamedType) {
            result.setIsType(this.dataTypeToQName(isType));
        } else {
            result.setIsTypeSpecifier(this.dataTypeToTypeSpecifier(isType));
        }
        return result;
    }

    public Null buildNull(DataType nullType) {
        Null result = (Null)this.of.createNull().withResultType(nullType);
        if (nullType instanceof NamedType) {
            result.setResultTypeName(this.dataTypeToQName(nullType));
        } else {
            result.setResultTypeSpecifier(this.dataTypeToTypeSpecifier(nullType));
        }
        return result;
    }

    public MinValue buildMinimum(DataType dataType) {
        MinValue minimum = this.of.createMinValue();
        minimum.setValueType(this.dataTypeToQName(dataType));
        minimum.setResultType(dataType);
        return minimum;
    }

    public MaxValue buildMaximum(DataType dataType) {
        MaxValue maximum = this.of.createMaxValue();
        maximum.setValueType(this.dataTypeToQName(dataType));
        maximum.setResultType(dataType);
        return maximum;
    }

    public Expression buildPredecessor(Expression source) {
        Predecessor result = this.of.createPredecessor().withOperand(source);
        this.resolveUnaryCall("System", "Predecessor", (UnaryExpression)result);
        return result;
    }

    public Expression buildSuccessor(Expression source) {
        Successor result = this.of.createSuccessor().withOperand(source);
        this.resolveUnaryCall("System", "Successor", (UnaryExpression)result);
        return result;
    }

    public Expression convertExpression(Expression expression, Conversion conversion) {
        if (conversion.isCast() && (conversion.getFromType().isSuperTypeOf(conversion.getToType()) || conversion.getFromType().isCompatibleWith(conversion.getToType()))) {
            As castedOperand = this.buildAs(expression, conversion.getToType());
            return castedOperand;
        }
        if (conversion.isCast() && conversion.getConversion() != null && (conversion.getFromType().isSuperTypeOf(conversion.getConversion().getFromType()) || conversion.getFromType().isCompatibleWith(conversion.getConversion().getFromType()))) {
            As castedOperand = this.buildAs(expression, conversion.getConversion().getFromType());
            Expression result = this.convertExpression((Expression)castedOperand, conversion.getConversion());
            if (conversion.hasAlternativeConversions()) {
                Case caseResult = this.of.createCase();
                caseResult.setResultType(result.getResultType());
                caseResult.withCaseItem(new CaseItem[]{this.of.createCaseItem().withWhen((Expression)this.buildIs(expression, conversion.getConversion().getFromType())).withThen(result)});
                for (Conversion alternative : conversion.getAlternativeConversions()) {
                    caseResult.withCaseItem(new CaseItem[]{this.of.createCaseItem().withWhen((Expression)this.buildIs(expression, alternative.getFromType())).withThen(this.convertExpression((Expression)this.buildAs(expression, alternative.getFromType()), alternative))});
                }
                caseResult.withElse((Expression)this.buildNull(result.getResultType()));
                result = caseResult;
            }
            return result;
        }
        if (conversion.isListConversion()) {
            return this.convertListExpression(expression, conversion);
        }
        if (conversion.isListDemotion()) {
            return this.demoteListExpression(expression, conversion);
        }
        if (conversion.isListPromotion()) {
            return this.promoteListExpression(expression, conversion);
        }
        if (conversion.isIntervalConversion()) {
            return this.convertIntervalExpression(expression, conversion);
        }
        if (conversion.isIntervalDemotion()) {
            return this.demoteIntervalExpression(expression, conversion);
        }
        if (conversion.isIntervalPromotion()) {
            return this.promoteIntervalExpression(expression, conversion);
        }
        if (conversion.getOperator() != null) {
            FunctionRef functionRef = this.of.createFunctionRef().withLibraryName(conversion.getOperator().getLibraryName()).withName(conversion.getOperator().getName()).withOperand(new Expression[]{expression});
            Expression systemFunction = this.systemFunctionResolver.resolveSystemFunction(functionRef);
            if (systemFunction != null) {
                return systemFunction;
            }
            this.resolveCall(functionRef.getLibraryName(), functionRef.getName(), new FunctionRefInvocation(functionRef), false);
            return functionRef;
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Boolean"))) {
            return (Expression)this.of.createToBoolean().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Integer"))) {
            return (Expression)this.of.createToInteger().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Decimal"))) {
            return (Expression)this.of.createToDecimal().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "String"))) {
            return (Expression)this.of.createToString().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Date"))) {
            return (Expression)this.of.createToDate().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "DateTime"))) {
            return (Expression)this.of.createToDateTime().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Time"))) {
            return (Expression)this.of.createToTime().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Quantity"))) {
            return (Expression)this.of.createToQuantity().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Ratio"))) {
            return (Expression)this.of.createToRatio().withOperand(expression).withResultType(conversion.getToType());
        }
        if (conversion.getToType().equals(this.resolveTypeName("System", "Concept"))) {
            return (Expression)this.of.createToConcept().withOperand(expression).withResultType(conversion.getToType());
        }
        Convert convertedOperand = (Convert)this.of.createConvert().withOperand(expression).withResultType(conversion.getToType());
        if (convertedOperand.getResultType() instanceof NamedType) {
            convertedOperand.setToType(this.dataTypeToQName(convertedOperand.getResultType()));
        } else {
            convertedOperand.setToTypeSpecifier(this.dataTypeToTypeSpecifier(convertedOperand.getResultType()));
        }
        return convertedOperand;
    }

    public void verifyType(DataType actualType, DataType expectedType) {
        if (expectedType.isSuperTypeOf(actualType) || actualType.isCompatibleWith(expectedType)) {
            return;
        }
        Conversion conversion = this.findConversion(actualType, expectedType, true, false);
        if (conversion != null) {
            return;
        }
        DataTypes.verifyType(actualType, expectedType);
    }

    public DataType findCompatibleType(DataType first, DataType second) {
        if (first == null || second == null) {
            return null;
        }
        if (first.equals(DataType.ANY)) {
            return second;
        }
        if (second.equals(DataType.ANY)) {
            return first;
        }
        if (first.isSuperTypeOf(second) || second.isCompatibleWith(first)) {
            return first;
        }
        if (second.isSuperTypeOf(first) || first.isCompatibleWith(second)) {
            return second;
        }
        Conversion conversion = this.findConversion(second, first, true, false);
        if (conversion != null) {
            return first;
        }
        conversion = this.findConversion(first, second, true, false);
        if (conversion != null) {
            return second;
        }
        return null;
    }

    public DataType ensureCompatibleTypes(DataType first, DataType second) {
        DataType compatibleType = this.findCompatibleType(first, second);
        if (compatibleType != null) {
            return compatibleType;
        }
        DataTypes.verifyType(second, first);
        return first;
    }

    public Expression ensureCompatible(Expression expression, DataType targetType) {
        if (targetType == null) {
            return this.of.createNull();
        }
        if (!targetType.isSuperTypeOf(expression.getResultType())) {
            return this.convertExpression(expression, targetType, true);
        }
        return expression;
    }

    public Expression enforceCompatible(Expression expression, DataType targetType) {
        if (targetType == null) {
            return this.of.createNull();
        }
        if (!targetType.isSuperTypeOf(expression.getResultType())) {
            return this.convertExpression(expression, targetType, false);
        }
        return expression;
    }

    public Literal createLiteral(String val, String type) {
        DataType resultType = this.resolveTypeName("System", type);
        Literal result = this.of.createLiteral().withValue(val).withValueType(this.dataTypeToQName(resultType));
        result.setResultType(resultType);
        return result;
    }

    public Literal createLiteral(String string) {
        return this.createLiteral(String.valueOf(string), "String");
    }

    public Literal createLiteral(Boolean bool) {
        return this.createLiteral(String.valueOf(bool), "Boolean");
    }

    public Literal createLiteral(Integer integer) {
        return this.createLiteral(String.valueOf(integer), "Integer");
    }

    public Literal createLiteral(Double value) {
        return this.createLiteral(String.valueOf(value), "Decimal");
    }

    public Literal createNumberLiteral(String value) {
        DataType resultType = this.resolveTypeName("System", value.contains(".") ? "Decimal" : "Integer");
        Literal result = this.of.createLiteral().withValue(value).withValueType(this.dataTypeToQName(resultType));
        result.setResultType(resultType);
        return result;
    }

    public void validateUnit(String unit) {
        switch (unit) {
            case "year": 
            case "years": 
            case "month": 
            case "months": 
            case "week": 
            case "weeks": 
            case "day": 
            case "days": 
            case "hour": 
            case "hours": 
            case "minute": 
            case "minutes": 
            case "second": 
            case "seconds": 
            case "millisecond": 
            case "milliseconds": {
                break;
            }
            default: {
                String message;
                if (this.ucumService == null || (message = this.ucumService.validate(unit)) == null) break;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public String ensureUcumUnit(String unit) {
        String message;
        switch (unit) {
            case "year": 
            case "years": {
                return "a";
            }
            case "month": 
            case "months": {
                return "mo";
            }
            case "week": 
            case "weeks": {
                return "wk";
            }
            case "day": 
            case "days": {
                return "d";
            }
            case "hour": 
            case "hours": {
                return "h";
            }
            case "minute": 
            case "minutes": {
                return "min";
            }
            case "second": 
            case "seconds": {
                return "s";
            }
            case "millisecond": 
            case "milliseconds": {
                return "ms";
            }
        }
        if (this.ucumService != null && (message = this.ucumService.validate(unit)) != null) {
            throw new IllegalArgumentException(message);
        }
        return unit;
    }

    public Quantity createQuantity(BigDecimal value, String unit) {
        this.validateUnit(unit);
        Quantity result = this.of.createQuantity().withValue(value).withUnit(unit);
        DataType resultType = this.resolveTypeName("System", "Quantity");
        result.setResultType(resultType);
        return result;
    }

    public Ratio createRatio(Quantity numerator, Quantity denominator) {
        Ratio result = this.of.createRatio().withNumerator(numerator).withDenominator(denominator);
        DataType resultType = this.resolveTypeName("System", "Ratio");
        result.setResultType(resultType);
        return result;
    }

    public Interval createInterval(Expression low, boolean lowClosed, Expression high, boolean highClosed) {
        Interval result = this.of.createInterval().withLow(low).withLowClosed(Boolean.valueOf(lowClosed)).withHigh(high).withHighClosed(Boolean.valueOf(highClosed));
        DataType pointType = this.ensureCompatibleTypes(result.getLow().getResultType(), result.getHigh().getResultType());
        result.setResultType((DataType)new IntervalType(pointType));
        result.setLow(this.ensureCompatible(result.getLow(), pointType));
        result.setHigh(this.ensureCompatible(result.getHigh(), pointType));
        return result;
    }

    public QName dataTypeToQName(DataType type) {
        if (type instanceof NamedType) {
            NamedType namedType = (NamedType)type;
            ModelInfo modelInfo = this.getModel(namedType.getNamespace()).getModelInfo();
            return new QName(modelInfo.getUrl(), namedType.getSimpleName());
        }
        throw new IllegalArgumentException("A named type is required in this context.");
    }

    public Iterable<TypeSpecifier> dataTypesToTypeSpecifiers(Iterable<DataType> types) {
        ArrayList<TypeSpecifier> result = new ArrayList<TypeSpecifier>();
        for (DataType type : types) {
            result.add(this.dataTypeToTypeSpecifier(type));
        }
        return result;
    }

    public TypeSpecifier dataTypeToTypeSpecifier(DataType type) {
        if (type instanceof NamedType) {
            return (TypeSpecifier)this.of.createNamedTypeSpecifier().withName(this.dataTypeToQName(type)).withResultType(type);
        }
        if (type instanceof ListType) {
            return this.listTypeToTypeSpecifier((ListType)type);
        }
        if (type instanceof IntervalType) {
            return this.intervalTypeToTypeSpecifier((IntervalType)type);
        }
        if (type instanceof TupleType) {
            return this.tupleTypeToTypeSpecifier((TupleType)type);
        }
        if (type instanceof ChoiceType) {
            return this.choiceTypeToTypeSpecifier((ChoiceType)type);
        }
        throw new IllegalArgumentException(String.format("Could not convert type %s to a type specifier.", type));
    }

    private TypeSpecifier listTypeToTypeSpecifier(ListType type) {
        return (TypeSpecifier)this.of.createListTypeSpecifier().withElementType(this.dataTypeToTypeSpecifier(type.getElementType())).withResultType((DataType)type);
    }

    private TypeSpecifier intervalTypeToTypeSpecifier(IntervalType type) {
        return (TypeSpecifier)this.of.createIntervalTypeSpecifier().withPointType(this.dataTypeToTypeSpecifier(type.getPointType())).withResultType((DataType)type);
    }

    private TypeSpecifier tupleTypeToTypeSpecifier(TupleType type) {
        return (TypeSpecifier)this.of.createTupleTypeSpecifier().withElement(this.tupleTypeElementsToTupleElementDefinitions(type.getElements())).withResultType((DataType)type);
    }

    private TupleElementDefinition[] tupleTypeElementsToTupleElementDefinitions(Iterable<TupleTypeElement> elements) {
        ArrayList<TupleElementDefinition> definitions = new ArrayList<TupleElementDefinition>();
        for (TupleTypeElement element : elements) {
            definitions.add(this.of.createTupleElementDefinition().withName(element.getName()).withType(this.dataTypeToTypeSpecifier(element.getType())));
        }
        return definitions.toArray(new TupleElementDefinition[definitions.size()]);
    }

    private TypeSpecifier choiceTypeToTypeSpecifier(ChoiceType type) {
        return (TypeSpecifier)this.of.createChoiceTypeSpecifier().withChoice(this.choiceTypeTypesToTypeSpecifiers(type)).withResultType((DataType)type);
    }

    private TypeSpecifier[] choiceTypeTypesToTypeSpecifiers(ChoiceType choiceType) {
        ArrayList<TypeSpecifier> specifiers = new ArrayList<TypeSpecifier>();
        for (DataType type : choiceType.getTypes()) {
            specifiers.add(this.dataTypeToTypeSpecifier(type));
        }
        return specifiers.toArray(new TypeSpecifier[specifiers.size()]);
    }

    public DataType resolvePath(DataType sourceType, String path) {
        String[] identifiers = path.split("\\.");
        for (int i = 0; i < identifiers.length; ++i) {
            PropertyResolution resolution = this.resolveProperty(sourceType, identifiers[i]);
            sourceType = resolution.getType();
            if (resolution.getTarget().equals(identifiers[i])) continue;
            throw new IllegalArgumentException(String.format("Identifier %s references an element with a target defined and cannot be resolved as part of a path", identifiers[i]));
        }
        return sourceType;
    }

    public PropertyResolution resolveProperty(DataType sourceType, String identifier) {
        return this.resolveProperty(sourceType, identifier, true);
    }

    public PropertyResolution resolveProperty(DataType sourceType, String identifier, boolean mustResolve) {
        for (DataType currentType = sourceType; currentType != null; currentType = currentType.getBaseType()) {
            if (currentType instanceof ClassType) {
                ClassType classType = (ClassType)currentType;
                for (ClassTypeElement e : classType.getElements()) {
                    if (!e.getName().equals(identifier)) continue;
                    if (e.isProhibited()) {
                        throw new IllegalArgumentException(String.format("Element %s cannot be referenced because it is marked prohibited in type %s.", e.getName(), ((ClassType)currentType).getName()));
                    }
                    return new PropertyResolution(e);
                }
            } else if (currentType instanceof TupleType) {
                TupleType tupleType = (TupleType)currentType;
                for (ClassTypeElement e : tupleType.getElements()) {
                    if (!e.getName().equals(identifier)) continue;
                    return new PropertyResolution((TupleTypeElement)e);
                }
            } else {
                if (currentType instanceof IntervalType) {
                    IntervalType intervalType = (IntervalType)currentType;
                    switch (identifier) {
                        case "low": 
                        case "high": {
                            return new PropertyResolution(intervalType.getPointType(), identifier);
                        }
                        case "lowClosed": 
                        case "highClosed": {
                            return new PropertyResolution(this.resolveTypeName("System", "Boolean"), identifier);
                        }
                    }
                    throw new IllegalArgumentException(String.format("Invalid interval property name %s.", identifier));
                }
                if (currentType instanceof ChoiceType) {
                    ChoiceType choiceType = (ChoiceType)currentType;
                    HashSet<DataType> resultTypes = new HashSet<DataType>();
                    String target = null;
                    Iterator<Object> iterator = choiceType.getTypes().iterator();
                    while (iterator.hasNext()) {
                        DataType choice = (DataType)iterator.next();
                        PropertyResolution resolution = this.resolveProperty(choice, identifier, false);
                        if (resolution == null) continue;
                        resultTypes.add(resolution.getType());
                        if (target == null) {
                            target = resolution.getTarget();
                            continue;
                        }
                        if (target.equals(resolution.getTarget())) continue;
                        throw new IllegalArgumentException("Cannot determine target for choices with targets specified.");
                    }
                    if (resultTypes.size() > 1) {
                        return new PropertyResolution((DataType)new ChoiceType(resultTypes), target);
                    }
                    if (resultTypes.size() == 1 && (iterator = resultTypes.iterator()).hasNext()) {
                        DataType resultType = (DataType)iterator.next();
                        return new PropertyResolution(resultType, target);
                    }
                } else if (currentType instanceof ListType && this.listTraversal) {
                    ListType listType = (ListType)currentType;
                    PropertyResolution resolution = this.resolveProperty(listType.getElementType(), identifier);
                    return new PropertyResolution((DataType)new ListType(resolution.getType()), resolution.getTarget());
                }
            }
            if (currentType.getBaseType() == null) break;
        }
        if (mustResolve) {
            throw new IllegalArgumentException(String.format("Member %s not found for type %s.", identifier, sourceType != null ? sourceType.toLabel() : null));
        }
        return null;
    }

    public Expression resolveIdentifier(String identifier, boolean mustResolve) {
        IdentifierRef resultElement = this.resolveQueryResultElement(identifier);
        if (resultElement != null) {
            return resultElement;
        }
        Expression thisElement = this.resolveQueryThisElement(identifier);
        if (thisElement != null) {
            return thisElement;
        }
        if (identifier.equals("$index")) {
            Iteration result = this.of.createIteration();
            result.setResultType(this.resolveTypeName("System", "Integer"));
            return result;
        }
        if (identifier.equals("$total")) {
            Total result = this.of.createTotal();
            result.setResultType(this.resolveTypeName("System", "Decimal"));
            return result;
        }
        AliasedQuerySource alias = this.resolveAlias(identifier);
        if (alias != null) {
            AliasRef result = this.of.createAliasRef().withName(identifier);
            if (alias.getResultType() instanceof ListType) {
                result.setResultType(((ListType)alias.getResultType()).getElementType());
            } else {
                result.setResultType(alias.getResultType());
            }
            return result;
        }
        LetClause let = this.resolveQueryLet(identifier);
        if (let != null) {
            QueryLetRef result = this.of.createQueryLetRef().withName(identifier);
            result.setResultType(let.getResultType());
            return result;
        }
        OperandRef operandRef = this.resolveOperandRef(identifier);
        if (operandRef != null) {
            return operandRef;
        }
        Element element = this.resolve(identifier);
        if (element instanceof ExpressionDef) {
            this.checkLiteralContext();
            ExpressionRef expressionRef = this.of.createExpressionRef().withName(((ExpressionDef)element).getName());
            expressionRef.setResultType(this.getExpressionDefResultType((ExpressionDef)element));
            if (expressionRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to expression %s because its definition contains errors.", expressionRef.getName()));
            }
            return expressionRef;
        }
        if (element instanceof ParameterDef) {
            this.checkLiteralContext();
            ParameterRef parameterRef = this.of.createParameterRef().withName(((ParameterDef)element).getName());
            parameterRef.setResultType(element.getResultType());
            if (parameterRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to parameter %s because its definition contains errors.", parameterRef.getName()));
            }
            return parameterRef;
        }
        if (element instanceof ValueSetDef) {
            this.checkLiteralContext();
            ValueSetRef valuesetRef = this.of.createValueSetRef().withName(((ValueSetDef)element).getName());
            valuesetRef.setResultType(element.getResultType());
            if (valuesetRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to valueset %s because its definition contains errors.", valuesetRef.getName()));
            }
            return valuesetRef;
        }
        if (element instanceof CodeSystemDef) {
            this.checkLiteralContext();
            CodeSystemRef codesystemRef = this.of.createCodeSystemRef().withName(((CodeSystemDef)element).getName());
            codesystemRef.setResultType(element.getResultType());
            if (codesystemRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to codesystem %s because its definition contains errors.", codesystemRef.getName()));
            }
            return codesystemRef;
        }
        if (element instanceof CodeDef) {
            this.checkLiteralContext();
            CodeRef codeRef = this.of.createCodeRef().withName(((CodeDef)element).getName());
            codeRef.setResultType(element.getResultType());
            if (codeRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to code %s because its definition contains errors.", codeRef.getName()));
            }
            return codeRef;
        }
        if (element instanceof ConceptDef) {
            this.checkLiteralContext();
            ConceptRef conceptRef = this.of.createConceptRef().withName(((ConceptDef)element).getName());
            conceptRef.setResultType(element.getResultType());
            if (conceptRef.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not validate reference to concept %s because its definition contains error.", conceptRef.getName()));
            }
            return conceptRef;
        }
        if (element instanceof IncludeDef) {
            this.checkLiteralContext();
            LibraryRef libraryRef = new LibraryRef();
            libraryRef.setLibraryName(((IncludeDef)element).getLocalIdentifier());
            return libraryRef;
        }
        if (mustResolve) {
            throw new IllegalArgumentException(String.format("Could not resolve identifier %s in the current library.", identifier));
        }
        return null;
    }

    public Expression resolveAccessor(Expression left, String memberIdentifier) {
        if (left instanceof LibraryRef) {
            String libraryName = ((LibraryRef)left).getLibraryName();
            TranslatedLibrary referencedLibrary = this.resolveLibrary(libraryName);
            Element element = referencedLibrary.resolve(memberIdentifier);
            if (element instanceof ExpressionDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ExpressionDef)element).getAccessLevel());
                ExpressionRef result = this.of.createExpressionRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(this.getExpressionDefResultType((ExpressionDef)element));
                return result;
            }
            if (element instanceof ParameterDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ParameterDef)element).getAccessLevel());
                ParameterRef result = this.of.createParameterRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof ValueSetDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ValueSetDef)element).getAccessLevel());
                ValueSetRef result = this.of.createValueSetRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof CodeSystemDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((CodeSystemDef)element).getAccessLevel());
                CodeSystemRef result = this.of.createCodeSystemRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof CodeDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((CodeDef)element).getAccessLevel());
                CodeRef result = this.of.createCodeRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof ConceptDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ConceptDef)element).getAccessLevel());
                ConceptRef result = this.of.createConceptRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            throw new IllegalArgumentException(String.format("Could not resolve identifier %s in library %s.", memberIdentifier, referencedLibrary.getIdentifier().getId()));
        }
        if (left instanceof AliasRef) {
            PropertyResolution resolution = this.resolveProperty(left.getResultType(), memberIdentifier);
            Property result = this.of.createProperty().withScope(((AliasRef)left).getName()).withPath(resolution.getTarget());
            result.setResultType(resolution.getType());
            return result;
        }
        if (left.getResultType() instanceof ListType && this.listTraversal) {
            ListType listType = (ListType)left.getResultType();
            PropertyResolution resolution = this.resolveProperty(listType.getElementType(), memberIdentifier);
            Property accessor = this.of.createProperty().withSource((Expression)this.of.createAliasRef().withName("$this")).withPath(resolution.getTarget());
            accessor.setResultType(resolution.getType());
            IsNull isNull = this.of.createIsNull().withOperand((Expression)accessor);
            isNull.setResultType(this.resolveTypeName("System", "Boolean"));
            Not not = this.of.createNot().withOperand((Expression)isNull);
            not.setResultType(this.resolveTypeName("System", "Boolean"));
            accessor = this.of.createProperty().withSource((Expression)this.of.createAliasRef().withName("$this")).withPath(memberIdentifier);
            accessor.setResultType(resolution.getType());
            AliasedQuerySource source = this.of.createAliasedQuerySource().withExpression(left).withAlias("$this");
            source.setResultType(left.getResultType());
            Query query = this.of.createQuery().withSource(new AliasedQuerySource[]{source}).withWhere((Expression)not).withReturn(this.of.createReturnClause().withExpression((Expression)accessor));
            query.setResultType((DataType)new ListType(accessor.getResultType()));
            if (accessor.getResultType() instanceof ListType) {
                Flatten result = this.of.createFlatten().withOperand((Expression)query);
                result.setResultType(accessor.getResultType());
                return result;
            }
            return query;
        }
        PropertyResolution resolution = this.resolveProperty(left.getResultType(), memberIdentifier);
        Property result = this.of.createProperty().withSource(left).withPath(resolution.getTarget());
        result.setResultType(resolution.getType());
        return result;
    }

    private IdentifierRef resolveQueryResultElement(String identifier) {
        QueryContext query;
        if (this.inQueryContext() && (query = this.peekQueryContext()).inSortClause() && !query.isSingular()) {
            if (identifier.equals("$this")) {
                IdentifierRef result = new IdentifierRef().withName(identifier);
                result.setResultType(query.getResultElementType());
                return result;
            }
            PropertyResolution resolution = this.resolveProperty(query.getResultElementType(), identifier, false);
            if (resolution != null) {
                IdentifierRef result = new IdentifierRef().withName(resolution.getTarget());
                result.setResultType(resolution.getType());
                return result;
            }
        }
        return null;
    }

    private AliasedQuerySource resolveAlias(String identifier) {
        if (this.inQueryContext()) {
            for (int i = this.getScope().getQueries().size() - 1; i >= 0; --i) {
                AliasedQuerySource source = ((QueryContext)this.getScope().getQueries().get(i)).resolveAlias(identifier);
                if (source == null) continue;
                return source;
            }
        }
        return null;
    }

    private Expression resolveQueryThisElement(String identifier) {
        AliasedQuerySource source;
        QueryContext query;
        if (this.inQueryContext() && (query = this.peekQueryContext()).isImplicit() && (source = this.resolveAlias("$this")) != null) {
            AliasRef aliasRef = this.of.createAliasRef().withName("$this");
            if (source.getResultType() instanceof ListType) {
                aliasRef.setResultType(((ListType)source.getResultType()).getElementType());
            } else {
                aliasRef.setResultType(source.getResultType());
            }
            PropertyResolution result = this.resolveProperty(aliasRef.getResultType(), identifier, false);
            if (result != null) {
                return this.resolveAccessor((Expression)aliasRef, identifier);
            }
        }
        return null;
    }

    private LetClause resolveQueryLet(String identifier) {
        if (this.inQueryContext()) {
            for (int i = this.getScope().getQueries().size() - 1; i >= 0; --i) {
                LetClause let = ((QueryContext)this.getScope().getQueries().get(i)).resolveLet(identifier);
                if (let == null) continue;
                return let;
            }
        }
        return null;
    }

    private OperandRef resolveOperandRef(String identifier) {
        if (!this.functionDefs.empty()) {
            for (OperandDef operand : this.functionDefs.peek().getOperand()) {
                if (!operand.getName().equals(identifier)) continue;
                return (OperandRef)this.of.createOperandRef().withName(identifier).withResultType(operand.getResultType());
            }
        }
        return null;
    }

    private DataType getExpressionDefResultType(ExpressionDef expressionDef) {
        if (this.currentExpressionContext().equals(expressionDef.getContext())) {
            return expressionDef.getResultType();
        }
        if (this.inSpecificContext()) {
            return expressionDef.getResultType();
        }
        if (this.inUnfilteredContext()) {
            DataType resultType;
            if (this.inQueryContext() && this.getScope().getQueries().peek().inSourceClause()) {
                this.getScope().getQueries().peek().referenceSpecificContext();
            }
            if (!((resultType = expressionDef.getResultType()) instanceof ListType)) {
                return new ListType(resultType);
            }
            return resultType;
        }
        throw new IllegalArgumentException(String.format("Invalid context reference from %s context to %s context.", this.currentExpressionContext(), expressionDef.getContext()));
    }

    public Exception determineRootCause() {
        ExpressionDefinitionContext currentContext;
        if (!this.expressionDefinitions.isEmpty() && (currentContext = (ExpressionDefinitionContext)this.expressionDefinitions.peek()) != null) {
            return currentContext.getRootCause();
        }
        return null;
    }

    public void setRootCause(Exception rootCause) {
        ExpressionDefinitionContext currentContext;
        if (!this.expressionDefinitions.isEmpty() && (currentContext = (ExpressionDefinitionContext)this.expressionDefinitions.peek()) != null) {
            currentContext.setRootCause(rootCause);
        }
    }

    public void pushExpressionDefinition(String identifier) {
        if (this.expressionDefinitions.contains(identifier)) {
            throw new IllegalArgumentException(String.format("Cannot resolve reference to expression or function %s because it results in a circular reference.", identifier));
        }
        this.expressionDefinitions.push(new ExpressionDefinitionContext(identifier));
    }

    public void popExpressionDefinition() {
        this.expressionDefinitions.pop();
    }

    private boolean hasScope() {
        return !this.expressionDefinitions.empty();
    }

    private Scope getScope() {
        return ((ExpressionDefinitionContext)this.expressionDefinitions.peek()).getScope();
    }

    public void pushExpressionContext(String context) {
        this.expressionContext.push(context);
    }

    public void popExpressionContext() {
        if (this.expressionContext.empty()) {
            throw new IllegalStateException("Expression context stack is empty.");
        }
        this.expressionContext.pop();
    }

    public String currentExpressionContext() {
        if (this.expressionContext.empty()) {
            throw new IllegalStateException("Expression context stack is empty.");
        }
        return this.expressionContext.peek();
    }

    public boolean inSpecificContext() {
        return !this.currentExpressionContext().equals("Unfiltered");
    }

    public boolean inUnfilteredContext() {
        return this.currentExpressionContext().equals("Unfiltered");
    }

    public boolean inQueryContext() {
        return this.hasScope() && this.getScope().getQueries().size() > 0;
    }

    public void pushQueryContext(QueryContext context) {
        this.getScope().getQueries().push(context);
    }

    public QueryContext popQueryContext() {
        return this.getScope().getQueries().pop();
    }

    public QueryContext peekQueryContext() {
        return this.getScope().getQueries().peek();
    }

    public void pushExpressionTarget(Expression target) {
        this.getScope().getTargets().push(target);
    }

    public Expression popExpressionTarget() {
        return this.getScope().getTargets().pop();
    }

    public boolean hasExpressionTarget() {
        return this.hasScope() && !this.getScope().getTargets().isEmpty();
    }

    public void beginFunctionDef(FunctionDef functionDef) {
        this.functionDefs.push(functionDef);
    }

    public void endFunctionDef() {
        this.functionDefs.pop();
    }

    public void pushLiteralContext() {
        ++this.literalContext;
    }

    public void popLiteralContext() {
        if (!this.inLiteralContext()) {
            throw new IllegalStateException("Not in literal context");
        }
        --this.literalContext;
    }

    public boolean inLiteralContext() {
        return this.literalContext > 0;
    }

    public void checkLiteralContext() {
        if (this.inLiteralContext()) {
            throw new IllegalStateException("Expressions in this context must be able to be evaluated at compile-time.");
        }
    }

    private class ExpressionDefinitionContextStack
    extends Stack<ExpressionDefinitionContext> {
        private ExpressionDefinitionContextStack() {
        }

        public boolean contains(String identifier) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (!((ExpressionDefinitionContext)this.elementAt(i)).getIdentifier().equals(identifier)) continue;
                return true;
            }
            return false;
        }
    }

    private class ExpressionDefinitionContext {
        private String identifier;
        private Scope scope;
        private Exception rootCause;

        public ExpressionDefinitionContext(String identifier) {
            this.scope = new Scope();
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Scope getScope() {
            return this.scope;
        }

        public Exception getRootCause() {
            return this.rootCause;
        }

        public void setRootCause(Exception rootCause) {
            this.rootCause = rootCause;
        }
    }

    private class Scope {
        private final Stack<Expression> targets = new Stack();
        private final Stack<QueryContext> queries = new Stack();

        private Scope() {
        }

        public Stack<Expression> getTargets() {
            return this.targets;
        }

        public Stack<QueryContext> getQueries() {
            return this.queries;
        }
    }

    private class BinaryWrapper {
        public Expression left;
        public Expression right;

        public BinaryWrapper(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }
    }

    public static enum SignatureLevel {
        None,
        Differing,
        Overloads,
        All;

    }
}

