/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.cql2elm.LibrarySourceLoader;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.hl7.elm.r1.VersionedIdentifier;

public class PriorityLibrarySourceLoader
implements LibrarySourceLoader {
    private final List<LibrarySourceProvider> PROVIDERS = new ArrayList<LibrarySourceProvider>();

    @Override
    public void registerProvider(LibrarySourceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null.");
        }
        this.PROVIDERS.add(provider);
    }

    @Override
    public void clearProviders() {
        this.PROVIDERS.clear();
    }

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is null.");
        }
        if (libraryIdentifier.getId() == null || libraryIdentifier.getId().equals("")) {
            throw new IllegalArgumentException("libraryIdentifier Id is null.");
        }
        Object source = null;
        for (LibrarySourceProvider provider : this.PROVIDERS) {
            InputStream localSource = provider.getLibrarySource(libraryIdentifier);
            if (localSource == null) continue;
            return localSource;
        }
        throw new IllegalArgumentException(String.format("Could not load source for library %s, version %s.", libraryIdentifier.getId(), libraryIdentifier.getVersion()));
    }
}

