/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.preprocessor;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.cqframework.cql.cql2elm.preprocessor.CodeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.CodesystemDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ConceptDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ExpressionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.FunctionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.IncludeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.LibraryInfo;
import org.cqframework.cql.cql2elm.preprocessor.ParameterDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.UsingDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ValuesetDefinitionInfo;
import org.cqframework.cql.gen.cqlBaseVisitor;
import org.cqframework.cql.gen.cqlParser;

public class CqlPreprocessorVisitor
extends cqlBaseVisitor {
    private LibraryInfo libraryInfo = new LibraryInfo();
    private boolean implicitContextCreated = false;
    private String currentContext = "Unspecified";

    public LibraryInfo getLibraryInfo() {
        return this.libraryInfo;
    }

    public Object visitLibraryDefinition(@NotNull cqlParser.LibraryDefinitionContext ctx) {
        this.libraryInfo.setLibraryName(String.join((CharSequence)".", (Iterable)this.visit((ParseTree)ctx.qualifiedIdentifier())));
        if (ctx.versionSpecifier() != null) {
            this.libraryInfo.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        return super.visitLibraryDefinition(ctx);
    }

    public Object visitIncludeDefinition(@NotNull cqlParser.IncludeDefinitionContext ctx) {
        IncludeDefinitionInfo includeDefinition = new IncludeDefinitionInfo();
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        includeDefinition.setName(String.join((CharSequence)".", identifiers));
        if (ctx.versionSpecifier() != null) {
            includeDefinition.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        if (ctx.localIdentifier() != null) {
            includeDefinition.setLocalName((String)this.visit((ParseTree)ctx.localIdentifier()));
        } else if (identifiers.size() > 1) {
            includeDefinition.setLocalName((String)identifiers.get(identifiers.size() - 1));
        }
        this.libraryInfo.addIncludeDefinition(includeDefinition);
        return includeDefinition;
    }

    public Object visitUsingDefinition(@NotNull cqlParser.UsingDefinitionContext ctx) {
        UsingDefinitionInfo usingDefinition = new UsingDefinitionInfo();
        usingDefinition.setName((String)this.visit((ParseTree)ctx.modelIdentifier()));
        if (ctx.versionSpecifier() != null) {
            usingDefinition.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        this.libraryInfo.addUsingDefinition(usingDefinition);
        return usingDefinition;
    }

    public Object visitCodesystemDefinition(@NotNull cqlParser.CodesystemDefinitionContext ctx) {
        CodesystemDefinitionInfo codesystemDefinition = new CodesystemDefinitionInfo();
        codesystemDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        codesystemDefinition.setDefinition(ctx);
        this.libraryInfo.addCodesystemDefinition(codesystemDefinition);
        return codesystemDefinition;
    }

    public Object visitValuesetDefinition(@NotNull cqlParser.ValuesetDefinitionContext ctx) {
        ValuesetDefinitionInfo valuesetDefinition = new ValuesetDefinitionInfo();
        valuesetDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        valuesetDefinition.setDefinition(ctx);
        this.libraryInfo.addValuesetDefinition(valuesetDefinition);
        return valuesetDefinition;
    }

    public Object visitCodeDefinition(@NotNull cqlParser.CodeDefinitionContext ctx) {
        CodeDefinitionInfo codeDefinition = new CodeDefinitionInfo();
        codeDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        codeDefinition.setDefinition(ctx);
        this.libraryInfo.addCodeDefinition(codeDefinition);
        return codeDefinition;
    }

    public Object visitConceptDefinition(@NotNull cqlParser.ConceptDefinitionContext ctx) {
        ConceptDefinitionInfo conceptDefinition = new ConceptDefinitionInfo();
        conceptDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        conceptDefinition.setDefinition(ctx);
        this.libraryInfo.addConceptDefinition(conceptDefinition);
        return conceptDefinition;
    }

    public Object visitParameterDefinition(@NotNull cqlParser.ParameterDefinitionContext ctx) {
        ParameterDefinitionInfo parameterDefinition = new ParameterDefinitionInfo();
        parameterDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        parameterDefinition.setDefinition(ctx);
        this.libraryInfo.addParameterDefinition(parameterDefinition);
        return parameterDefinition;
    }

    public Object visitContextDefinition(@NotNull cqlParser.ContextDefinitionContext ctx) {
        String modelIdentifier = ctx.modelIdentifier() != null ? (String)this.visit((ParseTree)ctx.modelIdentifier()) : null;
        String unqualifiedContext = (String)this.visit((ParseTree)ctx.identifier());
        this.currentContext = modelIdentifier != null && !modelIdentifier.equals("") ? modelIdentifier + "." + unqualifiedContext : unqualifiedContext;
        if (!this.implicitContextCreated && !unqualifiedContext.equals("Unspecified")) {
            ExpressionDefinitionInfo expressionDefinition = new ExpressionDefinitionInfo();
            expressionDefinition.setName(unqualifiedContext);
            expressionDefinition.setContext(this.currentContext);
            this.libraryInfo.addExpressionDefinition(expressionDefinition);
            this.implicitContextCreated = true;
        }
        return this.currentContext;
    }

    public Object visitExpressionDefinition(@NotNull cqlParser.ExpressionDefinitionContext ctx) {
        ExpressionDefinitionInfo expressionDefinition = new ExpressionDefinitionInfo();
        expressionDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        expressionDefinition.setContext(this.currentContext);
        expressionDefinition.setDefinition(ctx);
        this.libraryInfo.addExpressionDefinition(expressionDefinition);
        return expressionDefinition;
    }

    public Object visitFunctionDefinition(@NotNull cqlParser.FunctionDefinitionContext ctx) {
        FunctionDefinitionInfo functionDefinition = new FunctionDefinitionInfo();
        functionDefinition.setName((String)this.visit((ParseTree)ctx.identifierOrFunctionIdentifier()));
        functionDefinition.setContext(this.currentContext);
        functionDefinition.setDefinition(ctx);
        this.libraryInfo.addFunctionDefinition(functionDefinition);
        return functionDefinition;
    }

    public Object visitTerminal(@NotNull TerminalNode node) {
        String text = node.getText();
        int tokenType = node.getSymbol().getType();
        if (159 == tokenType || 154 == tokenType) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public Object visitQualifiedIdentifier(@NotNull cqlParser.QualifiedIdentifierContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierContext qualifierContext : ctx.qualifier()) {
            String qualifier = (String)this.visit((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = (String)this.visit((ParseTree)ctx.identifier());
        identifiers.add(identifier);
        return identifiers;
    }

    public Object visitQualifiedIdentifierExpression(@NotNull cqlParser.QualifiedIdentifierExpressionContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierExpressionContext qualifierContext : ctx.qualifierExpression()) {
            String qualifier = (String)this.visit((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = (String)this.visit((ParseTree)ctx.referentialIdentifier());
        identifiers.add(identifier);
        return identifiers;
    }
}

