/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.HashMap;
import java.util.Map;
import org.cqframework.cql.cql2elm.ModelInfoLoader;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.hl7.elm.r1.VersionedIdentifier;

public class ModelManager {
    private final Map<String, Model> models = new HashMap<String, Model>();

    private Model buildModel(VersionedIdentifier identifier) {
        Model model = null;
        try {
            ModelInfoProvider provider = ModelInfoLoader.getModelInfoProvider(identifier);
            model = identifier.getId().equals("System") ? new SystemModel(provider.load()) : new Model(provider.load(), this.resolveModel("System"));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s.", identifier.getId(), identifier.getVersion()));
        }
        return model;
    }

    public Model resolveModel(String modelName) {
        return this.resolveModel(modelName, null);
    }

    public Model resolveModel(String modelName, String version) {
        return this.resolveModel(new VersionedIdentifier().withId(modelName).withVersion(version));
    }

    public Model resolveModel(VersionedIdentifier modelIdentifier) {
        Model model = this.models.get(modelIdentifier.getId());
        if (model == null) {
            model = this.buildModel(modelIdentifier);
            this.models.put(modelIdentifier.getId(), model);
        }
        if (modelIdentifier.getVersion() != null && !modelIdentifier.getVersion().equals(model.getModelInfo().getVersion())) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s because version %s is already loaded.", modelIdentifier.getId(), modelIdentifier.getVersion(), model.getModelInfo().getVersion()));
        }
        return model;
    }
}

