/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.cqframework.cql.cql2elm.Cql2ElmVisitor;
import org.cqframework.cql.cql2elm.CqlSyntaxException;
import org.cqframework.cql.cql2elm.CqlTranslatorException;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.DefaultLibrarySourceProvider;
import org.cqframework.cql.cql2elm.DefaultModelInfoProvider;
import org.cqframework.cql.cql2elm.FhirLibrarySourceProvider;
import org.cqframework.cql.cql2elm.LibraryBuilder;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.ModelInfoLoader;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.NamespaceAware;
import org.cqframework.cql.cql2elm.NamespaceInfo;
import org.cqframework.cql.cql2elm.StringEscapeUtils;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.cqframework.cql.cql2elm.model.serialization.LibraryWrapper;
import org.cqframework.cql.cql2elm.preprocessor.CqlPreprocessorVisitor;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.cqframework.cql.gen.cqlLexer;
import org.cqframework.cql.gen.cqlParser;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumService;
import org.hl7.cql_annotations.r1.Annotation;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class CqlTranslator {
    private static JAXBContext jaxbContext;
    private static ObjectMapper jxsonMapper;
    private Library library = null;
    private TranslatedLibrary translatedLibrary = null;
    private Object visitResult = null;
    private List<Retrieve> retrieves = null;
    private List<CqlTranslatorException> exceptions = null;
    private List<CqlTranslatorException> errors = null;
    private List<CqlTranslatorException> warnings = null;
    private List<CqlTranslatorException> messages = null;
    private VersionedIdentifier sourceInfo = null;
    private NamespaceInfo namespaceInfo = null;
    private ModelManager modelManager = null;
    private LibraryManager libraryManager = null;
    private UcumService ucumService = null;

    public static CqlTranslator fromText(String cqlText, ModelManager modelManager, LibraryManager libraryManager, Options ... options) {
        return new CqlTranslator(null, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, null, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, String cqlText, ModelManager modelManager, LibraryManager libraryManager, Options ... options) {
        return new CqlTranslator(namespaceInfo, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, null, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(String cqlText, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) {
        return new CqlTranslator(null, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, String cqlText, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) {
        return new CqlTranslator(namespaceInfo, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(String cqlText, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) {
        return new CqlTranslator(null, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, String cqlText, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) {
        return new CqlTranslator(namespaceInfo, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, Options ... options) {
        return new CqlTranslator(null, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, Options ... options) {
        return new CqlTranslator(namespaceInfo, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) {
        return new CqlTranslator(null, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) {
        return new CqlTranslator(namespaceInfo, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromText(String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) {
        return new CqlTranslator(null, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) {
        return new CqlTranslator(namespaceInfo, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(null, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, null, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, null, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, null, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, null, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, Options ... options) throws IOException {
        return new CqlTranslator(null, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromFile(String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, null, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, null, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, null, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, null, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromFile(File cqlFile, ModelManager modelManager, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, null, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, File cqlFile, ModelManager modelManager, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, null, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(File cqlFile, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, File cqlFile, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, null, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(File cqlFile, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, null, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, File cqlFile, ModelManager modelManager, LibraryManager libraryManager, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, null, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromFile(String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, ucumService, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, ucumService, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, ucumService, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, ucumService, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, ucumService, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, String cqlFileName, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), modelManager, libraryManager, ucumService, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromFile(File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, CqlTranslatorException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, errorLevel, LibraryBuilder.SignatureLevel.None, options);
    }

    public static CqlTranslator fromFile(File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, errorLevel, signatureLevel, options);
    }

    public static CqlTranslator fromText(String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) {
        return new CqlTranslator(null, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, options);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) {
        return new CqlTranslator(namespaceInfo, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, options);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, String cqlText, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) {
        return new CqlTranslator(namespaceInfo, sourceInfo, (CharStream)CharStreams.fromString((String)cqlText), modelManager, libraryManager, ucumService, options);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) throws IOException {
        return new CqlTranslator(null, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, options);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) throws IOException {
        return new CqlTranslator(namespaceInfo, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, options);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, InputStream cqlStream, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) throws IOException {
        return new CqlTranslator(namespaceInfo, sourceInfo, CharStreams.fromStream((InputStream)cqlStream), modelManager, libraryManager, ucumService, options);
    }

    public static CqlTranslator fromFile(File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, options);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, File cqlFile, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) throws IOException {
        return new CqlTranslator(namespaceInfo, sourceInfo, CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), modelManager, libraryManager, ucumService, options);
    }

    private CqlTranslator(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, CharStream is, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) {
        this(namespaceInfo, sourceInfo, is, modelManager, libraryManager, ucumService, new CqlTranslatorOptions(errorLevel, signatureLevel, options));
    }

    private CqlTranslator(NamespaceInfo namespaceInfo, CharStream is, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) {
        this(namespaceInfo, is, modelManager, libraryManager, ucumService, new CqlTranslatorOptions(errorLevel, signatureLevel, options));
    }

    private CqlTranslator(NamespaceInfo namespaceInfo, CharStream is, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) {
        this(namespaceInfo, null, is, modelManager, libraryManager, ucumService, options);
    }

    private CqlTranslator(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, CharStream is, ModelManager modelManager, LibraryManager libraryManager, UcumService ucumService, CqlTranslatorOptions options) {
        this.sourceInfo = sourceInfo;
        this.namespaceInfo = namespaceInfo;
        this.modelManager = modelManager;
        this.libraryManager = libraryManager;
        this.ucumService = ucumService;
        if (this.sourceInfo == null) {
            this.sourceInfo = new VersionedIdentifier().withId("Anonymous").withSystem("text/cql");
        }
        if (this.namespaceInfo != null) {
            modelManager.getNamespaceManager().ensureNamespaceRegistered(this.namespaceInfo);
            libraryManager.getNamespaceManager().ensureNamespaceRegistered(this.namespaceInfo);
        }
        if (libraryManager.getNamespaceManager().hasNamespaces() && libraryManager.getLibrarySourceLoader() instanceof NamespaceAware) {
            ((NamespaceAware)((Object)libraryManager.getLibrarySourceLoader())).setNamespaceManager(libraryManager.getNamespaceManager());
        }
        if (libraryManager.getUcumService() == null) {
            libraryManager.setUcumService(this.ucumService);
        }
        this.translateToELM(is, options);
    }

    private static VersionedIdentifier getSourceInfo(String cqlFileName) {
        return CqlTranslator.getSourceInfo(new File(cqlFileName));
    }

    private static VersionedIdentifier getSourceInfo(File cqlFile) {
        String name = cqlFile.getName();
        int extensionIndex = name.lastIndexOf(46);
        if (extensionIndex > 0) {
            name = name.substring(0, extensionIndex);
        }
        String system = null;
        try {
            system = cqlFile.getCanonicalPath();
        }
        catch (IOException e) {
            system = cqlFile.getAbsolutePath();
        }
        return new VersionedIdentifier().withId(name).withSystem(system);
    }

    private String toXml(Library library) {
        try {
            return CqlTranslator.convertToXml(library);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not convert library to XML.", e);
        }
    }

    public String toXml() {
        return this.toXml(this.library);
    }

    private String toJson(Library library) {
        try {
            return CqlTranslator.convertToJson(library);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not convert library to JSON using JAXB serializer.", e);
        }
    }

    private String toJxson(Library library) {
        try {
            return CqlTranslator.convertToJxson(library);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not convert library to JSON using Jackson serializer.", e);
        }
    }

    public String toJxson() {
        return this.toJxson(this.library);
    }

    public String toJson() {
        return this.toJson(this.library);
    }

    public Library toELM() {
        return this.library;
    }

    public TranslatedLibrary getTranslatedLibrary() {
        return this.translatedLibrary;
    }

    public Object toObject() {
        return this.visitResult;
    }

    public List<Retrieve> toRetrieves() {
        return this.retrieves;
    }

    public Map<String, TranslatedLibrary> getTranslatedLibraries() {
        return this.libraryManager.getTranslatedLibraries();
    }

    public Map<String, Library> getLibraries() {
        HashMap<String, Library> result = new HashMap<String, Library>();
        for (String libraryName : this.libraryManager.getTranslatedLibraries().keySet()) {
            result.put(libraryName, this.libraryManager.getTranslatedLibraries().get(libraryName).getLibrary());
        }
        return result;
    }

    public Map<String, String> getLibrariesAsXML() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, TranslatedLibrary> entry : this.libraryManager.getTranslatedLibraries().entrySet()) {
            result.put(entry.getKey(), this.toXml(entry.getValue().getLibrary()));
        }
        return result;
    }

    public Map<String, String> getLibrariesAsJSON() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, TranslatedLibrary> entry : this.libraryManager.getTranslatedLibraries().entrySet()) {
            result.put(entry.getKey(), this.toJson(entry.getValue().getLibrary()));
        }
        return result;
    }

    public Map<String, String> getLibrariesAsJXSON() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, TranslatedLibrary> entry : this.libraryManager.getTranslatedLibraries().entrySet()) {
            result.put(entry.getKey(), this.toJxson(entry.getValue().getLibrary()));
        }
        return result;
    }

    public List<CqlTranslatorException> getExceptions() {
        return this.exceptions;
    }

    public List<CqlTranslatorException> getErrors() {
        return this.errors;
    }

    public List<CqlTranslatorException> getWarnings() {
        return this.warnings;
    }

    public List<CqlTranslatorException> getMessages() {
        return this.messages;
    }

    public static JAXBContext getJaxbContext() {
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Library.class, Annotation.class});
            }
            catch (JAXBException e) {
                e.printStackTrace();
                throw new RuntimeException("Error creating JAXBContext - " + e.getMessage());
            }
        }
        return jaxbContext;
    }

    public static ObjectMapper getJxsonMapper() {
        if (jxsonMapper == null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT);
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            JaxbAnnotationModule annotationModule = new JaxbAnnotationModule();
            mapper.registerModule((Module)annotationModule);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            jxsonMapper = mapper;
        }
        return jxsonMapper;
    }

    private void translateToELM(CharStream is, CqlTranslatorOptions options) {
        this.exceptions = new ArrayList<CqlTranslatorException>();
        this.errors = new ArrayList<CqlTranslatorException>();
        this.warnings = new ArrayList<CqlTranslatorException>();
        this.messages = new ArrayList<CqlTranslatorException>();
        LibraryBuilder builder = new LibraryBuilder(this.namespaceInfo, this.modelManager, this.libraryManager, this.ucumService);
        builder.setTranslatorOptions(options);
        Cql2ElmVisitor visitor = new Cql2ElmVisitor(builder);
        builder.setVisitor(visitor);
        visitor.setTranslatorOptions(options);
        CqlErrorListener errorListener = new CqlErrorListener(builder, visitor.isDetailedErrorsEnabled());
        cqlLexer lexer = new cqlLexer(is);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        cqlParser parser = new cqlParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        cqlParser.LibraryContext tree = parser.library();
        CqlPreprocessorVisitor preprocessor = new CqlPreprocessorVisitor();
        preprocessor.setTokenStream((TokenStream)tokens);
        preprocessor.visit((ParseTree)tree);
        visitor.setTokenStream((TokenStream)tokens);
        visitor.setLibraryInfo(preprocessor.getLibraryInfo());
        this.visitResult = visitor.visit((ParseTree)tree);
        this.library = builder.getLibrary();
        this.translatedLibrary = builder.getTranslatedLibrary();
        this.retrieves = visitor.getRetrieves();
        this.exceptions.addAll(builder.getExceptions());
        this.errors.addAll(builder.getErrors());
        this.warnings.addAll(builder.getWarnings());
        this.messages.addAll(builder.getMessages());
    }

    public static String convertToXml(Library library) throws JAXBException {
        Marshaller marshaller = CqlTranslator.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)new ObjectFactory().createLibrary(library), (Writer)writer);
        return writer.getBuffer().toString().replace("<xml version=\"1.0\"", "<xml version=\"1.1\"").replace("\f", "&#xc;");
    }

    public static String convertToJson(Library library) throws JAXBException {
        Marshaller marshaller = CqlTranslator.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)new ObjectFactory().createLibrary(library), (Writer)writer);
        return writer.getBuffer().toString();
    }

    public static String convertToJxson(Library library) throws JsonProcessingException {
        LibraryWrapper wrapper = new LibraryWrapper();
        wrapper.setLibrary(library);
        return CqlTranslator.getJxsonMapper().writeValueAsString((Object)wrapper);
    }

    public static void loadModelInfo(File modelInfoXML) {
        ModelInfo modelInfo = (ModelInfo)JAXB.unmarshal((File)modelInfoXML, ModelInfo.class);
        VersionedIdentifier modelId = new VersionedIdentifier().withId(modelInfo.getName()).withVersion(modelInfo.getVersion());
        ModelInfoProvider modelProvider = modelIdentifier -> modelInfo;
        ModelInfoLoader modelInfoLoader = new ModelInfoLoader();
        modelInfoLoader.registerModelInfoProvider(modelProvider);
    }

    private static void outputExceptions(Iterable<CqlTranslatorException> exceptions) {
        for (CqlTranslatorException error : exceptions) {
            TrackBack tb = error.getLocator();
            String lines = tb == null ? "[n/a]" : String.format("[%d:%d, %d:%d]", tb.getStartLine(), tb.getStartChar(), tb.getEndLine(), tb.getEndChar());
            System.err.printf("%s:%s %s%n", new Object[]{error.getSeverity(), lines, error.getMessage()});
        }
    }

    private static void writeELM(Path inPath, Path outPath, Format format, CqlTranslatorOptions options) throws IOException {
        System.err.println("================================================================================");
        System.err.printf("TRANSLATE %s%n", inPath);
        ModelManager modelManager = options.getOptions().contains((Object)Options.DisableDefaultModelInfoLoad) ? new ModelManager(false) : new ModelManager();
        LibraryManager libraryManager = new LibraryManager(modelManager);
        UcumEssenceService ucumService = null;
        if (options.getValidateUnits()) {
            try {
                ucumService = new UcumEssenceService(UcumEssenceService.class.getResourceAsStream("/ucum-essence.xml"));
            }
            catch (UcumException e) {
                System.err.println("Could not create UCUM validation service:");
                e.printStackTrace();
            }
        }
        modelManager.getModelInfoLoader().registerModelInfoProvider(new DefaultModelInfoProvider(inPath.getParent()), true);
        libraryManager.getLibrarySourceLoader().registerProvider(new DefaultLibrarySourceProvider(inPath.getParent()));
        libraryManager.getLibrarySourceLoader().registerProvider(new FhirLibrarySourceProvider());
        CqlTranslator translator = CqlTranslator.fromFile(inPath.toFile(), modelManager, libraryManager, (UcumService)ucumService, options);
        libraryManager.getLibrarySourceLoader().clearProviders();
        if (translator.getErrors().size() > 0) {
            System.err.println("Translation failed due to errors:");
            CqlTranslator.outputExceptions(translator.getExceptions());
        } else if (!options.getVerifyOnly()) {
            if (translator.getExceptions().size() == 0) {
                System.err.println("Translation completed successfully.");
            } else {
                System.err.println("Translation completed with messages:");
                CqlTranslator.outputExceptions(translator.getExceptions());
            }
            try (PrintWriter pw = new PrintWriter(outPath.toFile(), "UTF-8");){
                switch (format) {
                    case COFFEE: {
                        pw.print("module.exports = ");
                        pw.println(translator.toJson());
                        break;
                    }
                    case JXSON: {
                        pw.println(translator.toJxson());
                        break;
                    }
                    case JSON: {
                        pw.println(translator.toJson());
                        break;
                    }
                    default: {
                        pw.println(translator.toXml());
                    }
                }
                pw.println();
            }
            System.err.println(String.format("ELM output written to: %s", outPath.toString()));
        }
        System.err.println();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec input = parser.accepts("input").withRequiredArg().ofType(File.class).required().describedAs("The name of the input file or directory. If a directory is given, all files ending in .cql will be processed");
        ArgumentAcceptingOptionSpec model = parser.accepts("model").withRequiredArg().ofType(File.class).describedAs("The name of an input file containing the model info to use for translation. Model info can also be provided through an implementation of ModelInfoProvider");
        ArgumentAcceptingOptionSpec output = parser.accepts("output").withRequiredArg().ofType(File.class).describedAs("The name of the output file or directory. If no output is given, an output file name is constructed based on the input name and target format");
        ArgumentAcceptingOptionSpec format = parser.accepts("format").withRequiredArg().ofType(Format.class).defaultsTo((Object)Format.XML, (Object[])new Format[0]).describedAs("The target format for the output");
        OptionSpecBuilder disableDefaultModelInfoLoad = parser.accepts("disable-default-modelinfo-load");
        OptionSpecBuilder verify = parser.accepts("verify");
        OptionSpecBuilder optimization = parser.accepts("date-range-optimization");
        OptionSpecBuilder annotations = parser.accepts("annotations");
        OptionSpecBuilder locators = parser.accepts("locators");
        OptionSpecBuilder resultTypes = parser.accepts("result-types");
        OptionSpecBuilder detailedErrors = parser.accepts("detailed-errors");
        ArgumentAcceptingOptionSpec errorLevel = parser.accepts("error-level").withRequiredArg().ofType(CqlTranslatorException.ErrorSeverity.class).defaultsTo((Object)CqlTranslatorException.ErrorSeverity.Info, (Object[])new CqlTranslatorException.ErrorSeverity[0]).describedAs("Indicates the minimum severity message that will be reported. If no error-level is specified, all messages will be output");
        OptionSpecBuilder disableListTraversal = parser.accepts("disable-list-traversal");
        OptionSpecBuilder disableListDemotion = parser.accepts("disable-list-demotion");
        OptionSpecBuilder disableListPromotion = parser.accepts("disable-list-promotion");
        OptionSpecBuilder enableIntervalDemotion = parser.accepts("enable-interval-demotion");
        OptionSpecBuilder enableIntervalPromotion = parser.accepts("enable-interval-promotion");
        OptionSpecBuilder disableMethodInvocation = parser.accepts("disable-method-invocation");
        OptionSpecBuilder requireFromKeyword = parser.accepts("require-from-keyword");
        OptionSpecBuilder strict = parser.accepts("strict");
        OptionSpecBuilder debug = parser.accepts("debug");
        OptionSpecBuilder validateUnits = parser.accepts("validate-units");
        ArgumentAcceptingOptionSpec signatures = parser.accepts("signatures").withRequiredArg().ofType(LibraryBuilder.SignatureLevel.class).defaultsTo((Object)LibraryBuilder.SignatureLevel.None, (Object[])new LibraryBuilder.SignatureLevel[0]).describedAs("Indicates whether signatures should be included for invocations in the output ELM. Differing will include invocation signatures that differ from the declared signature. Overloads will include declaration signatures when the operator or function has more than one overload with the same number of arguments as the invocation");
        ArgumentAcceptingOptionSpec compatibilityLevel = parser.accepts("compatibility-level").withRequiredArg().ofType(String.class).describedAs("Compatibility level for the translator, valid values are 1.3, 1.4, and 1.5");
        OptionSet options = parser.parse(args);
        final Path source = ((File)input.value(options)).toPath();
        final Path destination = output.value(options) != null ? ((File)output.value(options)).toPath() : (source.toFile().isDirectory() ? source : source.getParent());
        Format outputFormat = (Format)((Object)format.value(options));
        LibraryBuilder.SignatureLevel signatureLevel = (LibraryBuilder.SignatureLevel)((Object)signatures.value(options));
        final HashMap<Path, Path> inOutMap = new HashMap<Path, Path>();
        if (source.toFile().isDirectory()) {
            if (destination.toFile().exists() && !destination.toFile().isDirectory()) {
                throw new IllegalArgumentException("Output must be a valid folder if input is a folder!");
            }
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().endsWith(".cql") || file.toFile().getName().endsWith(".CQL")) {
                        Path destinationFolder = destination.resolve(source.relativize(file.getParent()));
                        if (!destinationFolder.toFile().exists() && !destinationFolder.toFile().mkdirs()) {
                            System.err.printf("Problem creating %s%n", destinationFolder);
                        }
                        inOutMap.put(file, destinationFolder);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            inOutMap.put(source, destination);
        }
        for (Map.Entry inOut : inOutMap.entrySet()) {
            Path in = (Path)inOut.getKey();
            Path out = (Path)inOut.getValue();
            if (out.toFile().isDirectory()) {
                String name = in.toFile().getName();
                if (name.lastIndexOf(46) != -1) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                switch (outputFormat) {
                    case JXSON: 
                    case JSON: {
                        name = name + ".json";
                        break;
                    }
                    case COFFEE: {
                        name = name + ".coffee";
                        break;
                    }
                    default: {
                        name = name + ".xml";
                    }
                }
                out = out.resolve(name);
            }
            if (out.equals(in)) {
                throw new IllegalArgumentException("input and output file must be different!");
            }
            if (options.has((OptionSpec)model)) {
                File modelFile = (File)options.valueOf((OptionSpec)model);
                if (!modelFile.exists() || modelFile.isDirectory()) {
                    throw new IllegalArgumentException("model must be a valid file!");
                }
                CqlTranslator.loadModelInfo(modelFile);
            }
            CqlTranslator.writeELM(in, out, outputFormat, new CqlTranslatorOptions(outputFormat, options.has((OptionSpec)optimization), options.has((OptionSpec)debug) || options.has((OptionSpec)annotations), options.has((OptionSpec)debug) || options.has((OptionSpec)locators), options.has((OptionSpec)debug) || options.has((OptionSpec)resultTypes), options.has((OptionSpec)verify), options.has((OptionSpec)detailedErrors), options.has((OptionSpec)errorLevel) ? (CqlTranslatorException.ErrorSeverity)((Object)options.valueOf((OptionSpec)errorLevel)) : CqlTranslatorException.ErrorSeverity.Info, options.has((OptionSpec)strict) || options.has((OptionSpec)disableListTraversal), options.has((OptionSpec)strict) || options.has((OptionSpec)disableListDemotion), options.has((OptionSpec)strict) || options.has((OptionSpec)disableListPromotion), options.has((OptionSpec)enableIntervalDemotion), options.has((OptionSpec)enableIntervalPromotion), options.has((OptionSpec)strict) || options.has((OptionSpec)disableMethodInvocation), options.has((OptionSpec)requireFromKeyword), options.has((OptionSpec)validateUnits), options.has((OptionSpec)disableDefaultModelInfoLoad), signatureLevel, options.has((OptionSpec)compatibilityLevel) ? (String)options.valueOf((OptionSpec)compatibilityLevel) : null));
        }
    }

    public static enum Options {
        EnableDateRangeOptimization,
        EnableAnnotations,
        EnableLocators,
        EnableResultTypes,
        EnableDetailedErrors,
        DisableListTraversal,
        DisableListDemotion,
        DisableListPromotion,
        EnableIntervalDemotion,
        EnableIntervalPromotion,
        DisableMethodInvocation,
        RequireFromKeyword,
        DisableDefaultModelInfoLoad;

    }

    private class CqlErrorListener
    extends BaseErrorListener {
        private LibraryBuilder builder;
        private boolean detailedErrors;

        public CqlErrorListener(LibraryBuilder builder, boolean detailedErrors) {
            this.builder = builder;
            this.detailedErrors = detailedErrors;
        }

        private VersionedIdentifier extractLibraryIdentifier(cqlParser parser) {
            cqlParser.LibraryDefinitionContext ldc;
            ParserRuleContext context = parser.getContext();
            while (context != null && !(context instanceof cqlParser.LibraryContext)) {
                context = context.parent;
            }
            if (context instanceof cqlParser.LibraryContext && (ldc = ((cqlParser.LibraryContext)context).libraryDefinition()) != null && ldc.qualifiedIdentifier() != null && ldc.qualifiedIdentifier().identifier() != null) {
                return new VersionedIdentifier().withId(StringEscapeUtils.unescapeCql(ldc.qualifiedIdentifier().identifier().getText()));
            }
            return null;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            VersionedIdentifier libraryIdentifier = this.builder.getLibraryIdentifier();
            if (libraryIdentifier == null) {
                if (recognizer instanceof cqlParser) {
                    libraryIdentifier = this.extractLibraryIdentifier((cqlParser)recognizer);
                }
                if (libraryIdentifier == null) {
                    libraryIdentifier = CqlTranslator.this.sourceInfo;
                }
            }
            TrackBack trackback = new TrackBack(libraryIdentifier, line, charPositionInLine, line, charPositionInLine);
            if (this.detailedErrors) {
                this.builder.recordParsingException(new CqlSyntaxException(msg, trackback, (Throwable)e));
                this.builder.recordParsingException(new CqlTranslatorException(msg, trackback, (Throwable)e));
            } else if (offendingSymbol instanceof CommonToken) {
                CommonToken token = (CommonToken)offendingSymbol;
                this.builder.recordParsingException(new CqlSyntaxException(String.format("Syntax error at %s", token.getText()), trackback, (Throwable)e));
            } else {
                this.builder.recordParsingException(new CqlSyntaxException("Syntax error", trackback, (Throwable)e));
            }
        }
    }

    public static enum Format {
        XML,
        JSON,
        JXSON,
        COFFEE;

    }
}

