/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.InputStream;
import javax.xml.bind.JAXB;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.NamespaceAware;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class FhirModelInfoProvider
implements ModelInfoProvider,
NamespaceAware {
    private NamespaceManager namespaceManager;

    @Override
    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    private boolean isFHIRModelIdentifier(VersionedIdentifier modelIdentifier) {
        if (this.namespaceManager != null && this.namespaceManager.hasNamespaces()) {
            return modelIdentifier.getId().equals("FHIR") && (modelIdentifier.getSystem() == null || modelIdentifier.getSystem().equals("http://hl7.org/fhir"));
        }
        return modelIdentifier.getId().equals("FHIR");
    }

    @Override
    public ModelInfo load(VersionedIdentifier modelIdentifier) {
        if (this.isFHIRModelIdentifier(modelIdentifier)) {
            String localVersion;
            switch (localVersion = modelIdentifier.getVersion() == null ? "" : modelIdentifier.getVersion()) {
                case "1.0.2": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-1.0.2.xml"), ModelInfo.class);
                }
                case "1.4": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-1.4.xml"), ModelInfo.class);
                }
                case "1.6": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-1.6.xml"), ModelInfo.class);
                }
                case "1.8": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-1.8.xml"), ModelInfo.class);
                }
                case "3.0.0": 
                case "": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-3.0.0.xml"), ModelInfo.class);
                }
                case "3.0.1": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-3.0.1.xml"), ModelInfo.class);
                }
                case "3.2.0": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-3.2.0.xml"), ModelInfo.class);
                }
                case "4.0.0": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-4.0.0.xml"), ModelInfo.class);
                }
                case "4.0.1": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-4.0.1.xml"), ModelInfo.class);
                }
            }
        }
        return null;
    }
}

