/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cqframework.cql.cql2elm.LibraryContentType;
import org.cqframework.cql.cql2elm.LibrarySourceLoaderExt;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.LibrarySourceProviderExt;
import org.cqframework.cql.cql2elm.NamespaceAware;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.hl7.elm.r1.VersionedIdentifier;

public class PriorityLibrarySourceLoader
implements LibrarySourceLoaderExt,
NamespaceAware {
    private final List<LibrarySourceProvider> PROVIDERS = new ArrayList<LibrarySourceProvider>();
    private Set<LibraryContentType> supportedTypes = new HashSet<LibraryContentType>();
    private NamespaceManager namespaceManager;

    @Override
    public void registerProvider(LibrarySourceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null.");
        }
        if (this.supportedTypes == null) {
            this.supportedTypes = new HashSet<LibraryContentType>();
        }
        if (provider instanceof LibrarySourceProviderExt) {
            LibrarySourceProviderExt providerExt = (LibrarySourceProviderExt)provider;
            this.supportedTypes.add(providerExt.getLibrarySourceType());
        }
        if (provider instanceof NamespaceAware) {
            ((NamespaceAware)((Object)provider)).setNamespaceManager(this.namespaceManager);
        }
        this.PROVIDERS.add(provider);
    }

    @Override
    public void clearProviders() {
        this.PROVIDERS.clear();
    }

    @Override
    public Set<LibraryContentType> getSupportedContentTypes() {
        return this.supportedTypes;
    }

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier, LibraryContentType type) {
        this.validateInput(libraryIdentifier, type);
        InputStream source = null;
        for (LibrarySourceProvider provider : this.PROVIDERS) {
            if (provider instanceof LibrarySourceProviderExt) {
                LibrarySourceProviderExt providerExt = (LibrarySourceProviderExt)provider;
                if (providerExt.isLibrarySourceAvailable(libraryIdentifier, type)) {
                    source = providerExt.getLibrarySource(libraryIdentifier, type);
                }
            } else {
                source = provider.getLibrarySource(libraryIdentifier);
            }
            if (source == null) continue;
            return source;
        }
        throw new IllegalArgumentException(String.format("Could not load source for library %s, version %s.", libraryIdentifier.getId(), libraryIdentifier.getVersion()));
    }

    @Override
    public boolean isLibrarySourceAvailable(VersionedIdentifier libraryIdentifier, LibraryContentType type) {
        this.validateInput(libraryIdentifier, type);
        for (LibrarySourceProvider provider : this.PROVIDERS) {
            InputStream source;
            LibrarySourceProviderExt providerExt;
            if (!(provider instanceof LibrarySourceProviderExt ? (providerExt = (LibrarySourceProviderExt)provider).isLibrarySourceAvailable(libraryIdentifier, type) : (source = provider.getLibrarySource(libraryIdentifier)) != null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        return this.getLibrarySource(libraryIdentifier, LibraryContentType.CQL);
    }

    @Override
    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
        for (LibrarySourceProvider provider : this.PROVIDERS) {
            if (!(provider instanceof NamespaceAware)) continue;
            ((NamespaceAware)((Object)provider)).setNamespaceManager(namespaceManager);
        }
    }

    private void validateInput(VersionedIdentifier libraryIdentifier, LibraryContentType type) {
        if (type == null) {
            throw new IllegalArgumentException("libraryContentType is null.");
        }
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is null.");
        }
        if (libraryIdentifier.getId() == null || libraryIdentifier.getId().equals("")) {
            throw new IllegalArgumentException("libraryIdentifier Id is null.");
        }
    }
}

