/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.InputStream;
import javax.xml.bind.JAXB;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.NamespaceAware;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class QdmModelInfoProvider
implements ModelInfoProvider,
NamespaceAware {
    private NamespaceManager namespaceManager;

    @Override
    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    private boolean isQDMModelIdentifier(VersionedIdentifier modelIdentifier) {
        if (this.namespaceManager != null && this.namespaceManager.hasNamespaces()) {
            return modelIdentifier.getId().equals("QDM") && (modelIdentifier.getSystem() == null || modelIdentifier.getSystem().equals("urn:healthit-gov"));
        }
        return modelIdentifier.getId().equals("QDM");
    }

    @Override
    public ModelInfo load(VersionedIdentifier modelIdentifier) {
        if (this.isQDMModelIdentifier(modelIdentifier)) {
            String localVersion;
            switch (localVersion = modelIdentifier.getVersion() == null ? "" : modelIdentifier.getVersion()) {
                case "4.1.2": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo.xml"), ModelInfo.class);
                }
                case "4.2": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-4.2.xml"), ModelInfo.class);
                }
                case "4.3": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-4.3.xml"), ModelInfo.class);
                }
                case "5.0": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-5.0.xml"), ModelInfo.class);
                }
                case "5.0.1": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-5.0.1.xml"), ModelInfo.class);
                }
                case "5.0.2": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-5.0.2.xml"), ModelInfo.class);
                }
                case "5.3": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-5.3.xml"), ModelInfo.class);
                }
                case "5.4": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-5.4.xml"), ModelInfo.class);
                }
                case "5.5": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-5.5.xml"), ModelInfo.class);
                }
                case "5.6": 
                case "": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QdmModelInfoProvider.class.getResourceAsStream("/gov/healthit/qdm/qdm-modelinfo-5.6.xml"), ModelInfo.class);
                }
            }
        }
        return null;
    }
}

