/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.Operator;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.SimpleType;

public class Conversion {
    private boolean implicit;
    private Operator operator;
    private Conversion conversionField;
    private List<Conversion> alternativeConversions;
    private boolean isCastFlag;
    private boolean isListConversionFlag;
    private boolean isListPromotionFlag;
    private boolean isListDemotionFlag;
    private boolean isIntervalConversionFlag;
    private boolean isIntervalPromotionFlag;
    private boolean isIntervalDemotionFlag;
    private DataType fromType;
    private DataType toType;

    public Conversion(Operator operator, boolean isImplicit) {
        this.setIsImplicit(isImplicit);
        this.setOperator(operator);
    }

    public Conversion(DataType fromType, DataType toType) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.isCastFlag = true;
    }

    public Conversion(ChoiceType fromType, DataType toType, Conversion choiceConversion) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.conversionField = choiceConversion;
        this.isCastFlag = true;
    }

    public Conversion(DataType fromType, ChoiceType toType, Conversion choiceConversion) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.conversionField = choiceConversion;
        this.isCastFlag = true;
    }

    public Conversion(ListType fromType, ListType toType, Conversion elementConversion) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        if (elementConversion == null) {
            throw new IllegalArgumentException("elementConversion is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.conversionField = elementConversion;
        this.isListConversionFlag = true;
    }

    public Conversion(ListType fromType, DataType toType, Conversion elementConversion) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.conversionField = elementConversion;
        this.isListDemotionFlag = true;
    }

    public Conversion(DataType fromType, ListType toType, Conversion elementConversion) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.conversionField = elementConversion;
        this.isListPromotionFlag = true;
    }

    public Conversion(IntervalType fromType, DataType toType, Conversion elementConversion) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.conversionField = elementConversion;
        this.isIntervalDemotionFlag = true;
    }

    public Conversion(DataType fromType, IntervalType toType, Conversion elementConversion) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.conversionField = elementConversion;
        this.isIntervalPromotionFlag = true;
    }

    public Conversion(IntervalType fromType, IntervalType toType, Conversion pointConversion) {
        if (fromType == null) {
            throw new IllegalArgumentException("fromType is null");
        }
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        if (pointConversion == null) {
            throw new IllegalArgumentException("pointConversion is null");
        }
        this.setIsImplicit(true);
        this.fromType = fromType;
        this.toType = toType;
        this.conversionField = pointConversion;
        this.isIntervalConversionFlag = true;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setIsImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        this.fromType = null;
        for (DataType dataType : operator.getSignature().getOperandTypes()) {
            if (this.fromType != null) {
                throw new IllegalArgumentException("Conversion operator must be unary.");
            }
            this.fromType = dataType;
        }
        if (this.fromType == null) {
            throw new IllegalArgumentException("Conversion operator must be unary.");
        }
        this.toType = operator.getResultType();
        this.operator = operator;
    }

    public Conversion getConversion() {
        return this.conversionField;
    }

    public List<Conversion> getAlternativeConversions() {
        if (this.alternativeConversions == null) {
            this.alternativeConversions = new ArrayList<Conversion>();
        }
        return this.alternativeConversions;
    }

    public boolean hasAlternativeConversions() {
        return this.alternativeConversions != null;
    }

    public void addAlternativeConversion(Conversion alternativeConversion) {
        if (!(this.fromType instanceof ChoiceType)) {
            throw new IllegalArgumentException("Alternative conversions can only be used with choice types");
        }
        this.getAlternativeConversions().add(alternativeConversion);
    }

    public int getScore() {
        int nestedScore;
        int n = nestedScore = this.conversionField != null ? this.conversionField.getScore() : 0;
        if (this.isCast()) {
            return ConversionMap.ConversionScore.Cast.score() + nestedScore;
        }
        if (this.isIntervalDemotion()) {
            return ConversionMap.ConversionScore.IntervalDemotion.score() + nestedScore;
        }
        if (this.isListDemotion()) {
            return ConversionMap.ConversionScore.ListDemotion.score() + nestedScore;
        }
        if (this.isIntervalPromotion()) {
            return ConversionMap.ConversionScore.IntervalPromotion.score() + nestedScore;
        }
        if (this.isListPromotion()) {
            return ConversionMap.ConversionScore.ListPromotion.score() + nestedScore;
        }
        if (this.isListConversion()) {
            if (((ListType)this.getToType()).getElementType() instanceof SimpleType) {
                return ConversionMap.ConversionScore.SimpleConversion.score() + nestedScore;
            }
            return ConversionMap.ConversionScore.ComplexConversion.score() + nestedScore;
        }
        if (this.isIntervalConversion()) {
            if (((IntervalType)this.getToType()).getPointType() instanceof SimpleType) {
                return ConversionMap.ConversionScore.SimpleConversion.score() + nestedScore;
            }
            return ConversionMap.ConversionScore.ComplexConversion.score() + nestedScore;
        }
        if (this.getToType() instanceof ClassType) {
            return ConversionMap.ConversionScore.ComplexConversion.score() + nestedScore;
        }
        return ConversionMap.ConversionScore.SimpleConversion.score() + nestedScore;
    }

    public boolean isGeneric() {
        return this.operator instanceof GenericOperator;
    }

    public boolean isCast() {
        return this.isCastFlag;
    }

    public boolean isListConversion() {
        return this.isListConversionFlag;
    }

    public boolean isListPromotion() {
        return this.isListPromotionFlag;
    }

    public boolean isListDemotion() {
        return this.isListDemotionFlag;
    }

    public boolean isIntervalConversion() {
        return this.isIntervalConversionFlag;
    }

    public boolean isIntervalPromotion() {
        return this.isIntervalPromotionFlag;
    }

    public boolean isIntervalDemotion() {
        return this.isIntervalDemotionFlag;
    }

    public DataType getFromType() {
        return this.fromType;
    }

    public DataType getToType() {
        return this.toType;
    }
}

