/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.HashMap;
import java.util.Map;
import org.cqframework.cql.cql2elm.NamespaceInfo;

public class NamespaceManager {
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Map<String, String> reverseNamespaces = new HashMap<String, String>();

    public boolean hasNamespaces() {
        return this.namespaces.size() > 0;
    }

    public void ensureNamespaceRegistered(NamespaceInfo namespaceInfo) {
        if (namespaceInfo == null) {
            throw new IllegalArgumentException("namespaceInfo is required");
        }
        if (!this.namespaces.containsKey(namespaceInfo.getName())) {
            this.addNamespace(namespaceInfo.getName(), namespaceInfo.getUri());
        }
    }

    public void addNamespace(NamespaceInfo namespaceInfo) {
        if (namespaceInfo == null) {
            throw new IllegalArgumentException("namespaceInfo is required");
        }
        this.addNamespace(namespaceInfo.getName(), namespaceInfo.getUri());
    }

    public void addNamespace(String namespaceName, String namespaceUri) {
        if (namespaceName == null || namespaceName.isEmpty()) {
            throw new IllegalArgumentException("namespaceName is required");
        }
        if (namespaceUri == null || namespaceUri.isEmpty()) {
            throw new IllegalArgumentException("namespaceUri is required");
        }
        if (this.namespaces.containsKey(namespaceName)) {
            throw new IllegalArgumentException(String.format("A namespace named %s is already defined.", namespaceName));
        }
        if (this.reverseNamespaces.containsKey(namespaceUri)) {
            throw new IllegalArgumentException(String.format("A namespace name for uri %s is already defined.", namespaceUri));
        }
        this.namespaces.put(namespaceName, namespaceUri);
        this.reverseNamespaces.put(namespaceUri, namespaceName);
    }

    public String resolveNamespaceUri(String namespaceName) {
        if (this.namespaces.containsKey(namespaceName)) {
            return this.namespaces.get(namespaceName);
        }
        return null;
    }

    public NamespaceInfo getNamespaceInfoFromUri(String namespaceUri) {
        if (this.reverseNamespaces.containsKey(namespaceUri)) {
            return new NamespaceInfo(this.reverseNamespaces.get(namespaceUri), namespaceUri);
        }
        return null;
    }

    public static String getPath(String namespaceUri, String name) {
        if (namespaceUri != null) {
            return String.format("%s/%s", namespaceUri, name);
        }
        return name;
    }

    public static String getUriPart(String namespaceQualifiedName) {
        if (namespaceQualifiedName == null) {
            return null;
        }
        int i = namespaceQualifiedName.lastIndexOf(47);
        if (i > 0) {
            return namespaceQualifiedName.substring(0, i);
        }
        return null;
    }

    public static String getNamePart(String namespaceQualifiedName) {
        if (namespaceQualifiedName == null) {
            return null;
        }
        int i = namespaceQualifiedName.lastIndexOf("/");
        if (i > 0) {
            return namespaceQualifiedName.substring(i + 1);
        }
        return namespaceQualifiedName;
    }
}

