/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.preprocessor;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.cqframework.cql.cql2elm.preprocessor.BaseInfo;
import org.cqframework.cql.cql2elm.preprocessor.CodeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.CodesystemDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ConceptDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ContextDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ExpressionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.FunctionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.IncludeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.LibraryInfo;
import org.cqframework.cql.cql2elm.preprocessor.ParameterDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.UsingDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ValuesetDefinitionInfo;
import org.cqframework.cql.gen.cqlBaseVisitor;
import org.cqframework.cql.gen.cqlParser;

public class CqlPreprocessorVisitor
extends cqlBaseVisitor {
    private LibraryInfo libraryInfo = new LibraryInfo();
    private boolean implicitContextCreated = false;
    private String currentContext = "Unfiltered";
    private int lastSourceIndex = -1;
    private TokenStream tokenStream;

    public LibraryInfo getLibraryInfo() {
        return this.libraryInfo;
    }

    public TokenStream getTokenStream() {
        return this.tokenStream;
    }

    public void setTokenStream(TokenStream value) {
        this.tokenStream = value;
    }

    public Object visit(ParseTree tree) {
        return super.visit(tree);
    }

    private void processHeader(ParseTree ctx, BaseInfo info) {
        Interval header = null;
        Interval sourceInterval = ctx.getSourceInterval();
        int beforeDefinition = sourceInterval.a - 1;
        if (beforeDefinition >= this.lastSourceIndex) {
            header = new Interval(this.lastSourceIndex + 1, sourceInterval.a - 1);
            this.lastSourceIndex = sourceInterval.b;
            info.setHeaderInterval(header);
            info.setHeader(this.tokenStream.getText(header));
        }
    }

    public Object visitLibraryDefinition(cqlParser.LibraryDefinitionContext ctx) {
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        this.libraryInfo.setLibraryName((String)identifiers.remove(identifiers.size() - 1));
        if (identifiers.size() > 0) {
            this.libraryInfo.setNamespaceName(String.join((CharSequence)".", identifiers));
        }
        if (ctx.versionSpecifier() != null) {
            this.libraryInfo.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        this.libraryInfo.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, this.libraryInfo);
        return super.visitLibraryDefinition(ctx);
    }

    public Object visitIncludeDefinition(cqlParser.IncludeDefinitionContext ctx) {
        IncludeDefinitionInfo includeDefinition = new IncludeDefinitionInfo();
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        includeDefinition.setName((String)identifiers.remove(identifiers.size() - 1));
        if (identifiers.size() > 0) {
            includeDefinition.setNamespaceName(String.join((CharSequence)".", identifiers));
        }
        if (ctx.versionSpecifier() != null) {
            includeDefinition.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        if (ctx.localIdentifier() != null) {
            includeDefinition.setLocalName((String)this.visit((ParseTree)ctx.localIdentifier()));
        } else {
            includeDefinition.setLocalName(includeDefinition.getName());
        }
        includeDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, includeDefinition);
        this.libraryInfo.addIncludeDefinition(includeDefinition);
        return includeDefinition;
    }

    public Object visitUsingDefinition(cqlParser.UsingDefinitionContext ctx) {
        UsingDefinitionInfo usingDefinition = new UsingDefinitionInfo();
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        usingDefinition.setName((String)identifiers.remove(identifiers.size() - 1));
        if (identifiers.size() > 0) {
            usingDefinition.setNamespaceName(String.join((CharSequence)".", identifiers));
        }
        if (ctx.versionSpecifier() != null) {
            usingDefinition.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        if (ctx.localIdentifier() != null) {
            usingDefinition.setLocalName((String)this.visit((ParseTree)ctx.localIdentifier()));
        } else {
            usingDefinition.setLocalName(usingDefinition.getName());
        }
        usingDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, usingDefinition);
        this.libraryInfo.addUsingDefinition(usingDefinition);
        return usingDefinition;
    }

    public Object visitCodesystemDefinition(cqlParser.CodesystemDefinitionContext ctx) {
        CodesystemDefinitionInfo codesystemDefinition = new CodesystemDefinitionInfo();
        codesystemDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        codesystemDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, codesystemDefinition);
        this.libraryInfo.addCodesystemDefinition(codesystemDefinition);
        return codesystemDefinition;
    }

    public Object visitValuesetDefinition(cqlParser.ValuesetDefinitionContext ctx) {
        ValuesetDefinitionInfo valuesetDefinition = new ValuesetDefinitionInfo();
        valuesetDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        valuesetDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, valuesetDefinition);
        this.libraryInfo.addValuesetDefinition(valuesetDefinition);
        return valuesetDefinition;
    }

    public Object visitCodeDefinition(cqlParser.CodeDefinitionContext ctx) {
        CodeDefinitionInfo codeDefinition = new CodeDefinitionInfo();
        codeDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        codeDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, codeDefinition);
        this.libraryInfo.addCodeDefinition(codeDefinition);
        return codeDefinition;
    }

    public Object visitConceptDefinition(cqlParser.ConceptDefinitionContext ctx) {
        ConceptDefinitionInfo conceptDefinition = new ConceptDefinitionInfo();
        conceptDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        conceptDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, conceptDefinition);
        this.libraryInfo.addConceptDefinition(conceptDefinition);
        return conceptDefinition;
    }

    public Object visitParameterDefinition(cqlParser.ParameterDefinitionContext ctx) {
        ParameterDefinitionInfo parameterDefinition = new ParameterDefinitionInfo();
        parameterDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        parameterDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, parameterDefinition);
        this.libraryInfo.addParameterDefinition(parameterDefinition);
        return parameterDefinition;
    }

    public Object visitContextDefinition(cqlParser.ContextDefinitionContext ctx) {
        String modelIdentifier = ctx.modelIdentifier() != null ? (String)this.visit((ParseTree)ctx.modelIdentifier()) : null;
        String unqualifiedContext = (String)this.visit((ParseTree)ctx.identifier());
        this.currentContext = modelIdentifier != null && !modelIdentifier.equals("") ? modelIdentifier + "." + unqualifiedContext : unqualifiedContext;
        ContextDefinitionInfo contextDefinition = new ContextDefinitionInfo();
        contextDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, contextDefinition);
        this.libraryInfo.addContextDefinition(contextDefinition);
        if (!this.implicitContextCreated && !unqualifiedContext.equals("Unfiltered")) {
            ExpressionDefinitionInfo expressionDefinition = new ExpressionDefinitionInfo();
            expressionDefinition.setName(unqualifiedContext);
            expressionDefinition.setContext(this.currentContext);
            this.libraryInfo.addExpressionDefinition(expressionDefinition);
            this.implicitContextCreated = true;
        }
        return this.currentContext;
    }

    public Object visitExpressionDefinition(cqlParser.ExpressionDefinitionContext ctx) {
        ExpressionDefinitionInfo expressionDefinition = new ExpressionDefinitionInfo();
        expressionDefinition.setName((String)this.visit((ParseTree)ctx.identifier()));
        expressionDefinition.setContext(this.currentContext);
        expressionDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, expressionDefinition);
        this.libraryInfo.addExpressionDefinition(expressionDefinition);
        return expressionDefinition;
    }

    public Object visitFunctionDefinition(cqlParser.FunctionDefinitionContext ctx) {
        FunctionDefinitionInfo functionDefinition = new FunctionDefinitionInfo();
        functionDefinition.setName((String)this.visit((ParseTree)ctx.identifierOrFunctionIdentifier()));
        functionDefinition.setContext(this.currentContext);
        functionDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, functionDefinition);
        this.libraryInfo.addFunctionDefinition(functionDefinition);
        return functionDefinition;
    }

    public Object visitTerminal(TerminalNode node) {
        String text = node.getText();
        int tokenType = node.getSymbol().getType();
        if (165 == tokenType || 158 == tokenType) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public Object visitQualifiedIdentifier(cqlParser.QualifiedIdentifierContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierContext qualifierContext : ctx.qualifier()) {
            String qualifier = (String)this.visit((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = (String)this.visit((ParseTree)ctx.identifier());
        identifiers.add(identifier);
        return identifiers;
    }

    public Object visitQualifiedIdentifierExpression(cqlParser.QualifiedIdentifierExpressionContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierExpressionContext qualifierContext : ctx.qualifierExpression()) {
            String qualifier = (String)this.visit((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = (String)this.visit((ParseTree)ctx.referentialIdentifier());
        identifiers.add(identifier);
        return identifiers;
    }
}

