/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.InputStream;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.NamespaceAware;
import org.cqframework.cql.cql2elm.NamespaceInfo;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.hl7.elm.r1.VersionedIdentifier;

public class FhirLibrarySourceProvider
implements LibrarySourceProvider,
NamespaceAware {
    private final String namespaceName = "FHIR";
    private final String namespaceUri = "http://hl7.org/fhir";
    private NamespaceManager namespaceManager;

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        InputStream result = FhirLibrarySourceProvider.class.getResourceAsStream(String.format("/org/hl7/fhir/%s-%s.cql", libraryIdentifier.getId(), libraryIdentifier.getVersion()));
        if (result != null && this.namespaceManager != null && this.namespaceManager.hasNamespaces()) {
            NamespaceInfo namespaceInfo = this.namespaceManager.getNamespaceInfoFromUri("http://hl7.org/fhir");
            if (namespaceInfo == null) {
                namespaceInfo = new NamespaceInfo("FHIR", "http://hl7.org/fhir");
                this.namespaceManager.ensureNamespaceRegistered(namespaceInfo);
            }
            libraryIdentifier.setSystem("http://hl7.org/fhir");
        }
        return result;
    }

    @Override
    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }
}

