/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cqframework.cql.cql2elm.FhirModelInfoProvider;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.cqframework.cql.cql2elm.QICoreModelInfoProvider;
import org.cqframework.cql.cql2elm.QdmModelInfoProvider;
import org.cqframework.cql.cql2elm.QuickModelInfoProvider;
import org.cqframework.cql.cql2elm.SystemModelInfoProvider;
import org.cqframework.cql.cql2elm.UsCoreModelInfoProvider;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class ModelInfoLoader {
    private final List<ModelInfoProvider> providers = new ArrayList<ModelInfoProvider>();

    public ModelInfoLoader() {
        this.registerWellKnownModelInfoProviders();
    }

    private void registerWellKnownModelInfoProviders() {
        this.registerModelInfoProvider(new SystemModelInfoProvider());
        this.registerModelInfoProvider(new QuickModelInfoProvider());
        this.registerModelInfoProvider(new QdmModelInfoProvider());
        this.registerModelInfoProvider(new FhirModelInfoProvider());
        this.registerModelInfoProvider(new UsCoreModelInfoProvider());
        this.registerModelInfoProvider(new QICoreModelInfoProvider());
    }

    public ModelInfo getModelInfo(VersionedIdentifier modelIdentifier) {
        ModelInfoProvider provider;
        ModelInfo modelInfo = null;
        Iterator<ModelInfoProvider> iterator = this.providers.iterator();
        while (iterator.hasNext() && (modelInfo = (provider = iterator.next()).load(modelIdentifier)) == null) {
        }
        if (modelInfo == null) {
            throw new IllegalArgumentException(String.format("Could not resolve model info provider for model %s, version %s.", modelIdentifier.getSystem() == null ? modelIdentifier.getId() : NamespaceManager.getPath(modelIdentifier.getSystem(), modelIdentifier.getId()), modelIdentifier.getVersion()));
        }
        return modelInfo;
    }

    public void registerModelInfoProvider(ModelInfoProvider provider) {
        this.registerModelInfoProvider(provider, false);
    }

    public void registerModelInfoProvider(ModelInfoProvider provider, boolean priority) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider is null");
        }
        if (priority) {
            this.providers.add(0, provider);
        } else {
            this.providers.add(provider);
        }
    }

    public void unregisterModelInfoProvider(ModelInfoProvider provider) {
        this.providers.remove(provider);
    }

    public void clearModelInfoProviders() {
        this.providers.clear();
    }

    private void checkModelIdentifier(VersionedIdentifier modelIdentifier) {
        if (modelIdentifier == null) {
            throw new IllegalArgumentException("modelIdentifier is null.");
        }
        if (modelIdentifier.getId() == null || modelIdentifier.getId().equals("")) {
            throw new IllegalArgumentException("modelIdentifier Id is null.");
        }
    }
}

