/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.InputStream;
import javax.xml.bind.JAXB;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class QuickFhirModelInfoProvider
implements ModelInfoProvider {
    private NamespaceManager namespaceManager;

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    private boolean isQuickFhirModelIdentifier(VersionedIdentifier modelIdentifier) {
        if (this.namespaceManager != null && this.namespaceManager.hasNamespaces()) {
            return modelIdentifier.getId().equals("QUICKFHIR") && (modelIdentifier.getSystem() == null || modelIdentifier.getSystem().equals("http://hl7.org/fhir"));
        }
        return modelIdentifier.getId().equals("QUICKFHIR");
    }

    @Override
    public ModelInfo load(VersionedIdentifier modelIdentifier) {
        if (this.isQuickFhirModelIdentifier(modelIdentifier)) {
            String localVersion;
            switch (localVersion = modelIdentifier.getVersion() == null ? "" : modelIdentifier.getVersion()) {
                case "3.0.1": 
                case "": {
                    return (ModelInfo)JAXB.unmarshal((InputStream)QuickFhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/quickfhir-modelinfo-3.0.1.xml"), ModelInfo.class);
                }
            }
        }
        return null;
    }
}

