/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.nio.file.Path;
import javax.xml.bind.JAXB;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.model.Version;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class DefaultModelInfoProvider
implements ModelInfoProvider {
    private Path path;

    public DefaultModelInfoProvider(Path path) {
        if (path == null || !path.toFile().isDirectory()) {
            throw new IllegalArgumentException(String.format("path '%s' is not a valid directory", path));
        }
        this.path = path;
    }

    @Override
    public ModelInfo load(VersionedIdentifier modelIdentifier) {
        final String modelName = modelIdentifier.getId();
        String modelVersion = modelIdentifier.getVersion();
        Path modelPath = this.path.resolve(String.format("%s-modelinfo%s.xml", modelName.toLowerCase(), modelVersion != null ? "-" + modelVersion : ""));
        File modelFile = modelPath.toFile();
        if (!modelFile.exists()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File path, String name) {
                    return name.startsWith(modelName.toLowerCase() + "-modelinfo") && name.endsWith(".xml");
                }
            };
            File mostRecentFile = null;
            Version mostRecent = null;
            try {
                Version requestedVersion = modelVersion == null ? null : new Version(modelVersion);
                for (File file : this.path.toFile().listFiles(filter)) {
                    String[] fileNameComponents;
                    String fileName = file.getName();
                    int indexOfExtension = fileName.lastIndexOf(".");
                    if (indexOfExtension >= 0) {
                        fileName = fileName.substring(0, indexOfExtension);
                    }
                    if ((fileNameComponents = fileName.split("-")).length == 3) {
                        Version version = new Version(fileNameComponents[2]);
                        if (requestedVersion != null && !version.compatibleWith(requestedVersion) || mostRecent != null && version.compareTo(mostRecent) <= 0) continue;
                        mostRecent = version;
                        mostRecentFile = file;
                        continue;
                    }
                    if (mostRecent != null) continue;
                    mostRecentFile = file;
                }
                modelFile = mostRecentFile;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            if (modelFile != null) {
                FileInputStream is = new FileInputStream(modelFile);
                return (ModelInfo)JAXB.unmarshal((InputStream)is, ModelInfo.class);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not load definition for model info %s.", modelIdentifier.getId()), e);
        }
        return null;
    }
}

