/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.Signature;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.TypeParameter;
import org.hl7.elm.r1.VersionedIdentifier;

public class SystemLibraryHelper {
    public static TranslatedLibrary load(SystemModel systemModel) {
        TranslatedLibrary system = new TranslatedLibrary();
        system.setIdentifier(new VersionedIdentifier().withId("System").withVersion("1.0"));
        system.add(new Operator("And", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        system.add(new Operator("Or", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        system.add(new Operator("Xor", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        system.add(new Operator("Not", new Signature(systemModel.getBoolean()), systemModel.getBoolean()));
        system.add(new Operator("IsNull", new Signature(systemModel.getAny()), systemModel.getBoolean()));
        system.add(new Operator("IsTrue", new Signature(systemModel.getBoolean()), systemModel.getBoolean()));
        system.add(new Operator("IsFalse", new Signature(systemModel.getBoolean()), systemModel.getBoolean()));
        system.add(new GenericOperator("Coalesce", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Coalesce", new Signature(new DataType[]{new TypeParameter("T"), new TypeParameter("T")}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Coalesce", new Signature(new DataType[]{new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T")}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Coalesce", new Signature(new DataType[]{new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T")}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Coalesce", new Signature(new DataType[]{new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T")}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        Operator booleanToString = new Operator("ToString", new Signature(systemModel.getBoolean()), systemModel.getString());
        system.add(booleanToString);
        system.add(new Conversion(booleanToString, false));
        Operator integerToString = new Operator("ToString", new Signature(systemModel.getInteger()), systemModel.getString());
        system.add(integerToString);
        system.add(new Conversion(integerToString, false));
        Operator longToString = new Operator("ToString", new Signature(systemModel.getLong()), systemModel.getString());
        system.add(longToString);
        system.add(new Conversion(longToString, false));
        Operator decimalToString = new Operator("ToString", new Signature(systemModel.getDecimal()), systemModel.getString());
        system.add(decimalToString);
        system.add(new Conversion(decimalToString, false));
        Operator dateTimeToString = new Operator("ToString", new Signature(systemModel.getDateTime()), systemModel.getString());
        system.add(dateTimeToString);
        system.add(new Conversion(dateTimeToString, false));
        Operator dateToString = new Operator("ToString", new Signature(systemModel.getDate()), systemModel.getString());
        system.add(dateToString);
        system.add(new Conversion(dateToString, false));
        Operator timeToString = new Operator("ToString", new Signature(systemModel.getTime()), systemModel.getString());
        system.add(timeToString);
        system.add(new Conversion(timeToString, false));
        Operator quantityToString = new Operator("ToString", new Signature(systemModel.getQuantity()), systemModel.getString());
        system.add(quantityToString);
        system.add(new Conversion(quantityToString, false));
        Operator ratioToString = new Operator("ToString", new Signature(systemModel.getRatio()), systemModel.getString());
        system.add(ratioToString);
        system.add(new Conversion(ratioToString, false));
        Operator stringToBoolean = new Operator("ToBoolean", new Signature(systemModel.getString()), systemModel.getBoolean());
        system.add(stringToBoolean);
        system.add(new Conversion(stringToBoolean, false));
        Operator integerToBoolean = new Operator("ToBoolean", new Signature(systemModel.getInteger()), systemModel.getBoolean());
        system.add(integerToBoolean);
        system.add(new Conversion(integerToBoolean, false));
        Operator decimalToBoolean = new Operator("ToBoolean", new Signature(systemModel.getDecimal()), systemModel.getBoolean());
        system.add(decimalToBoolean);
        system.add(new Conversion(decimalToBoolean, false));
        Operator longToBoolean = new Operator("ToBoolean", new Signature(systemModel.getLong()), systemModel.getBoolean());
        system.add(longToBoolean);
        system.add(new Conversion(longToBoolean, false));
        Operator toChars = new Operator("ToChars", new Signature(systemModel.getString()), (DataType)new ListType(systemModel.getString()));
        system.add(toChars);
        system.add(new Conversion(toChars, false));
        Operator stringToInteger = new Operator("ToInteger", new Signature(systemModel.getString()), systemModel.getInteger());
        system.add(stringToInteger);
        system.add(new Conversion(stringToInteger, false));
        Operator longToInteger = new Operator("ToInteger", new Signature(systemModel.getLong()), systemModel.getInteger());
        system.add(longToInteger);
        system.add(new Conversion(longToInteger, false));
        Operator booleanToInteger = new Operator("ToInteger", new Signature(systemModel.getBoolean()), systemModel.getInteger());
        system.add(booleanToInteger);
        system.add(new Conversion(booleanToInteger, false));
        Operator stringToLong = new Operator("ToLong", new Signature(systemModel.getString()), systemModel.getLong());
        system.add(stringToLong);
        system.add(new Conversion(stringToLong, false));
        Operator integerToLong = new Operator("ToLong", new Signature(systemModel.getInteger()), systemModel.getLong());
        system.add(integerToLong);
        system.add(new Conversion(integerToLong, true));
        Operator booleanToLong = new Operator("ToLong", new Signature(systemModel.getBoolean()), systemModel.getLong());
        system.add(booleanToLong);
        system.add(new Conversion(booleanToLong, false));
        Operator stringToDecimal = new Operator("ToDecimal", new Signature(systemModel.getString()), systemModel.getDecimal());
        system.add(stringToDecimal);
        system.add(new Conversion(stringToDecimal, false));
        Operator integerToDecimal = new Operator("ToDecimal", new Signature(systemModel.getInteger()), systemModel.getDecimal());
        system.add(integerToDecimal);
        system.add(new Conversion(integerToDecimal, true));
        Operator longToDecimal = new Operator("ToDecimal", new Signature(systemModel.getLong()), systemModel.getDecimal());
        system.add(longToDecimal);
        system.add(new Conversion(longToDecimal, true));
        Operator booleanToDecimal = new Operator("ToDecimal", new Signature(systemModel.getBoolean()), systemModel.getDecimal());
        system.add(booleanToDecimal);
        system.add(new Conversion(booleanToDecimal, false));
        Operator stringToDateTime = new Operator("ToDateTime", new Signature(systemModel.getString()), systemModel.getDateTime());
        system.add(stringToDateTime);
        system.add(new Conversion(stringToDateTime, false));
        Operator dateToDateTime = new Operator("ToDateTime", new Signature(systemModel.getDate()), systemModel.getDateTime());
        system.add(dateToDateTime);
        system.add(new Conversion(dateToDateTime, true));
        Operator stringToDate = new Operator("ToDate", new Signature(systemModel.getString()), systemModel.getDate());
        system.add(stringToDate);
        system.add(new Conversion(stringToDate, false));
        Operator dateTimeToDate = new Operator("ToDate", new Signature(systemModel.getDateTime()), systemModel.getDate());
        system.add(dateTimeToDate);
        system.add(new Conversion(dateTimeToDate, false));
        Operator stringToTime = new Operator("ToTime", new Signature(systemModel.getString()), systemModel.getTime());
        system.add(stringToTime);
        system.add(new Conversion(stringToTime, false));
        Operator stringToQuantity = new Operator("ToQuantity", new Signature(systemModel.getString()), systemModel.getQuantity());
        system.add(stringToQuantity);
        system.add(new Conversion(stringToQuantity, false));
        Operator ratioToQuantity = new Operator("ToQuantity", new Signature(systemModel.getRatio()), systemModel.getQuantity());
        system.add(ratioToQuantity);
        system.add(new Conversion(ratioToQuantity, false));
        Operator integerToQuantity = new Operator("ToQuantity", new Signature(systemModel.getInteger()), systemModel.getQuantity());
        system.add(integerToQuantity);
        system.add(new Conversion(integerToQuantity, true));
        Operator decimalToQuantity = new Operator("ToQuantity", new Signature(systemModel.getDecimal()), systemModel.getQuantity());
        system.add(decimalToQuantity);
        system.add(new Conversion(decimalToQuantity, true));
        Operator stringToRatio = new Operator("ToRatio", new Signature(systemModel.getString()), systemModel.getRatio());
        system.add(stringToRatio);
        system.add(new Conversion(stringToRatio, false));
        Operator convertsTo = new Operator("ConvertsToBoolean", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToInteger", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToLong", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToDecimal", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToDateTime", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToDate", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToTime", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToString", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToQuantity", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        convertsTo = new Operator("ConvertsToRatio", new Signature(systemModel.getAny()), systemModel.getBoolean());
        system.add(convertsTo);
        Operator canConvertToQuantity = new Operator("CanConvertQuantity", new Signature(systemModel.getQuantity(), systemModel.getString()), systemModel.getBoolean());
        system.add(canConvertToQuantity);
        Operator convertToQuantity = new Operator("ConvertQuantity", new Signature(systemModel.getQuantity(), systemModel.getString()), systemModel.getQuantity());
        system.add(convertToQuantity);
        TypeParameter C = new TypeParameter("C", TypeParameter.TypeParameterConstraint.CLASS, null);
        system.add(new GenericOperator("Equal", new Signature(new DataType[]{C, C}), systemModel.getBoolean(), C));
        TypeParameter R = new TypeParameter("R", TypeParameter.TypeParameterConstraint.TUPLE, null);
        system.add(new GenericOperator("Equal", new Signature(new DataType[]{R, R}), systemModel.getBoolean(), R));
        TypeParameter H = new TypeParameter("H", TypeParameter.TypeParameterConstraint.CHOICE, null);
        system.add(new GenericOperator("Equal", new Signature(new DataType[]{H, H}), systemModel.getBoolean(), H));
        C = new TypeParameter("C", TypeParameter.TypeParameterConstraint.CLASS, null);
        system.add(new GenericOperator("Equivalent", new Signature(new DataType[]{C, C}), systemModel.getBoolean(), C));
        R = new TypeParameter("R", TypeParameter.TypeParameterConstraint.TUPLE, null);
        system.add(new GenericOperator("Equivalent", new Signature(new DataType[]{R, R}), systemModel.getBoolean(), R));
        H = new TypeParameter("H", TypeParameter.TypeParameterConstraint.CHOICE, null);
        system.add(new GenericOperator("Equivalent", new Signature(new DataType[]{H, H}), systemModel.getBoolean(), H));
        system.add(new Operator("Equal", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        system.add(new Operator("Less", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        system.add(new Operator("LessOrEqual", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        system.add(new Operator("Greater", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        system.add(new Operator("GreaterOrEqual", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        system.add(new Operator("Less", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        system.add(new Operator("LessOrEqual", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        system.add(new Operator("Greater", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        system.add(new Operator("GreaterOrEqual", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        system.add(new Operator("Less", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        system.add(new Operator("LessOrEqual", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        system.add(new Operator("Greater", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        system.add(new Operator("GreaterOrEqual", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("Less", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("LessOrEqual", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("Greater", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("GreaterOrEqual", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("Less", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("LessOrEqual", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("Greater", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("GreaterOrEqual", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("Less", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("LessOrEqual", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("Greater", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("GreaterOrEqual", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("Less", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("LessOrEqual", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("Greater", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("GreaterOrEqual", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        system.add(new Operator("Less", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        system.add(new Operator("LessOrEqual", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        system.add(new Operator("Greater", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        system.add(new Operator("GreaterOrEqual", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getRatio(), systemModel.getRatio()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getRatio(), systemModel.getRatio()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getCode(), systemModel.getCode()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getCode(), systemModel.getCode()), systemModel.getBoolean()));
        system.add(new Operator("Equal", new Signature(systemModel.getConcept(), systemModel.getConcept()), systemModel.getBoolean()));
        system.add(new Operator("Equivalent", new Signature(systemModel.getConcept(), systemModel.getConcept()), systemModel.getBoolean()));
        system.add(new Operator("Abs", new Signature(systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Abs", new Signature(systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Abs", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Abs", new Signature(systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Add", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Add", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Add", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Add", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Ceiling", new Signature(systemModel.getDecimal()), systemModel.getInteger()));
        system.add(new Operator("Divide", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Divide", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Exp", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Floor", new Signature(systemModel.getDecimal()), systemModel.getInteger()));
        system.add(new Operator("HighBoundary", new Signature(systemModel.getDecimal(), systemModel.getInteger()), systemModel.getDecimal()));
        system.add(new Operator("HighBoundary", new Signature(systemModel.getDate(), systemModel.getInteger()), systemModel.getDate()));
        system.add(new Operator("HighBoundary", new Signature(systemModel.getDateTime(), systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("HighBoundary", new Signature(systemModel.getTime(), systemModel.getInteger()), systemModel.getTime()));
        system.add(new Operator("Log", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("LowBoundary", new Signature(systemModel.getDecimal(), systemModel.getInteger()), systemModel.getDecimal()));
        system.add(new Operator("LowBoundary", new Signature(systemModel.getDate(), systemModel.getInteger()), systemModel.getDate()));
        system.add(new Operator("LowBoundary", new Signature(systemModel.getDateTime(), systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("LowBoundary", new Signature(systemModel.getTime(), systemModel.getInteger()), systemModel.getTime()));
        system.add(new Operator("Ln", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Modulo", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Modulo", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Modulo", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Modulo", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Multiply", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Multiply", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Multiply", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Multiply", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Negate", new Signature(systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Negate", new Signature(systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Negate", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Negate", new Signature(systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Precision", new Signature(systemModel.getDecimal()), systemModel.getInteger()));
        system.add(new Operator("Precision", new Signature(systemModel.getDate()), systemModel.getInteger()));
        system.add(new Operator("Precision", new Signature(systemModel.getDateTime()), systemModel.getInteger()));
        system.add(new Operator("Precision", new Signature(systemModel.getTime()), systemModel.getInteger()));
        system.add(new Operator("Predecessor", new Signature(systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Predecessor", new Signature(systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Predecessor", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Predecessor", new Signature(systemModel.getDate()), systemModel.getDate()));
        system.add(new Operator("Predecessor", new Signature(systemModel.getDateTime()), systemModel.getDateTime()));
        system.add(new Operator("Predecessor", new Signature(systemModel.getTime()), systemModel.getTime()));
        system.add(new Operator("Predecessor", new Signature(systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Power", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Power", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Power", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Round", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Round", new Signature(systemModel.getDecimal(), systemModel.getInteger()), systemModel.getDecimal()));
        system.add(new Operator("Subtract", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Subtract", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Subtract", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Subtract", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Successor", new Signature(systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("Successor", new Signature(systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("Successor", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("Successor", new Signature(systemModel.getDate()), systemModel.getDate()));
        system.add(new Operator("Successor", new Signature(systemModel.getDateTime()), systemModel.getDateTime()));
        system.add(new Operator("Successor", new Signature(systemModel.getTime()), systemModel.getTime()));
        system.add(new Operator("Successor", new Signature(systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Truncate", new Signature(systemModel.getDecimal()), systemModel.getInteger()));
        system.add(new Operator("TruncatedDivide", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        system.add(new Operator("TruncatedDivide", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        system.add(new Operator("TruncatedDivide", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        system.add(new Operator("TruncatedDivide", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        system.add(new Operator("Add", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getString()));
        system.add(new Operator("Combine", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getString()));
        system.add(new Operator("Combine", new Signature(new DataType[]{new ListType(systemModel.getString()), systemModel.getString()}), systemModel.getString()));
        system.add(new Operator("Concatenate", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getString()));
        system.add(new Operator("EndsWith", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("Indexer", new Signature(systemModel.getString(), systemModel.getInteger()), systemModel.getString()));
        system.add(new Operator("LastPositionOf", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getInteger()));
        system.add(new Operator("Length", new Signature(systemModel.getString()), systemModel.getInteger()));
        system.add(new Operator("Lower", new Signature(systemModel.getString()), systemModel.getString()));
        system.add(new Operator("Matches", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("PositionOf", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getInteger()));
        system.add(new Operator("ReplaceMatches", new Signature(systemModel.getString(), systemModel.getString(), systemModel.getString()), systemModel.getString()));
        system.add(new Operator("Split", new Signature(systemModel.getString(), systemModel.getString()), (DataType)new ListType(systemModel.getString())));
        system.add(new Operator("SplitOnMatches", new Signature(systemModel.getString(), systemModel.getString()), (DataType)new ListType(systemModel.getString())));
        system.add(new Operator("StartsWith", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("Substring", new Signature(systemModel.getString(), systemModel.getInteger()), systemModel.getString()));
        system.add(new Operator("Substring", new Signature(systemModel.getString(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getString()));
        system.add(new Operator("Upper", new Signature(systemModel.getString()), systemModel.getString()));
        system.add(new Operator("Add", new Signature(systemModel.getDateTime(), systemModel.getQuantity()), systemModel.getDateTime()));
        system.add(new Operator("Add", new Signature(systemModel.getDate(), systemModel.getQuantity()), systemModel.getDate()));
        system.add(new Operator("Add", new Signature(systemModel.getTime(), systemModel.getQuantity()), systemModel.getTime()));
        system.add(new Operator("After", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("After", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("After", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("Before", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("Before", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("Before", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("DateTime", new Signature(systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        system.add(new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getDecimal()), systemModel.getDateTime()));
        system.add(new Operator("Date", new Signature(systemModel.getInteger()), systemModel.getDate()));
        system.add(new Operator("Date", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getDate()));
        system.add(new Operator("Date", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDate()));
        system.add(new Operator("DateFrom", new Signature(systemModel.getDateTime()), systemModel.getDate()));
        system.add(new Operator("TimeFrom", new Signature(systemModel.getDateTime()), systemModel.getTime()));
        system.add(new Operator("TimezoneFrom", new Signature(systemModel.getDateTime()), systemModel.getDecimal()));
        system.add(new Operator("TimezoneOffsetFrom", new Signature(systemModel.getDateTime()), systemModel.getDecimal()));
        system.add(new Operator("DateTimeComponentFrom", new Signature(systemModel.getDateTime()), systemModel.getInteger()));
        system.add(new Operator("DateTimeComponentFrom", new Signature(systemModel.getDate()), systemModel.getInteger()));
        system.add(new Operator("DateTimeComponentFrom", new Signature(systemModel.getTime()), systemModel.getInteger()));
        system.add(new Operator("DifferenceBetween", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getInteger()));
        system.add(new Operator("DifferenceBetween", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getInteger()));
        system.add(new Operator("DifferenceBetween", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getInteger()));
        system.add(new Operator("DurationBetween", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getInteger()));
        system.add(new Operator("DurationBetween", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getInteger()));
        system.add(new Operator("DurationBetween", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getInteger()));
        system.add(new Operator("Now", new Signature(new DataType[0]), systemModel.getDateTime()));
        system.add(new Operator("SameAs", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("SameAs", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("SameAs", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("SameOrAfter", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("SameOrAfter", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("SameOrAfter", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("SameOrBefore", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        system.add(new Operator("SameOrBefore", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        system.add(new Operator("SameOrBefore", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        system.add(new Operator("Subtract", new Signature(systemModel.getDateTime(), systemModel.getQuantity()), systemModel.getDateTime()));
        system.add(new Operator("Subtract", new Signature(systemModel.getDate(), systemModel.getQuantity()), systemModel.getDate()));
        system.add(new Operator("Subtract", new Signature(systemModel.getTime(), systemModel.getQuantity()), systemModel.getTime()));
        system.add(new Operator("Today", new Signature(new DataType[0]), systemModel.getDate()));
        system.add(new Operator("Time", new Signature(systemModel.getInteger()), systemModel.getTime()));
        system.add(new Operator("Time", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getTime()));
        system.add(new Operator("Time", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getTime()));
        system.add(new Operator("Time", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getTime()));
        system.add(new Operator("TimeOfDay", new Signature(new DataType[0]), systemModel.getTime()));
        system.add(new GenericOperator("After", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Before", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Collapse", new Signature(new DataType[]{new ListType((DataType)new IntervalType((DataType)new TypeParameter("T"))), systemModel.getQuantity()}), (DataType)new ListType((DataType)new IntervalType((DataType)new TypeParameter("T"))), new TypeParameter("T")));
        system.add(new GenericOperator("Contains", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("End", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Ends", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Equal", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Equivalent", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Except", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Expand", new Signature(new DataType[]{new ListType((DataType)new IntervalType((DataType)new TypeParameter("T"))), systemModel.getQuantity()}), (DataType)new ListType((DataType)new IntervalType((DataType)new TypeParameter("T"))), new TypeParameter("T")));
        system.add(new GenericOperator("Expand", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), systemModel.getQuantity()}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("In", new Signature(new DataType[]{new TypeParameter("T"), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Includes", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("IncludedIn", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Intersect", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Meets", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("MeetsBefore", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("MeetsAfter", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Overlaps", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("OverlapsBefore", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("OverlapsAfter", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        GenericOperator pointFrom = new GenericOperator("PointFrom", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T"));
        system.add(pointFrom);
        system.add(new GenericOperator("ProperContains", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("ProperIn", new Signature(new DataType[]{new TypeParameter("T"), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("ProperIncludes", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("ProperIncludedIn", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("SameAs", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("SameOrAfter", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("SameOrBefore", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Size", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Start", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Starts", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Union", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Width", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Contains", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Distinct", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Equal", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Equivalent", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Except", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Exists", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Flatten", new Signature(new DataType[]{new ListType((DataType)new ListType((DataType)new TypeParameter("T")))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("First", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("In", new Signature(new DataType[]{new TypeParameter("T"), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Includes", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("IncludedIn", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("Indexer", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), systemModel.getInteger()}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("IndexOf", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getInteger(), new TypeParameter("T")));
        system.add(new GenericOperator("Intersect", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Last", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new GenericOperator("Length", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), systemModel.getInteger(), new TypeParameter("T")));
        system.add(new GenericOperator("ProperContains", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("ProperIn", new Signature(new DataType[]{new TypeParameter("T"), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("ProperIncludes", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        system.add(new GenericOperator("ProperIncludedIn", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        GenericOperator singletonFrom = new GenericOperator("SingletonFrom", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T"));
        system.add(singletonFrom);
        system.add(new GenericOperator("Skip", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), systemModel.getInteger()}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Tail", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Take", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), systemModel.getInteger()}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new GenericOperator("Union", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        system.add(new Operator("AllTrue", new Signature(new DataType[]{new ListType(systemModel.getBoolean())}), systemModel.getBoolean()));
        system.add(new Operator("AnyTrue", new Signature(new DataType[]{new ListType(systemModel.getBoolean())}), systemModel.getBoolean()));
        system.add(new Operator("Avg", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("Avg", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new GenericOperator("Count", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), systemModel.getInteger(), new TypeParameter("T")));
        system.add(new Operator("GeometricMean", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getInteger())}), systemModel.getInteger()));
        system.add(new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getLong())}), systemModel.getLong()));
        system.add(new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getDateTime())}), systemModel.getDateTime()));
        system.add(new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getDate())}), systemModel.getDate()));
        system.add(new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getTime())}), systemModel.getTime()));
        system.add(new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getString()));
        system.add(new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getInteger())}), systemModel.getInteger()));
        system.add(new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getLong())}), systemModel.getLong()));
        system.add(new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getDateTime())}), systemModel.getDateTime()));
        system.add(new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getDate())}), systemModel.getDate()));
        system.add(new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getTime())}), systemModel.getTime()));
        system.add(new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getString()));
        system.add(new Operator("Median", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("Median", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new GenericOperator("Mode", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        system.add(new Operator("PopulationStdDev", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("PopulationStdDev", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new Operator("PopulationVariance", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("PopulationVariance", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new Operator("Product", new Signature(new DataType[]{new ListType(systemModel.getInteger())}), systemModel.getInteger()));
        system.add(new Operator("Product", new Signature(new DataType[]{new ListType(systemModel.getLong())}), systemModel.getLong()));
        system.add(new Operator("Product", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("Product", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new Operator("StdDev", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("StdDev", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new Operator("Sum", new Signature(new DataType[]{new ListType(systemModel.getInteger())}), systemModel.getInteger()));
        system.add(new Operator("Sum", new Signature(new DataType[]{new ListType(systemModel.getLong())}), systemModel.getLong()));
        system.add(new Operator("Sum", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("Sum", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        system.add(new Operator("Variance", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        system.add(new Operator("Variance", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        Operator codeToConcept = new Operator("ToConcept", new Signature(systemModel.getCode()), systemModel.getConcept());
        system.add(codeToConcept);
        system.add(new Conversion(codeToConcept, true));
        Operator codesToConcept = new Operator("ToConcept", new Signature(new DataType[]{new ListType(systemModel.getCode())}), systemModel.getConcept());
        system.add(codesToConcept);
        system.add(new Conversion(codesToConcept, false));
        system.add(new Operator("CalculateAge", new Signature(systemModel.getDateTime()), systemModel.getInteger()));
        system.add(new Operator("CalculateAge", new Signature(systemModel.getDate()), systemModel.getInteger()));
        system.add(new Operator("CalculateAgeAt", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getInteger()));
        system.add(new Operator("CalculateAgeAt", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getInteger()));
        system.add(new Operator("InValueSet", new Signature(systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("InValueSet", new Signature(systemModel.getCode()), systemModel.getBoolean()));
        system.add(new Operator("InValueSet", new Signature(systemModel.getConcept()), systemModel.getBoolean()));
        system.add(new Operator("InValueSet", new Signature(systemModel.getString(), systemModel.getValueSet()), systemModel.getBoolean()));
        system.add(new Operator("InValueSet", new Signature(systemModel.getCode(), systemModel.getValueSet()), systemModel.getBoolean()));
        system.add(new Operator("InValueSet", new Signature(systemModel.getConcept(), systemModel.getValueSet()), systemModel.getBoolean()));
        system.add(new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getBoolean()));
        system.add(new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getCode())}), systemModel.getBoolean()));
        system.add(new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getConcept())}), systemModel.getBoolean()));
        system.add(new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getString()), systemModel.getValueSet()}), systemModel.getBoolean()));
        system.add(new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getCode()), systemModel.getValueSet()}), systemModel.getBoolean()));
        system.add(new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getConcept()), systemModel.getValueSet()}), systemModel.getBoolean()));
        system.add(new Operator("InCodeSystem", new Signature(systemModel.getString()), systemModel.getBoolean()));
        system.add(new Operator("InCodeSystem", new Signature(systemModel.getCode()), systemModel.getBoolean()));
        system.add(new Operator("InCodeSystem", new Signature(systemModel.getConcept()), systemModel.getBoolean()));
        system.add(new Operator("InCodeSystem", new Signature(systemModel.getString(), systemModel.getCodeSystem()), systemModel.getBoolean()));
        system.add(new Operator("InCodeSystem", new Signature(systemModel.getCode(), systemModel.getCodeSystem()), systemModel.getBoolean()));
        system.add(new Operator("InCodeSystem", new Signature(systemModel.getConcept(), systemModel.getCodeSystem()), systemModel.getBoolean()));
        system.add(new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getBoolean()));
        system.add(new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getCode())}), systemModel.getBoolean()));
        system.add(new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getConcept())}), systemModel.getBoolean()));
        system.add(new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getString()), systemModel.getCodeSystem()}), systemModel.getBoolean()));
        system.add(new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getCode()), systemModel.getCodeSystem()}), systemModel.getBoolean()));
        system.add(new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getConcept()), systemModel.getCodeSystem()}), systemModel.getBoolean()));
        system.add(new Operator("Subsumes", new Signature(systemModel.getCode(), systemModel.getCode()), systemModel.getBoolean()));
        system.add(new Operator("Subsumes", new Signature(systemModel.getConcept(), systemModel.getConcept()), systemModel.getBoolean()));
        system.add(new Operator("SubsumedBy", new Signature(systemModel.getCode(), systemModel.getCode()), systemModel.getBoolean()));
        system.add(new Operator("SubsumedBy", new Signature(systemModel.getConcept(), systemModel.getConcept()), systemModel.getBoolean()));
        system.add(new GenericOperator("Message", new Signature(new DataType[]{new TypeParameter("T"), systemModel.getBoolean(), systemModel.getString(), systemModel.getString(), systemModel.getString()}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        return system;
    }
}

