/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import org.cqframework.cql.cql2elm.TypeBuilder;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.Signature;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.TypeParameter;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.VersionedIdentifier;

public class SystemLibraryHelper {
    public static TranslatedLibrary load(SystemModel systemModel, TypeBuilder tb) {
        TranslatedLibrary system = new TranslatedLibrary();
        system.setIdentifier(new VersionedIdentifier().withId("System").withVersion("1.0"));
        SystemLibraryHelper.add(system, tb, new Operator("And", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Or", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Xor", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Not", new Signature(systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Implies", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("IsNull", new Signature(systemModel.getAny()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("IsTrue", new Signature(systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("IsFalse", new Signature(systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Coalesce", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Coalesce", new Signature(new DataType[]{new TypeParameter("T"), new TypeParameter("T")}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Coalesce", new Signature(new DataType[]{new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T")}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Coalesce", new Signature(new DataType[]{new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T")}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Coalesce", new Signature(new DataType[]{new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T"), new TypeParameter("T")}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        Operator booleanToString = new Operator("ToString", new Signature(systemModel.getBoolean()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, booleanToString);
        SystemLibraryHelper.add(system, tb, new Conversion(booleanToString, false));
        Operator integerToString = new Operator("ToString", new Signature(systemModel.getInteger()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, integerToString);
        SystemLibraryHelper.add(system, tb, new Conversion(integerToString, false));
        Operator longToString = new Operator("ToString", new Signature(systemModel.getLong()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, longToString);
        SystemLibraryHelper.add(system, tb, new Conversion(longToString, false));
        Operator decimalToString = new Operator("ToString", new Signature(systemModel.getDecimal()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, decimalToString);
        SystemLibraryHelper.add(system, tb, new Conversion(decimalToString, false));
        Operator dateTimeToString = new Operator("ToString", new Signature(systemModel.getDateTime()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, dateTimeToString);
        SystemLibraryHelper.add(system, tb, new Conversion(dateTimeToString, false));
        Operator dateToString = new Operator("ToString", new Signature(systemModel.getDate()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, dateToString);
        SystemLibraryHelper.add(system, tb, new Conversion(dateToString, false));
        Operator timeToString = new Operator("ToString", new Signature(systemModel.getTime()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, timeToString);
        SystemLibraryHelper.add(system, tb, new Conversion(timeToString, false));
        Operator quantityToString = new Operator("ToString", new Signature(systemModel.getQuantity()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, quantityToString);
        SystemLibraryHelper.add(system, tb, new Conversion(quantityToString, false));
        Operator ratioToString = new Operator("ToString", new Signature(systemModel.getRatio()), systemModel.getString());
        SystemLibraryHelper.add(system, tb, ratioToString);
        SystemLibraryHelper.add(system, tb, new Conversion(ratioToString, false));
        Operator stringToBoolean = new Operator("ToBoolean", new Signature(systemModel.getString()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, stringToBoolean);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToBoolean, false));
        Operator integerToBoolean = new Operator("ToBoolean", new Signature(systemModel.getInteger()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, integerToBoolean);
        SystemLibraryHelper.add(system, tb, new Conversion(integerToBoolean, false));
        Operator decimalToBoolean = new Operator("ToBoolean", new Signature(systemModel.getDecimal()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, decimalToBoolean);
        SystemLibraryHelper.add(system, tb, new Conversion(decimalToBoolean, false));
        Operator longToBoolean = new Operator("ToBoolean", new Signature(systemModel.getLong()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, longToBoolean);
        SystemLibraryHelper.add(system, tb, new Conversion(longToBoolean, false));
        Operator toChars = new Operator("ToChars", new Signature(systemModel.getString()), (DataType)new ListType(systemModel.getString()));
        SystemLibraryHelper.add(system, tb, toChars);
        SystemLibraryHelper.add(system, tb, new Conversion(toChars, false));
        Operator stringToInteger = new Operator("ToInteger", new Signature(systemModel.getString()), systemModel.getInteger());
        SystemLibraryHelper.add(system, tb, stringToInteger);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToInteger, false));
        Operator longToInteger = new Operator("ToInteger", new Signature(systemModel.getLong()), systemModel.getInteger());
        SystemLibraryHelper.add(system, tb, longToInteger);
        SystemLibraryHelper.add(system, tb, new Conversion(longToInteger, false));
        Operator booleanToInteger = new Operator("ToInteger", new Signature(systemModel.getBoolean()), systemModel.getInteger());
        SystemLibraryHelper.add(system, tb, booleanToInteger);
        SystemLibraryHelper.add(system, tb, new Conversion(booleanToInteger, false));
        Operator stringToLong = new Operator("ToLong", new Signature(systemModel.getString()), systemModel.getLong());
        SystemLibraryHelper.add(system, tb, stringToLong);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToLong, false));
        Operator integerToLong = new Operator("ToLong", new Signature(systemModel.getInteger()), systemModel.getLong());
        SystemLibraryHelper.add(system, tb, integerToLong);
        SystemLibraryHelper.add(system, tb, new Conversion(integerToLong, true));
        Operator booleanToLong = new Operator("ToLong", new Signature(systemModel.getBoolean()), systemModel.getLong());
        SystemLibraryHelper.add(system, tb, booleanToLong);
        SystemLibraryHelper.add(system, tb, new Conversion(booleanToLong, false));
        Operator stringToDecimal = new Operator("ToDecimal", new Signature(systemModel.getString()), systemModel.getDecimal());
        SystemLibraryHelper.add(system, tb, stringToDecimal);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToDecimal, false));
        Operator integerToDecimal = new Operator("ToDecimal", new Signature(systemModel.getInteger()), systemModel.getDecimal());
        SystemLibraryHelper.add(system, tb, integerToDecimal);
        SystemLibraryHelper.add(system, tb, new Conversion(integerToDecimal, true));
        Operator longToDecimal = new Operator("ToDecimal", new Signature(systemModel.getLong()), systemModel.getDecimal());
        SystemLibraryHelper.add(system, tb, longToDecimal);
        SystemLibraryHelper.add(system, tb, new Conversion(longToDecimal, true));
        Operator booleanToDecimal = new Operator("ToDecimal", new Signature(systemModel.getBoolean()), systemModel.getDecimal());
        SystemLibraryHelper.add(system, tb, booleanToDecimal);
        SystemLibraryHelper.add(system, tb, new Conversion(booleanToDecimal, false));
        Operator stringToDateTime = new Operator("ToDateTime", new Signature(systemModel.getString()), systemModel.getDateTime());
        SystemLibraryHelper.add(system, tb, stringToDateTime);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToDateTime, false));
        Operator dateToDateTime = new Operator("ToDateTime", new Signature(systemModel.getDate()), systemModel.getDateTime());
        SystemLibraryHelper.add(system, tb, dateToDateTime);
        SystemLibraryHelper.add(system, tb, new Conversion(dateToDateTime, true));
        Operator stringToDate = new Operator("ToDate", new Signature(systemModel.getString()), systemModel.getDate());
        SystemLibraryHelper.add(system, tb, stringToDate);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToDate, false));
        Operator dateTimeToDate = new Operator("ToDate", new Signature(systemModel.getDateTime()), systemModel.getDate());
        SystemLibraryHelper.add(system, tb, dateTimeToDate);
        SystemLibraryHelper.add(system, tb, new Conversion(dateTimeToDate, false));
        Operator stringToTime = new Operator("ToTime", new Signature(systemModel.getString()), systemModel.getTime());
        SystemLibraryHelper.add(system, tb, stringToTime);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToTime, false));
        Operator stringToQuantity = new Operator("ToQuantity", new Signature(systemModel.getString()), systemModel.getQuantity());
        SystemLibraryHelper.add(system, tb, stringToQuantity);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToQuantity, false));
        Operator ratioToQuantity = new Operator("ToQuantity", new Signature(systemModel.getRatio()), systemModel.getQuantity());
        SystemLibraryHelper.add(system, tb, ratioToQuantity);
        SystemLibraryHelper.add(system, tb, new Conversion(ratioToQuantity, false));
        Operator integerToQuantity = new Operator("ToQuantity", new Signature(systemModel.getInteger()), systemModel.getQuantity());
        SystemLibraryHelper.add(system, tb, integerToQuantity);
        SystemLibraryHelper.add(system, tb, new Conversion(integerToQuantity, true));
        Operator decimalToQuantity = new Operator("ToQuantity", new Signature(systemModel.getDecimal()), systemModel.getQuantity());
        SystemLibraryHelper.add(system, tb, decimalToQuantity);
        SystemLibraryHelper.add(system, tb, new Conversion(decimalToQuantity, true));
        Operator stringToRatio = new Operator("ToRatio", new Signature(systemModel.getString()), systemModel.getRatio());
        SystemLibraryHelper.add(system, tb, stringToRatio);
        SystemLibraryHelper.add(system, tb, new Conversion(stringToRatio, false));
        Operator convertsTo = new Operator("ConvertsToBoolean", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToInteger", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToLong", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToDecimal", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToDateTime", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToDate", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToTime", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToString", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToQuantity", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        convertsTo = new Operator("ConvertsToRatio", new Signature(systemModel.getAny()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, convertsTo);
        Operator canConvertToQuantity = new Operator("CanConvertQuantity", new Signature(systemModel.getQuantity(), systemModel.getString()), systemModel.getBoolean());
        SystemLibraryHelper.add(system, tb, canConvertToQuantity);
        Operator convertToQuantity = new Operator("ConvertQuantity", new Signature(systemModel.getQuantity(), systemModel.getString()), systemModel.getQuantity());
        SystemLibraryHelper.add(system, tb, convertToQuantity);
        TypeParameter C = new TypeParameter("C", TypeParameter.TypeParameterConstraint.CLASS, null);
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equal", new Signature(new DataType[]{C, C}), systemModel.getBoolean(), C));
        TypeParameter R = new TypeParameter("R", TypeParameter.TypeParameterConstraint.TUPLE, null);
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equal", new Signature(new DataType[]{R, R}), systemModel.getBoolean(), R));
        TypeParameter H = new TypeParameter("H", TypeParameter.TypeParameterConstraint.CHOICE, null);
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equal", new Signature(new DataType[]{H, H}), systemModel.getBoolean(), H));
        C = new TypeParameter("C", TypeParameter.TypeParameterConstraint.CLASS, null);
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equivalent", new Signature(new DataType[]{C, C}), systemModel.getBoolean(), C));
        R = new TypeParameter("R", TypeParameter.TypeParameterConstraint.TUPLE, null);
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equivalent", new Signature(new DataType[]{R, R}), systemModel.getBoolean(), R));
        H = new TypeParameter("H", TypeParameter.TypeParameterConstraint.CHOICE, null);
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equivalent", new Signature(new DataType[]{H, H}), systemModel.getBoolean(), H));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getBoolean(), systemModel.getBoolean()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Less", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("LessOrEqual", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Greater", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("GreaterOrEqual", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Less", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("LessOrEqual", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Greater", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("GreaterOrEqual", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Less", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("LessOrEqual", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Greater", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("GreaterOrEqual", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Less", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("LessOrEqual", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Greater", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("GreaterOrEqual", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Less", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("LessOrEqual", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Greater", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("GreaterOrEqual", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Less", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("LessOrEqual", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Greater", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("GreaterOrEqual", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Less", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("LessOrEqual", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Greater", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("GreaterOrEqual", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Less", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("LessOrEqual", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Greater", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("GreaterOrEqual", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getRatio(), systemModel.getRatio()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getRatio(), systemModel.getRatio()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getCode(), systemModel.getCode()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getCode(), systemModel.getCode()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equal", new Signature(systemModel.getConcept(), systemModel.getConcept()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Equivalent", new Signature(systemModel.getConcept(), systemModel.getConcept()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Abs", new Signature(systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Abs", new Signature(systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Abs", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Abs", new Signature(systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Add", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Add", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Add", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Add", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Ceiling", new Signature(systemModel.getDecimal()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Divide", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Divide", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Exp", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Floor", new Signature(systemModel.getDecimal()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("HighBoundary", new Signature(systemModel.getDecimal(), systemModel.getInteger()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("HighBoundary", new Signature(systemModel.getDate(), systemModel.getInteger()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("HighBoundary", new Signature(systemModel.getDateTime(), systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("HighBoundary", new Signature(systemModel.getTime(), systemModel.getInteger()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Log", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("LowBoundary", new Signature(systemModel.getDecimal(), systemModel.getInteger()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("LowBoundary", new Signature(systemModel.getDate(), systemModel.getInteger()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("LowBoundary", new Signature(systemModel.getDateTime(), systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("LowBoundary", new Signature(systemModel.getTime(), systemModel.getInteger()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Ln", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Modulo", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Modulo", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Modulo", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Modulo", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Multiply", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Multiply", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Multiply", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Multiply", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Negate", new Signature(systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Negate", new Signature(systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Negate", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Negate", new Signature(systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Precision", new Signature(systemModel.getDecimal()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Precision", new Signature(systemModel.getDate()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Precision", new Signature(systemModel.getDateTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Precision", new Signature(systemModel.getTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Predecessor", new Signature(systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Predecessor", new Signature(systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Predecessor", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Predecessor", new Signature(systemModel.getDate()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Predecessor", new Signature(systemModel.getDateTime()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Predecessor", new Signature(systemModel.getTime()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Predecessor", new Signature(systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Power", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Power", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Power", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Round", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Round", new Signature(systemModel.getDecimal(), systemModel.getInteger()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Subtract", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Subtract", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Subtract", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Subtract", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Successor", new Signature(systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Successor", new Signature(systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Successor", new Signature(systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Successor", new Signature(systemModel.getDate()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Successor", new Signature(systemModel.getDateTime()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Successor", new Signature(systemModel.getTime()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Successor", new Signature(systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Truncate", new Signature(systemModel.getDecimal()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("TruncatedDivide", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("TruncatedDivide", new Signature(systemModel.getLong(), systemModel.getLong()), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("TruncatedDivide", new Signature(systemModel.getDecimal(), systemModel.getDecimal()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("TruncatedDivide", new Signature(systemModel.getQuantity(), systemModel.getQuantity()), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Add", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Combine", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Combine", new Signature(new DataType[]{new ListType(systemModel.getString()), systemModel.getString()}), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Concatenate", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("EndsWith", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Indexer", new Signature(systemModel.getString(), systemModel.getInteger()), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("LastPositionOf", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Length", new Signature(systemModel.getString()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Lower", new Signature(systemModel.getString()), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Matches", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("PositionOf", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("ReplaceMatches", new Signature(systemModel.getString(), systemModel.getString(), systemModel.getString()), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Split", new Signature(systemModel.getString(), systemModel.getString()), (DataType)new ListType(systemModel.getString())));
        SystemLibraryHelper.add(system, tb, new Operator("SplitOnMatches", new Signature(systemModel.getString(), systemModel.getString()), (DataType)new ListType(systemModel.getString())));
        SystemLibraryHelper.add(system, tb, new Operator("StartsWith", new Signature(systemModel.getString(), systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Substring", new Signature(systemModel.getString(), systemModel.getInteger()), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Substring", new Signature(systemModel.getString(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Upper", new Signature(systemModel.getString()), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Add", new Signature(systemModel.getDateTime(), systemModel.getQuantity()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Add", new Signature(systemModel.getDate(), systemModel.getQuantity()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Add", new Signature(systemModel.getTime(), systemModel.getQuantity()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("After", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("After", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("After", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Before", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Before", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Before", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTime", new Signature(systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTime", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getDecimal()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Date", new Signature(systemModel.getInteger()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Date", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Date", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("DateFrom", new Signature(systemModel.getDateTime()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("TimeFrom", new Signature(systemModel.getDateTime()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("TimezoneFrom", new Signature(systemModel.getDateTime()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("TimezoneOffsetFrom", new Signature(systemModel.getDateTime()), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTimeComponentFrom", new Signature(systemModel.getDateTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTimeComponentFrom", new Signature(systemModel.getDate()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("DateTimeComponentFrom", new Signature(systemModel.getTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("DifferenceBetween", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("DifferenceBetween", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("DifferenceBetween", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("DurationBetween", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("DurationBetween", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("DurationBetween", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Now", new Signature(new DataType[0]), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("SameAs", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SameAs", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SameAs", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SameOrAfter", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SameOrAfter", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SameOrAfter", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SameOrBefore", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SameOrBefore", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SameOrBefore", new Signature(systemModel.getTime(), systemModel.getTime()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Subtract", new Signature(systemModel.getDateTime(), systemModel.getQuantity()), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Subtract", new Signature(systemModel.getDate(), systemModel.getQuantity()), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Subtract", new Signature(systemModel.getTime(), systemModel.getQuantity()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Today", new Signature(new DataType[0]), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Time", new Signature(systemModel.getInteger()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Time", new Signature(systemModel.getInteger(), systemModel.getInteger()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Time", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Time", new Signature(systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger(), systemModel.getInteger()), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("TimeOfDay", new Signature(new DataType[0]), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new GenericOperator("After", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Before", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Collapse", new Signature(new DataType[]{new ListType((DataType)new IntervalType((DataType)new TypeParameter("T"))), systemModel.getQuantity()}), (DataType)new ListType((DataType)new IntervalType((DataType)new TypeParameter("T"))), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Contains", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("End", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Ends", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equal", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equivalent", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Except", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Expand", new Signature(new DataType[]{new ListType((DataType)new IntervalType((DataType)new TypeParameter("T"))), systemModel.getQuantity()}), (DataType)new ListType((DataType)new IntervalType((DataType)new TypeParameter("T"))), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Expand", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), systemModel.getQuantity()}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("In", new Signature(new DataType[]{new TypeParameter("T"), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Includes", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("IncludedIn", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Intersect", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Meets", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("MeetsBefore", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("MeetsAfter", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Overlaps", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("OverlapsBefore", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("OverlapsAfter", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        GenericOperator pointFrom = new GenericOperator("PointFrom", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T"));
        SystemLibraryHelper.add(system, tb, pointFrom);
        SystemLibraryHelper.add(system, tb, new GenericOperator("ProperContains", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("ProperIn", new Signature(new DataType[]{new TypeParameter("T"), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("ProperIncludes", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("ProperIncludedIn", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("SameAs", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("SameOrAfter", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("SameOrBefore", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Size", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Start", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Starts", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Union", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T")), new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new IntervalType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Width", new Signature(new DataType[]{new IntervalType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Contains", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Distinct", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equal", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Equivalent", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Except", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Exists", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Flatten", new Signature(new DataType[]{new ListType((DataType)new ListType((DataType)new TypeParameter("T")))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("First", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("In", new Signature(new DataType[]{new TypeParameter("T"), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Includes", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("IncludedIn", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Indexer", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), systemModel.getInteger()}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("IndexOf", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getInteger(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Intersect", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Last", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Length", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), systemModel.getInteger(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("ProperContains", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("ProperIn", new Signature(new DataType[]{new TypeParameter("T"), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("ProperIncludes", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("ProperIncludedIn", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), systemModel.getBoolean(), new TypeParameter("T")));
        GenericOperator singletonFrom = new GenericOperator("SingletonFrom", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T"));
        SystemLibraryHelper.add(system, tb, singletonFrom);
        SystemLibraryHelper.add(system, tb, new GenericOperator("Skip", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), systemModel.getInteger()}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Tail", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Take", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), systemModel.getInteger()}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Union", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T")), new ListType((DataType)new TypeParameter("T"))}), (DataType)new ListType((DataType)new TypeParameter("T")), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new Operator("AllTrue", new Signature(new DataType[]{new ListType(systemModel.getBoolean())}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyTrue", new Signature(new DataType[]{new ListType(systemModel.getBoolean())}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Avg", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Avg", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Count", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), systemModel.getInteger(), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new Operator("GeometricMean", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getInteger())}), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getLong())}), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getDateTime())}), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getDate())}), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getTime())}), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Max", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getInteger())}), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getLong())}), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getDateTime())}), systemModel.getDateTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getDate())}), systemModel.getDate()));
        SystemLibraryHelper.add(system, tb, new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getTime())}), systemModel.getTime()));
        SystemLibraryHelper.add(system, tb, new Operator("Min", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getString()));
        SystemLibraryHelper.add(system, tb, new Operator("Median", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Median", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Mode", new Signature(new DataType[]{new ListType((DataType)new TypeParameter("T"))}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        SystemLibraryHelper.add(system, tb, new Operator("PopulationStdDev", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("PopulationStdDev", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("PopulationVariance", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("PopulationVariance", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Product", new Signature(new DataType[]{new ListType(systemModel.getInteger())}), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Product", new Signature(new DataType[]{new ListType(systemModel.getLong())}), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Product", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Product", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("StdDev", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("StdDev", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Sum", new Signature(new DataType[]{new ListType(systemModel.getInteger())}), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("Sum", new Signature(new DataType[]{new ListType(systemModel.getLong())}), systemModel.getLong()));
        SystemLibraryHelper.add(system, tb, new Operator("Sum", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Sum", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        SystemLibraryHelper.add(system, tb, new Operator("Variance", new Signature(new DataType[]{new ListType(systemModel.getDecimal())}), systemModel.getDecimal()));
        SystemLibraryHelper.add(system, tb, new Operator("Variance", new Signature(new DataType[]{new ListType(systemModel.getQuantity())}), systemModel.getQuantity()));
        Operator codeToConcept = new Operator("ToConcept", new Signature(systemModel.getCode()), systemModel.getConcept());
        SystemLibraryHelper.add(system, tb, codeToConcept);
        SystemLibraryHelper.add(system, tb, new Conversion(codeToConcept, true));
        Operator codesToConcept = new Operator("ToConcept", new Signature(new DataType[]{new ListType(systemModel.getCode())}), systemModel.getConcept());
        SystemLibraryHelper.add(system, tb, codesToConcept);
        SystemLibraryHelper.add(system, tb, new Conversion(codesToConcept, false));
        SystemLibraryHelper.add(system, tb, new Operator("CalculateAge", new Signature(systemModel.getDateTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("CalculateAge", new Signature(systemModel.getDate()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("CalculateAgeAt", new Signature(systemModel.getDateTime(), systemModel.getDateTime()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("CalculateAgeAt", new Signature(systemModel.getDate(), systemModel.getDate()), systemModel.getInteger()));
        SystemLibraryHelper.add(system, tb, new Operator("InValueSet", new Signature(systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InValueSet", new Signature(systemModel.getCode()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InValueSet", new Signature(systemModel.getConcept()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InValueSet", new Signature(systemModel.getString(), systemModel.getValueSet()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InValueSet", new Signature(systemModel.getCode(), systemModel.getValueSet()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InValueSet", new Signature(systemModel.getConcept(), systemModel.getValueSet()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getCode())}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getConcept())}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getString()), systemModel.getValueSet()}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getCode()), systemModel.getValueSet()}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInValueSet", new Signature(new DataType[]{new ListType(systemModel.getConcept()), systemModel.getValueSet()}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InCodeSystem", new Signature(systemModel.getString()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InCodeSystem", new Signature(systemModel.getCode()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InCodeSystem", new Signature(systemModel.getConcept()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InCodeSystem", new Signature(systemModel.getString(), systemModel.getCodeSystem()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InCodeSystem", new Signature(systemModel.getCode(), systemModel.getCodeSystem()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("InCodeSystem", new Signature(systemModel.getConcept(), systemModel.getCodeSystem()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getString())}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getCode())}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getConcept())}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getString()), systemModel.getCodeSystem()}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getCode()), systemModel.getCodeSystem()}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("AnyInCodeSystem", new Signature(new DataType[]{new ListType(systemModel.getConcept()), systemModel.getCodeSystem()}), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Subsumes", new Signature(systemModel.getCode(), systemModel.getCode()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("Subsumes", new Signature(systemModel.getConcept(), systemModel.getConcept()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SubsumedBy", new Signature(systemModel.getCode(), systemModel.getCode()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new Operator("SubsumedBy", new Signature(systemModel.getConcept(), systemModel.getConcept()), systemModel.getBoolean()));
        SystemLibraryHelper.add(system, tb, new GenericOperator("Message", new Signature(new DataType[]{new TypeParameter("T"), systemModel.getBoolean(), systemModel.getString(), systemModel.getString(), systemModel.getString()}), (DataType)new TypeParameter("T"), new TypeParameter("T")));
        return system;
    }

    private static void add(TranslatedLibrary systemLibrary, TypeBuilder tb, Operator operator) {
        FunctionDef fd = new FunctionDef();
        fd.setName(operator.getName());
        int n = 0;
        for (DataType dataType : operator.getSignature().getOperandTypes()) {
            OperandDef od = new OperandDef().withName(String.format("param%d", ++n));
            if (dataType instanceof NamedType) {
                od.setOperandType(tb.dataTypeToQName(dataType));
            } else {
                od.setOperandTypeSpecifier(tb.dataTypeToTypeSpecifier(dataType));
            }
            od.setResultType(dataType);
            fd.getOperand().add(od);
        }
        operator.setFunctionDef(fd);
        systemLibrary.add(fd, operator);
    }

    private static void add(TranslatedLibrary systemLibrary, TypeBuilder tb, Conversion conversion) {
        systemLibrary.add(conversion);
    }
}

