/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cqframework.cql.cql2elm.ModelInfoLoader;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class ModelManager {
    private NamespaceManager namespaceManager;
    private ModelInfoLoader modelInfoLoader;
    private final Map<String, Model> models = new HashMap<String, Model>();
    private final Set<String> loadingModels = new HashSet<String>();
    private final Map<String, Model> modelsByUri = new HashMap<String, Model>();

    public ModelManager() {
        this.namespaceManager = new NamespaceManager();
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
        this.initialize();
    }

    private void initialize() {
        this.modelInfoLoader = new ModelInfoLoader();
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public ModelInfoLoader getModelInfoLoader() {
        return this.modelInfoLoader;
    }

    public boolean isWellKnownModelName(String unqualifiedIdentifier) {
        if (unqualifiedIdentifier == null) {
            return false;
        }
        switch (unqualifiedIdentifier) {
            case "FHIR": 
            case "QDM": 
            case "USCore": 
            case "QICore": 
            case "QUICK": {
                return true;
            }
        }
        return false;
    }

    private Model buildModel(VersionedIdentifier identifier) {
        Model model = null;
        if (identifier == null) {
            throw new IllegalArgumentException("Model identifier is required");
        }
        if (identifier.getId() == null || identifier.getId().equals("")) {
            throw new IllegalArgumentException("Model identifier Id is required");
        }
        String modelPath = NamespaceManager.getPath(identifier.getSystem(), identifier.getId());
        this.pushLoading(modelPath);
        try {
            ModelInfo modelInfo = this.modelInfoLoader.getModelInfo(identifier);
            model = identifier.getId().equals("System") ? new SystemModel(modelInfo) : new Model(modelInfo, this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s.", identifier.getId(), identifier.getVersion()));
        }
        finally {
            this.popLoading(modelPath);
        }
        return model;
    }

    private void pushLoading(String modelId) {
        if (this.loadingModels.contains(modelId)) {
            throw new IllegalArgumentException(String.format("Circular model reference %s", modelId));
        }
        this.loadingModels.add(modelId);
    }

    private void popLoading(String modelId) {
        this.loadingModels.remove(modelId);
    }

    public Model resolveModel(String modelName) {
        return this.resolveModel(modelName, null);
    }

    public Model resolveModel(String modelName, String version) {
        return this.resolveModel(new VersionedIdentifier().withId(modelName).withVersion(version));
    }

    public Model resolveModel(VersionedIdentifier modelIdentifier) {
        String modelPath = NamespaceManager.getPath(modelIdentifier.getSystem(), modelIdentifier.getId());
        Model model = this.models.get(modelPath);
        if (model == null) {
            model = this.buildModel(modelIdentifier);
            this.models.put(modelPath, model);
            this.modelsByUri.put(model.getModelInfo().getUrl(), model);
        }
        if (modelIdentifier.getVersion() != null && !modelIdentifier.getVersion().equals(model.getModelInfo().getVersion())) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s because version %s is already loaded.", modelIdentifier.getId(), modelIdentifier.getVersion(), model.getModelInfo().getVersion()));
        }
        return model;
    }

    public Model resolveModelByUri(String namespaceUri) {
        Model model = this.modelsByUri.get(namespaceUri);
        if (model == null) {
            throw new IllegalArgumentException(String.format("Could not resolve model with namespace %s", namespaceUri));
        }
        return model;
    }
}

