/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.cqframework.cql.cql2elm.Cql2ElmVisitor;
import org.cqframework.cql.cql2elm.DataTypes;
import org.cqframework.cql.cql2elm.LibraryBuilder;
import org.cqframework.cql.cql2elm.model.QueryContext;
import org.cqframework.cql.gen.cqlParser;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.Children;
import org.hl7.elm.r1.Descendents;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.If;
import org.hl7.elm.r1.Is;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryLetRef;
import org.hl7.elm.r1.Repeat;
import org.hl7.elm.r1.ReturnClause;

public class SystemMethodResolver {
    private final ObjectFactory of = new ObjectFactory();
    private final Cql2ElmVisitor visitor;
    private final LibraryBuilder builder;

    public SystemMethodResolver(Cql2ElmVisitor visitor, LibraryBuilder builder) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor is null");
        }
        if (builder == null) {
            throw new IllegalArgumentException("builder is null");
        }
        this.visitor = visitor;
        this.builder = builder;
    }

    private List<Expression> getParams(Expression target, cqlParser.ParamListContext ctx) {
        ArrayList<Expression> params = new ArrayList<Expression>();
        params.add(target);
        if (ctx != null && ctx.expression() != null) {
            for (cqlParser.ExpressionContext param : ctx.expression()) {
                params.add((Expression)this.visitor.visit((ParseTree)param));
            }
        }
        return params;
    }

    private void checkArgumentCount(cqlParser.ParamListContext ctx, String functionName, int expectedCount) {
        int actualCount = 0;
        if (ctx != null && ctx.expression() != null) {
            actualCount = ctx.expression().size();
        }
        if (actualCount != expectedCount) {
            throw new IllegalArgumentException(String.format("Expected %s argument for method %s.", Integer.valueOf(expectedCount).toString(), functionName));
        }
    }

    private AliasedQuerySource enterQueryContext(Expression target) {
        QueryContext queryContext = new QueryContext();
        queryContext.setIsImplicit(true);
        ArrayList<AliasedQuerySource> sources = new ArrayList<AliasedQuerySource>();
        AliasedQuerySource source = this.of.createAliasedQuerySource().withExpression(target).withAlias("$this");
        source.setResultType(target.getResultType());
        sources.add(source);
        queryContext.addPrimaryQuerySources(sources);
        this.builder.pushQueryContext(queryContext);
        return source;
    }

    private Query createQuery(AliasedQuerySource source, LetClause let, Expression where, ReturnClause ret) {
        QueryContext queryContext = this.builder.peekQueryContext();
        ArrayList<LetClause> lets = null;
        if (let != null) {
            lets = new ArrayList<LetClause>();
            lets.add(let);
        }
        Query query = this.of.createQuery().withSource(queryContext.getQuerySources()).withLet(lets).withWhere(where).withReturn(ret);
        if (ret != null) {
            query.setResultType(ret.getResultType());
        } else {
            query.setResultType(source.getResultType());
        }
        return query;
    }

    private void exitQueryContext() {
        this.builder.popQueryContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query createWhere(Expression target, String functionName, cqlParser.ParamListContext ctx) {
        AliasedQuerySource source = this.enterQueryContext(target);
        try {
            this.checkArgumentCount(ctx, functionName, 1);
            Expression where = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
            if (this.visitor.getDateRangeOptimization()) {
                where = this.visitor.optimizeDateRangeInQuery(where, source);
            }
            Query query = this.createQuery(source, null, where, null);
            return query;
        }
        finally {
            this.exitQueryContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression createOfType(Expression target, String functionName, cqlParser.ParamListContext ctx) {
        AliasedQuerySource source = this.enterQueryContext(target);
        try {
            this.checkArgumentCount(ctx, functionName, 1);
            Expression typeArgument = null;
            this.builder.pushTypeSpecifierContext();
            try {
                typeArgument = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
            }
            finally {
                this.builder.popTypeSpecifierContext();
            }
            if (!(typeArgument instanceof Literal)) {
                throw new IllegalArgumentException("Expected literal argument");
            }
            Literal typeLiteral = (Literal)typeArgument;
            if (!DataTypes.equal(typeLiteral.getResultType(), this.builder.resolveTypeName("System", "String"))) {
                throw new IllegalArgumentException("Expected string literal argument");
            }
            String typeSpecifier = ((Literal)typeArgument).getValue();
            DataType isType = this.builder.resolveTypeSpecifier(typeSpecifier);
            AliasRef thisRef = this.of.createAliasRef().withName(source.getAlias());
            boolean isSingular = !(source.getResultType() instanceof ListType);
            DataType elementType = isSingular ? source.getResultType() : ((ListType)source.getResultType()).getElementType();
            thisRef.setResultType(elementType);
            Is is = this.of.createIs().withOperand((Expression)thisRef);
            if (isType instanceof NamedType) {
                is.setIsType(this.builder.dataTypeToQName(isType));
            } else {
                is.setIsTypeSpecifier(this.builder.dataTypeToTypeSpecifier(isType));
            }
            is.setResultType(this.builder.resolveTypeName("System", "Boolean"));
            Query query = this.createQuery(source, null, (Expression)is, null);
            return query;
        }
        finally {
            this.exitQueryContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression createRepeat(Expression target, String functionName, cqlParser.ParamListContext ctx) {
        AliasedQuerySource source = this.enterQueryContext(target);
        try {
            boolean isSingular = !(source.getResultType() instanceof ListType);
            this.checkArgumentCount(ctx, functionName, 1);
            Expression select = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
            Repeat repeat = this.of.createRepeat();
            repeat.setSource(target);
            repeat.setElement(select);
            repeat.setScope("$this");
            if (isSingular) {
                repeat.setResultType((DataType)new ListType(select.getResultType()));
            } else {
                repeat.setResultType(select.getResultType());
            }
            Repeat repeat2 = repeat;
            return repeat2;
        }
        finally {
            this.exitQueryContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression createSelect(Expression target, String functionName, cqlParser.ParamListContext ctx) {
        boolean isListResult = false;
        boolean isSingular = false;
        AliasedQuerySource source = this.enterQueryContext(target);
        try {
            isSingular = !(source.getResultType() instanceof ListType);
            this.checkArgumentCount(ctx, functionName, 1);
            Expression select = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
            QueryContext queryContext = this.builder.peekQueryContext();
            LetClause let = this.of.createLetClause().withExpression(select).withIdentifier("$a");
            let.setResultType(select.getResultType());
            queryContext.addLetClause(let);
            isListResult = select.getResultType() instanceof ListType;
            QueryLetRef letRef = this.of.createQueryLetRef().withName("$a");
            letRef.setResultType(select.getResultType());
            ArrayList<Object> params = new ArrayList<Expression>();
            params.add(letRef);
            Expression where = this.builder.resolveFunction(null, "IsNull", params);
            params = new ArrayList();
            params.add(where);
            where = this.builder.resolveFunction(null, "Not", params);
            ReturnClause returnClause = this.of.createReturnClause();
            letRef = this.of.createQueryLetRef().withName("$a");
            letRef.setResultType(select.getResultType());
            returnClause.setExpression((Expression)letRef);
            returnClause.setResultType((DataType)(isSingular ? letRef.getResultType() : new ListType(letRef.getResultType())));
            Query query = this.createQuery(source, let, where, returnClause);
            if (!isSingular && isListResult) {
                params = new ArrayList();
                params.add((Expression)query);
                Expression expression = this.builder.resolveFunction(null, "Flatten", params);
                return expression;
            }
            Query query2 = query;
            return query2;
        }
        finally {
            this.exitQueryContext();
        }
    }

    private void gatherChildTypes(DataType dataType, boolean recurse, Set<DataType> dataTypes) {
        if (dataType instanceof ClassType) {
            for (ClassTypeElement element : ((ClassType)dataType).getElements()) {
                DataType elementType = element.getType() instanceof ListType ? ((ListType)element.getType()).getElementType() : element.getType();
                dataTypes.add(elementType);
                if (!recurse) continue;
                this.gatherChildTypes(elementType, recurse, dataTypes);
            }
        } else if (dataType instanceof TupleType) {
            for (TupleTypeElement element : ((TupleType)dataType).getElements()) {
                DataType elementType = element.getType() instanceof ListType ? ((ListType)element.getType()).getElementType() : element.getType();
                dataTypes.add(elementType);
                if (!recurse) continue;
                this.gatherChildTypes(elementType, recurse, dataTypes);
            }
        } else if (dataType instanceof ListType) {
            DataType elementType = ((ListType)dataType).getElementType();
            dataTypes.add(elementType);
            if (recurse) {
                this.gatherChildTypes(elementType, recurse, dataTypes);
            }
        } else {
            dataTypes.add(this.builder.resolveTypeName("System.Any"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression resolveMethod(Expression target, String functionName, cqlParser.ParamListContext ctx, boolean mustResolve) {
        switch (functionName) {
            case "aggregate": {
                return this.builder.resolveFunction(null, "Aggregate", this.getParams(target, ctx));
            }
            case "abs": {
                return this.builder.resolveFunction(null, "Abs", this.getParams(target, ctx));
            }
            case "all": {
                Query query = this.createWhere(target, functionName, ctx);
                ReturnClause returnClause = this.of.createReturnClause();
                returnClause.setExpression((Expression)this.builder.createLiteral(true));
                if (query.getResultType() instanceof ListType) {
                    returnClause.setResultType((DataType)new ListType(returnClause.getExpression().getResultType()));
                } else {
                    returnClause.setResultType(returnClause.getExpression().getResultType());
                }
                query.setReturn(returnClause);
                query.setResultType(returnClause.getResultType());
                ArrayList<Expression> params = new ArrayList<Expression>();
                params.add((Expression)query);
                return this.builder.resolveFunction(null, "AllTrue", params);
            }
            case "allTrue": {
                return this.builder.resolveFunction(null, "AllTrue", this.getParams(target, ctx));
            }
            case "anyTrue": {
                return this.builder.resolveFunction(null, "AnyTrue", this.getParams(target, ctx));
            }
            case "allFalse": {
                return this.builder.resolveFunction(null, "AllFalse", this.getParams(target, ctx));
            }
            case "anyFalse": {
                return this.builder.resolveFunction(null, "AnyFalse", this.getParams(target, ctx));
            }
            case "ceiling": {
                return this.builder.resolveFunction(null, "Ceiling", this.getParams(target, ctx));
            }
            case "children": {
                this.checkArgumentCount(ctx, functionName, 0);
                Children children = this.of.createChildren();
                children.setSource(target);
                HashSet<DataType> dataTypes = new HashSet<DataType>();
                this.gatherChildTypes(target.getResultType(), false, dataTypes);
                if (dataTypes.size() == 1) {
                    children.setResultType((DataType)new ListType((DataType)dataTypes.toArray()[0]));
                } else {
                    children.setResultType((DataType)new ListType((DataType)new ChoiceType(dataTypes)));
                }
                return children;
            }
            case "combine": {
                this.checkArgumentCount(ctx, functionName, 1);
                ArrayList<Expression> elements = new ArrayList<Expression>();
                Expression argument = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
                elements.add(target);
                elements.add(argument);
                DataType elementType = this.builder.ensureCompatibleTypes(target.getResultType(), argument.getResultType());
                org.hl7.elm.r1.List list = this.of.createList();
                list.setResultType((DataType)new ListType(elementType));
                list.getElement().add(this.builder.ensureCompatible(target, elementType));
                list.getElement().add(this.builder.ensureCompatible(argument, elementType));
                ArrayList<Expression> params = new ArrayList<Expression>();
                params.add((Expression)list);
                return this.builder.resolveFunction(null, "Flatten", params);
            }
            case "contains": {
                this.checkArgumentCount(ctx, functionName, 1);
                ArrayList<Object> params = new ArrayList<Expression>();
                Expression argument = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
                params.add(argument);
                params.add(target);
                Expression result = this.builder.resolveFunction(null, "PositionOf", params);
                params = new ArrayList();
                params.add(result);
                params.add(this.builder.createLiteral(0));
                return this.builder.resolveFunction(null, "GreaterOrEqual", params);
            }
            case "convertsToBoolean": {
                return this.builder.resolveFunction(null, "ConvertsToBoolean", this.getParams(target, ctx));
            }
            case "convertsToDate": {
                return this.builder.resolveFunction(null, "ConvertsToDate", this.getParams(target, ctx));
            }
            case "convertsToDateTime": {
                return this.builder.resolveFunction(null, "ConvertsToDateTime", this.getParams(target, ctx));
            }
            case "convertsToDecimal": {
                return this.builder.resolveFunction(null, "ConvertsToDecimal", this.getParams(target, ctx));
            }
            case "convertsToInteger": {
                return this.builder.resolveFunction(null, "ConvertsToInteger", this.getParams(target, ctx));
            }
            case "convertsToQuantity": {
                return this.builder.resolveFunction(null, "ConvertsToQuantity", this.getParams(target, ctx));
            }
            case "convertsToString": {
                return this.builder.resolveFunction(null, "ConvertsToString", this.getParams(target, ctx));
            }
            case "convertsToTime": {
                return this.builder.resolveFunction(null, "ConvertsToTime", this.getParams(target, ctx));
            }
            case "count": {
                return this.builder.resolveFunction(null, "Count", this.getParams(target, ctx));
            }
            case "descendents": {
                this.checkArgumentCount(ctx, functionName, 0);
                Descendents descendents = this.of.createDescendents();
                descendents.setSource(target);
                HashSet<DataType> dataTypes = new HashSet<DataType>();
                this.gatherChildTypes(target.getResultType(), true, dataTypes);
                if (dataTypes.size() == 1) {
                    descendents.setResultType((DataType)new ListType((DataType)dataTypes.toArray()[0]));
                } else {
                    descendents.setResultType((DataType)new ListType((DataType)new ChoiceType(dataTypes)));
                }
                return descendents;
            }
            case "distinct": {
                return this.builder.resolveFunction(null, "Distinct", this.getParams(target, ctx));
            }
            case "empty": {
                List<Expression> params = this.getParams(target, ctx);
                Expression exists = this.builder.resolveFunction(null, "Exists", params);
                params = new ArrayList<Expression>();
                params.add(exists);
                return this.builder.resolveFunction(null, "Not", params);
            }
            case "endsWith": {
                return this.builder.resolveFunction(null, "EndsWith", this.getParams(target, ctx));
            }
            case "exclude": {
                return this.builder.resolveFunction(null, "Except", this.getParams(target, ctx));
            }
            case "exists": {
                if (ctx == null || ctx.expression() == null || ctx.expression().isEmpty()) {
                    List<Expression> params = this.getParams(target, ctx);
                    return this.builder.resolveFunction(null, "Exists", params);
                }
                Query query = this.createWhere(target, functionName, ctx);
                ArrayList<Expression> params = new ArrayList<Expression>();
                params.add((Expression)query);
                return this.builder.resolveFunction(null, "Exists", params);
            }
            case "exp": {
                return this.builder.resolveFunction(null, "Exp", this.getParams(target, ctx));
            }
            case "first": {
                return this.builder.resolveFunction(null, "First", this.getParams(target, ctx));
            }
            case "floor": {
                return this.builder.resolveFunction(null, "Floor", this.getParams(target, ctx));
            }
            case "hasValue": {
                List<Expression> params = this.getParams(target, ctx);
                Expression isNull = this.builder.resolveFunction(null, "IsNull", params);
                params = new ArrayList<Expression>();
                params.add(isNull);
                return this.builder.resolveFunction(null, "Not", params);
            }
            case "iif": {
                Expression result = target;
                ArrayList<Expression> params = null;
                if (result.getResultType() instanceof ListType) {
                    params = new ArrayList<Expression>();
                    params.add(result);
                    result = this.builder.resolveFunction(null, "SingletonFrom", params);
                }
                Expression thenExpression = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
                Null elseExpression = ctx.expression().size() == 2 ? (Expression)this.visitor.visit((ParseTree)ctx.expression(1)) : this.of.createNull();
                result = this.of.createIf().withCondition(result).withThen(thenExpression).withElse((Expression)elseExpression);
                return this.visitor.resolveIfThenElse((If)result);
            }
            case "indexOf": {
                this.checkArgumentCount(ctx, functionName, 1);
                ArrayList<Expression> params = new ArrayList<Expression>();
                Expression argument = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
                params.add(argument);
                params.add(target);
                return this.builder.resolveFunction(null, "PositionOf", params);
            }
            case "intersect": {
                return this.builder.resolveFunction(null, "Intersect", this.getParams(target, ctx));
            }
            case "is": 
            case "as": {
                this.checkArgumentCount(ctx, functionName, 1);
                Expression typeArgument = null;
                this.builder.pushTypeSpecifierContext();
                try {
                    typeArgument = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
                }
                finally {
                    this.builder.popTypeSpecifierContext();
                }
                if (!(typeArgument instanceof Literal)) {
                    throw new IllegalArgumentException("Expected literal argument");
                }
                Literal typeLiteral = (Literal)typeArgument;
                if (!DataTypes.equal(typeLiteral.getResultType(), this.builder.resolveTypeName("System", "String"))) {
                    throw new IllegalArgumentException("Expected string literal argument");
                }
                String typeSpecifier = ((Literal)typeArgument).getValue();
                DataType isType = this.builder.resolveTypeSpecifier(typeSpecifier);
                return functionName.equals("is") ? this.builder.buildIs(target, isType) : this.builder.buildAs(target, isType);
            }
            case "last": {
                return this.builder.resolveFunction(null, "Last", this.getParams(target, ctx));
            }
            case "lastIndexOf": {
                this.checkArgumentCount(ctx, functionName, 1);
                ArrayList<Expression> params = new ArrayList<Expression>();
                Expression argument = (Expression)this.visitor.visit((ParseTree)ctx.expression(0));
                params.add(argument);
                params.add(target);
                return this.builder.resolveFunction(null, "LastPositionOf", params);
            }
            case "length": {
                return this.builder.resolveFunction(null, "Length", this.getParams(target, ctx));
            }
            case "ln": {
                return this.builder.resolveFunction(null, "Ln", this.getParams(target, ctx));
            }
            case "log": {
                return this.builder.resolveFunction(null, "Log", this.getParams(target, ctx));
            }
            case "lower": {
                return this.builder.resolveFunction(null, "Lower", this.getParams(target, ctx));
            }
            case "matches": {
                return this.builder.resolveFunction(null, "Matches", this.getParams(target, ctx));
            }
            case "memberOf": {
                return this.builder.resolveFunction(null, "InValueSet", this.getParams(target, ctx));
            }
            case "not": {
                return this.builder.resolveFunction(null, "Not", this.getParams(target, ctx));
            }
            case "now": {
                return this.builder.resolveFunction(null, "Now", this.getParams(target, ctx));
            }
            case "ofType": {
                return this.createOfType(target, functionName, ctx);
            }
            case "power": {
                return this.builder.resolveFunction(null, "Power", this.getParams(target, ctx));
            }
            case "repeat": {
                return this.createRepeat(target, functionName, ctx);
            }
            case "replace": {
                return this.builder.resolveFunction(null, "Replace", this.getParams(target, ctx));
            }
            case "replaceMatches": {
                return this.builder.resolveFunction(null, "ReplaceMatches", this.getParams(target, ctx));
            }
            case "round": {
                return this.builder.resolveFunction(null, "Round", this.getParams(target, ctx));
            }
            case "select": {
                return this.createSelect(target, functionName, ctx);
            }
            case "single": {
                return this.builder.resolveFunction(null, "SingletonFrom", this.getParams(target, ctx));
            }
            case "skip": {
                return this.builder.resolveFunction(null, "Skip", this.getParams(target, ctx));
            }
            case "sqrt": {
                this.checkArgumentCount(ctx, functionName, 0);
                ArrayList<Expression> params = new ArrayList<Expression>();
                params.add(target);
                params.add((Expression)this.builder.createLiteral(0.5));
                return this.builder.resolveFunction(null, "Power", params);
            }
            case "startsWith": {
                return this.builder.resolveFunction(null, "StartsWith", this.getParams(target, ctx));
            }
            case "subsetOf": {
                return this.builder.resolveFunction(null, "IncludedIn", this.getParams(target, ctx));
            }
            case "substring": {
                return this.builder.resolveFunction(null, "Substring", this.getParams(target, ctx));
            }
            case "subsumes": {
                return this.builder.resolveFunction(null, "Subsumes", this.getParams(target, ctx));
            }
            case "subsumedBy": {
                return this.builder.resolveFunction(null, "SubsumedBy", this.getParams(target, ctx));
            }
            case "supersetOf": {
                return this.builder.resolveFunction(null, "Includes", this.getParams(target, ctx));
            }
            case "tail": {
                return this.builder.resolveFunction(null, "Tail", this.getParams(target, ctx));
            }
            case "take": {
                return this.builder.resolveFunction(null, "Take", this.getParams(target, ctx));
            }
            case "timeOfDay": {
                return this.builder.resolveFunction(null, "TimeOfDay", this.getParams(target, ctx));
            }
            case "toBoolean": {
                return this.builder.resolveFunction(null, "ToBoolean", this.getParams(target, ctx));
            }
            case "toChars": {
                return this.builder.resolveFunction(null, "ToChars", this.getParams(target, ctx));
            }
            case "toDate": {
                return this.builder.resolveFunction(null, "ToDate", this.getParams(target, ctx));
            }
            case "toDateTime": {
                return this.builder.resolveFunction(null, "ToDateTime", this.getParams(target, ctx));
            }
            case "today": {
                return this.builder.resolveFunction(null, "Today", this.getParams(target, ctx));
            }
            case "toDecimal": {
                return this.builder.resolveFunction(null, "ToDecimal", this.getParams(target, ctx));
            }
            case "toInteger": {
                return this.builder.resolveFunction(null, "ToInteger", this.getParams(target, ctx));
            }
            case "toQuantity": {
                return this.builder.resolveFunction(null, "ToQuantity", this.getParams(target, ctx));
            }
            case "toString": {
                return this.builder.resolveFunction(null, "ToString", this.getParams(target, ctx));
            }
            case "toTime": {
                return this.builder.resolveFunction(null, "ToTime", this.getParams(target, ctx));
            }
            case "trace": {
                this.checkArgumentCount(ctx, functionName, 1);
                ArrayList<Expression> params = new ArrayList<Expression>();
                params.add(target);
                params.add((Expression)this.builder.createLiteral(true));
                params.add((Expression)this.builder.createLiteral("TRACE"));
                params.add((Expression)this.builder.createLiteral("Trace"));
                params.add((Expression)this.visitor.visit((ParseTree)ctx.expression(0)));
                return this.builder.resolveFunction(null, "Message", params);
            }
            case "truncate": {
                return this.builder.resolveFunction(null, "Truncate", this.getParams(target, ctx));
            }
            case "upper": {
                return this.builder.resolveFunction(null, "Upper", this.getParams(target, ctx));
            }
            case "where": {
                return this.createWhere(target, functionName, ctx);
            }
        }
        return this.visitor.resolveFunction(null, functionName, this.getParams(target, ctx), mustResolve, false, true);
    }
}

