/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlTranslator;
import org.cqframework.cql.cql2elm.LibraryBuilder;

public class CqlTranslatorOptions {
    private List<CqlTranslator.Format> formats = new ArrayList<CqlTranslator.Format>();
    private EnumSet<Options> options = EnumSet.noneOf(Options.class);
    private boolean validateUnits = true;
    private boolean verifyOnly = false;
    private boolean enableCqlOnly = false;
    private String compatibilityLevel = "1.5";
    private CqlCompilerException.ErrorSeverity errorLevel = CqlCompilerException.ErrorSeverity.Info;
    private LibraryBuilder.SignatureLevel signatureLevel = LibraryBuilder.SignatureLevel.Overloads;
    private boolean analyzeDataRequirements = false;
    private boolean collapseDataRequirements = false;

    public static CqlTranslatorOptions defaultOptions() {
        CqlTranslatorOptions result = new CqlTranslatorOptions();
        result.options.add(Options.EnableAnnotations);
        result.options.add(Options.EnableLocators);
        result.options.add(Options.DisableListDemotion);
        result.options.add(Options.DisableListPromotion);
        return result;
    }

    public CqlTranslatorOptions() {
    }

    public CqlTranslatorOptions(Options ... options) {
        this(CqlCompilerException.ErrorSeverity.Info, LibraryBuilder.SignatureLevel.Overloads, options);
    }

    public CqlTranslatorOptions(CqlCompilerException.ErrorSeverity errorLevel, Options ... options) {
        this(errorLevel, LibraryBuilder.SignatureLevel.Overloads, options);
    }

    public CqlTranslatorOptions(CqlCompilerException.ErrorSeverity errorLevel, LibraryBuilder.SignatureLevel signatureLevel, Options ... options) {
        this.setOptions(options);
        this.errorLevel = errorLevel;
        this.signatureLevel = signatureLevel;
    }

    public CqlTranslatorOptions(CqlTranslator.Format format, boolean dateRangeOptimizations, boolean annotations, boolean locators, boolean resultTypes, boolean verifyOnly, boolean detailedErrors, CqlCompilerException.ErrorSeverity errorLevel, boolean disableListTraversal, boolean disableListDemotion, boolean disableListPromotion, boolean enableIntervalDemotion, boolean enableIntervalPromotion, boolean disableMethodInvocation, boolean requireFromKeyword, boolean validateUnits, boolean disableDefaultModelInfoLoad, LibraryBuilder.SignatureLevel signatureLevel, String compatibilityLevel) {
        this.formats.add(format);
        this.verifyOnly = verifyOnly;
        this.errorLevel = errorLevel;
        this.signatureLevel = signatureLevel;
        this.validateUnits = validateUnits;
        this.compatibilityLevel = compatibilityLevel;
        if (dateRangeOptimizations) {
            this.options.add(Options.EnableDateRangeOptimization);
        }
        if (annotations) {
            this.options.add(Options.EnableAnnotations);
        }
        if (locators) {
            this.options.add(Options.EnableLocators);
        }
        if (resultTypes) {
            this.options.add(Options.EnableResultTypes);
        }
        if (detailedErrors) {
            this.options.add(Options.EnableDetailedErrors);
        }
        if (disableListTraversal) {
            this.options.add(Options.DisableListTraversal);
        }
        if (disableListDemotion) {
            this.options.add(Options.DisableListDemotion);
        }
        if (disableListPromotion) {
            this.options.add(Options.DisableListPromotion);
        }
        if (enableIntervalDemotion) {
            this.options.add(Options.EnableIntervalDemotion);
        }
        if (enableIntervalPromotion) {
            this.options.add(Options.EnableIntervalPromotion);
        }
        if (disableMethodInvocation) {
            this.options.add(Options.DisableMethodInvocation);
        }
        if (requireFromKeyword) {
            this.options.add(Options.RequireFromKeyword);
        }
        if (disableDefaultModelInfoLoad) {
            this.options.add(Options.DisableDefaultModelInfoLoad);
        }
    }

    public EnumSet<Options> getOptions() {
        return this.options;
    }

    public void setOptions(Options ... options) {
        if (options != null) {
            for (Options option : options) {
                this.options.add(option);
            }
        }
    }

    public CqlTranslatorOptions withOptions(Options ... options) {
        this.setOptions(options);
        return this;
    }

    public List<CqlTranslator.Format> getFormats() {
        return this.formats;
    }

    public CqlTranslatorOptions withFormat(CqlTranslator.Format format) {
        this.formats.add(format);
        return this;
    }

    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public void setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    public CqlTranslatorOptions withCompatibilityLevel(String compatibilityLevel) {
        this.setCompatibilityLevel(compatibilityLevel);
        return this;
    }

    public boolean getVerifyOnly() {
        return this.verifyOnly;
    }

    public void setVerifyOnly(boolean verifyOnly) {
        this.verifyOnly = verifyOnly;
    }

    public CqlTranslatorOptions withVerifyOnly(boolean verifyOnly) {
        this.setVerifyOnly(verifyOnly);
        return this;
    }

    public boolean getEnableCqlOnly() {
        return this.enableCqlOnly;
    }

    public void setEnableCqlOnly(boolean enableCqlOnly) {
        this.enableCqlOnly = enableCqlOnly;
    }

    public boolean getValidateUnits() {
        return this.validateUnits;
    }

    public void setValidateUnits(boolean validateUnits) {
        this.validateUnits = validateUnits;
    }

    public CqlTranslatorOptions withValidateUnits(boolean validateUnits) {
        this.setValidateUnits(validateUnits);
        return this;
    }

    public CqlCompilerException.ErrorSeverity getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(CqlCompilerException.ErrorSeverity errorLevel) {
        this.errorLevel = errorLevel;
    }

    public CqlTranslatorOptions withErrorLevel(CqlCompilerException.ErrorSeverity errorLevel) {
        this.setErrorLevel(errorLevel);
        return this;
    }

    public LibraryBuilder.SignatureLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public void setSignatureLevel(LibraryBuilder.SignatureLevel signatureLevel) {
        this.signatureLevel = signatureLevel;
    }

    public CqlTranslatorOptions withSignatureLevel(LibraryBuilder.SignatureLevel signatureLevel) {
        this.setSignatureLevel(signatureLevel);
        return this;
    }

    public boolean getCollapseDataRequirements() {
        return this.collapseDataRequirements;
    }

    public void setCollapseDataRequirements(boolean collapseDataRequirements) {
        this.collapseDataRequirements = collapseDataRequirements;
    }

    public CqlTranslatorOptions withCollapseDataRequirements(boolean collapseDataRequirements) {
        this.setCollapseDataRequirements(collapseDataRequirements);
        return this;
    }

    public boolean getAnalyzeDataRequirements() {
        return this.analyzeDataRequirements;
    }

    public void setAnalyzeDataRequirements(boolean analyzeDataRequirements) {
        this.analyzeDataRequirements = analyzeDataRequirements;
    }

    public CqlTranslatorOptions withAnalyzeDataRequirements(boolean analyzeDataRequirements) {
        this.setAnalyzeDataRequirements(analyzeDataRequirements);
        return this;
    }

    public String toString() {
        if (this.getOptions() != null) {
            StringBuilder translatorOptions = new StringBuilder();
            for (Options option : this.getOptions()) {
                if (translatorOptions.length() > 0) {
                    translatorOptions.append(",");
                }
                translatorOptions.append(option.name());
            }
            return translatorOptions.toString();
        }
        return null;
    }

    public static enum Options {
        EnableDateRangeOptimization,
        EnableAnnotations,
        EnableLocators,
        EnableResultTypes,
        EnableDetailedErrors,
        DisableListTraversal,
        DisableListDemotion,
        DisableListPromotion,
        EnableIntervalDemotion,
        EnableIntervalPromotion,
        DisableMethodInvocation,
        RequireFromKeyword,
        DisableDefaultModelInfoLoad;

    }
}

