/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model.invocation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cqframework.cql.cql2elm.model.invocation.OperatorExpressionInvocation;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.OperatorExpression;
import org.hl7.elm.r1.Time;

public class TimeInvocation
extends OperatorExpressionInvocation {
    public TimeInvocation(Time expression) {
        super((OperatorExpression)expression);
    }

    @Override
    public Iterable<Expression> getOperands() {
        int i;
        Time t = (Time)this.expression;
        List<Expression> opList = Arrays.asList(t.getHour(), t.getMinute(), t.getSecond(), t.getMillisecond());
        for (i = 3; i > 0 && opList.get(i) == null; --i) {
        }
        return opList.subList(0, i + 1);
    }

    @Override
    public void setOperands(Iterable<Expression> operands) {
        ArrayList<Expression> opList = new ArrayList<Expression>();
        for (Expression operand : operands) {
            opList.add(operand);
        }
        TimeInvocation.setTimeFieldsFromOperands((Time)this.expression, opList);
    }

    public static void setTimeFieldsFromOperands(Time t, List<Expression> operands) {
        if (operands.isEmpty() || operands.size() > 4) {
            throw new IllegalArgumentException("Could not resolve call to system operator Time.  Expected 1 - 4 arguments.");
        }
        t.setHour(operands.get(0));
        if (operands.size() > 1) {
            t.setMinute(operands.get(1));
        }
        if (operands.size() > 2) {
            t.setSecond(operands.get(2));
        }
        if (operands.size() > 3) {
            t.setMillisecond(operands.get(3));
        }
    }
}

