/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cqframework.cql.cql2elm.LibraryContentType;
import org.cqframework.cql.cql2elm.LibrarySourceLoader;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.LibrarySourceProviderFactory;
import org.cqframework.cql.cql2elm.PathAware;
import org.hl7.cql.model.NamespaceAware;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm.r1.VersionedIdentifier;

public class PriorityLibrarySourceLoader
implements LibrarySourceLoader,
NamespaceAware,
PathAware {
    private final List<LibrarySourceProvider> PROVIDERS = new ArrayList<LibrarySourceProvider>();
    private boolean initialized = false;
    private Path path;
    private NamespaceManager namespaceManager;

    @Override
    public void registerProvider(LibrarySourceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null.");
        }
        if (provider instanceof NamespaceAware) {
            ((NamespaceAware)provider).setNamespaceManager(this.namespaceManager);
        }
        if (this.path != null && provider instanceof PathAware) {
            ((PathAware)((Object)provider)).setPath(this.path);
        }
        this.PROVIDERS.add(provider);
    }

    @Override
    public void setPath(Path path) {
        if (path == null || !path.toFile().isDirectory()) {
            throw new IllegalArgumentException(String.format("path '%s' is not a valid directory", path));
        }
        this.path = path;
        for (LibrarySourceProvider provider : this.getProviders()) {
            if (!(provider instanceof PathAware)) continue;
            ((PathAware)((Object)provider)).setPath(path);
        }
    }

    @Override
    public void clearProviders() {
        this.PROVIDERS.clear();
        this.initialized = false;
    }

    private List<LibrarySourceProvider> getProviders() {
        if (!this.initialized) {
            this.initialized = true;
            Iterator<LibrarySourceProvider> it = LibrarySourceProviderFactory.providers(false);
            while (it.hasNext()) {
                LibrarySourceProvider provider = it.next();
                this.registerProvider(provider);
            }
        }
        return this.PROVIDERS;
    }

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        return this.getLibraryContent(libraryIdentifier, LibraryContentType.CQL);
    }

    @Override
    public InputStream getLibraryContent(VersionedIdentifier libraryIdentifier, LibraryContentType type) {
        this.validateInput(libraryIdentifier, type);
        InputStream content = null;
        for (LibrarySourceProvider provider : this.getProviders()) {
            content = provider.getLibraryContent(libraryIdentifier, type);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    @Override
    public boolean isLibraryContentAvailable(VersionedIdentifier libraryIdentifier, LibraryContentType type) {
        this.validateInput(libraryIdentifier, type);
        for (LibrarySourceProvider provider : this.getProviders()) {
            if (!provider.isLibraryContentAvailable(libraryIdentifier, type)) continue;
            return true;
        }
        return false;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
        for (LibrarySourceProvider provider : this.getProviders()) {
            if (!(provider instanceof NamespaceAware)) continue;
            ((NamespaceAware)provider).setNamespaceManager(namespaceManager);
        }
    }

    private void validateInput(VersionedIdentifier libraryIdentifier, LibraryContentType type) {
        if (type == null) {
            throw new IllegalArgumentException("libraryContentType is null.");
        }
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is null.");
        }
        if (libraryIdentifier.getId() == null || libraryIdentifier.getId().equals("")) {
            throw new IllegalArgumentException("libraryIdentifier Id is null.");
        }
    }
}

