/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorMap;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.cql_annotations.r1.Annotation;
import org.hl7.cql_annotations.r1.Tag;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.VersionedIdentifier;

public class CompiledLibrary {
    private VersionedIdentifier identifier;
    private Library library;
    private final Map<String, Element> namespace = new HashMap<String, Element>();
    private final OperatorMap operators = new OperatorMap();
    private final Map<Operator, FunctionDef> functionDefs = new HashMap<Operator, FunctionDef>();
    private final List<Conversion> conversions = new ArrayList<Conversion>();

    public VersionedIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(VersionedIdentifier identifier) {
        this.identifier = identifier;
    }

    public Library getLibrary() {
        return this.library;
    }

    public void setLibrary(Library library) {
        this.library = library;
    }

    private void checkNamespace(String identifier) {
        Element existingElement = this.resolve(identifier);
        if (existingElement != null) {
            throw new IllegalArgumentException(String.format("Identifier %s is already in use in this library.", identifier));
        }
    }

    public void add(UsingDef using) {
        this.checkNamespace(using.getLocalIdentifier());
        this.namespace.put(using.getLocalIdentifier(), (Element)using);
    }

    public void add(IncludeDef include) {
        this.checkNamespace(include.getLocalIdentifier());
        this.namespace.put(include.getLocalIdentifier(), (Element)include);
    }

    public void add(CodeSystemDef codesystem) {
        this.checkNamespace(codesystem.getName());
        this.namespace.put(codesystem.getName(), (Element)codesystem);
    }

    public void add(ValueSetDef valueset) {
        this.checkNamespace(valueset.getName());
        this.namespace.put(valueset.getName(), (Element)valueset);
    }

    public void add(CodeDef code) {
        this.checkNamespace(code.getName());
        this.namespace.put(code.getName(), (Element)code);
    }

    public void add(ConceptDef concept) {
        this.checkNamespace(concept.getName());
        this.namespace.put(concept.getName(), (Element)concept);
    }

    public void add(ParameterDef parameter) {
        this.checkNamespace(parameter.getName());
        this.namespace.put(parameter.getName(), (Element)parameter);
    }

    public void add(ExpressionDef expression) {
        if (expression instanceof FunctionDef) {
            this.add((FunctionDef)expression, Operator.fromFunctionDef((FunctionDef)expression));
        } else {
            this.checkNamespace(expression.getName());
            this.namespace.put(expression.getName(), (Element)expression);
        }
    }

    public void remove(ExpressionDef expression) {
        if (expression instanceof FunctionDef) {
            throw new IllegalArgumentException("FunctionDef cannot be removed.");
        }
        this.namespace.remove(expression.getName());
    }

    private void ensureLibrary(Operator operator) {
        if (this.identifier != null && this.identifier.getId() != null) {
            if (operator.getLibraryName() == null) {
                operator.setLibraryName(this.identifier.getId());
            } else if (!operator.getLibraryName().equals(this.identifier.getId())) {
                throw new IllegalArgumentException(String.format("Operator %s cannot be registered in library %s because it is defined in library %s.", operator.getName(), this.identifier.getId(), operator.getLibraryName()));
            }
        }
    }

    private void ensureResultType(Operator operator) {
        if (operator.getResultType() == null) {
            throw new IllegalArgumentException(String.format("Operator %s cannot be registered in library %s because it does not have a result type defined.", operator.getName(), this.identifier.getId()));
        }
    }

    public void add(FunctionDef functionDef, Operator operator) {
        this.ensureLibrary(operator);
        this.ensureResultType(operator);
        this.operators.addOperator(operator);
        this.functionDefs.put(operator, functionDef);
    }

    public boolean contains(FunctionDef functionDef) {
        return this.contains(Operator.fromFunctionDef(functionDef));
    }

    public boolean contains(Operator operator) {
        return this.operators.containsOperator(operator);
    }

    public void add(Conversion conversion) {
        if (conversion.isCast()) {
            throw new IllegalArgumentException("Casting conversions cannot be registered as part of a library.");
        }
        this.conversions.add(conversion);
    }

    public Element resolve(String identifier) {
        return this.namespace.get(identifier);
    }

    public UsingDef resolveUsingRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof UsingDef) {
            return (UsingDef)element;
        }
        return null;
    }

    public IncludeDef resolveIncludeRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof IncludeDef) {
            return (IncludeDef)element;
        }
        return null;
    }

    public String resolveIncludeAlias(VersionedIdentifier identifier) {
        if (identifier != null && this.library != null && this.library.getIncludes() != null && this.library.getIncludes().getDef() != null) {
            String libraryPath = NamespaceManager.getPath((String)identifier.getSystem(), (String)identifier.getId());
            for (IncludeDef id : this.library.getIncludes().getDef()) {
                if (!id.getPath().equals(libraryPath)) continue;
                return id.getLocalIdentifier();
            }
        }
        return null;
    }

    public CodeSystemDef resolveCodeSystemRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof CodeSystemDef) {
            return (CodeSystemDef)element;
        }
        return null;
    }

    public ValueSetDef resolveValueSetRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof ValueSetDef) {
            return (ValueSetDef)element;
        }
        return null;
    }

    public CodeDef resolveCodeRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof CodeDef) {
            return (CodeDef)element;
        }
        return null;
    }

    public ConceptDef resolveConceptRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof ConceptDef) {
            return (ConceptDef)element;
        }
        return null;
    }

    public ParameterDef resolveParameterRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof ParameterDef) {
            return (ParameterDef)element;
        }
        return null;
    }

    public ExpressionDef resolveExpressionRef(String identifier) {
        Element element = this.resolve(identifier);
        if (element instanceof ExpressionDef) {
            return (ExpressionDef)element;
        }
        return null;
    }

    public Iterable<FunctionDef> resolveFunctionRef(String identifier) {
        ArrayList<FunctionDef> results = new ArrayList<FunctionDef>();
        for (ExpressionDef ed : this.getLibrary().getStatements().getDef()) {
            if (!(ed instanceof FunctionDef) || !ed.getName().equals(identifier)) continue;
            results.add((FunctionDef)ed);
        }
        return results;
    }

    public Iterable<FunctionDef> resolveFunctionRef(String identifier, List<DataType> signature) {
        if (signature == null) {
            return this.resolveFunctionRef(identifier);
        }
        CallContext cc = new CallContext(this.getIdentifier().getId(), identifier, false, false, false, signature.toArray(new DataType[signature.size()]));
        OperatorResolution resolution = this.resolveCall(cc, null);
        ArrayList<FunctionDef> results = new ArrayList<FunctionDef>();
        if (resolution != null) {
            results.add(resolution.getOperator().getFunctionDef());
        }
        return results;
    }

    public OperatorResolution resolveCall(CallContext callContext, ConversionMap conversionMap) {
        OperatorResolution resolution = this.operators.resolveOperator(callContext, conversionMap);
        if (resolution != null && resolution.getOperator() != null) {
            if (callContext.getAllowFluent() && !resolution.getOperator().getFluent()) {
                resolution.setAllowFluent(this.getBooleanTag("allowFluent"));
            }
            resolution.setLibraryIdentifier(this.getIdentifier());
        }
        return resolution;
    }

    public OperatorMap getOperatorMap() {
        return this.operators;
    }

    public Iterable<Conversion> getConversions() {
        return this.conversions;
    }

    private Annotation getAnnotation() {
        if (this.library != null && this.library.getAnnotation() != null) {
            for (Object o : this.library.getAnnotation()) {
                if (!(o instanceof Annotation)) continue;
                return (Annotation)o;
            }
        }
        return null;
    }

    public String getTag(String tagName) {
        Annotation a = this.getAnnotation();
        if (a != null && a.getT() != null) {
            for (Tag t : a.getT()) {
                if (!t.getName().equals(tagName)) continue;
                return t.getValue();
            }
        }
        return null;
    }

    public boolean getBooleanTag(String tagName) {
        String tagValue = this.getTag(tagName);
        if (tagValue != null) {
            try {
                return Boolean.valueOf(tagValue);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

