/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private String version;
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer patchVersion;
    private String buildVersion;
    private static Pattern isUnsignedInteger = Pattern.compile("[0-9]+");

    private void setVersion(String version) {
        this.version = version;
        String[] parts = this.version.split("\\.|-");
        block6: for (int i = 0; i < Math.max(parts.length, 4); ++i) {
            String part;
            String string = part = i < parts.length ? parts[i] : "";
            if (part.startsWith("v")) {
                part = part.substring(1);
            }
            switch (i) {
                case 0: {
                    if (!isUnsignedInteger.matcher(part).matches()) continue block6;
                    this.majorVersion = Integer.parseInt(part);
                    continue block6;
                }
                case 1: {
                    if (isUnsignedInteger.matcher(part).matches()) {
                        this.minorVersion = Integer.parseInt(part);
                        continue block6;
                    }
                    return;
                }
                case 2: {
                    if (isUnsignedInteger.matcher(part).matches()) {
                        this.patchVersion = Integer.parseInt(part);
                        continue block6;
                    }
                    return;
                }
                case 3: {
                    this.buildVersion = part;
                    continue block6;
                }
                default: {
                    this.buildVersion = this.buildVersion + "-" + part;
                }
            }
        }
    }

    public Version(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        this.setVersion(version);
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public Integer getPatchVersion() {
        return this.patchVersion;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    private int compareTo(Version that, int level) {
        if (that == null) {
            return 1;
        }
        this.validateComparability(that);
        block6: for (int i = 0; i < Math.max(level, 4); ++i) {
            switch (i) {
                case 0: {
                    int result = Integer.compare(this.majorVersion, that.majorVersion);
                    if (result == 0) continue block6;
                    return result;
                }
                case 1: {
                    if (this.minorVersion == null && that.minorVersion == null) {
                        return 0;
                    }
                    if (this.minorVersion == null) {
                        return -1;
                    }
                    if (that.minorVersion == null) {
                        return 1;
                    }
                    int result = Integer.compare(this.minorVersion, that.minorVersion);
                    if (result == 0) continue block6;
                    return result;
                }
                case 2: {
                    if (this.patchVersion == null && that.patchVersion == null) {
                        return 0;
                    }
                    if (this.patchVersion == null) {
                        return -1;
                    }
                    if (that.patchVersion == null) {
                        return 1;
                    }
                    int result = Integer.compare(this.patchVersion, that.patchVersion);
                    if (result == 0) continue block6;
                    return result;
                }
                case 3: {
                    if (this.buildVersion == null && that.buildVersion == null) {
                        return 0;
                    }
                    if (this.buildVersion == null) {
                        return -1;
                    }
                    if (that.buildVersion == null) {
                        return 1;
                    }
                    return this.buildVersion.compareToIgnoreCase(that.buildVersion);
                }
            }
        }
        return 0;
    }

    @Override
    public int compareTo(Version that) {
        return this.compareTo(that, 4);
    }

    public boolean compatibleWith(Version that) {
        if (that == null) {
            return false;
        }
        if (!this.isComparable() || !that.isComparable()) {
            return this.matchStrictly(that);
        }
        return this.majorVersion == that.majorVersion && this.compareTo(that, 2) >= 0;
    }

    public boolean matchStrictly(Version that) {
        if (that != null) {
            return this.version.equals(that.version);
        }
        return false;
    }

    public boolean isComparable(int level) {
        switch (level) {
            case 0: {
                return this.majorVersion != null;
            }
            case 1: {
                return this.minorVersion != null;
            }
            case 2: {
                return this.patchVersion != null;
            }
            case 3: {
                return this.buildVersion != null;
            }
        }
        return false;
    }

    public boolean isComparable() {
        return this.isComparable(2);
    }

    private void validateComparability(Version that) {
        if (!this.isComparable() || that != null && !that.isComparable()) {
            throw new IllegalArgumentException("The versions are not comparable");
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }
}

