/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.Operator;
import org.hl7.elm.r1.VersionedIdentifier;

public class OperatorResolution {
    private Operator operator;
    private boolean allowFluent = false;
    private VersionedIdentifier libraryIdentifier;
    private String libraryName;
    private List<Conversion> conversions;
    private boolean operatorHasOverloads = false;
    private int score;

    public OperatorResolution() {
    }

    public OperatorResolution(Operator operator) {
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public boolean getAllowFluent() {
        return this.allowFluent;
    }

    public void setAllowFluent(boolean allowFluent) {
        this.allowFluent = allowFluent;
    }

    public VersionedIdentifier getLibraryIdentifier() {
        return this.libraryIdentifier;
    }

    public void setLibraryIdentifier(VersionedIdentifier libraryIdentifier) {
        this.libraryIdentifier = libraryIdentifier;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    private void ensureConversions() {
        if (this.conversions == null) {
            this.conversions = new ArrayList<Conversion>();
        } else {
            this.conversions.clear();
        }
    }

    public Iterable<Conversion> getConversions() {
        return this.conversions;
    }

    public void setConversions(Iterable<Conversion> conversions) {
        this.ensureConversions();
        for (Conversion conversion : conversions) {
            this.conversions.add(conversion);
        }
    }

    public void setConversions(Conversion[] conversions) {
        this.ensureConversions();
        for (int i = 0; i < conversions.length; ++i) {
            this.conversions.add(conversions[i]);
        }
    }

    public boolean hasConversions() {
        return this.conversions != null;
    }

    public boolean getOperatorHasOverloads() {
        return this.operatorHasOverloads;
    }

    public void setOperatorHasOverloads() {
        this.operatorHasOverloads = true;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }
}

