/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.JavaUnicodeEscaper;
import org.apache.commons.text.translate.LookupTranslator;
import org.apache.commons.text.translate.UnicodeUnescaper;

public class StringEscapeUtils {
    private static final Map<CharSequence, CharSequence> CQL_CTRL_CHARS_ESCAPE = new HashMap<CharSequence, CharSequence>(){
        {
            this.put("\n", "\\n");
            this.put("\t", "\\t");
            this.put("\f", "\\f");
            this.put("\r", "\\r");
        }
    };
    private static final Map<CharSequence, CharSequence> CQL_CTRL_CHARS_UNESCAPE = new HashMap<CharSequence, CharSequence>(){
        {
            this.put("\\n", "\n");
            this.put("\\t", "\t");
            this.put("\\f", "\f");
            this.put("\\r", "\r");
        }
    };
    public static final CharSequenceTranslator ESCAPE_CQL = new LookupTranslator((Map)new HashMap<CharSequence, CharSequence>(){
        {
            this.put("\"", "\\\"");
            this.put("\\", "\\\\");
            this.put("'", "\\'");
        }
    }).with(new CharSequenceTranslator[]{new LookupTranslator(StringEscapeUtils.CQL_CTRL_CHARS_ESCAPE())}).with(new CharSequenceTranslator[]{JavaUnicodeEscaper.outsideOf((int)32, (int)127)});
    public static final CharSequenceTranslator UNESCAPE_CQL = new AggregateTranslator(new CharSequenceTranslator[]{new UnicodeUnescaper(), new LookupTranslator(StringEscapeUtils.CQL_CTRL_CHARS_UNESCAPE()), new LookupTranslator((Map)new HashMap<CharSequence, CharSequence>(){
        {
            this.put("\\\\", "\\");
            this.put("\\\"", "\"");
            this.put("\\'", "'");
            this.put("\\`", "`");
            this.put("\\/", "/");
            this.put("\\", "");
        }
    })});

    public static Map<CharSequence, CharSequence> CQL_CTRL_CHARS_ESCAPE() {
        return new HashMap<CharSequence, CharSequence>(CQL_CTRL_CHARS_ESCAPE);
    }

    public static Map<CharSequence, CharSequence> CQL_CTRL_CHARS_UNESCAPE() {
        return new HashMap<CharSequence, CharSequence>(CQL_CTRL_CHARS_UNESCAPE);
    }

    public static final String escapeCql(String input) {
        return ESCAPE_CQL.translate((CharSequence)input);
    }

    public static final String unescapeCql(String input) {
        return UNESCAPE_CQL.translate((CharSequence)input);
    }
}

