/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cqframework.cql.cql2elm.LibrarySourceLoader;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.LibrarySourceProviderFactory;
import org.cqframework.cql.cql2elm.PathAware;
import org.hl7.cql.model.NamespaceAware;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm.r1.VersionedIdentifier;

class DefaultLibrarySourceLoader
implements LibrarySourceLoader,
NamespaceAware,
PathAware {
    private final List<LibrarySourceProvider> providers = new ArrayList<LibrarySourceProvider>();
    boolean initialized = false;
    private Path path;
    private NamespaceManager namespaceManager;

    DefaultLibrarySourceLoader() {
    }

    @Override
    public void registerProvider(LibrarySourceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null.");
        }
        if (provider instanceof NamespaceAware) {
            ((NamespaceAware)provider).setNamespaceManager(this.namespaceManager);
        }
        if (provider instanceof PathAware) {
            ((PathAware)((Object)provider)).setPath(this.path);
        }
        this.providers.add(provider);
    }

    @Override
    public void setPath(Path path) {
        if (path == null || !path.toFile().isDirectory()) {
            throw new IllegalArgumentException(String.format("path '%s' is not a valid directory", path));
        }
        this.path = path;
        for (LibrarySourceProvider provider : this.getProviders()) {
            if (!(provider instanceof PathAware)) continue;
            ((PathAware)((Object)provider)).setPath(path);
        }
    }

    @Override
    public void clearProviders() {
        this.providers.clear();
        this.initialized = false;
    }

    private List<LibrarySourceProvider> getProviders() {
        if (!this.initialized) {
            this.initialized = true;
            Iterator<LibrarySourceProvider> it = LibrarySourceProviderFactory.providers(false);
            while (it.hasNext()) {
                LibrarySourceProvider provider = it.next();
                this.registerProvider(provider);
            }
        }
        return this.providers;
    }

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is null.");
        }
        if (libraryIdentifier.getId() == null || libraryIdentifier.getId().equals("")) {
            throw new IllegalArgumentException("libraryIdentifier Id is null.");
        }
        InputStream source = null;
        for (LibrarySourceProvider provider : this.getProviders()) {
            InputStream localSource = provider.getLibrarySource(libraryIdentifier);
            if (localSource == null) continue;
            if (source != null) {
                throw new IllegalArgumentException(String.format("Multiple sources found for library %s, version %s.", libraryIdentifier.getId(), libraryIdentifier.getVersion()));
            }
            source = localSource;
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Could not load source for library %s, version %s.", libraryIdentifier.getId(), libraryIdentifier.getVersion()));
        }
        return source;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
        for (LibrarySourceProvider provider : this.getProviders()) {
            if (!(provider instanceof NamespaceAware)) continue;
            ((NamespaceAware)provider).setNamespaceManager(namespaceManager);
        }
    }
}

