/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ModelImporter;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.ClassTypeElement;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.ModelContext;
import org.hl7.cql.model.NamedType;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class Model {
    private ModelInfo info;
    private Map<String, DataType> index;
    private Map<String, ClassType> classIndex;
    private Map<String, DataType> nameIndex;
    private List<Conversion> conversions;
    private List<ModelContext> contexts;
    private String defaultContext;

    public Model(ModelInfo modelInfo, ModelManager modelManager) throws ClassNotFoundException {
        this.info = modelInfo;
        this.index = new HashMap<String, DataType>();
        this.nameIndex = new HashMap<String, DataType>();
        this.classIndex = new HashMap<String, ClassType>();
        this.conversions = new ArrayList<Conversion>();
        this.contexts = new ArrayList<ModelContext>();
        ModelImporter importer = new ModelImporter(this.info, modelManager);
        this.index = importer.getTypes();
        for (Conversion conversion : importer.getConversions()) {
            this.conversions.add(conversion);
        }
        for (ModelContext modelContext : importer.getContexts()) {
            this.contexts.add(modelContext);
        }
        this.defaultContext = importer.getDefaultContextName();
        for (DataType dataType : this.index.values()) {
            if (dataType instanceof ClassType && ((ClassType)dataType).getLabel() != null) {
                this.classIndex.put(this.casify(((ClassType)dataType).getLabel()), (ClassType)dataType);
            }
            if (!(dataType instanceof NamedType)) continue;
            this.nameIndex.put(this.casify(((NamedType)dataType).getSimpleName()), dataType);
        }
    }

    public ModelInfo getModelInfo() {
        return this.info;
    }

    protected Map<String, DataType> getNameIndex() {
        return this.nameIndex;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public Iterable<Conversion> getConversions() {
        return this.conversions;
    }

    public DataType resolveTypeName(String typeName) {
        DataType result = this.index.get(typeName = this.casify(typeName));
        if (result == null) {
            result = this.nameIndex.get(typeName);
        }
        return result;
    }

    public ModelContext resolveContextName(String contextName) {
        return this.resolveContextName(contextName, true);
    }

    public ModelContext resolveContextName(String contextName, boolean mustResolve) {
        for (ModelContext context : this.contexts) {
            if (!context.getName().equals(contextName)) continue;
            return context;
        }
        DataType contextType = this.resolveTypeName(contextName);
        if (contextType instanceof ClassType) {
            ClassType contextClassType = (ClassType)contextType;
            String keyName = null;
            for (ClassTypeElement cte : contextClassType.getElements()) {
                if (!cte.getName().equals("id")) continue;
                keyName = cte.getName();
                break;
            }
            return new ModelContext(contextName, (ClassType)contextType, keyName != null ? Arrays.asList(keyName) : null, null);
        }
        if (mustResolve) {
            throw new IllegalArgumentException(String.format("Could not resolve context name %s in model %s.", contextName, this.info.getName()));
        }
        return null;
    }

    public ClassType resolveLabel(String label) {
        return this.classIndex.get(this.casify(label));
    }

    private String casify(String typeName) {
        return this.info.isCaseSensitive() != null && this.info.isCaseSensitive() != false ? typeName.toLowerCase() : typeName;
    }

    private DataType internalResolveTypeName(String typeName, Model systemModel) {
        DataType result = this.resolveTypeName(typeName);
        if (result == null && (result = systemModel.resolveTypeName(typeName)) == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type name %s in model %s.", typeName, this.info.getName()));
        }
        return result;
    }
}

