/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.nio.file.Path;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.PathAware;
import org.cqframework.cql.cql2elm.model.Version;
import org.hl7.elm.r1.VersionedIdentifier;

public class DefaultLibrarySourceProvider
implements LibrarySourceProvider,
PathAware {
    private Path path;

    public DefaultLibrarySourceProvider(Path path) {
        this.setPath(path);
    }

    @Override
    public void setPath(Path path) {
        if (path == null || !path.toFile().isDirectory()) {
            throw new IllegalArgumentException(String.format("path '%s' is not a valid directory", path));
        }
        this.path = path;
    }

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        if (this.path != null) {
            final String libraryName = libraryIdentifier.getId();
            Path libraryPath = this.path.resolve(String.format("%s%s.cql", libraryName, libraryIdentifier.getVersion() != null ? "-" + libraryIdentifier.getVersion() : ""));
            File libraryFile = libraryPath.toFile();
            if (!libraryFile.exists()) {
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File path, String name) {
                        return name.startsWith(libraryName) && name.endsWith(".cql");
                    }
                };
                File mostRecentFile = null;
                Version mostRecent = null;
                Version requestedVersion = libraryIdentifier.getVersion() == null ? null : new Version(libraryIdentifier.getVersion());
                for (File file : this.path.toFile().listFiles(filter)) {
                    int indexOfVersionSeparator;
                    String fileName = file.getName();
                    int indexOfExtension = fileName.lastIndexOf(".");
                    if (indexOfExtension >= 0) {
                        fileName = fileName.substring(0, indexOfExtension);
                    }
                    if ((indexOfVersionSeparator = fileName.indexOf("-")) >= 0) {
                        Version version = new Version(fileName.substring(indexOfVersionSeparator + 1));
                        if ((indexOfVersionSeparator != libraryName.length() || requestedVersion != null) && !version.compatibleWith(requestedVersion)) continue;
                        if (mostRecent == null || version != null && version.isComparable() && mostRecent != null && mostRecent.isComparable() && version.compareTo(mostRecent) > 0) {
                            mostRecent = version;
                            mostRecentFile = file;
                            continue;
                        }
                        if (version == null || !version.matchStrictly(mostRecent)) continue;
                        mostRecent = version;
                        mostRecentFile = file;
                        continue;
                    }
                    if (!fileName.equals(libraryName) || mostRecent != null) continue;
                    mostRecentFile = file;
                }
                libraryFile = mostRecentFile;
            }
            try {
                if (libraryFile != null) {
                    return new FileInputStream(libraryFile);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(String.format("Could not load source for library %s.", libraryIdentifier.getId()), e);
            }
        }
        return null;
    }
}

