/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.hl7.elm.r1.VersionedIdentifier;

public class StringLibrarySourceProvider
implements LibrarySourceProvider {
    private List<String> libraries;

    public StringLibrarySourceProvider(List<String> libraries) {
        this.libraries = libraries;
    }

    @Override
    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        String id = libraryIdentifier.getId();
        String version = libraryIdentifier.getVersion();
        String maybeQuotedIdPattern = "(\"" + id + "\"|" + id + ")";
        String matchText = "(?s).*library\\s+\"?" + maybeQuotedIdPattern;
        matchText = version != null ? matchText + "\\s+version\\s+'" + version + "'\\s+(?s).*" : matchText + "\\s+(?s).*";
        ArrayList<String> matches = new ArrayList<String>();
        for (String library : this.libraries) {
            if (!library.matches(matchText)) continue;
            matches.add(library);
        }
        if (matches.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple libraries for id : %s resolved.%nEnsure that there are no duplicates in the input set.", libraryIdentifier.toString()));
        }
        return matches.size() == 1 ? new ByteArrayInputStream(((String)matches.get(0)).getBytes()) : null;
    }
}

