/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.preprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.cqframework.cql.cql2elm.ResultWithPossibleError;
import org.cqframework.cql.cql2elm.preprocessor.BaseInfo;
import org.cqframework.cql.cql2elm.preprocessor.CodeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.CodesystemDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ConceptDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ContextDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ExpressionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.FunctionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.IncludeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ParameterDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.UsingDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ValuesetDefinitionInfo;
import org.cqframework.cql.gen.cqlParser;
import org.hl7.elm.r1.OperandDef;

public class LibraryInfo
extends BaseInfo {
    private String namespaceName;
    private String libraryName;
    private String version;
    private UsingDefinitionInfo preferredUsingDefinition;
    private final Map<String, UsingDefinitionInfo> usingDefinitions = new LinkedHashMap<String, UsingDefinitionInfo>();
    private final Map<String, IncludeDefinitionInfo> includeDefinitions = new LinkedHashMap<String, IncludeDefinitionInfo>();
    private final Map<String, CodesystemDefinitionInfo> codesystemDefinitions = new LinkedHashMap<String, CodesystemDefinitionInfo>();
    private final Map<String, ValuesetDefinitionInfo> valuesetDefinitions = new LinkedHashMap<String, ValuesetDefinitionInfo>();
    private final Map<String, CodeDefinitionInfo> codeDefinitions = new LinkedHashMap<String, CodeDefinitionInfo>();
    private final Map<String, ConceptDefinitionInfo> conceptDefinitions = new LinkedHashMap<String, ConceptDefinitionInfo>();
    private final Map<String, ParameterDefinitionInfo> parameterDefinitions = new LinkedHashMap<String, ParameterDefinitionInfo>();
    private final Map<String, ExpressionDefinitionInfo> expressionDefinitions = new LinkedHashMap<String, ExpressionDefinitionInfo>();
    private final Map<String, List<FunctionDefinitionInfo>> functionDefinitions = new LinkedHashMap<String, List<FunctionDefinitionInfo>>();
    private final List<ContextDefinitionInfo> contextDefinitions = new ArrayList<ContextDefinitionInfo>();
    private final Map<Interval, BaseInfo> definitions = new HashMap<Interval, BaseInfo>();

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public LibraryInfo withLibraryName(String value) {
        this.setLibraryName(value);
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public LibraryInfo withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    private void addDefinition(BaseInfo definition) {
        Interval sourceInterval;
        if (definition != null && definition.getDefinition() != null && (sourceInterval = definition.getDefinition().getSourceInterval()) != null) {
            this.definitions.put(sourceInterval, definition);
        }
    }

    public cqlParser.LibraryDefinitionContext getDefinition() {
        return (cqlParser.LibraryDefinitionContext)super.getDefinition();
    }

    public void setDefinition(cqlParser.LibraryDefinitionContext value) {
        super.setDefinition((ParseTree)value);
        this.addDefinition(this);
    }

    public LibraryInfo withDefinition(cqlParser.LibraryDefinitionContext value) {
        this.setDefinition(value);
        return this;
    }

    public void addUsingDefinition(UsingDefinitionInfo usingDefinition) {
        if (this.preferredUsingDefinition == null) {
            this.preferredUsingDefinition = usingDefinition;
        }
        this.usingDefinitions.put(usingDefinition.getName(), usingDefinition);
        this.addDefinition(usingDefinition);
    }

    public UsingDefinitionInfo resolveModelReference(String identifier) {
        return this.usingDefinitions.get(identifier);
    }

    public UsingDefinitionInfo getDefaultUsingDefinition() {
        return this.preferredUsingDefinition;
    }

    public String getDefaultModelName() {
        UsingDefinitionInfo usingDefinitionInfo = this.getDefaultUsingDefinition();
        if (usingDefinitionInfo == null) {
            throw new IllegalArgumentException("Could not determine a default model because no usings have been defined.");
        }
        return usingDefinitionInfo.getName();
    }

    public void addIncludeDefinition(IncludeDefinitionInfo includeDefinition) {
        this.includeDefinitions.put(includeDefinition.getLocalName(), includeDefinition);
        this.addDefinition(includeDefinition);
    }

    public IncludeDefinitionInfo resolveLibraryReference(String identifier) {
        return this.includeDefinitions.get(identifier);
    }

    public String resolveLibraryName(String identifier) {
        IncludeDefinitionInfo includeDefinition = this.resolveLibraryReference(identifier);
        if (includeDefinition != null) {
            return includeDefinition.getLocalName();
        }
        return null;
    }

    public void addParameterDefinition(ParameterDefinitionInfo parameterDefinition) {
        this.parameterDefinitions.put(parameterDefinition.getName(), parameterDefinition);
        this.addDefinition(parameterDefinition);
    }

    public ParameterDefinitionInfo resolveParameterReference(String identifier) {
        return this.parameterDefinitions.get(identifier);
    }

    public String resolveParameterName(String identifier) {
        ParameterDefinitionInfo parameterDefinition = this.resolveParameterReference(identifier);
        if (parameterDefinition != null) {
            return parameterDefinition.getName();
        }
        return null;
    }

    public void addCodesystemDefinition(CodesystemDefinitionInfo codesystemDefinition) {
        this.codesystemDefinitions.put(codesystemDefinition.getName(), codesystemDefinition);
        this.addDefinition(codesystemDefinition);
    }

    public CodesystemDefinitionInfo resolveCodesystemReference(String identifier) {
        return this.codesystemDefinitions.get(identifier);
    }

    public void addValuesetDefinition(ValuesetDefinitionInfo valuesetDefinition) {
        this.valuesetDefinitions.put(valuesetDefinition.getName(), valuesetDefinition);
        this.addDefinition(valuesetDefinition);
    }

    public ValuesetDefinitionInfo resolveValuesetReference(String identifier) {
        return this.valuesetDefinitions.get(identifier);
    }

    public String resolveValuesetName(String identifier) {
        ValuesetDefinitionInfo valuesetDefinition = this.resolveValuesetReference(identifier);
        if (valuesetDefinition != null) {
            return valuesetDefinition.getName();
        }
        return null;
    }

    public void addCodeDefinition(CodeDefinitionInfo codeDefinition) {
        this.codeDefinitions.put(codeDefinition.getName(), codeDefinition);
        this.addDefinition(codeDefinition);
    }

    public CodeDefinitionInfo resolveCodeReference(String identifier) {
        return this.codeDefinitions.get(identifier);
    }

    public void addConceptDefinition(ConceptDefinitionInfo conceptDefinition) {
        this.conceptDefinitions.put(conceptDefinition.getName(), conceptDefinition);
        this.addDefinition(conceptDefinition);
    }

    public ConceptDefinitionInfo resolveConceptReference(String identifier) {
        return this.conceptDefinitions.get(identifier);
    }

    public void addExpressionDefinition(ExpressionDefinitionInfo letStatement) {
        this.expressionDefinitions.put(letStatement.getName(), letStatement);
        this.addDefinition(letStatement);
    }

    public ExpressionDefinitionInfo resolveExpressionReference(String identifier) {
        return this.expressionDefinitions.get(identifier);
    }

    public String resolveExpressionName(String identifier) {
        ExpressionDefinitionInfo letStatement = this.resolveExpressionReference(identifier);
        if (letStatement != null) {
            return letStatement.getName();
        }
        return null;
    }

    public void addFunctionDefinition(FunctionDefinitionInfo functionDefinition) {
        List<FunctionDefinitionInfo> infos = this.functionDefinitions.get(functionDefinition.getName());
        if (infos == null) {
            infos = new ArrayList<FunctionDefinitionInfo>();
            this.functionDefinitions.put(functionDefinition.getName(), infos);
        }
        infos.add(functionDefinition);
        this.addDefinition(functionDefinition);
    }

    public Iterable<FunctionDefinitionInfo> resolveFunctionReference(String identifier) {
        return this.functionDefinitions.get(identifier);
    }

    public String resolveFunctionName(String identifier) {
        Iterable<FunctionDefinitionInfo> functionDefinitions = this.resolveFunctionReference(identifier);
        Iterator<FunctionDefinitionInfo> iterator = functionDefinitions.iterator();
        if (iterator.hasNext()) {
            FunctionDefinitionInfo functionInfo = iterator.next();
            return functionInfo.getName();
        }
        return null;
    }

    public void addContextDefinition(ContextDefinitionInfo contextDefinition) {
        this.contextDefinitions.add(contextDefinition);
        this.addDefinition(contextDefinition);
    }

    public ContextDefinitionInfo resolveContext(cqlParser.ContextDefinitionContext ctx) {
        for (ContextDefinitionInfo cd : this.contextDefinitions) {
            if (!ctx.getSourceInterval().equals((Object)cd.getDefinition().getSourceInterval())) continue;
            return cd;
        }
        return null;
    }

    public BaseInfo resolveDefinition(ParseTree pt) {
        return this.definitions.get(pt.getSourceInterval());
    }

    private static boolean isFunctionDefInfoAlreadyPresent(ResultWithPossibleError<FunctionDefinitionInfo> existingFunctionDefInfo, ResultWithPossibleError<FunctionDefinitionInfo> functionDefinition) {
        return LibraryInfo.matchesFunctionDefInfos(existingFunctionDefInfo, functionDefinition);
    }

    private static boolean matchesFunctionDefInfos(ResultWithPossibleError<FunctionDefinitionInfo> existingInfo, ResultWithPossibleError<FunctionDefinitionInfo> newInfo) {
        if (existingInfo == null) {
            return false;
        }
        if (existingInfo.hasError() || newInfo.hasError()) {
            return existingInfo.hasError() && newInfo.hasError();
        }
        List existingOperands = existingInfo.getUnderlyingResultIfExists().getPreCompileOutput().getFunctionDef().getOperand();
        List newOperands = newInfo.getUnderlyingResultIfExists().getPreCompileOutput().getFunctionDef().getOperand();
        if (existingOperands.size() != newOperands.size()) {
            return false;
        }
        for (int index = 0; index < existingOperands.size(); ++index) {
            OperandDef newOperand;
            OperandDef existingOperand = (OperandDef)existingOperands.get(index);
            if (LibraryInfo.matchesOperands(existingOperand, newOperand = (OperandDef)newOperands.get(index))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesOperands(OperandDef existingOperand, OperandDef newOperand) {
        return existingOperand.getResultType().equals(newOperand.getResultType());
    }
}

