/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.cqframework.cql.cql2elm.CqlCompiler;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.LibraryContentType;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.elm.serializing.ElmLibraryWriterFactory;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;

public class CqlTranslator {
    private CqlCompiler compiler;

    public static CqlTranslator fromText(String cqlText, LibraryManager libraryManager) {
        return new CqlTranslator(null, null, (CharStream)CharStreams.fromString((String)cqlText), libraryManager);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, String cqlText, LibraryManager libraryManager) {
        return new CqlTranslator(namespaceInfo, null, (CharStream)CharStreams.fromString((String)cqlText), libraryManager);
    }

    public static CqlTranslator fromText(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, String cqlText, LibraryManager libraryManager) {
        return new CqlTranslator(namespaceInfo, sourceInfo, (CharStream)CharStreams.fromString((String)cqlText), libraryManager);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, InputStream cqlStream, LibraryManager libraryManager) throws IOException {
        return new CqlTranslator(namespaceInfo, null, CharStreams.fromStream((InputStream)cqlStream), libraryManager);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, LibraryManager libraryManager) throws IOException {
        return new CqlTranslator(null, null, CharStreams.fromStream((InputStream)cqlStream), libraryManager);
    }

    public static CqlTranslator fromStream(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, InputStream cqlStream, LibraryManager libraryManager) throws IOException {
        return new CqlTranslator(namespaceInfo, sourceInfo, CharStreams.fromStream((InputStream)cqlStream), libraryManager);
    }

    public static CqlTranslator fromFile(String cqlFileName, LibraryManager libraryManager) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), libraryManager);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, String cqlFileName, LibraryManager libraryManager) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFileName), CharStreams.fromStream((InputStream)new FileInputStream(cqlFileName)), libraryManager);
    }

    public static CqlTranslator fromFile(File cqlFile, LibraryManager libraryManager) throws IOException {
        return new CqlTranslator(null, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), libraryManager);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, File cqlFile, LibraryManager libraryManager) throws IOException {
        return new CqlTranslator(namespaceInfo, CqlTranslator.getSourceInfo(cqlFile), CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), libraryManager);
    }

    public static CqlTranslator fromFile(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, File cqlFile, LibraryManager libraryManager) throws IOException {
        return new CqlTranslator(namespaceInfo, sourceInfo, CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)), libraryManager);
    }

    private CqlTranslator(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, CharStream is, LibraryManager libraryManager) {
        this.compiler = new CqlCompiler(namespaceInfo, sourceInfo, libraryManager);
        this.compiler.run(is);
    }

    private static VersionedIdentifier getSourceInfo(String cqlFileName) {
        return CqlTranslator.getSourceInfo(new File(cqlFileName));
    }

    private static VersionedIdentifier getSourceInfo(File cqlFile) {
        String name = cqlFile.getName();
        int extensionIndex = name.lastIndexOf(46);
        if (extensionIndex > 0) {
            name = name.substring(0, extensionIndex);
        }
        String system = null;
        try {
            system = cqlFile.getCanonicalPath();
        }
        catch (IOException e) {
            system = cqlFile.getAbsolutePath();
        }
        return new VersionedIdentifier().withId(name).withSystem(system);
    }

    private String toXml(Library library) {
        try {
            return CqlTranslator.convertToXml(library);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not convert library to XML.", e);
        }
    }

    private String toJson(Library library) {
        try {
            return CqlTranslator.convertToJson(library);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not convert library to JSON using JAXB serializer.", e);
        }
    }

    public String toXml() {
        return this.toXml(this.compiler.getLibrary());
    }

    public String toJson() {
        return this.toJson(this.compiler.getLibrary());
    }

    public Library toELM() {
        return this.compiler.getLibrary();
    }

    public CompiledLibrary getTranslatedLibrary() {
        return this.compiler.getCompiledLibrary();
    }

    public Object toObject() {
        return this.compiler.toObject();
    }

    public List<Retrieve> toRetrieves() {
        return this.compiler.toRetrieves();
    }

    public Map<VersionedIdentifier, Library> getLibraries() {
        return this.compiler.getLibraries();
    }

    public Map<VersionedIdentifier, CompiledLibrary> getTranslatedLibraries() {
        return this.compiler.getCompiledLibraries();
    }

    public List<CqlCompilerException> getExceptions() {
        return this.compiler.getExceptions();
    }

    public List<CqlCompilerException> getErrors() {
        return this.compiler.getErrors();
    }

    public List<CqlCompilerException> getWarnings() {
        return this.compiler.getWarnings();
    }

    public List<CqlCompilerException> getMessages() {
        return this.compiler.getMessages();
    }

    public static String convertToXml(Library library) throws IOException {
        StringWriter writer = new StringWriter();
        ElmLibraryWriterFactory.getWriter((String)LibraryContentType.XML.mimeType()).write(library, (Writer)writer);
        return writer.getBuffer().toString();
    }

    public static String convertToJson(Library library) throws IOException {
        StringWriter writer = new StringWriter();
        ElmLibraryWriterFactory.getWriter((String)LibraryContentType.JSON.mimeType()).write(library, (Writer)writer);
        return writer.getBuffer().toString();
    }

    public static enum Format {
        XML,
        JSON,
        COFFEE;

    }
}

