/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cqframework.cql.cql2elm.CompiledLibraryResult;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.VersionedIdentifier;

public record CompiledLibraryMultiResults(List<CompiledLibraryResult> results) {
    public CompiledLibraryMultiResults(List<CompiledLibraryResult> results) {
        this.results = Collections.unmodifiableList(results);
    }

    public static CompiledLibraryMultiResults from(List<CompiledLibraryResult> results) {
        return new CompiledLibraryMultiResults(results);
    }

    public boolean hasErrors() {
        return this.results.stream().anyMatch(res -> !res.errors().isEmpty());
    }

    public List<CompiledLibraryResult> allResults() {
        return this.results;
    }

    public CompiledLibrary getCompiledLibraryFor(VersionedIdentifier libraryIdentifier) {
        return this.results.stream().filter(res -> libraryIdentifier.getId().equals(res.compiledLibrary().getIdentifier().getId())).findFirst().map(CompiledLibraryResult::compiledLibrary).orElse(null);
    }

    public List<CompiledLibrary> allCompiledLibraries() {
        return this.results.stream().map(CompiledLibraryResult::compiledLibrary).toList();
    }

    public CompiledLibraryResult getOnlyResult() {
        if (this.results.size() != 1) {
            throw new IllegalStateException("Expected exactly one result, but found " + this.results.size());
        }
        return this.results.get(0);
    }

    public List<CqlCompilerException> getErrorsFor(VersionedIdentifier libraryIdentifier) {
        return this.results.stream().filter(res -> libraryIdentifier.equals((Object)res.compiledLibrary().getIdentifier())).map(CompiledLibraryResult::errors).flatMap(Collection::stream).toList();
    }

    public List<Library> allLibrariesWithoutErrorSeverity() {
        return this.results.stream().filter(res -> !CqlCompilerException.hasErrors(res.errors())).map(CompiledLibraryResult::compiledLibrary).map(CompiledLibrary::getLibrary).toList();
    }

    public List<CqlCompilerException> allErrors() {
        return this.results.stream().map(CompiledLibraryResult::errors).flatMap(Collection::stream).toList();
    }
}

