/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cqframework.cql.cql2elm.CompiledLibraryMultiResults;
import org.cqframework.cql.cql2elm.CompiledLibraryResult;
import org.cqframework.cql.cql2elm.CompilerOptions;
import org.cqframework.cql.cql2elm.CqlCompiler;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlCompilerOptions;
import org.cqframework.cql.cql2elm.CqlIncludeException;
import org.cqframework.cql.cql2elm.LibraryContentType;
import org.cqframework.cql.cql2elm.LibrarySourceLoader;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.PriorityLibrarySourceLoader;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.elm.serializing.ElmLibraryReaderFactory;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumService;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryManager {
    private static final Logger logger = LoggerFactory.getLogger(LibraryManager.class);
    private final ModelManager modelManager;
    private final NamespaceManager namespaceManager;
    private final CqlCompilerOptions cqlCompilerOptions;
    private final Map<VersionedIdentifier, CompiledLibrary> compiledLibraries;
    private final LibrarySourceLoader librarySourceLoader;
    private UcumService ucumService;
    private static final LibraryContentType[] supportedContentTypes = new LibraryContentType[]{LibraryContentType.JSON, LibraryContentType.XML, LibraryContentType.CQL};

    public LibraryManager(ModelManager modelManager) {
        this(modelManager, CqlCompilerOptions.defaultOptions(), null);
    }

    public LibraryManager(ModelManager modelManager, CqlCompilerOptions cqlCompilerOptions) {
        this(modelManager, cqlCompilerOptions, null);
    }

    public LibraryManager(ModelManager modelManager, CqlCompilerOptions cqlCompilerOptions, Map<VersionedIdentifier, CompiledLibrary> libraryCache) {
        if (modelManager == null) {
            throw new IllegalArgumentException("modelManager is null");
        }
        this.modelManager = modelManager;
        this.cqlCompilerOptions = cqlCompilerOptions;
        this.namespaceManager = this.modelManager.getNamespaceManager() != null ? modelManager.getNamespaceManager() : new NamespaceManager();
        this.compiledLibraries = libraryCache != null ? libraryCache : new HashMap<VersionedIdentifier, CompiledLibrary>();
        this.librarySourceLoader = new PriorityLibrarySourceLoader();
    }

    public CqlCompilerOptions getCqlCompilerOptions() {
        return this.cqlCompilerOptions;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public Map<VersionedIdentifier, CompiledLibrary> getCompiledLibraries() {
        return this.compiledLibraries;
    }

    public UcumService getUcumService() {
        if (this.ucumService == null) {
            this.ucumService = this.getDefaultUcumService();
        }
        return this.ucumService;
    }

    protected synchronized UcumService getDefaultUcumService() {
        try {
            return new UcumEssenceService(UcumEssenceService.class.getResourceAsStream("/ucum-essence.xml"));
        }
        catch (UcumException e) {
            logger.warn("Error creating shared UcumService", (Throwable)e);
            return null;
        }
    }

    public void setUcumService(UcumService ucumService) {
        this.ucumService = ucumService;
    }

    public LibrarySourceLoader getLibrarySourceLoader() {
        return this.librarySourceLoader;
    }

    public boolean isWellKnownLibraryName(String unqualifiedIdentifier) {
        if (unqualifiedIdentifier == null) {
            return false;
        }
        return unqualifiedIdentifier.equals("FHIRHelpers");
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier, CacheMode cacheMode) {
        return this.resolveLibraryInner(libraryIdentifier, cacheMode).compiledLibrary();
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier) {
        return this.resolveLibraryInner(libraryIdentifier, CacheMode.READ_WRITE).compiledLibrary();
    }

    public boolean canResolveLibrary(VersionedIdentifier libraryIdentifier) {
        CompiledLibrary lib = this.resolveLibrary(libraryIdentifier);
        return lib != null;
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier, List<CqlCompilerException> errors) {
        CompiledLibraryResult compiledLibraryResult = this.resolveLibraryInner(libraryIdentifier, CacheMode.READ_WRITE);
        Optional.ofNullable(compiledLibraryResult.errors()).ifPresent(errors::addAll);
        return compiledLibraryResult.compiledLibrary();
    }

    private CompiledLibraryResult resolveLibraryInner(VersionedIdentifier libraryIdentifier, CacheMode cacheMode) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is null.");
        }
        if (libraryIdentifier.getId() == null || libraryIdentifier.getId().isEmpty()) {
            throw new IllegalArgumentException("libraryIdentifier Id is null");
        }
        CompiledLibraryMultiResults compiledLibraryResults = this.resolveLibraries(List.of(libraryIdentifier), cacheMode);
        return compiledLibraryResults.getOnlyResult();
    }

    public CompiledLibraryMultiResults resolveLibraries(List<VersionedIdentifier> libraryIdentifiers) {
        return this.resolveLibraries(libraryIdentifiers, CacheMode.READ_WRITE);
    }

    private CompiledLibraryMultiResults resolveLibraries(List<VersionedIdentifier> libraryIdentifiers, CacheMode cacheMode) {
        if (libraryIdentifiers == null || libraryIdentifiers.isEmpty() || libraryIdentifiers.get(0) == null) {
            throw new IllegalArgumentException("libraryIdentifier can not be null");
        }
        if (libraryIdentifiers.stream().anyMatch(libraryIdentifier -> libraryIdentifier.getId() == null || libraryIdentifier.getId().isEmpty())) {
            throw new IllegalArgumentException("at least one libraryIdentifier Id is null");
        }
        ArrayList<CompiledLibraryResult> compiledLibraryResults = new ArrayList<CompiledLibraryResult>();
        if (cacheMode != CacheMode.NONE) {
            List<CompiledLibrary> librariesFromCache = libraryIdentifiers.stream().filter(this.compiledLibraries::containsKey).map(this.compiledLibraries::get).toList();
            if (librariesFromCache.size() == libraryIdentifiers.size()) {
                return CompiledLibraryMultiResults.from(librariesFromCache.stream().map(lib -> new CompiledLibraryResult((CompiledLibrary)lib, List.of())).toList());
            }
            librariesFromCache.stream().map(libraryFromCache -> new CompiledLibraryResult((CompiledLibrary)libraryFromCache, List.of())).forEach(compiledLibraryResults::add);
        }
        for (VersionedIdentifier libraryIdentifier2 : libraryIdentifiers) {
            if (this.isLibraryAlreadyRetrievedFromCache(libraryIdentifier2, compiledLibraryResults)) {
                logger.debug("library {} already in cache, skipping compilation", (Object)libraryIdentifier2.getId());
                continue;
            }
            CompiledLibraryResult compiledLibraryResult = this.compileLibrary(libraryIdentifier2);
            if (!CqlCompilerException.hasErrors(compiledLibraryResult.errors()) && cacheMode == CacheMode.READ_WRITE) {
                logger.debug("adding library to cache: {}", (Object)libraryIdentifier2.getId());
                this.compiledLibraries.put(libraryIdentifier2, compiledLibraryResult.compiledLibrary());
            }
            compiledLibraryResults.add(compiledLibraryResult);
        }
        return CompiledLibraryMultiResults.from(compiledLibraryResults);
    }

    private boolean isLibraryAlreadyRetrievedFromCache(VersionedIdentifier searchedForLibraryIdentifier, List<CompiledLibraryResult> compiledLibrariesFromCache) {
        return compiledLibrariesFromCache.stream().map(CompiledLibraryResult::compiledLibrary).map(CompiledLibrary::getIdentifier).map(compiledLibraryIdentifier -> this.stripVersionIfNeeded((VersionedIdentifier)compiledLibraryIdentifier, searchedForLibraryIdentifier)).toList().contains(searchedForLibraryIdentifier);
    }

    private VersionedIdentifier stripVersionIfNeeded(VersionedIdentifier compiledLibraryIdentifier, VersionedIdentifier searchedForLibraryIdentifier) {
        if (searchedForLibraryIdentifier.getVersion() == null) {
            return new VersionedIdentifier().withId(compiledLibraryIdentifier.getId());
        }
        return compiledLibraryIdentifier;
    }

    private CompiledLibraryResult compileLibrary(VersionedIdentifier libraryIdentifier) {
        CompiledLibrary compiledLibrary;
        List<CqlCompilerException> errors;
        CompiledLibrary elmCompiledLibrary;
        String libraryPath = NamespaceManager.getPath((String)libraryIdentifier.getSystem(), (String)libraryIdentifier.getId());
        if (!this.cqlCompilerOptions.getEnableCqlOnly() && (elmCompiledLibrary = this.tryCompiledLibraryElm(libraryIdentifier)) != null) {
            this.validateIdentifiers(libraryIdentifier, elmCompiledLibrary, libraryPath);
            this.sortStatements(elmCompiledLibrary);
            return new CompiledLibraryResult(elmCompiledLibrary, List.of());
        }
        try {
            InputStream cqlSource = this.librarySourceLoader.getLibrarySource(libraryIdentifier);
            if (cqlSource == null) {
                throw new CqlIncludeException(String.format("Could not load source for library %s, version %s, namespace uri %s.", libraryIdentifier.getId(), libraryIdentifier.getVersion(), libraryIdentifier.getSystem()), libraryIdentifier.getSystem(), libraryIdentifier.getId(), libraryIdentifier.getVersion());
            }
            CqlCompiler compiler = new CqlCompiler(this.namespaceManager.getNamespaceInfoFromUri(libraryIdentifier.getSystem()), libraryIdentifier, this);
            compiler.run(cqlSource);
            errors = Collections.unmodifiableList(compiler.getExceptions());
            compiledLibrary = compiler.getCompiledLibrary();
            if (compiledLibrary == null) {
                throw new CqlIncludeException(String.format("Could not load source for library %s, version %s.", libraryPath, libraryIdentifier.getVersion()), libraryIdentifier.getSystem(), libraryIdentifier.getId(), libraryIdentifier.getVersion());
            }
            this.validateIdentifiers(libraryIdentifier, compiledLibrary, libraryPath);
        }
        catch (IOException e) {
            throw new CqlIncludeException(String.format("Errors occurred translating library %s, version %s.", libraryPath, libraryIdentifier.getVersion()), libraryIdentifier.getSystem(), libraryIdentifier.getId(), libraryIdentifier.getVersion(), e);
        }
        this.sortStatements(compiledLibrary);
        return new CompiledLibraryResult(compiledLibrary, errors);
    }

    private void validateIdentifiers(VersionedIdentifier libraryIdentifier, CompiledLibrary result, String libraryPath) {
        boolean areIdentifiersValid;
        VersionedIdentifier resultIdentifier = result.getIdentifier();
        boolean areIdsEqual = libraryIdentifier.getId().equals(resultIdentifier.getId());
        String libraryIdentifierVersion = libraryIdentifier.getVersion();
        String resultIdentifierVersion = resultIdentifier.getVersion();
        if (libraryIdentifierVersion == null) {
            areIdentifiersValid = areIdsEqual;
        } else {
            boolean areVersionsEqual = libraryIdentifierVersion.equals(resultIdentifier.getVersion());
            boolean bl = areIdentifiersValid = areIdsEqual && areVersionsEqual;
        }
        if (!areIdentifiersValid) {
            throw new CqlIncludeException(String.format("Library %s was included with version %s, but id: %s and version %s of the library was found.", libraryPath, libraryIdentifierVersion, resultIdentifier.getId(), resultIdentifierVersion), libraryIdentifier.getSystem(), libraryIdentifier.getId(), libraryIdentifierVersion == null ? "null" : libraryIdentifierVersion);
        }
    }

    private void sortStatements(CompiledLibrary compiledLibrary) {
        if (compiledLibrary == null || compiledLibrary.getLibrary().getStatements() == null) {
            return;
        }
        compiledLibrary.getLibrary().getStatements().getDef().sort((a, b) -> a.getName().compareTo(b.getName()));
    }

    private CompiledLibrary tryCompiledLibraryElm(VersionedIdentifier libraryIdentifier) {
        InputStream elm = null;
        for (LibraryContentType type : supportedContentTypes) {
            if (LibraryContentType.CQL == type || (elm = this.librarySourceLoader.getLibraryContent(libraryIdentifier, type)) == null) continue;
            return this.generateCompiledLibraryFromElm(elm, type);
        }
        return null;
    }

    private CompiledLibrary generateCompiledLibraryFromElm(InputStream librarySource, LibraryContentType type) {
        Library library = null;
        CompiledLibrary compiledLibrary = null;
        try {
            library = ElmLibraryReaderFactory.getReader((String)type.mimeType()).read((Reader)new InputStreamReader(librarySource));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (library != null && this.checkBinaryCompatibility(library)) {
            compiledLibrary = this.generateCompiledLibrary(library);
        }
        return compiledLibrary;
    }

    private CompiledLibrary generateCompiledLibrary(Library library) {
        CompiledLibrary compiledLibrary;
        boolean compilationSuccess;
        block21: {
            if (library == null) {
                return null;
            }
            compilationSuccess = true;
            compiledLibrary = new CompiledLibrary();
            try {
                if (library != null) {
                    compiledLibrary.setLibrary(library);
                }
                if (library.getIdentifier() != null) {
                    compiledLibrary.setIdentifier(library.getIdentifier());
                }
                if (library.getUsings() != null && library.getUsings().getDef() != null) {
                    for (UsingDef usingDef : library.getUsings().getDef()) {
                        compiledLibrary.add(usingDef);
                    }
                }
                if (library.getIncludes() != null && library.getIncludes().getDef() != null) {
                    for (IncludeDef includeDef : library.getIncludes().getDef()) {
                        compiledLibrary.add(includeDef);
                    }
                }
                if (library.getCodeSystems() != null && library.getCodeSystems().getDef() != null) {
                    for (CodeSystemDef codeSystemDef : library.getCodeSystems().getDef()) {
                        compiledLibrary.add(codeSystemDef);
                    }
                }
                for (ValueSetDef valueSetDef : library.getValueSets().getDef()) {
                    compiledLibrary.add(valueSetDef);
                }
                if (library.getCodes() != null && library.getCodes().getDef() != null) {
                    for (CodeDef codeDef : library.getCodes().getDef()) {
                        compiledLibrary.add(codeDef);
                    }
                }
                if (library.getConcepts() != null && library.getConcepts().getDef() != null) {
                    for (ConceptDef conceptDef : library.getConcepts().getDef()) {
                        compiledLibrary.add(conceptDef);
                    }
                }
                if (library.getParameters() != null && library.getParameters().getDef() != null) {
                    for (ParameterDef parameterDef : library.getParameters().getDef()) {
                        compiledLibrary.add(parameterDef);
                    }
                }
                if (library.getStatements() == null || library.getStatements().getDef() == null) break block21;
                for (ExpressionDef expressionDef : library.getStatements().getDef()) {
                    if (expressionDef.getResultType() != null) {
                        compiledLibrary.add(expressionDef);
                        continue;
                    }
                    compilationSuccess = false;
                    break;
                }
            }
            catch (Exception e) {
                compilationSuccess = false;
            }
        }
        if (compilationSuccess) {
            return compiledLibrary;
        }
        return null;
    }

    protected Boolean compilerOptionsMatch(Library library) {
        Set<CqlCompilerOptions.Options> compilerOptions = CompilerOptions.getCompilerOptions(library);
        if (compilerOptions == null) {
            return false;
        }
        return compilerOptions.equals(this.cqlCompilerOptions.getOptions());
    }

    private boolean checkBinaryCompatibility(Library library) {
        if (library == null) {
            return false;
        }
        return this.isSignatureCompatible(library) && this.isVersionCompatible(library) && this.compilerOptionsMatch(library) != false;
    }

    private boolean isSignatureCompatible(Library library) {
        return !this.hasOverloadedFunctions(library) || this.hasSignature(library);
    }

    private boolean hasOverloadedFunctions(Library library) {
        if (library == null || library.getStatements() == null) {
            return false;
        }
        HashSet<FunctionSig> functionNames = new HashSet<FunctionSig>();
        for (ExpressionDef ed : library.getStatements().getDef()) {
            if (!(ed instanceof FunctionDef)) continue;
            FunctionDef fd = (FunctionDef)ed;
            FunctionSig sig = new FunctionSig(fd.getName(), fd.getOperand() == null ? 0 : fd.getOperand().size());
            if (functionNames.contains(sig)) {
                return true;
            }
            functionNames.add(sig);
        }
        return false;
    }

    boolean hasSignature(Library library) {
        if (library != null && library.getStatements() != null) {
            for (ExpressionDef ed : library.getStatements().getDef()) {
                FunctionRef fr;
                Expression expression = ed.getExpression();
                if (!(expression instanceof FunctionRef) || (fr = (FunctionRef)expression).getSignature() == null || fr.getSignature().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVersionCompatible(Library library) {
        String version;
        if (!StringUtils.isEmpty((CharSequence)this.cqlCompilerOptions.getCompatibilityLevel()) && library.getAnnotation() != null && (version = CompilerOptions.getCompilerVersion(library)) != null) {
            return version.equals(this.cqlCompilerOptions.getCompatibilityLevel());
        }
        return false;
    }

    public static enum CacheMode {
        NONE,
        READ_ONLY,
        READ_WRITE;

    }

    static class FunctionSig {
        private final String name;
        private final int numArguments;

        public FunctionSig(String name, int numArguments) {
            this.name = name;
            this.numArguments = numArguments;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.numArguments;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionSig other = (FunctionSig)obj;
            return other.name.equals(this.name) && other.numArguments == this.numArguments;
        }
    }
}

