/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ContextDef;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.ValueSetDef;

public class ResolvedIdentifierContext {
    private final String identifier;
    private final Element nullableElement;
    private final ResolvedIdentifierMatchType matchType;

    public static ResolvedIdentifierContext exactMatch(String identifier, Element nullableElement) {
        return new ResolvedIdentifierContext(identifier, nullableElement, ResolvedIdentifierMatchType.EXACT);
    }

    public static ResolvedIdentifierContext caseInsensitiveMatch(String identifier, Element nullableElement) {
        return new ResolvedIdentifierContext(identifier, nullableElement, ResolvedIdentifierMatchType.CASE_INSENSITIVE);
    }

    private ResolvedIdentifierContext(String identifier, Element nullableElement, ResolvedIdentifierMatchType matchType) {
        this.identifier = identifier;
        this.nullableElement = nullableElement;
        this.matchType = matchType;
    }

    public Optional<Element> getExactMatchElement() {
        if (this.isExactMatch()) {
            return Optional.ofNullable(this.nullableElement);
        }
        return Optional.empty();
    }

    private boolean isExactMatch() {
        return ResolvedIdentifierMatchType.EXACT == this.matchType;
    }

    public Optional<String> warnCaseInsensitiveIfApplicable() {
        if (this.nullableElement != null && !this.isExactMatch()) {
            return ResolvedIdentifierContext.getName(this.nullableElement).map(name -> String.format("Could not resolve identifier %s. Consider whether the identifier %s (differing only in case) was intended.", this.identifier, name));
        }
        return Optional.empty();
    }

    public <T extends Element> T resolveIdentifier(Class<T> clazz) {
        return (T)((Element)this.getExactMatchElement().filter(clazz::isInstance).map(clazz::cast).orElse(null));
    }

    public <T extends Element> Optional<T> getElementOfType(Class<T> clazz) {
        if (clazz.isInstance(this.nullableElement)) {
            return Optional.of((Element)clazz.cast(this.nullableElement));
        }
        return Optional.empty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResolvedIdentifierContext that = (ResolvedIdentifierContext)other;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.nullableElement, that.nullableElement) && this.matchType == that.matchType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.nullableElement, this.matchType});
    }

    public String toString() {
        return new StringJoiner(", ", ResolvedIdentifierContext.class.getSimpleName() + "[", "]").add("identifier='" + this.identifier + "'").add("nullableElement=" + this.nullableElement).add("matchType=" + this.matchType).toString();
    }

    private static Optional<String> getName(Element element) {
        if (element instanceof ExpressionDef) {
            return Optional.of(((ExpressionDef)element).getName());
        }
        if (element instanceof ValueSetDef) {
            return Optional.of(((ValueSetDef)element).getName());
        }
        if (element instanceof OperandDef) {
            return Optional.of(((OperandDef)element).getName());
        }
        if (element instanceof TupleElementDefinition) {
            return Optional.of(((TupleElementDefinition)element).getName());
        }
        if (element instanceof CodeDef) {
            return Optional.of(((CodeDef)element).getName());
        }
        if (element instanceof ConceptDef) {
            return Optional.of(((ConceptDef)element).getName());
        }
        if (element instanceof ParameterDef) {
            return Optional.of(((ParameterDef)element).getName());
        }
        if (element instanceof CodeSystemDef) {
            return Optional.of(((CodeSystemDef)element).getName());
        }
        if (element instanceof ContextDef) {
            return Optional.of(((ContextDef)element).getName());
        }
        return Optional.empty();
    }

    private static enum ResolvedIdentifierMatchType {
        EXACT,
        CASE_INSENSITIVE;

    }
}

