/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.preprocessor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.tuple.Pair;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlCompilerOptions;
import org.cqframework.cql.cql2elm.CqlIncludeException;
import org.cqframework.cql.cql2elm.CqlInternalException;
import org.cqframework.cql.cql2elm.CqlSemanticException;
import org.cqframework.cql.cql2elm.LibraryBuilder;
import org.cqframework.cql.cql2elm.StringEscapeUtils;
import org.cqframework.cql.cql2elm.model.Chunk;
import org.cqframework.cql.cql2elm.model.FunctionHeader;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.preprocessor.BaseInfo;
import org.cqframework.cql.cql2elm.preprocessor.LibraryInfo;
import org.cqframework.cql.cql2elm.preprocessor.UsingDefinitionInfo;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.cqframework.cql.elm.tracking.Trackable;
import org.cqframework.cql.gen.cqlBaseVisitor;
import org.cqframework.cql.gen.cqlParser;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.cql_annotations.r1.Annotation;
import org.hl7.cql_annotations.r1.Narrative;
import org.hl7.cql_annotations.r1.Tag;
import org.hl7.elm.r1.AccessModifier;
import org.hl7.elm.r1.ChoiceTypeSpecifier;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ContextDef;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.ListTypeSpecifier;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TupleTypeSpecifier;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;

public class CqlPreprocessorElmCommonVisitor
extends cqlBaseVisitor {
    protected final ObjectFactory of = new ObjectFactory();
    protected final org.hl7.cql_annotations.r1.ObjectFactory af = new org.hl7.cql_annotations.r1.ObjectFactory();
    private boolean implicitContextCreated = false;
    private String currentContext = "Unfiltered";
    protected Stack<Chunk> chunks = new Stack();
    protected final LibraryBuilder libraryBuilder;
    protected TokenStream tokenStream;
    protected LibraryInfo libraryInfo = new LibraryInfo();
    private boolean annotate = false;
    private boolean detailedErrors = false;
    private int nextLocalId = 1;
    private boolean locate = false;
    private boolean resultTypes = false;
    private boolean dateRangeOptimization = false;
    private boolean methodInvocation = true;
    private boolean fromKeywordRequired = false;
    private final List<Expression> expressions = new ArrayList<Expression>();
    private boolean includeDeprecatedElements = false;

    public CqlPreprocessorElmCommonVisitor(LibraryBuilder libraryBuilder) {
        this.libraryBuilder = libraryBuilder;
    }

    public CqlPreprocessorElmCommonVisitor(LibraryBuilder libraryBuilder, TokenStream tokenStream) {
        this.libraryBuilder = libraryBuilder;
        this.tokenStream = tokenStream;
    }

    protected boolean getImplicitContextCreated() {
        return this.implicitContextCreated;
    }

    protected void setImplicitContextCreated(boolean implicitContextCreated) {
        this.implicitContextCreated = implicitContextCreated;
    }

    protected String getCurrentContext() {
        return this.currentContext;
    }

    protected void setCurrentContext(String currentContext) {
        this.currentContext = currentContext;
    }

    protected String saveCurrentContext(String currentContext) {
        String saveContext = this.currentContext;
        this.currentContext = currentContext;
        return saveContext;
    }

    public void setTokenStream(TokenStream theTokenStream) {
        this.tokenStream = theTokenStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ParseTree tree) {
        boolean pushedChunk = this.pushChunk(tree);
        Object o = null;
        try {
            try {
                o = super.visit(tree);
            }
            catch (CqlIncludeException e) {
                CqlCompilerException translatorException = new CqlCompilerException(e.getMessage(), this.getTrackBack(tree), (Throwable)e);
                if (translatorException.getLocator() == null) {
                    throw translatorException;
                }
                this.libraryBuilder.recordParsingException(translatorException);
            }
            catch (CqlCompilerException e) {
                if (e.getLocator() == null) {
                    if (tree == null) {
                        throw e;
                    }
                    e.setLocator(this.getTrackBack(tree));
                }
                this.libraryBuilder.recordParsingException(e);
            }
            catch (Exception e) {
                Exception rootCause;
                CqlCompilerException ex = null;
                if (e.getMessage() == null) {
                    ex = new CqlInternalException("Internal translator error.", this.getTrackBack(tree), (Throwable)e);
                    if (tree == null) {
                        throw ex;
                    }
                } else {
                    ex = new CqlSemanticException(e.getMessage(), this.getTrackBack(tree), (Throwable)e);
                }
                if ((rootCause = this.libraryBuilder.determineRootCause()) == null) {
                    rootCause = ex;
                    this.libraryBuilder.recordParsingException(ex);
                    this.libraryBuilder.setRootCause(rootCause);
                } else if (this.detailedErrors) {
                    this.libraryBuilder.recordParsingException(ex);
                }
                o = this.of.createNull();
            }
            if (o instanceof Trackable && !(tree instanceof cqlParser.LibraryContext)) {
                this.track((Trackable)o, tree);
            }
            if (o instanceof Expression) {
                this.addExpression((Expression)o);
            }
            Object object = o;
            return object;
        }
        finally {
            this.popChunk(tree, o, pushedChunk);
            this.processTags(tree, o);
        }
    }

    public TupleElementDefinition visitTupleElementDefinition(cqlParser.TupleElementDefinitionContext ctx) {
        TupleElementDefinition result = this.of.createTupleElementDefinition().withName(this.parseString((ParseTree)ctx.referentialIdentifier())).withElementType(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        if (this.includeDeprecatedElements) {
            result.setType(result.getElementType());
        }
        return result;
    }

    public Object visitTupleTypeSpecifier(cqlParser.TupleTypeSpecifierContext ctx) {
        TupleType resultType = new TupleType();
        TupleTypeSpecifier typeSpecifier = this.of.createTupleTypeSpecifier();
        for (cqlParser.TupleElementDefinitionContext definitionContext : ctx.tupleElementDefinition()) {
            TupleElementDefinition element = (TupleElementDefinition)this.visit((ParseTree)definitionContext);
            resultType.addElement(new TupleTypeElement(element.getName(), element.getElementType().getResultType()));
            typeSpecifier.getElement().add(element);
        }
        typeSpecifier.setResultType((DataType)resultType);
        return typeSpecifier;
    }

    public ChoiceTypeSpecifier visitChoiceTypeSpecifier(cqlParser.ChoiceTypeSpecifierContext ctx) {
        ArrayList<TypeSpecifier> typeSpecifiers = new ArrayList<TypeSpecifier>();
        ArrayList<DataType> types = new ArrayList<DataType>();
        for (cqlParser.TypeSpecifierContext typeSpecifierContext : ctx.typeSpecifier()) {
            TypeSpecifier typeSpecifier = this.parseTypeSpecifier((ParseTree)typeSpecifierContext);
            typeSpecifiers.add(typeSpecifier);
            types.add(typeSpecifier.getResultType());
        }
        ChoiceTypeSpecifier result = this.of.createChoiceTypeSpecifier().withChoice(typeSpecifiers);
        if (this.includeDeprecatedElements) {
            result.getType().addAll(typeSpecifiers);
        }
        ChoiceType choiceType = new ChoiceType(types);
        result.setResultType((DataType)choiceType);
        return result;
    }

    public IntervalTypeSpecifier visitIntervalTypeSpecifier(cqlParser.IntervalTypeSpecifierContext ctx) {
        IntervalTypeSpecifier result = this.of.createIntervalTypeSpecifier().withPointType(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        IntervalType intervalType = new IntervalType(result.getPointType().getResultType());
        result.setResultType((DataType)intervalType);
        return result;
    }

    public ListTypeSpecifier visitListTypeSpecifier(cqlParser.ListTypeSpecifierContext ctx) {
        ListTypeSpecifier result = this.of.createListTypeSpecifier().withElementType(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        ListType listType = new ListType(result.getElementType().getResultType());
        result.setResultType((DataType)listType);
        return result;
    }

    public FunctionHeader parseFunctionHeader(cqlParser.FunctionDefinitionContext ctx) {
        cqlParser.TypeSpecifierContext typeSpecifierContext;
        FunctionDef fun = this.of.createFunctionDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifierOrFunctionIdentifier())).withContext(this.getCurrentContext());
        if (ctx.fluentModifier() != null) {
            this.libraryBuilder.checkCompatibilityLevel("Fluent functions", "1.5");
            fun.setFluent(Boolean.valueOf(true));
        }
        if (ctx.operandDefinition() != null) {
            for (cqlParser.OperandDefinitionContext opdef : ctx.operandDefinition()) {
                TypeSpecifier typeSpecifier = this.parseTypeSpecifier((ParseTree)opdef.typeSpecifier());
                fun.getOperand().add((OperandDef)this.of.createOperandDef().withName(this.parseString((ParseTree)opdef.referentialIdentifier())).withOperandTypeSpecifier(typeSpecifier).withResultType(typeSpecifier.getResultType()));
            }
        }
        if ((typeSpecifierContext = ctx.typeSpecifier()) != null) {
            return FunctionHeader.withReturnType(fun, this.parseTypeSpecifier((ParseTree)typeSpecifierContext));
        }
        return FunctionHeader.noReturnType(fun);
    }

    protected TypeSpecifier parseTypeSpecifier(ParseTree pt) {
        return pt == null ? null : (TypeSpecifier)this.visit(pt);
    }

    protected AccessModifier parseAccessModifier(ParseTree pt) {
        return pt == null ? AccessModifier.PUBLIC : (AccessModifier)this.visit(pt);
    }

    protected List<String> parseQualifiers(cqlParser.NamedTypeSpecifierContext ctx) {
        ArrayList<String> qualifiers = new ArrayList<String>();
        if (ctx.qualifier() != null) {
            for (cqlParser.QualifierContext qualifierContext : ctx.qualifier()) {
                String qualifier = this.parseString((ParseTree)qualifierContext);
                qualifiers.add(qualifier);
            }
        }
        return qualifiers;
    }

    protected Model getModel(NamespaceInfo modelNamespace, String modelName, String version, String localIdentifier) {
        if (modelName == null) {
            UsingDefinitionInfo defaultUsing = this.libraryInfo.getDefaultUsingDefinition();
            modelName = defaultUsing.getName();
            version = defaultUsing.getVersion();
        }
        ModelIdentifier modelIdentifier = new ModelIdentifier().withId(modelName).withVersion(version);
        if (modelNamespace != null) {
            modelIdentifier.setSystem(modelNamespace.getUri());
        }
        return this.libraryBuilder.getModel(modelIdentifier, localIdentifier);
    }

    private boolean pushChunk(ParseTree tree) {
        if (!this.isAnnotationEnabled()) {
            return false;
        }
        Interval sourceInterval = tree.getSourceInterval();
        if (sourceInterval.b < sourceInterval.a) {
            return false;
        }
        Chunk chunk = new Chunk().withInterval(sourceInterval);
        this.chunks.push(chunk);
        return true;
    }

    private void popChunk(ParseTree tree, Object o, boolean pushedChunk) {
        if (!pushedChunk) {
            return;
        }
        Chunk chunk = this.chunks.pop();
        if (o instanceof Element) {
            Element element = (Element)o;
            if (element.getLocalId() == null) {
                element.setLocalId(Integer.toString(this.getNextLocalId()));
            }
            chunk.setElement(element);
            if (!(tree instanceof cqlParser.LibraryContext)) {
                Annotation a;
                if ((element instanceof UsingDef || element instanceof IncludeDef || element instanceof CodeSystemDef || element instanceof ValueSetDef || element instanceof CodeDef || element instanceof ConceptDef || element instanceof ParameterDef || element instanceof ContextDef || element instanceof ExpressionDef) && ((a = this.getAnnotation(element)) == null || a.getS() == null)) {
                    BaseInfo definitionInfo = this.libraryInfo.resolveDefinition(tree);
                    if (definitionInfo != null && definitionInfo.getHeaderInterval() != null) {
                        Chunk headerChunk = new Chunk().withInterval(definitionInfo.getHeaderInterval()).withIsHeaderChunk(true);
                        Chunk newChunk = new Chunk().withInterval(new Interval(headerChunk.getInterval().a, chunk.getInterval().b));
                        newChunk.addChunk(headerChunk);
                        newChunk.setElement(chunk.getElement());
                        for (Chunk c : chunk.getChunks()) {
                            newChunk.addChunk(c);
                        }
                        chunk = newChunk;
                    }
                    if (a == null) {
                        element.getAnnotation().add(this.buildAnnotation(chunk));
                    } else {
                        this.addNarrativeToAnnotation(a, chunk);
                    }
                }
            } else if (this.libraryInfo.getDefinition() != null && this.libraryInfo.getHeaderInterval() != null) {
                Chunk headerChunk = new Chunk().withInterval(this.libraryInfo.getHeaderInterval()).withIsHeaderChunk(true);
                Chunk definitionChunk = new Chunk().withInterval(this.libraryInfo.getDefinition().getSourceInterval());
                Chunk newChunk = new Chunk().withInterval(new Interval(headerChunk.getInterval().a, definitionChunk.getInterval().b));
                newChunk.addChunk(headerChunk);
                newChunk.addChunk(definitionChunk);
                newChunk.setElement(chunk.getElement());
                chunk = newChunk;
                Annotation a = this.getAnnotation((Element)this.libraryBuilder.getLibrary());
                if (a == null) {
                    this.libraryBuilder.getLibrary().getAnnotation().add(this.buildAnnotation(chunk));
                } else {
                    this.addNarrativeToAnnotation(a, chunk);
                }
            }
        }
        if (!this.chunks.isEmpty()) {
            this.chunks.peek().addChunk(chunk);
        }
    }

    private void processTags(ParseTree tree, Object o) {
        if (this.libraryBuilder.isCompatibleWith("1.5") && o instanceof Element) {
            List<Tag> tags;
            Element element = (Element)o;
            if (!(tree instanceof cqlParser.LibraryContext)) {
                List<Tag> tags2;
                if ((element instanceof UsingDef || element instanceof IncludeDef || element instanceof CodeSystemDef || element instanceof ValueSetDef || element instanceof CodeDef || element instanceof ConceptDef || element instanceof ParameterDef || element instanceof ContextDef || element instanceof ExpressionDef) && (tags2 = this.getTags(tree)) != null && tags2.size() > 0) {
                    Annotation a = this.getAnnotation(element);
                    if (a == null) {
                        a = this.buildAnnotation();
                        element.getAnnotation().add(a);
                    }
                    if (a.getT().size() == 0) {
                        a.getT().addAll(tags2);
                    }
                }
            } else if (this.libraryInfo.getDefinition() != null && this.libraryInfo.getHeaderInterval() != null && (tags = this.getTags(this.libraryInfo.getHeader())) != null && tags.size() > 0) {
                Annotation a = this.getAnnotation((Element)this.libraryBuilder.getLibrary());
                if (a == null) {
                    a = this.buildAnnotation();
                    this.libraryBuilder.getLibrary().getAnnotation().add(a);
                }
                a.getT().addAll(tags);
            }
        }
    }

    private List<Tag> getTags(String header) {
        if (header != null) {
            header = this.parseComments(header);
            return this.parseTags(header);
        }
        return null;
    }

    private List<Tag> getTags(ParseTree tree) {
        BaseInfo bi = this.libraryInfo.resolveDefinition(tree);
        if (bi != null) {
            return this.getTags(bi.getHeader());
        }
        return null;
    }

    private List<Tag> parseTags(String header) {
        Pair<String, Integer> tagNamePair;
        header = String.join((CharSequence)"\n", Arrays.asList(header.trim().split("\n[ \t]*\\*[ \t\\*]*")));
        ArrayList<Tag> tags = new ArrayList<Tag>();
        int startFrom = 0;
        while (startFrom < header.length() && (tagNamePair = this.lookForTagName(header, startFrom)) != null) {
            if (((String)tagNamePair.getLeft()).length() > 0 && CqlPreprocessorElmCommonVisitor.isValidIdentifier((String)tagNamePair.getLeft())) {
                Tag t = this.af.createTag().withName((String)tagNamePair.getLeft());
                startFrom = (Integer)tagNamePair.getRight();
                Pair<String, Integer> tagValuePair = CqlPreprocessorElmCommonVisitor.lookForTagValue(header, startFrom);
                if (tagValuePair != null && ((String)tagValuePair.getLeft()).length() > 0) {
                    t = t.withValue((String)tagValuePair.getLeft());
                    startFrom = (Integer)tagValuePair.getRight();
                }
                tags.add(t);
                continue;
            }
            startFrom = (Integer)tagNamePair.getRight();
        }
        return tags;
    }

    private String parseComments(String header) {
        ArrayList<String> result = new ArrayList<String>();
        if (header != null) {
            header = header.replace("\r\n", "\n");
            String[] lines = header.split("\n");
            boolean inMultiline = false;
            for (String line : lines) {
                if (!inMultiline) {
                    int start = line.indexOf("/*");
                    if (start >= 0) {
                        if (line.endsWith("*/")) {
                            result.add(line.substring(start + 2, line.length() - 2));
                        } else {
                            result.add(line.substring(start + 2));
                        }
                        inMultiline = true;
                    } else {
                        start = line.indexOf("//");
                    }
                    if (start < 0 || inMultiline) continue;
                    result.add(line.substring(start + 2));
                    continue;
                }
                int end = line.indexOf("*/");
                if (end >= 0) {
                    inMultiline = false;
                    if (end <= 0) continue;
                    result.add(line.substring(0, end));
                    continue;
                }
                result.add(line);
            }
        }
        return String.join((CharSequence)"\n", result);
    }

    public boolean isAnnotationEnabled() {
        return this.annotate;
    }

    public void enableAnnotations() {
        this.annotate = true;
    }

    public void disableAnnotations() {
        this.annotate = false;
    }

    private Annotation buildAnnotation(Chunk chunk) {
        Annotation annotation = this.af.createAnnotation();
        annotation.setS(this.buildNarrative(chunk));
        return annotation;
    }

    private Annotation buildAnnotation() {
        Annotation annotation = this.af.createAnnotation();
        return annotation;
    }

    private void addNarrativeToAnnotation(Annotation annotation, Chunk chunk) {
        annotation.setS(this.buildNarrative(chunk));
    }

    private Narrative buildNarrative(Chunk chunk) {
        Narrative narrative = this.af.createNarrative();
        if (chunk.getElement() != null) {
            narrative.setR(chunk.getElement().getLocalId());
        }
        if (chunk.hasChunks()) {
            Narrative currentNarrative = null;
            for (Chunk childChunk : chunk.getChunks()) {
                Narrative chunkNarrative = this.buildNarrative(childChunk);
                if (this.hasChunks(chunkNarrative)) {
                    if (currentNarrative != null) {
                        narrative.getContent().add(CqlPreprocessorElmCommonVisitor.wrapNarrative(currentNarrative));
                        currentNarrative = null;
                    }
                    narrative.getContent().add(CqlPreprocessorElmCommonVisitor.wrapNarrative(chunkNarrative));
                    continue;
                }
                if (currentNarrative == null) {
                    currentNarrative = chunkNarrative;
                    continue;
                }
                currentNarrative.getContent().addAll(chunkNarrative.getContent());
                if (currentNarrative.getR() != null) continue;
                currentNarrative.setR(chunkNarrative.getR());
            }
            if (currentNarrative != null) {
                narrative.getContent().add(CqlPreprocessorElmCommonVisitor.wrapNarrative(currentNarrative));
            }
        } else {
            String chunkContent = this.tokenStream.getText(chunk.getInterval());
            if (chunk.isHeaderChunk()) {
                chunkContent = CqlPreprocessorElmCommonVisitor.stripLeading(chunkContent);
            }
            chunkContent = CqlPreprocessorElmCommonVisitor.normalizeWhitespace(chunkContent);
            narrative.getContent().add(chunkContent);
        }
        return narrative;
    }

    private boolean hasChunks(Narrative narrative) {
        for (Serializable c : narrative.getContent()) {
            if (c instanceof String) continue;
            return true;
        }
        return false;
    }

    private TrackBack getTrackBack(ParseTree tree) {
        if (tree instanceof ParserRuleContext) {
            return this.getTrackBack((ParserRuleContext)tree);
        }
        if (tree instanceof TerminalNode) {
            return this.getTrackBack((ParseTree)((TerminalNode)tree));
        }
        return null;
    }

    private TrackBack getTrackBack(ParserRuleContext ctx) {
        TrackBack tb = new TrackBack(this.libraryBuilder.getLibraryIdentifier(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine() + 1, ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine() + ctx.getStop().getText().length());
        return tb;
    }

    private TrackBack track(Trackable trackable, ParseTree pt) {
        TrackBack tb = this.getTrackBack(pt);
        if (tb != null) {
            trackable.getTrackbacks().add(tb);
        }
        if (trackable instanceof Element) {
            this.decorate((Element)trackable, tb);
        }
        return tb;
    }

    private void decorate(Element element, TrackBack tb) {
        if (this.locate && tb != null) {
            element.setLocator(tb.toLocator());
        }
        if (this.resultTypes && element.getResultType() != null) {
            if (element.getResultType() instanceof NamedType) {
                element.setResultTypeName(this.libraryBuilder.dataTypeToQName(element.getResultType()));
            } else {
                element.setResultTypeSpecifier(this.libraryBuilder.dataTypeToTypeSpecifier(element.getResultType()));
            }
        }
    }

    private Pair<String, Integer> lookForTagName(String header, int startFrom) {
        if (startFrom >= header.length()) {
            return null;
        }
        int start = header.indexOf("@", startFrom);
        if (start < 0) {
            return null;
        }
        int nextTagStart = header.indexOf("@", start + 1);
        int nextColon = header.indexOf(":", start + 1);
        if (nextTagStart < 0) {
            if (nextColon < 0) {
                return Pair.of((Object)header.substring(start + 1, header.length()).trim(), (Object)header.length());
            }
        } else if (nextColon < 0 || nextColon > nextTagStart) {
            return Pair.of((Object)header.substring(start + 1, nextTagStart).trim(), (Object)nextTagStart);
        }
        return Pair.of((Object)header.substring(start + 1, nextColon).trim(), (Object)(nextColon + 1));
    }

    public static Pair<String, Integer> lookForTagValue(String header, int startFrom) {
        if (startFrom >= header.length()) {
            return null;
        }
        int nextTag = header.indexOf(64, startFrom);
        int nextStartDoubleQuote = header.indexOf("\"", startFrom);
        if ((nextTag < 0 || nextTag > nextStartDoubleQuote) && nextStartDoubleQuote > 0 && header.length() > nextStartDoubleQuote + 1) {
            int nextEndDoubleQuote = header.indexOf("\"", nextStartDoubleQuote + 1);
            if (nextEndDoubleQuote > 0) {
                int parameterEnd = header.indexOf("\n", nextStartDoubleQuote + 1);
                if (parameterEnd < 0) {
                    return Pair.of((Object)header.substring(nextStartDoubleQuote), (Object)header.length());
                }
                return Pair.of((Object)header.substring(nextStartDoubleQuote, parameterEnd), (Object)parameterEnd);
            }
            return Pair.of((Object)header.substring(nextStartDoubleQuote), (Object)header.length());
        }
        if (nextTag == startFrom && !CqlPreprocessorElmCommonVisitor.isStartingWithDigit(header, nextTag + 1)) {
            return Pair.of((Object)"", (Object)startFrom);
        }
        if (nextTag > 0) {
            String interimText = header.substring(startFrom, nextTag).trim();
            if (CqlPreprocessorElmCommonVisitor.isStartingWithDigit(header, nextTag + 1)) {
                if (interimText.length() > 0 && !interimText.equals(":")) {
                    return Pair.of((Object)interimText, (Object)nextTag);
                }
                int nextSpace = header.indexOf(32, nextTag);
                int nextLine = header.indexOf("\n", nextTag);
                int mul = nextSpace * nextLine;
                int nextDelimeterIndex = header.length();
                if (mul < 0) {
                    nextDelimeterIndex = Math.max(nextLine, nextSpace);
                } else if (mul > 1) {
                    nextDelimeterIndex = Math.min(nextLine, nextSpace);
                }
                return Pair.of((Object)header.substring(nextTag, nextDelimeterIndex), (Object)nextDelimeterIndex);
            }
            return Pair.of((Object)interimText, (Object)nextTag);
        }
        return Pair.of((Object)header.substring(startFrom).trim(), (Object)header.length());
    }

    public static Serializable wrapNarrative(Narrative narrative) {
        return new JAXBElement(new QName("urn:hl7-org:cql-annotations:r1", "s"), Narrative.class, (Object)narrative);
    }

    public static boolean isValidIdentifier(String tagName) {
        for (int i = 0; i < tagName.length(); ++i) {
            if (tagName.charAt(i) == '_' || !(i == 0 ? !Character.isLetter(tagName.charAt(i)) : !Character.isLetterOrDigit(tagName.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static String getTypeIdentifier(List<String> qualifiers, String identifier) {
        if (qualifiers.size() > 1) {
            String result = null;
            for (int i = 1; i < qualifiers.size(); ++i) {
                result = result == null ? qualifiers.get(i) : result + "." + qualifiers.get(i);
            }
            return result + "." + identifier;
        }
        return identifier;
    }

    public static String getModelIdentifier(List<String> qualifiers) {
        return qualifiers.size() > 0 ? qualifiers.get(0) : null;
    }

    public static String stripLeading(String s) {
        int index;
        for (index = 0; index < s.length() && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        if (index == s.length()) {
            return "";
        }
        return s.substring(index);
    }

    public int getNextLocalId() {
        return this.nextLocalId++;
    }

    private void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    private Annotation getAnnotation(Element element) {
        for (Object o : element.getAnnotation()) {
            if (!(o instanceof Annotation)) continue;
            return (Annotation)o;
        }
        return null;
    }

    protected String parseString(ParseTree pt) {
        return StringEscapeUtils.unescapeCql(pt == null ? null : (String)this.visit(pt));
    }

    public static String normalizeWhitespace(String input) {
        return input.replace("\r\n", "\n");
    }

    public static boolean isStartingWithDigit(String header, int index) {
        return index < header.length() && Character.isDigit(header.charAt(index));
    }

    public void enableLocators() {
        this.locate = true;
    }

    public boolean locatorsEnabled() {
        return this.locate;
    }

    public void disableLocators() {
        this.locate = false;
    }

    public void enableResultTypes() {
        this.resultTypes = true;
    }

    public void disableResultTypes() {
        this.resultTypes = false;
    }

    public boolean resultTypesEnabled() {
        return this.resultTypes;
    }

    public void enableDateRangeOptimization() {
        this.dateRangeOptimization = true;
    }

    public void disableDateRangeOptimization() {
        this.dateRangeOptimization = false;
    }

    public boolean getDateRangeOptimization() {
        return this.dateRangeOptimization;
    }

    public void enableDetailedErrors() {
        this.detailedErrors = true;
    }

    public void disableDetailedErrors() {
        this.detailedErrors = false;
    }

    public boolean isDetailedErrorsEnabled() {
        return this.detailedErrors;
    }

    public void enableMethodInvocation() {
        this.methodInvocation = true;
    }

    public void disableMethodInvocation() {
        this.methodInvocation = false;
    }

    public boolean isMethodInvocationEnabled() {
        return this.methodInvocation;
    }

    public boolean isFromKeywordRequired() {
        return this.fromKeywordRequired;
    }

    public void enableFromKeywordRequired() {
        this.fromKeywordRequired = true;
    }

    public void disableFromKeywordRequired() {
        this.fromKeywordRequired = false;
    }

    public boolean getIncludeDeprecatedElements() {
        return this.includeDeprecatedElements;
    }

    public void setIncludeDeprecatedElements(boolean includeDeprecatedElements) {
        this.includeDeprecatedElements = includeDeprecatedElements;
    }

    public void setTranslatorOptions(CqlCompilerOptions options) {
        if (options.getOptions().contains((Object)CqlCompilerOptions.Options.EnableDateRangeOptimization)) {
            this.enableDateRangeOptimization();
        }
        if (options.getOptions().contains((Object)CqlCompilerOptions.Options.EnableAnnotations)) {
            this.enableAnnotations();
        }
        if (options.getOptions().contains((Object)CqlCompilerOptions.Options.EnableLocators)) {
            this.enableLocators();
        }
        if (options.getOptions().contains((Object)CqlCompilerOptions.Options.EnableResultTypes)) {
            this.enableResultTypes();
        }
        if (options.getOptions().contains((Object)CqlCompilerOptions.Options.EnableDetailedErrors)) {
            this.enableDetailedErrors();
        }
        if (options.getOptions().contains((Object)CqlCompilerOptions.Options.DisableMethodInvocation)) {
            this.disableMethodInvocation();
        }
        if (options.getOptions().contains((Object)CqlCompilerOptions.Options.RequireFromKeyword)) {
            this.enableFromKeywordRequired();
        }
        this.libraryBuilder.setCompatibilityLevel(options.getCompatibilityLevel());
    }
}

