/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.preprocessor;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.LibraryBuilder;
import org.cqframework.cql.cql2elm.ResultWithPossibleError;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.preprocessor.BaseInfo;
import org.cqframework.cql.cql2elm.preprocessor.CodeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.CodesystemDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ConceptDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ContextDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.CqlPreprocessorElmCommonVisitor;
import org.cqframework.cql.cql2elm.preprocessor.ExpressionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.FunctionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.IncludeDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.LibraryInfo;
import org.cqframework.cql.cql2elm.preprocessor.ParameterDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.UsingDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.ValuesetDefinitionInfo;
import org.cqframework.cql.gen.cqlParser;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.VersionedIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlPreprocessorVisitor
extends CqlPreprocessorElmCommonVisitor {
    static final Logger logger = LoggerFactory.getLogger(CqlPreprocessorVisitor.class);
    private int lastSourceIndex = -1;

    public CqlPreprocessorVisitor(LibraryBuilder libraryBuilder, TokenStream tokenStream) {
        super(libraryBuilder, tokenStream);
    }

    public LibraryInfo getLibraryInfo() {
        return this.libraryInfo;
    }

    private void processHeader(ParseTree ctx, BaseInfo info) {
        Interval header = null;
        Interval sourceInterval = ctx.getSourceInterval();
        int beforeDefinition = sourceInterval.a - 1;
        if (beforeDefinition >= this.lastSourceIndex) {
            header = new Interval(this.lastSourceIndex + 1, sourceInterval.a - 1);
            this.lastSourceIndex = sourceInterval.b;
            info.setHeaderInterval(header);
            info.setHeader(this.tokenStream.getText(header));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitLibrary(cqlParser.LibraryContext ctx) {
        Object lastResult = null;
        VersionedIdentifier identifier = new VersionedIdentifier().withId(this.libraryInfo.getLibraryName()).withVersion(this.libraryInfo.getVersion());
        if (this.libraryInfo.getNamespaceName() != null) {
            identifier.setSystem(this.libraryBuilder.resolveNamespaceUri(this.libraryInfo.getNamespaceName(), true));
        } else if (this.libraryBuilder.getNamespaceInfo() != null) {
            identifier.setSystem(this.libraryBuilder.getNamespaceInfo().getUri());
        }
        this.libraryBuilder.setLibraryIdentifier(identifier);
        this.libraryBuilder.beginTranslation();
        try {
            for (int i = 0; i < ctx.getChildCount(); ++i) {
                Object childResult;
                TerminalNode terminalNode;
                ParseTree tree = ctx.getChild(i);
                TerminalNode terminalNode2 = terminalNode = tree instanceof TerminalNode ? (TerminalNode)tree : null;
                if (terminalNode != null && terminalNode.getSymbol().getType() == -1 || (childResult = this.visit(tree)) == null) continue;
                lastResult = childResult;
            }
            Object object = lastResult;
            return object;
        }
        finally {
            this.libraryBuilder.endTranslation();
        }
    }

    public Object visitLibraryDefinition(cqlParser.LibraryDefinitionContext ctx) {
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        this.libraryInfo.setLibraryName((String)identifiers.remove(identifiers.size() - 1));
        if (identifiers.size() > 0) {
            this.libraryInfo.setNamespaceName(String.join((CharSequence)".", identifiers));
        }
        if (ctx.versionSpecifier() != null) {
            this.libraryInfo.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        this.libraryInfo.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, this.libraryInfo);
        return super.visitLibraryDefinition(ctx);
    }

    public Object visitIncludeDefinition(cqlParser.IncludeDefinitionContext ctx) {
        IncludeDefinitionInfo includeDefinition = new IncludeDefinitionInfo();
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        includeDefinition.setName((String)identifiers.remove(identifiers.size() - 1));
        if (identifiers.size() > 0) {
            includeDefinition.setNamespaceName(String.join((CharSequence)".", identifiers));
        }
        if (ctx.versionSpecifier() != null) {
            includeDefinition.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        if (ctx.localIdentifier() != null) {
            includeDefinition.setLocalName(this.parseString((ParseTree)ctx.localIdentifier()));
        } else {
            includeDefinition.setLocalName(includeDefinition.getName());
        }
        includeDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, includeDefinition);
        this.libraryInfo.addIncludeDefinition(includeDefinition);
        return includeDefinition;
    }

    public Object visitUsingDefinition(cqlParser.UsingDefinitionContext ctx) {
        String localIdentifier;
        UsingDefinitionInfo usingDefinition = new UsingDefinitionInfo();
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        String unqualifiedIdentifier = (String)identifiers.remove(identifiers.size() - 1);
        usingDefinition.setName(unqualifiedIdentifier);
        if (identifiers.size() > 0) {
            usingDefinition.setNamespaceName(String.join((CharSequence)".", identifiers));
        }
        if (ctx.versionSpecifier() != null) {
            usingDefinition.setVersion((String)this.visit((ParseTree)ctx.versionSpecifier()));
        }
        if (ctx.localIdentifier() != null) {
            usingDefinition.setLocalName(this.parseString((ParseTree)ctx.localIdentifier()));
        } else {
            usingDefinition.setLocalName(usingDefinition.getName());
        }
        usingDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, usingDefinition);
        this.libraryInfo.addUsingDefinition(usingDefinition);
        String namespaceName = !identifiers.isEmpty() ? String.join((CharSequence)".", identifiers) : (this.libraryBuilder.isWellKnownModelName(unqualifiedIdentifier) ? null : (this.libraryBuilder.getNamespaceInfo() != null ? this.libraryBuilder.getNamespaceInfo().getName() : null));
        NamespaceInfo modelNamespace = null;
        if (namespaceName != null) {
            String namespaceUri = this.libraryBuilder.resolveNamespaceUri(namespaceName, true);
            modelNamespace = new NamespaceInfo(namespaceName, namespaceUri);
        }
        String string = localIdentifier = ctx.localIdentifier() == null ? unqualifiedIdentifier : this.parseString((ParseTree)ctx.localIdentifier());
        if (!localIdentifier.equals(unqualifiedIdentifier)) {
            throw new IllegalArgumentException(String.format("Local identifiers for models must be the same as the name of the model in this release of the translator (Model %s, Called %s)", unqualifiedIdentifier, localIdentifier));
        }
        Model model = this.getModel(modelNamespace, unqualifiedIdentifier, this.parseString((ParseTree)ctx.versionSpecifier()), localIdentifier);
        return usingDefinition;
    }

    public Object visitCodesystemDefinition(cqlParser.CodesystemDefinitionContext ctx) {
        CodesystemDefinitionInfo codesystemDefinition = new CodesystemDefinitionInfo();
        codesystemDefinition.setName(this.parseString((ParseTree)ctx.identifier()));
        codesystemDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, codesystemDefinition);
        this.libraryInfo.addCodesystemDefinition(codesystemDefinition);
        return codesystemDefinition;
    }

    public Object visitValuesetDefinition(cqlParser.ValuesetDefinitionContext ctx) {
        ValuesetDefinitionInfo valuesetDefinition = new ValuesetDefinitionInfo();
        valuesetDefinition.setName(this.parseString((ParseTree)ctx.identifier()));
        valuesetDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, valuesetDefinition);
        this.libraryInfo.addValuesetDefinition(valuesetDefinition);
        return valuesetDefinition;
    }

    public Object visitCodeDefinition(cqlParser.CodeDefinitionContext ctx) {
        CodeDefinitionInfo codeDefinition = new CodeDefinitionInfo();
        codeDefinition.setName(this.parseString((ParseTree)ctx.identifier()));
        codeDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, codeDefinition);
        this.libraryInfo.addCodeDefinition(codeDefinition);
        return codeDefinition;
    }

    public Object visitConceptDefinition(cqlParser.ConceptDefinitionContext ctx) {
        ConceptDefinitionInfo conceptDefinition = new ConceptDefinitionInfo();
        conceptDefinition.setName(this.parseString((ParseTree)ctx.identifier()));
        conceptDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, conceptDefinition);
        this.libraryInfo.addConceptDefinition(conceptDefinition);
        return conceptDefinition;
    }

    public Object visitParameterDefinition(cqlParser.ParameterDefinitionContext ctx) {
        ParameterDefinitionInfo parameterDefinition = new ParameterDefinitionInfo();
        parameterDefinition.setName(this.parseString((ParseTree)ctx.identifier()));
        parameterDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, parameterDefinition);
        this.libraryInfo.addParameterDefinition(parameterDefinition);
        return parameterDefinition;
    }

    public Object visitContextDefinition(cqlParser.ContextDefinitionContext ctx) {
        String modelIdentifier = ctx.modelIdentifier() != null ? this.parseString((ParseTree)ctx.modelIdentifier()) : null;
        String unqualifiedContext = this.parseString((ParseTree)ctx.identifier());
        if (modelIdentifier != null && !modelIdentifier.equals("")) {
            this.setCurrentContext(modelIdentifier + "." + unqualifiedContext);
        } else {
            this.setCurrentContext(unqualifiedContext);
        }
        ContextDefinitionInfo contextDefinition = new ContextDefinitionInfo();
        contextDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, contextDefinition);
        this.libraryInfo.addContextDefinition(contextDefinition);
        if (!this.getImplicitContextCreated() && !unqualifiedContext.equals("Unfiltered")) {
            ExpressionDefinitionInfo expressionDefinition = new ExpressionDefinitionInfo();
            expressionDefinition.setName(unqualifiedContext);
            expressionDefinition.setContext(this.getCurrentContext());
            this.libraryInfo.addExpressionDefinition(expressionDefinition);
            this.setImplicitContextCreated(true);
        }
        return this.getCurrentContext();
    }

    public Object visitExpressionDefinition(cqlParser.ExpressionDefinitionContext ctx) {
        ExpressionDefinitionInfo expressionDefinition = new ExpressionDefinitionInfo();
        expressionDefinition.setName(this.parseString((ParseTree)ctx.identifier()));
        expressionDefinition.setContext(this.getCurrentContext());
        expressionDefinition.setDefinition(ctx);
        this.processHeader((ParseTree)ctx, expressionDefinition);
        this.libraryInfo.addExpressionDefinition(expressionDefinition);
        return expressionDefinition;
    }

    public Object visitFunctionDefinition(cqlParser.FunctionDefinitionContext ctx) {
        FunctionDefinitionInfo functionDefinition = new FunctionDefinitionInfo();
        functionDefinition.setName(this.parseString((ParseTree)ctx.identifierOrFunctionIdentifier()));
        functionDefinition.setContext(this.getCurrentContext());
        functionDefinition.setDefinition((ParseTree)ctx);
        this.processHeader((ParseTree)ctx, functionDefinition);
        this.libraryInfo.addFunctionDefinition(functionDefinition);
        return functionDefinition;
    }

    public NamedTypeSpecifier visitNamedTypeSpecifier(cqlParser.NamedTypeSpecifierContext ctx) {
        List<String> qualifiers = this.parseQualifiers(ctx);
        String modelIdentifier = CqlPreprocessorVisitor.getModelIdentifier(qualifiers);
        String identifier = CqlPreprocessorVisitor.getTypeIdentifier(qualifiers, this.parseString((ParseTree)ctx.referentialOrTypeNameIdentifier()));
        String typeSpecifierKey = String.format("%s:%s", modelIdentifier, identifier);
        DataType resultType = this.libraryBuilder.resolveTypeName(modelIdentifier, identifier);
        if (null == resultType) {
            this.libraryBuilder.addNamedTypeSpecifierResult(typeSpecifierKey, ResultWithPossibleError.withError());
            throw new CqlCompilerException(String.format("Could not find type for model: %s and name: %s", modelIdentifier, identifier));
        }
        NamedTypeSpecifier result = this.of.createNamedTypeSpecifier().withName(this.libraryBuilder.dataTypeToQName(resultType));
        result.setResultType(resultType);
        this.libraryBuilder.addNamedTypeSpecifierResult(typeSpecifierKey, ResultWithPossibleError.withTypeSpecifier(result));
        return result;
    }

    public Object visitTerminal(TerminalNode node) {
        String text = node.getText();
        int tokenType = node.getSymbol().getType();
        if (165 == tokenType || 158 == tokenType) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public Object visitQualifiedIdentifier(cqlParser.QualifiedIdentifierContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierContext qualifierContext : ctx.qualifier()) {
            String qualifier = (String)this.visit((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = this.parseString((ParseTree)ctx.identifier());
        identifiers.add(identifier);
        return identifiers;
    }

    public Object visitQualifiedIdentifierExpression(cqlParser.QualifiedIdentifierExpressionContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierExpressionContext qualifierContext : ctx.qualifierExpression()) {
            String qualifier = (String)this.visit((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = this.parseString((ParseTree)ctx.referentialIdentifier());
        identifiers.add(identifier);
        return identifiers;
    }
}

