/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cqframework.cql.cql2elm.ModelInfoProviderFactory;
import org.cqframework.cql.cql2elm.PathAware;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.cql.model.NamespaceAware;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class ModelInfoLoader
implements NamespaceAware,
PathAware {
    private Path path;
    private NamespaceManager namespaceManager;
    private final List<ModelInfoProvider> providers = new ArrayList<ModelInfoProvider>();
    private boolean initialized = false;

    private List<ModelInfoProvider> getProviders() {
        if (!this.initialized) {
            this.initialized = true;
            Iterator<ModelInfoProvider> it = ModelInfoProviderFactory.providers(false);
            while (it.hasNext()) {
                ModelInfoProvider provider = it.next();
                this.registerModelInfoProvider(provider);
            }
        }
        return this.providers;
    }

    public ModelInfo getModelInfo(ModelIdentifier modelIdentifier) {
        ModelInfoProvider provider;
        this.checkModelIdentifier(modelIdentifier);
        ModelInfo modelInfo = null;
        Iterator<ModelInfoProvider> iterator = this.getProviders().iterator();
        while (iterator.hasNext() && (modelInfo = (provider = iterator.next()).load(modelIdentifier)) == null) {
        }
        if (modelInfo == null) {
            throw new IllegalArgumentException(String.format("Could not resolve model info provider for model %s, version %s.", modelIdentifier.getSystem() == null ? modelIdentifier.getId() : NamespaceManager.getPath((String)modelIdentifier.getSystem(), (String)modelIdentifier.getId()), modelIdentifier.getVersion()));
        }
        return modelInfo;
    }

    public void registerModelInfoProvider(ModelInfoProvider provider) {
        this.registerModelInfoProvider(provider, false);
    }

    public void registerModelInfoProvider(ModelInfoProvider provider, boolean priority) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider is null");
        }
        if (this.namespaceManager != null && provider instanceof NamespaceAware) {
            ((NamespaceAware)provider).setNamespaceManager(this.namespaceManager);
        }
        if (this.path != null && provider instanceof PathAware) {
            ((PathAware)provider).setPath(this.path);
        }
        if (priority) {
            this.providers.add(0, provider);
        } else {
            this.providers.add(provider);
        }
    }

    public void unregisterModelInfoProvider(ModelInfoProvider provider) {
        this.providers.remove(provider);
    }

    public void clearModelInfoProviders() {
        this.providers.clear();
        this.initialized = false;
    }

    private void checkModelIdentifier(ModelIdentifier modelIdentifier) {
        if (modelIdentifier == null) {
            throw new IllegalArgumentException("modelIdentifier is null.");
        }
        if (modelIdentifier.getId() == null || modelIdentifier.getId().equals("")) {
            throw new IllegalArgumentException("modelIdentifier Id is null or empty.");
        }
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        for (ModelInfoProvider provider : this.getProviders()) {
            if (!(provider instanceof NamespaceAware)) continue;
            ((NamespaceAware)provider).setNamespaceManager(namespaceManager);
        }
    }

    @Override
    public void setPath(Path path) {
        if (path == null || !path.toFile().isDirectory()) {
            throw new IllegalArgumentException(String.format("path '%s' is not a valid directory", path));
        }
        this.path = path;
        for (ModelInfoProvider provider : this.getProviders()) {
            if (!(provider instanceof PathAware)) continue;
            ((PathAware)provider).setPath(path);
        }
    }
}

